import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SamlIntegrationConfig extends cdktf.TerraformMetaArguments {
    /**
     * Specifies whether this security integration is enabled or disabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/saml_integration#enabled SamlIntegration#enabled}
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * Specifies the name of the SAML2 integration.
     *
     * This name follows the rules for Object Identifiers. The name should be unique among security integrations in your account.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/saml_integration#name SamlIntegration#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The Boolean indicating if the Log In With button will be shown on the login page.
     *
     * TRUE: displays the Log in WIth button on the login page.  FALSE: does not display the Log in With button on the login page.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/saml_integration#saml2_enable_sp_initiated SamlIntegration#saml2_enable_sp_initiated}
     *
     * @stability stable
     */
    readonly saml2EnableSpInitiated?: boolean | cdktf.IResolvable;
    /**
     * The Boolean indicating whether users, during the initial authentication flow, are forced to authenticate again to access Snowflake.
     *
     * When set to TRUE, Snowflake sets the ForceAuthn SAML parameter to TRUE in the outgoing request from Snowflake to the identity provider. TRUE: forces users to authenticate again to access Snowflake, even if a valid session with the identity provider exists. FALSE: does not force users to authenticate again to access Snowflake.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/saml_integration#saml2_force_authn SamlIntegration#saml2_force_authn}
     *
     * @stability stable
     */
    readonly saml2ForceAuthn?: boolean | cdktf.IResolvable;
    /**
     * The string containing the IdP EntityID / Issuer.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/saml_integration#saml2_issuer SamlIntegration#saml2_issuer}
     *
     * @stability stable
     */
    readonly saml2Issuer: string;
    /**
     * The endpoint to which Snowflake redirects users after clicking the Log Out button in the classic Snowflake web interface.
     *
     * Snowflake terminates the Snowflake session upon redirecting to the specified endpoint.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/saml_integration#saml2_post_logout_redirect_url SamlIntegration#saml2_post_logout_redirect_url}
     *
     * @stability stable
     */
    readonly saml2PostLogoutRedirectUrl?: string;
    /**
     * The string describing the IdP. One of the following: OKTA, ADFS, Custom.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/saml_integration#saml2_provider SamlIntegration#saml2_provider}
     *
     * @stability stable
     */
    readonly saml2Provider: string;
    /**
     * The SAML NameID format allows Snowflake to set an expectation of the identifying attribute of the user (i.e. SAML Subject) in the SAML assertion from the IdP to ensure a valid authentication to Snowflake. If a value is not specified, Snowflake sends the urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress value in the authentication request to the IdP. NameID must be one of the following values: urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified, urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress, urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName, urn:oasis:names:tc:SAML:1.1:nameid-format:WindowsDomainQualifiedName, urn:oasis:names:tc:SAML:2.0:nameid-format:kerberos, urn:oasis:names:tc:SAML:2.0:nameid-format:persistent, urn:oasis:names:tc:SAML:2.0:nameid-format:transient .
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/saml_integration#saml2_requested_nameid_format SamlIntegration#saml2_requested_nameid_format}
     *
     * @stability stable
     */
    readonly saml2RequestedNameidFormat?: string;
    /**
     * The Boolean indicating whether SAML requests are signed.
     *
     * TRUE: allows SAML requests to be signed. FALSE: does not allow SAML requests to be signed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/saml_integration#saml2_sign_request SamlIntegration#saml2_sign_request}
     *
     * @stability stable
     */
    readonly saml2SignRequest?: boolean | cdktf.IResolvable;
    /**
     * The string containing the Snowflake Assertion Consumer Service URL to which the IdP will send its SAML authentication response back to Snowflake.
     *
     * This property will be set in the SAML authentication request generated by Snowflake when initiating a SAML SSO operation with the IdP. If an incorrect value is specified, Snowflake returns an error message indicating the acceptable values to use. Default: https://<account_locator>.<region>.snowflakecomputing.com/fed/login
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/saml_integration#saml2_snowflake_acs_url SamlIntegration#saml2_snowflake_acs_url}
     *
     * @stability stable
     */
    readonly saml2SnowflakeAcsUrl?: string;
    /**
     * The string containing the EntityID / Issuer for the Snowflake service provider.
     *
     * If an incorrect value is specified, Snowflake returns an error message indicating the acceptable values to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/saml_integration#saml2_snowflake_issuer_url SamlIntegration#saml2_snowflake_issuer_url}
     *
     * @stability stable
     */
    readonly saml2SnowflakeIssuerUrl?: string;
    /**
     * The Base64 encoded self-signed certificate generated by Snowflake for use with Encrypting SAML Assertions and Signed SAML Requests.
     *
     * You must have at least one of these features (encrypted SAML assertions or signed SAML responses) enabled in your Snowflake account to access the certificate value.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/saml_integration#saml2_snowflake_x509_cert SamlIntegration#saml2_snowflake_x509_cert}
     *
     * @stability stable
     */
    readonly saml2SnowflakeX509Cert?: string;
    /**
     * The string containing the label to display after the Log In With button on the login page.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/saml_integration#saml2_sp_initiated_login_page_label SamlIntegration#saml2_sp_initiated_login_page_label}
     *
     * @stability stable
     */
    readonly saml2SpInitiatedLoginPageLabel?: string;
    /**
     * The string containing the IdP SSO URL, where the user should be redirected by Snowflake (the Service Provider) with a SAML AuthnRequest message.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/saml_integration#saml2_sso_url SamlIntegration#saml2_sso_url}
     *
     * @stability stable
     */
    readonly saml2SsoUrl: string;
    /**
     * The Base64 encoded IdP signing certificate on a single line without the leading -----BEGIN CERTIFICATE----- and ending -----END CERTIFICATE----- markers.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/saml_integration#saml2_x509_cert SamlIntegration#saml2_x509_cert}
     *
     * @stability stable
     */
    readonly saml2X509Cert: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/snowflake/r/saml_integration snowflake_saml_integration}.
 *
 * @stability stable
 */
export declare class SamlIntegration extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/snowflake/r/saml_integration snowflake_saml_integration} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: SamlIntegrationConfig);
    /**
     * @stability stable
     */
    get createdOn(): string;
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnabled(): void;
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get saml2DigestMethodsUsed(): string;
    private _saml2EnableSpInitiated?;
    /**
     * @stability stable
     */
    get saml2EnableSpInitiated(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set saml2EnableSpInitiated(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSaml2EnableSpInitiated(): void;
    /**
     * @stability stable
     */
    get saml2EnableSpInitiatedInput(): boolean | cdktf.IResolvable | undefined;
    private _saml2ForceAuthn?;
    /**
     * @stability stable
     */
    get saml2ForceAuthn(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set saml2ForceAuthn(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSaml2ForceAuthn(): void;
    /**
     * @stability stable
     */
    get saml2ForceAuthnInput(): boolean | cdktf.IResolvable | undefined;
    private _saml2Issuer?;
    /**
     * @stability stable
     */
    get saml2Issuer(): string;
    /**
     * @stability stable
     */
    set saml2Issuer(value: string);
    /**
     * @stability stable
     */
    get saml2IssuerInput(): string | undefined;
    private _saml2PostLogoutRedirectUrl?;
    /**
     * @stability stable
     */
    get saml2PostLogoutRedirectUrl(): string;
    /**
     * @stability stable
     */
    set saml2PostLogoutRedirectUrl(value: string);
    /**
     * @stability stable
     */
    resetSaml2PostLogoutRedirectUrl(): void;
    /**
     * @stability stable
     */
    get saml2PostLogoutRedirectUrlInput(): string | undefined;
    private _saml2Provider?;
    /**
     * @stability stable
     */
    get saml2Provider(): string;
    /**
     * @stability stable
     */
    set saml2Provider(value: string);
    /**
     * @stability stable
     */
    get saml2ProviderInput(): string | undefined;
    private _saml2RequestedNameidFormat?;
    /**
     * @stability stable
     */
    get saml2RequestedNameidFormat(): string;
    /**
     * @stability stable
     */
    set saml2RequestedNameidFormat(value: string);
    /**
     * @stability stable
     */
    resetSaml2RequestedNameidFormat(): void;
    /**
     * @stability stable
     */
    get saml2RequestedNameidFormatInput(): string | undefined;
    private _saml2SignRequest?;
    /**
     * @stability stable
     */
    get saml2SignRequest(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set saml2SignRequest(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSaml2SignRequest(): void;
    /**
     * @stability stable
     */
    get saml2SignRequestInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get saml2SignatureMethodsUsed(): string;
    private _saml2SnowflakeAcsUrl?;
    /**
     * @stability stable
     */
    get saml2SnowflakeAcsUrl(): string;
    /**
     * @stability stable
     */
    set saml2SnowflakeAcsUrl(value: string);
    /**
     * @stability stable
     */
    resetSaml2SnowflakeAcsUrl(): void;
    /**
     * @stability stable
     */
    get saml2SnowflakeAcsUrlInput(): string | undefined;
    private _saml2SnowflakeIssuerUrl?;
    /**
     * @stability stable
     */
    get saml2SnowflakeIssuerUrl(): string;
    /**
     * @stability stable
     */
    set saml2SnowflakeIssuerUrl(value: string);
    /**
     * @stability stable
     */
    resetSaml2SnowflakeIssuerUrl(): void;
    /**
     * @stability stable
     */
    get saml2SnowflakeIssuerUrlInput(): string | undefined;
    /**
     * @stability stable
     */
    get saml2SnowflakeMetadata(): string;
    private _saml2SnowflakeX509Cert?;
    /**
     * @stability stable
     */
    get saml2SnowflakeX509Cert(): string;
    /**
     * @stability stable
     */
    set saml2SnowflakeX509Cert(value: string);
    /**
     * @stability stable
     */
    resetSaml2SnowflakeX509Cert(): void;
    /**
     * @stability stable
     */
    get saml2SnowflakeX509CertInput(): string | undefined;
    private _saml2SpInitiatedLoginPageLabel?;
    /**
     * @stability stable
     */
    get saml2SpInitiatedLoginPageLabel(): string;
    /**
     * @stability stable
     */
    set saml2SpInitiatedLoginPageLabel(value: string);
    /**
     * @stability stable
     */
    resetSaml2SpInitiatedLoginPageLabel(): void;
    /**
     * @stability stable
     */
    get saml2SpInitiatedLoginPageLabelInput(): string | undefined;
    private _saml2SsoUrl?;
    /**
     * @stability stable
     */
    get saml2SsoUrl(): string;
    /**
     * @stability stable
     */
    set saml2SsoUrl(value: string);
    /**
     * @stability stable
     */
    get saml2SsoUrlInput(): string | undefined;
    private _saml2X509Cert?;
    /**
     * @stability stable
     */
    get saml2X509Cert(): string;
    /**
     * @stability stable
     */
    set saml2X509Cert(value: string);
    /**
     * @stability stable
     */
    get saml2X509CertInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
