import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SchemaConfig extends cdktf.TerraformMetaArguments {
    /**
     * Specifies a comment for the schema.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/schema#comment Schema#comment}
     *
     * @stability stable
     */
    readonly comment?: string;
    /**
     * Specifies the number of days for which Time Travel actions (CLONE and UNDROP) can be performed on the schema, as well as specifying the default Time Travel retention time for all tables created in the schema.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/schema#data_retention_days Schema#data_retention_days}
     *
     * @stability stable
     */
    readonly dataRetentionDays?: number;
    /**
     * The database in which to create the schema.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/schema#database Schema#database}
     *
     * @stability stable
     */
    readonly database: string;
    /**
     * Specifies a managed schema. Managed access schemas centralize privilege management with the schema owner.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/schema#is_managed Schema#is_managed}
     *
     * @stability stable
     */
    readonly isManaged?: boolean | cdktf.IResolvable;
    /**
     * Specifies a schema as transient.
     *
     * Transient schemas do not have a Fail-safe period so they do not incur additional storage costs once they leave Time Travel; however, this means they are also not protected by Fail-safe in the event of a data loss.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/schema#is_transient Schema#is_transient}
     *
     * @stability stable
     */
    readonly isTransient?: boolean | cdktf.IResolvable;
    /**
     * Specifies the identifier for the schema; must be unique for the database in which the schema is created.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/schema#name Schema#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * tag block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/schema#tag Schema#tag}
     *
     * @stability stable
     */
    readonly tag?: SchemaTag[] | cdktf.IResolvable;
}
/**
 * @stability stable
 */
export interface SchemaTag {
    /**
     * Name of the database that the tag was created in.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/schema#database Schema#database}
     *
     * @stability stable
     */
    readonly database?: string;
    /**
     * Tag name, e.g. department.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/schema#name Schema#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Name of the schema that the tag was created in.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/schema#schema Schema#schema}
     *
     * @stability stable
     */
    readonly schema?: string;
    /**
     * Tag value, e.g. marketing_info.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/schema#value Schema#value}
     *
     * @stability stable
     */
    readonly value: string;
}
export declare function schemaTagToTerraform(struct?: SchemaTag | cdktf.IResolvable): any;
/**
 * Represents a {@link https://www.terraform.io/docs/providers/snowflake/r/schema snowflake_schema}.
 *
 * @stability stable
 */
export declare class Schema extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/snowflake/r/schema snowflake_schema} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: SchemaConfig);
    private _comment?;
    /**
     * @stability stable
     */
    get comment(): string;
    /**
     * @stability stable
     */
    set comment(value: string);
    /**
     * @stability stable
     */
    resetComment(): void;
    /**
     * @stability stable
     */
    get commentInput(): string | undefined;
    private _dataRetentionDays?;
    /**
     * @stability stable
     */
    get dataRetentionDays(): number;
    /**
     * @stability stable
     */
    set dataRetentionDays(value: number);
    /**
     * @stability stable
     */
    resetDataRetentionDays(): void;
    /**
     * @stability stable
     */
    get dataRetentionDaysInput(): number | undefined;
    private _database?;
    /**
     * @stability stable
     */
    get database(): string;
    /**
     * @stability stable
     */
    set database(value: string);
    /**
     * @stability stable
     */
    get databaseInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _isManaged?;
    /**
     * @stability stable
     */
    get isManaged(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set isManaged(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetIsManaged(): void;
    /**
     * @stability stable
     */
    get isManagedInput(): boolean | cdktf.IResolvable | undefined;
    private _isTransient?;
    /**
     * @stability stable
     */
    get isTransient(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set isTransient(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetIsTransient(): void;
    /**
     * @stability stable
     */
    get isTransientInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _tag?;
    /**
     * @stability stable
     */
    get tag(): SchemaTag[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tag(value: SchemaTag[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTag(): void;
    /**
     * @stability stable
     */
    get tagInput(): cdktf.IResolvable | SchemaTag[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
