import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ScimIntegrationConfig extends cdktf.TerraformMetaArguments {
    /**
     * Specifies the name of the SCIM integration.
     *
     * This name follows the rules for Object Identifiers. The name should be unique among security integrations in your account.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/scim_integration#name ScimIntegration#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Specifies an existing network policy active for your account.
     *
     * The network policy restricts the list of user IP addresses when exchanging an authorization code for an access or refresh token and when using a refresh token to obtain a new access token. If this parameter is not set, the network policy for the account (if any) is used instead.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/scim_integration#network_policy ScimIntegration#network_policy}
     *
     * @stability stable
     */
    readonly networkPolicy?: string;
    /**
     * Specify the SCIM role in Snowflake that owns any users and roles that are imported from the identity provider into Snowflake using SCIM.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/scim_integration#provisioner_role ScimIntegration#provisioner_role}
     *
     * @stability stable
     */
    readonly provisionerRole: string;
    /**
     * Specifies the client type for the scim integration.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/scim_integration#scim_client ScimIntegration#scim_client}
     *
     * @stability stable
     */
    readonly scimClient: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/snowflake/r/scim_integration snowflake_scim_integration}.
 *
 * @stability stable
 */
export declare class ScimIntegration extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/snowflake/r/scim_integration snowflake_scim_integration} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ScimIntegrationConfig);
    /**
     * @stability stable
     */
    get createdOn(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _networkPolicy?;
    /**
     * @stability stable
     */
    get networkPolicy(): string;
    /**
     * @stability stable
     */
    set networkPolicy(value: string);
    /**
     * @stability stable
     */
    resetNetworkPolicy(): void;
    /**
     * @stability stable
     */
    get networkPolicyInput(): string | undefined;
    private _provisionerRole?;
    /**
     * @stability stable
     */
    get provisionerRole(): string;
    /**
     * @stability stable
     */
    set provisionerRole(value: string);
    /**
     * @stability stable
     */
    get provisionerRoleInput(): string | undefined;
    private _scimClient?;
    /**
     * @stability stable
     */
    get scimClient(): string;
    /**
     * @stability stable
     */
    set scimClient(value: string);
    /**
     * @stability stable
     */
    get scimClientInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
