import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SequenceConfig extends cdktf.TerraformMetaArguments {
    /**
     * Specifies a comment for the sequence.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/sequence#comment Sequence#comment}
     *
     * @stability stable
     */
    readonly comment?: string;
    /**
     * The database in which to create the sequence. Don't use the | character.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/sequence#database Sequence#database}
     *
     * @stability stable
     */
    readonly database: string;
    /**
     * The amount the sequence will increase by each time it is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/sequence#increment Sequence#increment}
     *
     * @stability stable
     */
    readonly increment?: number;
    /**
     * Specifies the name for the sequence.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/sequence#name Sequence#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The schema in which to create the sequence. Don't use the | character.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/sequence#schema Sequence#schema}
     *
     * @stability stable
     */
    readonly schema: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/snowflake/r/sequence snowflake_sequence}.
 *
 * @stability stable
 */
export declare class Sequence extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/snowflake/r/sequence snowflake_sequence} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: SequenceConfig);
    private _comment?;
    /**
     * @stability stable
     */
    get comment(): string;
    /**
     * @stability stable
     */
    set comment(value: string);
    /**
     * @stability stable
     */
    resetComment(): void;
    /**
     * @stability stable
     */
    get commentInput(): string | undefined;
    private _database?;
    /**
     * @stability stable
     */
    get database(): string;
    /**
     * @stability stable
     */
    set database(value: string);
    /**
     * @stability stable
     */
    get databaseInput(): string | undefined;
    /**
     * @stability stable
     */
    get fullyQualifiedName(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _increment?;
    /**
     * @stability stable
     */
    get increment(): number;
    /**
     * @stability stable
     */
    set increment(value: number);
    /**
     * @stability stable
     */
    resetIncrement(): void;
    /**
     * @stability stable
     */
    get incrementInput(): number | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get nextValue(): number;
    private _schema?;
    /**
     * @stability stable
     */
    get schema(): string;
    /**
     * @stability stable
     */
    set schema(value: string);
    /**
     * @stability stable
     */
    get schemaInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
