import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ShareConfig extends cdktf.TerraformMetaArguments {
    /**
     * A list of accounts to be added to the share.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/share#accounts Share#accounts}
     *
     * @stability stable
     */
    readonly accounts?: string[];
    /**
     * Specifies a comment for the managed account.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/share#comment Share#comment}
     *
     * @stability stable
     */
    readonly comment?: string;
    /**
     * Specifies the identifier for the share; must be unique for the account in which the share is created.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/share#name Share#name}
     *
     * @stability stable
     */
    readonly name: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/snowflake/r/share snowflake_share}.
 *
 * @stability stable
 */
export declare class Share extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/snowflake/r/share snowflake_share} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ShareConfig);
    private _accounts?;
    /**
     * @stability stable
     */
    get accounts(): string[];
    /**
     * @stability stable
     */
    set accounts(value: string[]);
    /**
     * @stability stable
     */
    resetAccounts(): void;
    /**
     * @stability stable
     */
    get accountsInput(): string[] | undefined;
    private _comment?;
    /**
     * @stability stable
     */
    get comment(): string;
    /**
     * @stability stable
     */
    set comment(value: string);
    /**
     * @stability stable
     */
    resetComment(): void;
    /**
     * @stability stable
     */
    get commentInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
