import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface SnowflakeProviderConfig {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake#account SnowflakeProvider#account}.
     *
     * @stability stable
     */
    readonly account: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake#browser_auth SnowflakeProvider#browser_auth}.
     *
     * @stability stable
     */
    readonly browserAuth?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake#oauth_access_token SnowflakeProvider#oauth_access_token}.
     *
     * @stability stable
     */
    readonly oauthAccessToken?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake#oauth_client_id SnowflakeProvider#oauth_client_id}.
     *
     * @stability stable
     */
    readonly oauthClientId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake#oauth_client_secret SnowflakeProvider#oauth_client_secret}.
     *
     * @stability stable
     */
    readonly oauthClientSecret?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake#oauth_endpoint SnowflakeProvider#oauth_endpoint}.
     *
     * @stability stable
     */
    readonly oauthEndpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake#oauth_redirect_url SnowflakeProvider#oauth_redirect_url}.
     *
     * @stability stable
     */
    readonly oauthRedirectUrl?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake#oauth_refresh_token SnowflakeProvider#oauth_refresh_token}.
     *
     * @stability stable
     */
    readonly oauthRefreshToken?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake#password SnowflakeProvider#password}.
     *
     * @stability stable
     */
    readonly password?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake#private_key SnowflakeProvider#private_key}.
     *
     * @stability stable
     */
    readonly privateKey?: string;
    /**
     * Supports the encryption ciphers aes-128-cbc, aes-128-gcm, aes-192-cbc, aes-192-gcm, aes-256-cbc, aes-256-gcm, and des-ede3-cbc.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake#private_key_passphrase SnowflakeProvider#private_key_passphrase}
     *
     * @stability stable
     */
    readonly privateKeyPassphrase?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake#private_key_path SnowflakeProvider#private_key_path}.
     *
     * @stability stable
     */
    readonly privateKeyPath?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake#region SnowflakeProvider#region}.
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake#role SnowflakeProvider#role}.
     *
     * @stability stable
     */
    readonly role?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake#username SnowflakeProvider#username}.
     *
     * @stability stable
     */
    readonly username: string;
    /**
     * Alias name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake#alias SnowflakeProvider#alias}
     *
     * @stability stable
     */
    readonly alias?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/snowflake snowflake}.
 *
 * @stability stable
 */
export declare class SnowflakeProvider extends cdktf.TerraformProvider {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/snowflake snowflake} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: SnowflakeProviderConfig);
    private _account?;
    /**
     * @stability stable
     */
    get account(): string | undefined;
    /**
     * @stability stable
     */
    set account(value: string | undefined);
    /**
     * @stability stable
     */
    get accountInput(): string | undefined;
    private _browserAuth?;
    /**
     * @stability stable
     */
    get browserAuth(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set browserAuth(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetBrowserAuth(): void;
    /**
     * @stability stable
     */
    get browserAuthInput(): boolean | cdktf.IResolvable | undefined;
    private _oauthAccessToken?;
    /**
     * @stability stable
     */
    get oauthAccessToken(): string | undefined;
    /**
     * @stability stable
     */
    set oauthAccessToken(value: string | undefined);
    /**
     * @stability stable
     */
    resetOauthAccessToken(): void;
    /**
     * @stability stable
     */
    get oauthAccessTokenInput(): string | undefined;
    private _oauthClientId?;
    /**
     * @stability stable
     */
    get oauthClientId(): string | undefined;
    /**
     * @stability stable
     */
    set oauthClientId(value: string | undefined);
    /**
     * @stability stable
     */
    resetOauthClientId(): void;
    /**
     * @stability stable
     */
    get oauthClientIdInput(): string | undefined;
    private _oauthClientSecret?;
    /**
     * @stability stable
     */
    get oauthClientSecret(): string | undefined;
    /**
     * @stability stable
     */
    set oauthClientSecret(value: string | undefined);
    /**
     * @stability stable
     */
    resetOauthClientSecret(): void;
    /**
     * @stability stable
     */
    get oauthClientSecretInput(): string | undefined;
    private _oauthEndpoint?;
    /**
     * @stability stable
     */
    get oauthEndpoint(): string | undefined;
    /**
     * @stability stable
     */
    set oauthEndpoint(value: string | undefined);
    /**
     * @stability stable
     */
    resetOauthEndpoint(): void;
    /**
     * @stability stable
     */
    get oauthEndpointInput(): string | undefined;
    private _oauthRedirectUrl?;
    /**
     * @stability stable
     */
    get oauthRedirectUrl(): string | undefined;
    /**
     * @stability stable
     */
    set oauthRedirectUrl(value: string | undefined);
    /**
     * @stability stable
     */
    resetOauthRedirectUrl(): void;
    /**
     * @stability stable
     */
    get oauthRedirectUrlInput(): string | undefined;
    private _oauthRefreshToken?;
    /**
     * @stability stable
     */
    get oauthRefreshToken(): string | undefined;
    /**
     * @stability stable
     */
    set oauthRefreshToken(value: string | undefined);
    /**
     * @stability stable
     */
    resetOauthRefreshToken(): void;
    /**
     * @stability stable
     */
    get oauthRefreshTokenInput(): string | undefined;
    private _password?;
    /**
     * @stability stable
     */
    get password(): string | undefined;
    /**
     * @stability stable
     */
    set password(value: string | undefined);
    /**
     * @stability stable
     */
    resetPassword(): void;
    /**
     * @stability stable
     */
    get passwordInput(): string | undefined;
    private _privateKey?;
    /**
     * @stability stable
     */
    get privateKey(): string | undefined;
    /**
     * @stability stable
     */
    set privateKey(value: string | undefined);
    /**
     * @stability stable
     */
    resetPrivateKey(): void;
    /**
     * @stability stable
     */
    get privateKeyInput(): string | undefined;
    private _privateKeyPassphrase?;
    /**
     * @stability stable
     */
    get privateKeyPassphrase(): string | undefined;
    /**
     * @stability stable
     */
    set privateKeyPassphrase(value: string | undefined);
    /**
     * @stability stable
     */
    resetPrivateKeyPassphrase(): void;
    /**
     * @stability stable
     */
    get privateKeyPassphraseInput(): string | undefined;
    private _privateKeyPath?;
    /**
     * @stability stable
     */
    get privateKeyPath(): string | undefined;
    /**
     * @stability stable
     */
    set privateKeyPath(value: string | undefined);
    /**
     * @stability stable
     */
    resetPrivateKeyPath(): void;
    /**
     * @stability stable
     */
    get privateKeyPathInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string | undefined;
    /**
     * @stability stable
     */
    set region(value: string | undefined);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    private _role?;
    /**
     * @stability stable
     */
    get role(): string | undefined;
    /**
     * @stability stable
     */
    set role(value: string | undefined);
    /**
     * @stability stable
     */
    resetRole(): void;
    /**
     * @stability stable
     */
    get roleInput(): string | undefined;
    private _username?;
    /**
     * @stability stable
     */
    get username(): string | undefined;
    /**
     * @stability stable
     */
    set username(value: string | undefined);
    /**
     * @stability stable
     */
    get usernameInput(): string | undefined;
    private _alias?;
    /**
     * @stability stable
     */
    get alias(): string | undefined;
    /**
     * @stability stable
     */
    set alias(value: string | undefined);
    /**
     * @stability stable
     */
    resetAlias(): void;
    /**
     * @stability stable
     */
    get aliasInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
