import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface StageConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/stage#aws_external_id Stage#aws_external_id}.
     *
     * @stability stable
     */
    readonly awsExternalId?: string;
    /**
     * Specifies a comment for the stage.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/stage#comment Stage#comment}
     *
     * @stability stable
     */
    readonly comment?: string;
    /**
     * Specifies the copy options for the stage.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/stage#copy_options Stage#copy_options}
     *
     * @stability stable
     */
    readonly copyOptions?: string;
    /**
     * Specifies the credentials for the stage.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/stage#credentials Stage#credentials}
     *
     * @stability stable
     */
    readonly credentials?: string;
    /**
     * The database in which to create the stage.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/stage#database Stage#database}
     *
     * @stability stable
     */
    readonly database: string;
    /**
     * Specifies the encryption settings for the stage.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/stage#encryption Stage#encryption}
     *
     * @stability stable
     */
    readonly encryption?: string;
    /**
     * Specifies the file format for the stage.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/stage#file_format Stage#file_format}
     *
     * @stability stable
     */
    readonly fileFormat?: string;
    /**
     * Specifies the identifier for the stage;
     *
     * must be unique for the database and schema in which the stage is created.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/stage#name Stage#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The schema in which to create the stage.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/stage#schema Stage#schema}
     *
     * @stability stable
     */
    readonly schema: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/stage#snowflake_iam_user Stage#snowflake_iam_user}.
     *
     * @stability stable
     */
    readonly snowflakeIamUser?: string;
    /**
     * Specifies the name of the storage integration used to delegate authentication responsibility for external cloud storage to a Snowflake identity and access management (IAM) entity.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/stage#storage_integration Stage#storage_integration}
     *
     * @stability stable
     */
    readonly storageIntegration?: string;
    /**
     * Specifies the URL for the stage.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/stage#url Stage#url}
     *
     * @stability stable
     */
    readonly url?: string;
    /**
     * tag block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/stage#tag Stage#tag}
     *
     * @stability stable
     */
    readonly tag?: StageTag[] | cdktf.IResolvable;
}
/**
 * @stability stable
 */
export interface StageTag {
    /**
     * Name of the database that the tag was created in.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/stage#database Stage#database}
     *
     * @stability stable
     */
    readonly database?: string;
    /**
     * Tag name, e.g. department.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/stage#name Stage#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Name of the schema that the tag was created in.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/stage#schema Stage#schema}
     *
     * @stability stable
     */
    readonly schema?: string;
    /**
     * Tag value, e.g. marketing_info.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/stage#value Stage#value}
     *
     * @stability stable
     */
    readonly value: string;
}
export declare function stageTagToTerraform(struct?: StageTag | cdktf.IResolvable): any;
/**
 * Represents a {@link https://www.terraform.io/docs/providers/snowflake/r/stage snowflake_stage}.
 *
 * @stability stable
 */
export declare class Stage extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/snowflake/r/stage snowflake_stage} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: StageConfig);
    private _awsExternalId?;
    /**
     * @stability stable
     */
    get awsExternalId(): string;
    /**
     * @stability stable
     */
    set awsExternalId(value: string);
    /**
     * @stability stable
     */
    resetAwsExternalId(): void;
    /**
     * @stability stable
     */
    get awsExternalIdInput(): string | undefined;
    private _comment?;
    /**
     * @stability stable
     */
    get comment(): string;
    /**
     * @stability stable
     */
    set comment(value: string);
    /**
     * @stability stable
     */
    resetComment(): void;
    /**
     * @stability stable
     */
    get commentInput(): string | undefined;
    private _copyOptions?;
    /**
     * @stability stable
     */
    get copyOptions(): string;
    /**
     * @stability stable
     */
    set copyOptions(value: string);
    /**
     * @stability stable
     */
    resetCopyOptions(): void;
    /**
     * @stability stable
     */
    get copyOptionsInput(): string | undefined;
    private _credentials?;
    /**
     * @stability stable
     */
    get credentials(): string;
    /**
     * @stability stable
     */
    set credentials(value: string);
    /**
     * @stability stable
     */
    resetCredentials(): void;
    /**
     * @stability stable
     */
    get credentialsInput(): string | undefined;
    private _database?;
    /**
     * @stability stable
     */
    get database(): string;
    /**
     * @stability stable
     */
    set database(value: string);
    /**
     * @stability stable
     */
    get databaseInput(): string | undefined;
    private _encryption?;
    /**
     * @stability stable
     */
    get encryption(): string;
    /**
     * @stability stable
     */
    set encryption(value: string);
    /**
     * @stability stable
     */
    resetEncryption(): void;
    /**
     * @stability stable
     */
    get encryptionInput(): string | undefined;
    private _fileFormat?;
    /**
     * @stability stable
     */
    get fileFormat(): string;
    /**
     * @stability stable
     */
    set fileFormat(value: string);
    /**
     * @stability stable
     */
    resetFileFormat(): void;
    /**
     * @stability stable
     */
    get fileFormatInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _schema?;
    /**
     * @stability stable
     */
    get schema(): string;
    /**
     * @stability stable
     */
    set schema(value: string);
    /**
     * @stability stable
     */
    get schemaInput(): string | undefined;
    private _snowflakeIamUser?;
    /**
     * @stability stable
     */
    get snowflakeIamUser(): string;
    /**
     * @stability stable
     */
    set snowflakeIamUser(value: string);
    /**
     * @stability stable
     */
    resetSnowflakeIamUser(): void;
    /**
     * @stability stable
     */
    get snowflakeIamUserInput(): string | undefined;
    private _storageIntegration?;
    /**
     * @stability stable
     */
    get storageIntegration(): string;
    /**
     * @stability stable
     */
    set storageIntegration(value: string);
    /**
     * @stability stable
     */
    resetStorageIntegration(): void;
    /**
     * @stability stable
     */
    get storageIntegrationInput(): string | undefined;
    private _url?;
    /**
     * @stability stable
     */
    get url(): string;
    /**
     * @stability stable
     */
    set url(value: string);
    /**
     * @stability stable
     */
    resetUrl(): void;
    /**
     * @stability stable
     */
    get urlInput(): string | undefined;
    private _tag?;
    /**
     * @stability stable
     */
    get tag(): StageTag[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tag(value: StageTag[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTag(): void;
    /**
     * @stability stable
     */
    get tagInput(): cdktf.IResolvable | StageTag[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
