import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface StorageIntegrationConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/storage_integration#azure_tenant_id StorageIntegration#azure_tenant_id}.
     *
     * @stability stable
     */
    readonly azureTenantId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/storage_integration#comment StorageIntegration#comment}.
     *
     * @stability stable
     */
    readonly comment?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/storage_integration#enabled StorageIntegration#enabled}.
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/storage_integration#name StorageIntegration#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Explicitly limits external stages that use the integration to reference one or more storage locations.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/storage_integration#storage_allowed_locations StorageIntegration#storage_allowed_locations}
     *
     * @stability stable
     */
    readonly storageAllowedLocations: string[];
    /**
     * "bucket-owner-full-control" Enables support for AWS access control lists (ACLs) to grant the bucket owner full control.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/storage_integration#storage_aws_object_acl StorageIntegration#storage_aws_object_acl}
     *
     * @stability stable
     */
    readonly storageAwsObjectAcl?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/storage_integration#storage_aws_role_arn StorageIntegration#storage_aws_role_arn}.
     *
     * @stability stable
     */
    readonly storageAwsRoleArn?: string;
    /**
     * Explicitly prohibits external stages that use the integration from referencing one or more storage locations.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/storage_integration#storage_blocked_locations StorageIntegration#storage_blocked_locations}
     *
     * @stability stable
     */
    readonly storageBlockedLocations?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/storage_integration#storage_provider StorageIntegration#storage_provider}.
     *
     * @stability stable
     */
    readonly storageProvider: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/storage_integration#type StorageIntegration#type}.
     *
     * @stability stable
     */
    readonly type?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/snowflake/r/storage_integration snowflake_storage_integration}.
 *
 * @stability stable
 */
export declare class StorageIntegration extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/snowflake/r/storage_integration snowflake_storage_integration} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: StorageIntegrationConfig);
    /**
     * @stability stable
     */
    get azureConsentUrl(): string;
    /**
     * @stability stable
     */
    get azureMultiTenantAppName(): string;
    private _azureTenantId?;
    /**
     * @stability stable
     */
    get azureTenantId(): string;
    /**
     * @stability stable
     */
    set azureTenantId(value: string);
    /**
     * @stability stable
     */
    resetAzureTenantId(): void;
    /**
     * @stability stable
     */
    get azureTenantIdInput(): string | undefined;
    private _comment?;
    /**
     * @stability stable
     */
    get comment(): string;
    /**
     * @stability stable
     */
    set comment(value: string);
    /**
     * @stability stable
     */
    resetComment(): void;
    /**
     * @stability stable
     */
    get commentInput(): string | undefined;
    /**
     * @stability stable
     */
    get createdOn(): string;
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnabled(): void;
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _storageAllowedLocations?;
    /**
     * @stability stable
     */
    get storageAllowedLocations(): string[];
    /**
     * @stability stable
     */
    set storageAllowedLocations(value: string[]);
    /**
     * @stability stable
     */
    get storageAllowedLocationsInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get storageAwsExternalId(): string;
    /**
     * @stability stable
     */
    get storageAwsIamUserArn(): string;
    private _storageAwsObjectAcl?;
    /**
     * @stability stable
     */
    get storageAwsObjectAcl(): string;
    /**
     * @stability stable
     */
    set storageAwsObjectAcl(value: string);
    /**
     * @stability stable
     */
    resetStorageAwsObjectAcl(): void;
    /**
     * @stability stable
     */
    get storageAwsObjectAclInput(): string | undefined;
    private _storageAwsRoleArn?;
    /**
     * @stability stable
     */
    get storageAwsRoleArn(): string;
    /**
     * @stability stable
     */
    set storageAwsRoleArn(value: string);
    /**
     * @stability stable
     */
    resetStorageAwsRoleArn(): void;
    /**
     * @stability stable
     */
    get storageAwsRoleArnInput(): string | undefined;
    private _storageBlockedLocations?;
    /**
     * @stability stable
     */
    get storageBlockedLocations(): string[];
    /**
     * @stability stable
     */
    set storageBlockedLocations(value: string[]);
    /**
     * @stability stable
     */
    resetStorageBlockedLocations(): void;
    /**
     * @stability stable
     */
    get storageBlockedLocationsInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get storageGcpServiceAccount(): string;
    private _storageProvider?;
    /**
     * @stability stable
     */
    get storageProvider(): string;
    /**
     * @stability stable
     */
    set storageProvider(value: string);
    /**
     * @stability stable
     */
    get storageProviderInput(): string | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    resetType(): void;
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
