import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface StreamConfig extends cdktf.TerraformMetaArguments {
    /**
     * Type of the stream that will be created.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/stream#append_only Stream#append_only}
     *
     * @stability stable
     */
    readonly appendOnly?: boolean | cdktf.IResolvable;
    /**
     * Specifies a comment for the stream.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/stream#comment Stream#comment}
     *
     * @stability stable
     */
    readonly comment?: string;
    /**
     * The database in which to create the stream.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/stream#database Stream#database}
     *
     * @stability stable
     */
    readonly database: string;
    /**
     * Create an insert only stream type.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/stream#insert_only Stream#insert_only}
     *
     * @stability stable
     */
    readonly insertOnly?: boolean | cdktf.IResolvable;
    /**
     * Specifies the identifier for the stream;
     *
     * must be unique for the database and schema in which the stream is created.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/stream#name Stream#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Name of the table the stream will monitor.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/stream#on_table Stream#on_table}
     *
     * @stability stable
     */
    readonly onTable?: string;
    /**
     * The schema in which to create the stream.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/stream#schema Stream#schema}
     *
     * @stability stable
     */
    readonly schema: string;
    /**
     * Specifies whether to return all existing rows in the source table as row inserts the first time the stream is consumed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/stream#show_initial_rows Stream#show_initial_rows}
     *
     * @stability stable
     */
    readonly showInitialRows?: boolean | cdktf.IResolvable;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/snowflake/r/stream snowflake_stream}.
 *
 * @stability stable
 */
export declare class Stream extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/snowflake/r/stream snowflake_stream} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: StreamConfig);
    private _appendOnly?;
    /**
     * @stability stable
     */
    get appendOnly(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set appendOnly(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAppendOnly(): void;
    /**
     * @stability stable
     */
    get appendOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _comment?;
    /**
     * @stability stable
     */
    get comment(): string;
    /**
     * @stability stable
     */
    set comment(value: string);
    /**
     * @stability stable
     */
    resetComment(): void;
    /**
     * @stability stable
     */
    get commentInput(): string | undefined;
    private _database?;
    /**
     * @stability stable
     */
    get database(): string;
    /**
     * @stability stable
     */
    set database(value: string);
    /**
     * @stability stable
     */
    get databaseInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _insertOnly?;
    /**
     * @stability stable
     */
    get insertOnly(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set insertOnly(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetInsertOnly(): void;
    /**
     * @stability stable
     */
    get insertOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _onTable?;
    /**
     * @stability stable
     */
    get onTable(): string;
    /**
     * @stability stable
     */
    set onTable(value: string);
    /**
     * @stability stable
     */
    resetOnTable(): void;
    /**
     * @stability stable
     */
    get onTableInput(): string | undefined;
    /**
     * @stability stable
     */
    get owner(): string;
    private _schema?;
    /**
     * @stability stable
     */
    get schema(): string;
    /**
     * @stability stable
     */
    set schema(value: string);
    /**
     * @stability stable
     */
    get schemaInput(): string | undefined;
    private _showInitialRows?;
    /**
     * @stability stable
     */
    get showInitialRows(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set showInitialRows(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetShowInitialRows(): void;
    /**
     * @stability stable
     */
    get showInitialRowsInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
