import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface TableConfig extends cdktf.TerraformMetaArguments {
    /**
     * Specifies whether to enable change tracking on the table. Default false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/table#change_tracking Table#change_tracking}
     *
     * @stability stable
     */
    readonly changeTracking?: boolean | cdktf.IResolvable;
    /**
     * A list of one or more table columns/expressions to be used as clustering key(s) for the table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/table#cluster_by Table#cluster_by}
     *
     * @stability stable
     */
    readonly clusterBy?: string[];
    /**
     * Specifies a comment for the table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/table#comment Table#comment}
     *
     * @stability stable
     */
    readonly comment?: string;
    /**
     * Specifies the retention period for the table so that Time Travel actions (SELECT, CLONE, UNDROP) can be performed on historical data in the table.
     *
     * Default value is 1, if you wish to inherit the parent schema setting then pass in the schema attribute to this argument.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/table#data_retention_days Table#data_retention_days}
     *
     * @stability stable
     */
    readonly dataRetentionDays?: number;
    /**
     * The database in which to create the table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/table#database Table#database}
     *
     * @stability stable
     */
    readonly database: string;
    /**
     * Specifies the identifier for the table;
     *
     * must be unique for the database and schema in which the table is created.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/table#name Table#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The schema in which to create the table.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/table#schema Table#schema}
     *
     * @stability stable
     */
    readonly schema: string;
    /**
     * column block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/table#column Table#column}
     *
     * @stability stable
     */
    readonly column: TableColumn[] | cdktf.IResolvable;
    /**
     * primary_key block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/table#primary_key Table#primary_key}
     *
     * @stability stable
     */
    readonly primaryKey?: TablePrimaryKey;
    /**
     * tag block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/table#tag Table#tag}
     *
     * @stability stable
     */
    readonly tag?: TableTag[] | cdktf.IResolvable;
}
/**
 * @stability stable
 */
export interface TableColumnDefault {
    /**
     * The default constant value for the column.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/table#constant Table#constant}
     *
     * @stability stable
     */
    readonly constant?: string;
    /**
     * The default expression value for the column.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/table#expression Table#expression}
     *
     * @stability stable
     */
    readonly expression?: string;
    /**
     * The default sequence to use for the column.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/table#sequence Table#sequence}
     *
     * @stability stable
     */
    readonly sequence?: string;
}
export declare function tableColumnDefaultToTerraform(struct?: TableColumnDefaultOutputReference | TableColumnDefault): any;
/**
 * @stability stable
 */
export declare class TableColumnDefaultOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): TableColumnDefault | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: TableColumnDefault | undefined);
    private _constant?;
    /**
     * @stability stable
     */
    get constant(): string;
    /**
     * @stability stable
     */
    set constant(value: string);
    /**
     * @stability stable
     */
    resetConstant(): void;
    /**
     * @stability stable
     */
    get constantInput(): string | undefined;
    private _expression?;
    /**
     * @stability stable
     */
    get expression(): string;
    /**
     * @stability stable
     */
    set expression(value: string);
    /**
     * @stability stable
     */
    resetExpression(): void;
    /**
     * @stability stable
     */
    get expressionInput(): string | undefined;
    private _sequence?;
    /**
     * @stability stable
     */
    get sequence(): string;
    /**
     * @stability stable
     */
    set sequence(value: string);
    /**
     * @stability stable
     */
    resetSequence(): void;
    /**
     * @stability stable
     */
    get sequenceInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface TableColumnIdentity {
    /**
     * The number to start incrementing at.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/table#start_num Table#start_num}
     *
     * @stability stable
     */
    readonly startNum?: number;
    /**
     * Step size to increment by.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/table#step_num Table#step_num}
     *
     * @stability stable
     */
    readonly stepNum?: number;
}
export declare function tableColumnIdentityToTerraform(struct?: TableColumnIdentityOutputReference | TableColumnIdentity): any;
/**
 * @stability stable
 */
export declare class TableColumnIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): TableColumnIdentity | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: TableColumnIdentity | undefined);
    private _startNum?;
    /**
     * @stability stable
     */
    get startNum(): number;
    /**
     * @stability stable
     */
    set startNum(value: number);
    /**
     * @stability stable
     */
    resetStartNum(): void;
    /**
     * @stability stable
     */
    get startNumInput(): number | undefined;
    private _stepNum?;
    /**
     * @stability stable
     */
    get stepNum(): number;
    /**
     * @stability stable
     */
    set stepNum(value: number);
    /**
     * @stability stable
     */
    resetStepNum(): void;
    /**
     * @stability stable
     */
    get stepNumInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface TableColumn {
    /**
     * Column comment.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/table#comment Table#comment}
     *
     * @stability stable
     */
    readonly comment?: string;
    /**
     * Column name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/table#name Table#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Whether this column can contain null values.
     *
     * **Note**: Depending on your Snowflake version, the default value will not suffice if this column is used in a primary key constraint.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/table#nullable Table#nullable}
     *
     * @stability stable
     */
    readonly nullable?: boolean | cdktf.IResolvable;
    /**
     * Column type, e.g. VARIANT.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/table#type Table#type}
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * default block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/table#default Table#default}
     *
     * @stability stable
     */
    readonly default?: TableColumnDefault;
    /**
     * identity block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/table#identity Table#identity}
     *
     * @stability stable
     */
    readonly identity?: TableColumnIdentity;
}
export declare function tableColumnToTerraform(struct?: TableColumn | cdktf.IResolvable): any;
/**
 * @stability stable
 */
export interface TablePrimaryKey {
    /**
     * Columns to use in primary key.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/table#keys Table#keys}
     *
     * @stability stable
     */
    readonly keys: string[];
    /**
     * Name of constraint.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/table#name Table#name}
     *
     * @stability stable
     */
    readonly name?: string;
}
export declare function tablePrimaryKeyToTerraform(struct?: TablePrimaryKeyOutputReference | TablePrimaryKey): any;
/**
 * @stability stable
 */
export declare class TablePrimaryKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): TablePrimaryKey | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: TablePrimaryKey | undefined);
    private _keys?;
    /**
     * @stability stable
     */
    get keys(): string[];
    /**
     * @stability stable
     */
    set keys(value: string[]);
    /**
     * @stability stable
     */
    get keysInput(): string[] | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface TableTag {
    /**
     * Name of the database that the tag was created in.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/table#database Table#database}
     *
     * @stability stable
     */
    readonly database?: string;
    /**
     * Tag name, e.g. department.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/table#name Table#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Name of the schema that the tag was created in.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/table#schema Table#schema}
     *
     * @stability stable
     */
    readonly schema?: string;
    /**
     * Tag value, e.g. marketing_info.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/table#value Table#value}
     *
     * @stability stable
     */
    readonly value: string;
}
export declare function tableTagToTerraform(struct?: TableTag | cdktf.IResolvable): any;
/**
 * Represents a {@link https://www.terraform.io/docs/providers/snowflake/r/table snowflake_table}.
 *
 * @stability stable
 */
export declare class Table extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/snowflake/r/table snowflake_table} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: TableConfig);
    private _changeTracking?;
    /**
     * @stability stable
     */
    get changeTracking(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set changeTracking(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetChangeTracking(): void;
    /**
     * @stability stable
     */
    get changeTrackingInput(): boolean | cdktf.IResolvable | undefined;
    private _clusterBy?;
    /**
     * @stability stable
     */
    get clusterBy(): string[];
    /**
     * @stability stable
     */
    set clusterBy(value: string[]);
    /**
     * @stability stable
     */
    resetClusterBy(): void;
    /**
     * @stability stable
     */
    get clusterByInput(): string[] | undefined;
    private _comment?;
    /**
     * @stability stable
     */
    get comment(): string;
    /**
     * @stability stable
     */
    set comment(value: string);
    /**
     * @stability stable
     */
    resetComment(): void;
    /**
     * @stability stable
     */
    get commentInput(): string | undefined;
    private _dataRetentionDays?;
    /**
     * @stability stable
     */
    get dataRetentionDays(): number;
    /**
     * @stability stable
     */
    set dataRetentionDays(value: number);
    /**
     * @stability stable
     */
    resetDataRetentionDays(): void;
    /**
     * @stability stable
     */
    get dataRetentionDaysInput(): number | undefined;
    private _database?;
    /**
     * @stability stable
     */
    get database(): string;
    /**
     * @stability stable
     */
    set database(value: string);
    /**
     * @stability stable
     */
    get databaseInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get owner(): string;
    private _schema?;
    /**
     * @stability stable
     */
    get schema(): string;
    /**
     * @stability stable
     */
    set schema(value: string);
    /**
     * @stability stable
     */
    get schemaInput(): string | undefined;
    private _column?;
    /**
     * @stability stable
     */
    get column(): TableColumn[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set column(value: TableColumn[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get columnInput(): cdktf.IResolvable | TableColumn[] | undefined;
    private _primaryKey;
    /**
     * @stability stable
     */
    get primaryKey(): TablePrimaryKeyOutputReference;
    /**
     * @stability stable
     */
    putPrimaryKey(value: TablePrimaryKey): void;
    /**
     * @stability stable
     */
    resetPrimaryKey(): void;
    /**
     * @stability stable
     */
    get primaryKeyInput(): TablePrimaryKey | undefined;
    private _tag?;
    /**
     * @stability stable
     */
    get tag(): TableTag[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tag(value: TableTag[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTag(): void;
    /**
     * @stability stable
     */
    get tagInput(): cdktf.IResolvable | TableTag[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
