import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface TaskConfig extends cdktf.TerraformMetaArguments {
    /**
     * Specifies the predecessor task in the same database and schema of the current task.
     *
     * When a run of the predecessor task finishes successfully, it triggers this task (after a brief lag). (Conflict with schedule)
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/task#after Task#after}
     *
     * @stability stable
     */
    readonly after?: string;
    /**
     * Specifies a comment for the task.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/task#comment Task#comment}
     *
     * @stability stable
     */
    readonly comment?: string;
    /**
     * The database in which to create the task.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/task#database Task#database}
     *
     * @stability stable
     */
    readonly database: string;
    /**
     * Specifies if the task should be started (enabled) after creation or should remain suspended (default).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/task#enabled Task#enabled}
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * Specifies the name of the notification integration used for error notifications.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/task#error_integration Task#error_integration}
     *
     * @stability stable
     */
    readonly errorIntegration?: string;
    /**
     * Specifies the identifier for the task;
     *
     * must be unique for the database and schema in which the task is created.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/task#name Task#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The schedule for periodically running the task. This can be a cron or interval in minutes. (Conflict with after).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/task#schedule Task#schedule}
     *
     * @stability stable
     */
    readonly schedule?: string;
    /**
     * The schema in which to create the task.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/task#schema Task#schema}
     *
     * @stability stable
     */
    readonly schema: string;
    /**
     * Specifies session parameters to set for the session when the task runs. A task supports all session parameters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/task#session_parameters Task#session_parameters}
     *
     * @stability stable
     */
    readonly sessionParameters?: {
        [key: string]: string;
    };
    /**
     * Any single SQL statement, or a call to a stored procedure, executed when the task runs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/task#sql_statement Task#sql_statement}
     *
     * @stability stable
     */
    readonly sqlStatement: string;
    /**
     * Specifies the size of the compute resources to provision for the first run of the task, before a task history is available for Snowflake to determine an ideal size.
     *
     * Once a task has successfully completed a few runs, Snowflake ignores this parameter setting. (Conflicts with warehouse)
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/task#user_task_managed_initial_warehouse_size Task#user_task_managed_initial_warehouse_size}
     *
     * @stability stable
     */
    readonly userTaskManagedInitialWarehouseSize?: string;
    /**
     * Specifies the time limit on a single run of the task before it times out (in milliseconds).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/task#user_task_timeout_ms Task#user_task_timeout_ms}
     *
     * @stability stable
     */
    readonly userTaskTimeoutMs?: number;
    /**
     * The warehouse the task will use.
     *
     * Omit this parameter to use Snowflake-managed compute resources for runs of this task. (Conflicts with user_task_managed_initial_warehouse_size)
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/task#warehouse Task#warehouse}
     *
     * @stability stable
     */
    readonly warehouse?: string;
    /**
     * Specifies a Boolean SQL expression; multiple conditions joined with AND/OR are supported.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/task#when Task#when}
     *
     * @stability stable
     */
    readonly when?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/snowflake/r/task snowflake_task}.
 *
 * @stability stable
 */
export declare class Task extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/snowflake/r/task snowflake_task} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: TaskConfig);
    private _after?;
    /**
     * @stability stable
     */
    get after(): string;
    /**
     * @stability stable
     */
    set after(value: string);
    /**
     * @stability stable
     */
    resetAfter(): void;
    /**
     * @stability stable
     */
    get afterInput(): string | undefined;
    private _comment?;
    /**
     * @stability stable
     */
    get comment(): string;
    /**
     * @stability stable
     */
    set comment(value: string);
    /**
     * @stability stable
     */
    resetComment(): void;
    /**
     * @stability stable
     */
    get commentInput(): string | undefined;
    private _database?;
    /**
     * @stability stable
     */
    get database(): string;
    /**
     * @stability stable
     */
    set database(value: string);
    /**
     * @stability stable
     */
    get databaseInput(): string | undefined;
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnabled(): void;
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _errorIntegration?;
    /**
     * @stability stable
     */
    get errorIntegration(): string;
    /**
     * @stability stable
     */
    set errorIntegration(value: string);
    /**
     * @stability stable
     */
    resetErrorIntegration(): void;
    /**
     * @stability stable
     */
    get errorIntegrationInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _schedule?;
    /**
     * @stability stable
     */
    get schedule(): string;
    /**
     * @stability stable
     */
    set schedule(value: string);
    /**
     * @stability stable
     */
    resetSchedule(): void;
    /**
     * @stability stable
     */
    get scheduleInput(): string | undefined;
    private _schema?;
    /**
     * @stability stable
     */
    get schema(): string;
    /**
     * @stability stable
     */
    set schema(value: string);
    /**
     * @stability stable
     */
    get schemaInput(): string | undefined;
    private _sessionParameters?;
    /**
     * @stability stable
     */
    get sessionParameters(): {
        [key: string]: string;
    };
    /**
     * @stability stable
     */
    set sessionParameters(value: {
        [key: string]: string;
    });
    /**
     * @stability stable
     */
    resetSessionParameters(): void;
    /**
     * @stability stable
     */
    get sessionParametersInput(): {
        [key: string]: string;
    } | undefined;
    private _sqlStatement?;
    /**
     * @stability stable
     */
    get sqlStatement(): string;
    /**
     * @stability stable
     */
    set sqlStatement(value: string);
    /**
     * @stability stable
     */
    get sqlStatementInput(): string | undefined;
    private _userTaskManagedInitialWarehouseSize?;
    /**
     * @stability stable
     */
    get userTaskManagedInitialWarehouseSize(): string;
    /**
     * @stability stable
     */
    set userTaskManagedInitialWarehouseSize(value: string);
    /**
     * @stability stable
     */
    resetUserTaskManagedInitialWarehouseSize(): void;
    /**
     * @stability stable
     */
    get userTaskManagedInitialWarehouseSizeInput(): string | undefined;
    private _userTaskTimeoutMs?;
    /**
     * @stability stable
     */
    get userTaskTimeoutMs(): number;
    /**
     * @stability stable
     */
    set userTaskTimeoutMs(value: number);
    /**
     * @stability stable
     */
    resetUserTaskTimeoutMs(): void;
    /**
     * @stability stable
     */
    get userTaskTimeoutMsInput(): number | undefined;
    private _warehouse?;
    /**
     * @stability stable
     */
    get warehouse(): string;
    /**
     * @stability stable
     */
    set warehouse(value: string);
    /**
     * @stability stable
     */
    resetWarehouse(): void;
    /**
     * @stability stable
     */
    get warehouseInput(): string | undefined;
    private _when?;
    /**
     * @stability stable
     */
    get when(): string;
    /**
     * @stability stable
     */
    set when(value: string);
    /**
     * @stability stable
     */
    resetWhen(): void;
    /**
     * @stability stable
     */
    get whenInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
