import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface UserPublicKeysConfig extends cdktf.TerraformMetaArguments {
    /**
     * Name of the user.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/user_public_keys#name UserPublicKeys#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Specifies the user’s RSA public key; used for key-pair authentication. Must be on 1 line without header and trailer.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/user_public_keys#rsa_public_key UserPublicKeys#rsa_public_key}
     *
     * @stability stable
     */
    readonly rsaPublicKey?: string;
    /**
     * Specifies the user’s second RSA public key;
     *
     * used to rotate the public and Public keys for key-pair authentication based on an expiration schedule set by your organization. Must be on 1 line without header and trailer.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/user_public_keys#rsa_public_key_2 UserPublicKeys#rsa_public_key_2}
     *
     * @stability stable
     */
    readonly rsaPublicKey2?: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/snowflake/r/user_public_keys snowflake_user_public_keys}.
 *
 * @stability stable
 */
export declare class UserPublicKeys extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/snowflake/r/user_public_keys snowflake_user_public_keys} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: UserPublicKeysConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _rsaPublicKey?;
    /**
     * @stability stable
     */
    get rsaPublicKey(): string;
    /**
     * @stability stable
     */
    set rsaPublicKey(value: string);
    /**
     * @stability stable
     */
    resetRsaPublicKey(): void;
    /**
     * @stability stable
     */
    get rsaPublicKeyInput(): string | undefined;
    private _rsaPublicKey2?;
    /**
     * @stability stable
     */
    get rsaPublicKey2(): string;
    /**
     * @stability stable
     */
    set rsaPublicKey2(value: string);
    /**
     * @stability stable
     */
    resetRsaPublicKey2(): void;
    /**
     * @stability stable
     */
    get rsaPublicKey2Input(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
