import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface UserConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/user#comment User#comment}.
     *
     * @stability stable
     */
    readonly comment?: string;
    /**
     * Specifies the namespace (database only or database and schema) that is active by default for the user’s session upon login.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/user#default_namespace User#default_namespace}
     *
     * @stability stable
     */
    readonly defaultNamespace?: string;
    /**
     * Specifies the role that is active by default for the user’s session upon login.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/user#default_role User#default_role}
     *
     * @stability stable
     */
    readonly defaultRole?: string;
    /**
     * Specifies the virtual warehouse that is active by default for the user’s session upon login.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/user#default_warehouse User#default_warehouse}
     *
     * @stability stable
     */
    readonly defaultWarehouse?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/user#disabled User#disabled}.
     *
     * @stability stable
     */
    readonly disabled?: boolean | cdktf.IResolvable;
    /**
     * Name displayed for the user in the Snowflake web interface.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/user#display_name User#display_name}
     *
     * @stability stable
     */
    readonly displayName?: string;
    /**
     * Email address for the user.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/user#email User#email}
     *
     * @stability stable
     */
    readonly email?: string;
    /**
     * First name of the user.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/user#first_name User#first_name}
     *
     * @stability stable
     */
    readonly firstName?: string;
    /**
     * Last name of the user.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/user#last_name User#last_name}
     *
     * @stability stable
     */
    readonly lastName?: string;
    /**
     * The name users use to log in. If not supplied, snowflake will use name instead.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/user#login_name User#login_name}
     *
     * @stability stable
     */
    readonly loginName?: string;
    /**
     * Specifies whether the user is forced to change their password on next login (including their first/initial login) into the system.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/user#must_change_password User#must_change_password}
     *
     * @stability stable
     */
    readonly mustChangePassword?: boolean | cdktf.IResolvable;
    /**
     * Name of the user. Note that if you do not supply login_name this will be used as login_name. [doc](https://docs.snowflake.net/manuals/sql-reference/sql/create-user.html#required-parameters).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/user#name User#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * **WARNING:** this will put the password in the terraform state file. Use carefully.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/user#password User#password}
     *
     * @stability stable
     */
    readonly password?: string;
    /**
     * Specifies the user’s RSA public key; used for key-pair authentication. Must be on 1 line without header and trailer.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/user#rsa_public_key User#rsa_public_key}
     *
     * @stability stable
     */
    readonly rsaPublicKey?: string;
    /**
     * Specifies the user’s second RSA public key;
     *
     * used to rotate the public and private keys for key-pair authentication based on an expiration schedule set by your organization. Must be on 1 line without header and trailer.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/user#rsa_public_key_2 User#rsa_public_key_2}
     *
     * @stability stable
     */
    readonly rsaPublicKey2?: string;
    /**
     * tag block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/user#tag User#tag}
     *
     * @stability stable
     */
    readonly tag?: UserTag[] | cdktf.IResolvable;
}
/**
 * @stability stable
 */
export interface UserTag {
    /**
     * Name of the database that the tag was created in.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/user#database User#database}
     *
     * @stability stable
     */
    readonly database?: string;
    /**
     * Tag name, e.g. department.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/user#name User#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Name of the schema that the tag was created in.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/user#schema User#schema}
     *
     * @stability stable
     */
    readonly schema?: string;
    /**
     * Tag value, e.g. marketing_info.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/user#value User#value}
     *
     * @stability stable
     */
    readonly value: string;
}
export declare function userTagToTerraform(struct?: UserTag | cdktf.IResolvable): any;
/**
 * Represents a {@link https://www.terraform.io/docs/providers/snowflake/r/user snowflake_user}.
 *
 * @stability stable
 */
export declare class User extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/snowflake/r/user snowflake_user} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: UserConfig);
    private _comment?;
    /**
     * @stability stable
     */
    get comment(): string;
    /**
     * @stability stable
     */
    set comment(value: string);
    /**
     * @stability stable
     */
    resetComment(): void;
    /**
     * @stability stable
     */
    get commentInput(): string | undefined;
    private _defaultNamespace?;
    /**
     * @stability stable
     */
    get defaultNamespace(): string;
    /**
     * @stability stable
     */
    set defaultNamespace(value: string);
    /**
     * @stability stable
     */
    resetDefaultNamespace(): void;
    /**
     * @stability stable
     */
    get defaultNamespaceInput(): string | undefined;
    private _defaultRole?;
    /**
     * @stability stable
     */
    get defaultRole(): string;
    /**
     * @stability stable
     */
    set defaultRole(value: string);
    /**
     * @stability stable
     */
    resetDefaultRole(): void;
    /**
     * @stability stable
     */
    get defaultRoleInput(): string | undefined;
    private _defaultWarehouse?;
    /**
     * @stability stable
     */
    get defaultWarehouse(): string;
    /**
     * @stability stable
     */
    set defaultWarehouse(value: string);
    /**
     * @stability stable
     */
    resetDefaultWarehouse(): void;
    /**
     * @stability stable
     */
    get defaultWarehouseInput(): string | undefined;
    private _disabled?;
    /**
     * @stability stable
     */
    get disabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set disabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDisabled(): void;
    /**
     * @stability stable
     */
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    resetDisplayName(): void;
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    private _email?;
    /**
     * @stability stable
     */
    get email(): string;
    /**
     * @stability stable
     */
    set email(value: string);
    /**
     * @stability stable
     */
    resetEmail(): void;
    /**
     * @stability stable
     */
    get emailInput(): string | undefined;
    private _firstName?;
    /**
     * @stability stable
     */
    get firstName(): string;
    /**
     * @stability stable
     */
    set firstName(value: string);
    /**
     * @stability stable
     */
    resetFirstName(): void;
    /**
     * @stability stable
     */
    get firstNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get hasRsaPublicKey(): cdktf.IResolvable;
    /**
     * @stability stable
     */
    get id(): string;
    private _lastName?;
    /**
     * @stability stable
     */
    get lastName(): string;
    /**
     * @stability stable
     */
    set lastName(value: string);
    /**
     * @stability stable
     */
    resetLastName(): void;
    /**
     * @stability stable
     */
    get lastNameInput(): string | undefined;
    private _loginName?;
    /**
     * @stability stable
     */
    get loginName(): string;
    /**
     * @stability stable
     */
    set loginName(value: string);
    /**
     * @stability stable
     */
    resetLoginName(): void;
    /**
     * @stability stable
     */
    get loginNameInput(): string | undefined;
    private _mustChangePassword?;
    /**
     * @stability stable
     */
    get mustChangePassword(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set mustChangePassword(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetMustChangePassword(): void;
    /**
     * @stability stable
     */
    get mustChangePasswordInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _password?;
    /**
     * @stability stable
     */
    get password(): string;
    /**
     * @stability stable
     */
    set password(value: string);
    /**
     * @stability stable
     */
    resetPassword(): void;
    /**
     * @stability stable
     */
    get passwordInput(): string | undefined;
    private _rsaPublicKey?;
    /**
     * @stability stable
     */
    get rsaPublicKey(): string;
    /**
     * @stability stable
     */
    set rsaPublicKey(value: string);
    /**
     * @stability stable
     */
    resetRsaPublicKey(): void;
    /**
     * @stability stable
     */
    get rsaPublicKeyInput(): string | undefined;
    private _rsaPublicKey2?;
    /**
     * @stability stable
     */
    get rsaPublicKey2(): string;
    /**
     * @stability stable
     */
    set rsaPublicKey2(value: string);
    /**
     * @stability stable
     */
    resetRsaPublicKey2(): void;
    /**
     * @stability stable
     */
    get rsaPublicKey2Input(): string | undefined;
    private _tag?;
    /**
     * @stability stable
     */
    get tag(): UserTag[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tag(value: UserTag[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTag(): void;
    /**
     * @stability stable
     */
    get tagInput(): cdktf.IResolvable | UserTag[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
