import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ViewConfig extends cdktf.TerraformMetaArguments {
    /**
     * Specifies a comment for the view.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/view#comment View#comment}
     *
     * @stability stable
     */
    readonly comment?: string;
    /**
     * The database in which to create the view. Don't use the | character.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/view#database View#database}
     *
     * @stability stable
     */
    readonly database: string;
    /**
     * Specifies that the view is secure.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/view#is_secure View#is_secure}
     *
     * @stability stable
     */
    readonly isSecure?: boolean | cdktf.IResolvable;
    /**
     * Specifies the identifier for the view;
     *
     * must be unique for the schema in which the view is created. Don't use the | character.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/view#name View#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Overwrites the View if it exists.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/view#or_replace View#or_replace}
     *
     * @stability stable
     */
    readonly orReplace?: boolean | cdktf.IResolvable;
    /**
     * The schema in which to create the view. Don't use the | character.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/view#schema View#schema}
     *
     * @stability stable
     */
    readonly schema: string;
    /**
     * Specifies the query used to create the view.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/view#statement View#statement}
     *
     * @stability stable
     */
    readonly statement: string;
    /**
     * tag block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/view#tag View#tag}
     *
     * @stability stable
     */
    readonly tag?: ViewTag[] | cdktf.IResolvable;
}
/**
 * @stability stable
 */
export interface ViewTag {
    /**
     * Name of the database that the tag was created in.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/view#database View#database}
     *
     * @stability stable
     */
    readonly database?: string;
    /**
     * Tag name, e.g. department.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/view#name View#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Name of the schema that the tag was created in.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/view#schema View#schema}
     *
     * @stability stable
     */
    readonly schema?: string;
    /**
     * Tag value, e.g. marketing_info.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/view#value View#value}
     *
     * @stability stable
     */
    readonly value: string;
}
export declare function viewTagToTerraform(struct?: ViewTag | cdktf.IResolvable): any;
/**
 * Represents a {@link https://www.terraform.io/docs/providers/snowflake/r/view snowflake_view}.
 *
 * @stability stable
 */
export declare class View extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/snowflake/r/view snowflake_view} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ViewConfig);
    private _comment?;
    /**
     * @stability stable
     */
    get comment(): string;
    /**
     * @stability stable
     */
    set comment(value: string);
    /**
     * @stability stable
     */
    resetComment(): void;
    /**
     * @stability stable
     */
    get commentInput(): string | undefined;
    private _database?;
    /**
     * @stability stable
     */
    get database(): string;
    /**
     * @stability stable
     */
    set database(value: string);
    /**
     * @stability stable
     */
    get databaseInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _isSecure?;
    /**
     * @stability stable
     */
    get isSecure(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set isSecure(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetIsSecure(): void;
    /**
     * @stability stable
     */
    get isSecureInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _orReplace?;
    /**
     * @stability stable
     */
    get orReplace(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set orReplace(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetOrReplace(): void;
    /**
     * @stability stable
     */
    get orReplaceInput(): boolean | cdktf.IResolvable | undefined;
    private _schema?;
    /**
     * @stability stable
     */
    get schema(): string;
    /**
     * @stability stable
     */
    set schema(value: string);
    /**
     * @stability stable
     */
    get schemaInput(): string | undefined;
    private _statement?;
    /**
     * @stability stable
     */
    get statement(): string;
    /**
     * @stability stable
     */
    set statement(value: string);
    /**
     * @stability stable
     */
    get statementInput(): string | undefined;
    private _tag?;
    /**
     * @stability stable
     */
    get tag(): ViewTag[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tag(value: ViewTag[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTag(): void;
    /**
     * @stability stable
     */
    get tagInput(): cdktf.IResolvable | ViewTag[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
