import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface WarehouseConfig extends cdktf.TerraformMetaArguments {
    /**
     * Specifies whether to automatically resume a warehouse when a SQL statement (e.g. query) is submitted to it.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/warehouse#auto_resume Warehouse#auto_resume}
     *
     * @stability stable
     */
    readonly autoResume?: boolean | cdktf.IResolvable;
    /**
     * Specifies the number of seconds of inactivity after which a warehouse is automatically suspended.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/warehouse#auto_suspend Warehouse#auto_suspend}
     *
     * @stability stable
     */
    readonly autoSuspend?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/warehouse#comment Warehouse#comment}.
     *
     * @stability stable
     */
    readonly comment?: string;
    /**
     * Specifies whether the warehouse is created initially in the ‘Suspended’ state.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/warehouse#initially_suspended Warehouse#initially_suspended}
     *
     * @stability stable
     */
    readonly initiallySuspended?: boolean | cdktf.IResolvable;
    /**
     * Specifies the maximum number of server clusters for the warehouse.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/warehouse#max_cluster_count Warehouse#max_cluster_count}
     *
     * @stability stable
     */
    readonly maxClusterCount?: number;
    /**
     * Object parameter that specifies the concurrency level for SQL statements (i.e. queries and DML) executed by a warehouse.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/warehouse#max_concurrency_level Warehouse#max_concurrency_level}
     *
     * @stability stable
     */
    readonly maxConcurrencyLevel?: number;
    /**
     * Specifies the minimum number of server clusters for the warehouse (only applies to multi-cluster warehouses).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/warehouse#min_cluster_count Warehouse#min_cluster_count}
     *
     * @stability stable
     */
    readonly minClusterCount?: number;
    /**
     * Identifier for the virtual warehouse; must be unique for your account.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/warehouse#name Warehouse#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Specifies the name of a resource monitor that is explicitly assigned to the warehouse.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/warehouse#resource_monitor Warehouse#resource_monitor}
     *
     * @stability stable
     */
    readonly resourceMonitor?: string;
    /**
     * Specifies the policy for automatically starting and shutting down clusters in a multi-cluster warehouse running in Auto-scale mode.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/warehouse#scaling_policy Warehouse#scaling_policy}
     *
     * @stability stable
     */
    readonly scalingPolicy?: string;
    /**
     * Object parameter that specifies the time, in seconds, a SQL statement (query, DDL, DML, etc.) can be queued on a warehouse before it is canceled by the system.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/warehouse#statement_queued_timeout_in_seconds Warehouse#statement_queued_timeout_in_seconds}
     *
     * @stability stable
     */
    readonly statementQueuedTimeoutInSeconds?: number;
    /**
     * Specifies the time, in seconds, after which a running SQL statement (query, DDL, DML, etc.) is canceled by the system.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/warehouse#statement_timeout_in_seconds Warehouse#statement_timeout_in_seconds}
     *
     * @stability stable
     */
    readonly statementTimeoutInSeconds?: number;
    /**
     * Specifies whether the warehouse, after being resized, waits for all the servers to provision before executing any queued or new queries.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/warehouse#wait_for_provisioning Warehouse#wait_for_provisioning}
     *
     * @stability stable
     */
    readonly waitForProvisioning?: boolean | cdktf.IResolvable;
    /**
     * Specifies the size of the virtual warehouse.
     *
     * Larger warehouse sizes 5X-Large and 6X-Large are currently in preview and only available on Amazon Web Services (AWS).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/warehouse#warehouse_size Warehouse#warehouse_size}
     *
     * @stability stable
     */
    readonly warehouseSize?: string;
    /**
     * tag block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/warehouse#tag Warehouse#tag}
     *
     * @stability stable
     */
    readonly tag?: WarehouseTag[] | cdktf.IResolvable;
}
/**
 * @stability stable
 */
export interface WarehouseTag {
    /**
     * Name of the database that the tag was created in.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/warehouse#database Warehouse#database}
     *
     * @stability stable
     */
    readonly database?: string;
    /**
     * Tag name, e.g. department.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/warehouse#name Warehouse#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Name of the schema that the tag was created in.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/warehouse#schema Warehouse#schema}
     *
     * @stability stable
     */
    readonly schema?: string;
    /**
     * Tag value, e.g. marketing_info.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/snowflake/r/warehouse#value Warehouse#value}
     *
     * @stability stable
     */
    readonly value: string;
}
export declare function warehouseTagToTerraform(struct?: WarehouseTag | cdktf.IResolvable): any;
/**
 * Represents a {@link https://www.terraform.io/docs/providers/snowflake/r/warehouse snowflake_warehouse}.
 *
 * @stability stable
 */
export declare class Warehouse extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/snowflake/r/warehouse snowflake_warehouse} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: WarehouseConfig);
    private _autoResume?;
    /**
     * @stability stable
     */
    get autoResume(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set autoResume(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAutoResume(): void;
    /**
     * @stability stable
     */
    get autoResumeInput(): boolean | cdktf.IResolvable | undefined;
    private _autoSuspend?;
    /**
     * @stability stable
     */
    get autoSuspend(): number;
    /**
     * @stability stable
     */
    set autoSuspend(value: number);
    /**
     * @stability stable
     */
    resetAutoSuspend(): void;
    /**
     * @stability stable
     */
    get autoSuspendInput(): number | undefined;
    private _comment?;
    /**
     * @stability stable
     */
    get comment(): string;
    /**
     * @stability stable
     */
    set comment(value: string);
    /**
     * @stability stable
     */
    resetComment(): void;
    /**
     * @stability stable
     */
    get commentInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _initiallySuspended?;
    /**
     * @stability stable
     */
    get initiallySuspended(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set initiallySuspended(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetInitiallySuspended(): void;
    /**
     * @stability stable
     */
    get initiallySuspendedInput(): boolean | cdktf.IResolvable | undefined;
    private _maxClusterCount?;
    /**
     * @stability stable
     */
    get maxClusterCount(): number;
    /**
     * @stability stable
     */
    set maxClusterCount(value: number);
    /**
     * @stability stable
     */
    resetMaxClusterCount(): void;
    /**
     * @stability stable
     */
    get maxClusterCountInput(): number | undefined;
    private _maxConcurrencyLevel?;
    /**
     * @stability stable
     */
    get maxConcurrencyLevel(): number;
    /**
     * @stability stable
     */
    set maxConcurrencyLevel(value: number);
    /**
     * @stability stable
     */
    resetMaxConcurrencyLevel(): void;
    /**
     * @stability stable
     */
    get maxConcurrencyLevelInput(): number | undefined;
    private _minClusterCount?;
    /**
     * @stability stable
     */
    get minClusterCount(): number;
    /**
     * @stability stable
     */
    set minClusterCount(value: number);
    /**
     * @stability stable
     */
    resetMinClusterCount(): void;
    /**
     * @stability stable
     */
    get minClusterCountInput(): number | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceMonitor?;
    /**
     * @stability stable
     */
    get resourceMonitor(): string;
    /**
     * @stability stable
     */
    set resourceMonitor(value: string);
    /**
     * @stability stable
     */
    resetResourceMonitor(): void;
    /**
     * @stability stable
     */
    get resourceMonitorInput(): string | undefined;
    private _scalingPolicy?;
    /**
     * @stability stable
     */
    get scalingPolicy(): string;
    /**
     * @stability stable
     */
    set scalingPolicy(value: string);
    /**
     * @stability stable
     */
    resetScalingPolicy(): void;
    /**
     * @stability stable
     */
    get scalingPolicyInput(): string | undefined;
    private _statementQueuedTimeoutInSeconds?;
    /**
     * @stability stable
     */
    get statementQueuedTimeoutInSeconds(): number;
    /**
     * @stability stable
     */
    set statementQueuedTimeoutInSeconds(value: number);
    /**
     * @stability stable
     */
    resetStatementQueuedTimeoutInSeconds(): void;
    /**
     * @stability stable
     */
    get statementQueuedTimeoutInSecondsInput(): number | undefined;
    private _statementTimeoutInSeconds?;
    /**
     * @stability stable
     */
    get statementTimeoutInSeconds(): number;
    /**
     * @stability stable
     */
    set statementTimeoutInSeconds(value: number);
    /**
     * @stability stable
     */
    resetStatementTimeoutInSeconds(): void;
    /**
     * @stability stable
     */
    get statementTimeoutInSecondsInput(): number | undefined;
    private _waitForProvisioning?;
    /**
     * @stability stable
     */
    get waitForProvisioning(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set waitForProvisioning(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetWaitForProvisioning(): void;
    /**
     * @stability stable
     */
    get waitForProvisioningInput(): boolean | cdktf.IResolvable | undefined;
    private _warehouseSize?;
    /**
     * @stability stable
     */
    get warehouseSize(): string;
    /**
     * @stability stable
     */
    set warehouseSize(value: string);
    /**
     * @stability stable
     */
    resetWarehouseSize(): void;
    /**
     * @stability stable
     */
    get warehouseSizeInput(): string | undefined;
    private _tag?;
    /**
     * @stability stable
     */
    get tag(): WarehouseTag[] | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tag(value: WarehouseTag[] | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTag(): void;
    /**
     * @stability stable
     */
    get tagInput(): cdktf.IResolvable | WarehouseTag[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
