from marshmallow import fields, EXCLUDE, post_load
from cc_py_commons.schemas.camel_case_schema import CamelCaseSchema
from cc_py_commons.lanes.lane import Lane

class LaneSchema(CamelCaseSchema):
  class Meta:
      unknown = EXCLUDE

  trailer_type = fields.String()
  origin_city = fields.String()
  origin_state = fields.String()
  dest_city = fields.String()
  dest_state = fields.String()  
  origin_zip = fields.String(allow_none=True)
  origin_lat = fields.Float(allow_none=True)
  origin_lng = fields.Float(allow_none=True)
  origin_deadhead = fields.Float(allow_none=True)
  dest_zip = fields.String(allow_none=True)
  destination_states = fields.String(allow_none=True)
  dest_lat = fields.Float(allow_none=True)
  dest_lng = fields.Float(allow_none=True)
  destination_deadhead = fields.Float(allow_none=True)
  priced_loads = fields.Integer(allow_none=True, missing=0)
  # generated by server
  id = fields.UUID(allow_none=True)