import * as eks from '@aws-cdk/aws-eks';
import * as cdk from '@aws-cdk/core';
/**
 * The construct properties for KubeSphere.
 *
 * @stability stable
 */
export interface KubeSphereProps {
    /**
     * The existing Amazon EKS cluster(if any).
     *
     * @stability stable
     */
    readonly cluster?: eks.ICluster;
}
/**
 * The KubeSphere workload.
 *
 * @stability stable
 */
export declare class KubeSphere extends cdk.Construct {
    /**
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string, props?: KubeSphereProps);
    private _createEksCluster;
}
