# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from .. import utilities, tables

class Oidc(pulumi.CustomResource):
    account_link_action: pulumi.Output[str]
    """
    Specifies the account linking action for an IdP user.
    """
    account_link_group_includes: pulumi.Output[list]
    """
    Group memberships to determine link candidates.
    """
    acs_binding: pulumi.Output[str]
    """
    The method of making an ACS request. It can be set to `"HTTP-POST"` or `"HTTP-REDIRECT"`.
    """
    acs_type: pulumi.Output[str]
    """
    The type of ACS. Default is `"INSTANCE"`.
    """
    authorization_binding: pulumi.Output[str]
    """
    The method of making an authorization request. It can be set to `"HTTP-POST"` or `"HTTP-REDIRECT"`.
    """
    authorization_url: pulumi.Output[str]
    """
    IdP Authorization Server (AS) endpoint to request consent from the user and obtain an authorization code grant.
    """
    client_id: pulumi.Output[str]
    """
    Unique identifier issued by AS for the Okta IdP instance.
    """
    client_secret: pulumi.Output[str]
    """
    Client secret issued by AS for the Okta IdP instance.
    """
    deprovisioned_action: pulumi.Output[str]
    """
    Action for a previously deprovisioned IdP user during authentication. Can be `"NONE"` or `"REACTIVATE"`.
    """
    groups_action: pulumi.Output[str]
    """
    Provisioning action for IdP user's group memberships. It can be `"NONE"`, `"SYNC"`, `"APPEND"`, or `"ASSIGN"`.
    """
    groups_assignments: pulumi.Output[list]
    """
    List of Okta Group IDs to add an IdP user as a member with the `"ASSIGN"` `groups_action`.
    """
    groups_attribute: pulumi.Output[str]
    """
    IdP user profile attribute name (case-insensitive) for an array value that contains group memberships.
    """
    groups_filters: pulumi.Output[list]
    """
    Whitelist of Okta Group identifiers that are allowed for the `"APPEND"` or `"SYNC"` `groups_action`.
    """
    issuer_mode: pulumi.Output[str]
    """
    Indicates whether Okta uses the original Okta org domain URL, or a custom domain URL. It can be `"ORG_URL"` or `"CUSTOM_URL"`.
    """
    issuer_url: pulumi.Output[str]
    """
    URI that identifies the issuer.
    """
    jwks_binding: pulumi.Output[str]
    """
    The method of making a request for the OIDC JWKS. It can be set to `"HTTP-POST"` or `"HTTP-REDIRECT"`.
    """
    jwks_url: pulumi.Output[str]
    """
    Endpoint where the signer of the keys publishes its keys in a JWK Set.
    """
    max_clock_skew: pulumi.Output[float]
    """
    Maximum allowable clock-skew when processing messages from the IdP.
    """
    name: pulumi.Output[str]
    """
    The Application's display name.
    """
    profile_master: pulumi.Output[bool]
    """
    Determines if the IdP should act as a source of truth for user profile attributes.
    """
    protocol_type: pulumi.Output[str]
    """
    The type of protocol to use. It can be `"OIDC"` or `"OAUTH2"`.
    """
    provisioning_action: pulumi.Output[str]
    """
    Provisioning action for an IdP user during authentication.
    """
    request_signature_algorithm: pulumi.Output[str]
    """
    algorithm to use to sign requests
    """
    request_signature_scope: pulumi.Output[str]
    """
    algorithm to use to sign response
    """
    response_signature_algorithm: pulumi.Output[str]
    """
    algorithm to use to sign requests
    """
    response_signature_scope: pulumi.Output[str]
    """
    algorithm to use to sign response
    """
    scopes: pulumi.Output[list]
    """
    The scopes of the IdP.
    """
    status: pulumi.Output[str]
    """
    Status of the IdP.
    """
    subject_match_attribute: pulumi.Output[str]
    """
    Okta user profile attribute for matching transformed IdP username. Only for matchType `"CUSTOM_ATTRIBUTE"`.
    """
    subject_match_type: pulumi.Output[str]
    """
    Determines the Okta user profile attribute match conditions for account linking and authentication of the transformed IdP username. By default it is set to `"USERNAME"`. It can be set to `"USERNAME"`, `"EMAIL"`, `"USERNAME_OR_EMAIL"` or `"CUSTOM_ATTRIBUTE"`.
    """
    suspended_action: pulumi.Output[str]
    """
    Action for a previously suspended IdP user during authentication. Can be set to `"NONE"` or `"UNSUSPEND"`
    """
    token_binding: pulumi.Output[str]
    """
    The method of making a token request. It can be set to `"HTTP-POST"` or `"HTTP-REDIRECT"`.
    """
    token_url: pulumi.Output[str]
    """
    IdP Authorization Server (AS) endpoint to exchange the authorization code grant for an access token.
    """
    type: pulumi.Output[str]
    """
    Type of OIDC IdP.
    """
    user_info_binding: pulumi.Output[str]
    user_info_url: pulumi.Output[str]
    """
    Protected resource endpoint that returns claims about the authenticated user.
    """
    username_template: pulumi.Output[str]
    """
    Okta EL Expression to generate or transform a unique username for the IdP user.
    """
    def __init__(__self__, resource_name, opts=None, account_link_action=None, account_link_group_includes=None, acs_binding=None, acs_type=None, authorization_binding=None, authorization_url=None, client_id=None, client_secret=None, deprovisioned_action=None, groups_action=None, groups_assignments=None, groups_attribute=None, groups_filters=None, issuer_mode=None, issuer_url=None, jwks_binding=None, jwks_url=None, max_clock_skew=None, name=None, profile_master=None, protocol_type=None, provisioning_action=None, request_signature_algorithm=None, request_signature_scope=None, response_signature_algorithm=None, response_signature_scope=None, scopes=None, status=None, subject_match_attribute=None, subject_match_type=None, suspended_action=None, token_binding=None, token_url=None, user_info_binding=None, user_info_url=None, username_template=None, __props__=None, __name__=None, __opts__=None):
        """
        Creates an OIDC Identity Provider.

        This resource allows you to create and configure an OIDC Identity Provider.

        ## Example Usage



        ```python
        import pulumi
        import pulumi_okta as okta

        example = okta.idp.Oidc("example",
            acs_binding="HTTP-POST",
            acs_type="INSTANCE",
            authorization_binding="HTTP-REDIRECT",
            authorization_url="https://idp.example.com/authorize",
            client_id="efg456",
            client_secret="efg456",
            issuer_url="https://id.example.com",
            jwks_binding="HTTP-REDIRECT",
            jwks_url="https://idp.example.com/keys",
            scopes=["openid"],
            token_binding="HTTP-POST",
            token_url="https://idp.example.com/token",
            user_info_binding="HTTP-REDIRECT",
            user_info_url="https://idp.example.com/userinfo",
            username_template="idpuser.email")
        ```


        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_link_action: Specifies the account linking action for an IdP user.
        :param pulumi.Input[list] account_link_group_includes: Group memberships to determine link candidates.
        :param pulumi.Input[str] acs_binding: The method of making an ACS request. It can be set to `"HTTP-POST"` or `"HTTP-REDIRECT"`.
        :param pulumi.Input[str] acs_type: The type of ACS. Default is `"INSTANCE"`.
        :param pulumi.Input[str] authorization_binding: The method of making an authorization request. It can be set to `"HTTP-POST"` or `"HTTP-REDIRECT"`.
        :param pulumi.Input[str] authorization_url: IdP Authorization Server (AS) endpoint to request consent from the user and obtain an authorization code grant.
        :param pulumi.Input[str] client_id: Unique identifier issued by AS for the Okta IdP instance.
        :param pulumi.Input[str] client_secret: Client secret issued by AS for the Okta IdP instance.
        :param pulumi.Input[str] deprovisioned_action: Action for a previously deprovisioned IdP user during authentication. Can be `"NONE"` or `"REACTIVATE"`.
        :param pulumi.Input[str] groups_action: Provisioning action for IdP user's group memberships. It can be `"NONE"`, `"SYNC"`, `"APPEND"`, or `"ASSIGN"`.
        :param pulumi.Input[list] groups_assignments: List of Okta Group IDs to add an IdP user as a member with the `"ASSIGN"` `groups_action`.
        :param pulumi.Input[str] groups_attribute: IdP user profile attribute name (case-insensitive) for an array value that contains group memberships.
        :param pulumi.Input[list] groups_filters: Whitelist of Okta Group identifiers that are allowed for the `"APPEND"` or `"SYNC"` `groups_action`.
        :param pulumi.Input[str] issuer_mode: Indicates whether Okta uses the original Okta org domain URL, or a custom domain URL. It can be `"ORG_URL"` or `"CUSTOM_URL"`.
        :param pulumi.Input[str] issuer_url: URI that identifies the issuer.
        :param pulumi.Input[str] jwks_binding: The method of making a request for the OIDC JWKS. It can be set to `"HTTP-POST"` or `"HTTP-REDIRECT"`.
        :param pulumi.Input[str] jwks_url: Endpoint where the signer of the keys publishes its keys in a JWK Set.
        :param pulumi.Input[float] max_clock_skew: Maximum allowable clock-skew when processing messages from the IdP.
        :param pulumi.Input[str] name: The Application's display name.
        :param pulumi.Input[bool] profile_master: Determines if the IdP should act as a source of truth for user profile attributes.
        :param pulumi.Input[str] protocol_type: The type of protocol to use. It can be `"OIDC"` or `"OAUTH2"`.
        :param pulumi.Input[str] provisioning_action: Provisioning action for an IdP user during authentication.
        :param pulumi.Input[str] request_signature_algorithm: algorithm to use to sign requests
        :param pulumi.Input[str] request_signature_scope: algorithm to use to sign response
        :param pulumi.Input[str] response_signature_algorithm: algorithm to use to sign requests
        :param pulumi.Input[str] response_signature_scope: algorithm to use to sign response
        :param pulumi.Input[list] scopes: The scopes of the IdP.
        :param pulumi.Input[str] status: Status of the IdP.
        :param pulumi.Input[str] subject_match_attribute: Okta user profile attribute for matching transformed IdP username. Only for matchType `"CUSTOM_ATTRIBUTE"`.
        :param pulumi.Input[str] subject_match_type: Determines the Okta user profile attribute match conditions for account linking and authentication of the transformed IdP username. By default it is set to `"USERNAME"`. It can be set to `"USERNAME"`, `"EMAIL"`, `"USERNAME_OR_EMAIL"` or `"CUSTOM_ATTRIBUTE"`.
        :param pulumi.Input[str] suspended_action: Action for a previously suspended IdP user during authentication. Can be set to `"NONE"` or `"UNSUSPEND"`
        :param pulumi.Input[str] token_binding: The method of making a token request. It can be set to `"HTTP-POST"` or `"HTTP-REDIRECT"`.
        :param pulumi.Input[str] token_url: IdP Authorization Server (AS) endpoint to exchange the authorization code grant for an access token.
        :param pulumi.Input[str] user_info_url: Protected resource endpoint that returns claims about the authenticated user.
        :param pulumi.Input[str] username_template: Okta EL Expression to generate or transform a unique username for the IdP user.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['account_link_action'] = account_link_action
            __props__['account_link_group_includes'] = account_link_group_includes
            if acs_binding is None:
                raise TypeError("Missing required property 'acs_binding'")
            __props__['acs_binding'] = acs_binding
            __props__['acs_type'] = acs_type
            if authorization_binding is None:
                raise TypeError("Missing required property 'authorization_binding'")
            __props__['authorization_binding'] = authorization_binding
            if authorization_url is None:
                raise TypeError("Missing required property 'authorization_url'")
            __props__['authorization_url'] = authorization_url
            if client_id is None:
                raise TypeError("Missing required property 'client_id'")
            __props__['client_id'] = client_id
            if client_secret is None:
                raise TypeError("Missing required property 'client_secret'")
            __props__['client_secret'] = client_secret
            __props__['deprovisioned_action'] = deprovisioned_action
            __props__['groups_action'] = groups_action
            __props__['groups_assignments'] = groups_assignments
            __props__['groups_attribute'] = groups_attribute
            __props__['groups_filters'] = groups_filters
            __props__['issuer_mode'] = issuer_mode
            if issuer_url is None:
                raise TypeError("Missing required property 'issuer_url'")
            __props__['issuer_url'] = issuer_url
            if jwks_binding is None:
                raise TypeError("Missing required property 'jwks_binding'")
            __props__['jwks_binding'] = jwks_binding
            if jwks_url is None:
                raise TypeError("Missing required property 'jwks_url'")
            __props__['jwks_url'] = jwks_url
            __props__['max_clock_skew'] = max_clock_skew
            __props__['name'] = name
            __props__['profile_master'] = profile_master
            __props__['protocol_type'] = protocol_type
            __props__['provisioning_action'] = provisioning_action
            __props__['request_signature_algorithm'] = request_signature_algorithm
            __props__['request_signature_scope'] = request_signature_scope
            __props__['response_signature_algorithm'] = response_signature_algorithm
            __props__['response_signature_scope'] = response_signature_scope
            if scopes is None:
                raise TypeError("Missing required property 'scopes'")
            __props__['scopes'] = scopes
            __props__['status'] = status
            __props__['subject_match_attribute'] = subject_match_attribute
            __props__['subject_match_type'] = subject_match_type
            __props__['suspended_action'] = suspended_action
            if token_binding is None:
                raise TypeError("Missing required property 'token_binding'")
            __props__['token_binding'] = token_binding
            if token_url is None:
                raise TypeError("Missing required property 'token_url'")
            __props__['token_url'] = token_url
            __props__['user_info_binding'] = user_info_binding
            __props__['user_info_url'] = user_info_url
            __props__['username_template'] = username_template
            __props__['type'] = None
        super(Oidc, __self__).__init__(
            'okta:idp/oidc:Oidc',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, account_link_action=None, account_link_group_includes=None, acs_binding=None, acs_type=None, authorization_binding=None, authorization_url=None, client_id=None, client_secret=None, deprovisioned_action=None, groups_action=None, groups_assignments=None, groups_attribute=None, groups_filters=None, issuer_mode=None, issuer_url=None, jwks_binding=None, jwks_url=None, max_clock_skew=None, name=None, profile_master=None, protocol_type=None, provisioning_action=None, request_signature_algorithm=None, request_signature_scope=None, response_signature_algorithm=None, response_signature_scope=None, scopes=None, status=None, subject_match_attribute=None, subject_match_type=None, suspended_action=None, token_binding=None, token_url=None, type=None, user_info_binding=None, user_info_url=None, username_template=None):
        """
        Get an existing Oidc resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] account_link_action: Specifies the account linking action for an IdP user.
        :param pulumi.Input[list] account_link_group_includes: Group memberships to determine link candidates.
        :param pulumi.Input[str] acs_binding: The method of making an ACS request. It can be set to `"HTTP-POST"` or `"HTTP-REDIRECT"`.
        :param pulumi.Input[str] acs_type: The type of ACS. Default is `"INSTANCE"`.
        :param pulumi.Input[str] authorization_binding: The method of making an authorization request. It can be set to `"HTTP-POST"` or `"HTTP-REDIRECT"`.
        :param pulumi.Input[str] authorization_url: IdP Authorization Server (AS) endpoint to request consent from the user and obtain an authorization code grant.
        :param pulumi.Input[str] client_id: Unique identifier issued by AS for the Okta IdP instance.
        :param pulumi.Input[str] client_secret: Client secret issued by AS for the Okta IdP instance.
        :param pulumi.Input[str] deprovisioned_action: Action for a previously deprovisioned IdP user during authentication. Can be `"NONE"` or `"REACTIVATE"`.
        :param pulumi.Input[str] groups_action: Provisioning action for IdP user's group memberships. It can be `"NONE"`, `"SYNC"`, `"APPEND"`, or `"ASSIGN"`.
        :param pulumi.Input[list] groups_assignments: List of Okta Group IDs to add an IdP user as a member with the `"ASSIGN"` `groups_action`.
        :param pulumi.Input[str] groups_attribute: IdP user profile attribute name (case-insensitive) for an array value that contains group memberships.
        :param pulumi.Input[list] groups_filters: Whitelist of Okta Group identifiers that are allowed for the `"APPEND"` or `"SYNC"` `groups_action`.
        :param pulumi.Input[str] issuer_mode: Indicates whether Okta uses the original Okta org domain URL, or a custom domain URL. It can be `"ORG_URL"` or `"CUSTOM_URL"`.
        :param pulumi.Input[str] issuer_url: URI that identifies the issuer.
        :param pulumi.Input[str] jwks_binding: The method of making a request for the OIDC JWKS. It can be set to `"HTTP-POST"` or `"HTTP-REDIRECT"`.
        :param pulumi.Input[str] jwks_url: Endpoint where the signer of the keys publishes its keys in a JWK Set.
        :param pulumi.Input[float] max_clock_skew: Maximum allowable clock-skew when processing messages from the IdP.
        :param pulumi.Input[str] name: The Application's display name.
        :param pulumi.Input[bool] profile_master: Determines if the IdP should act as a source of truth for user profile attributes.
        :param pulumi.Input[str] protocol_type: The type of protocol to use. It can be `"OIDC"` or `"OAUTH2"`.
        :param pulumi.Input[str] provisioning_action: Provisioning action for an IdP user during authentication.
        :param pulumi.Input[str] request_signature_algorithm: algorithm to use to sign requests
        :param pulumi.Input[str] request_signature_scope: algorithm to use to sign response
        :param pulumi.Input[str] response_signature_algorithm: algorithm to use to sign requests
        :param pulumi.Input[str] response_signature_scope: algorithm to use to sign response
        :param pulumi.Input[list] scopes: The scopes of the IdP.
        :param pulumi.Input[str] status: Status of the IdP.
        :param pulumi.Input[str] subject_match_attribute: Okta user profile attribute for matching transformed IdP username. Only for matchType `"CUSTOM_ATTRIBUTE"`.
        :param pulumi.Input[str] subject_match_type: Determines the Okta user profile attribute match conditions for account linking and authentication of the transformed IdP username. By default it is set to `"USERNAME"`. It can be set to `"USERNAME"`, `"EMAIL"`, `"USERNAME_OR_EMAIL"` or `"CUSTOM_ATTRIBUTE"`.
        :param pulumi.Input[str] suspended_action: Action for a previously suspended IdP user during authentication. Can be set to `"NONE"` or `"UNSUSPEND"`
        :param pulumi.Input[str] token_binding: The method of making a token request. It can be set to `"HTTP-POST"` or `"HTTP-REDIRECT"`.
        :param pulumi.Input[str] token_url: IdP Authorization Server (AS) endpoint to exchange the authorization code grant for an access token.
        :param pulumi.Input[str] type: Type of OIDC IdP.
        :param pulumi.Input[str] user_info_url: Protected resource endpoint that returns claims about the authenticated user.
        :param pulumi.Input[str] username_template: Okta EL Expression to generate or transform a unique username for the IdP user.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["account_link_action"] = account_link_action
        __props__["account_link_group_includes"] = account_link_group_includes
        __props__["acs_binding"] = acs_binding
        __props__["acs_type"] = acs_type
        __props__["authorization_binding"] = authorization_binding
        __props__["authorization_url"] = authorization_url
        __props__["client_id"] = client_id
        __props__["client_secret"] = client_secret
        __props__["deprovisioned_action"] = deprovisioned_action
        __props__["groups_action"] = groups_action
        __props__["groups_assignments"] = groups_assignments
        __props__["groups_attribute"] = groups_attribute
        __props__["groups_filters"] = groups_filters
        __props__["issuer_mode"] = issuer_mode
        __props__["issuer_url"] = issuer_url
        __props__["jwks_binding"] = jwks_binding
        __props__["jwks_url"] = jwks_url
        __props__["max_clock_skew"] = max_clock_skew
        __props__["name"] = name
        __props__["profile_master"] = profile_master
        __props__["protocol_type"] = protocol_type
        __props__["provisioning_action"] = provisioning_action
        __props__["request_signature_algorithm"] = request_signature_algorithm
        __props__["request_signature_scope"] = request_signature_scope
        __props__["response_signature_algorithm"] = response_signature_algorithm
        __props__["response_signature_scope"] = response_signature_scope
        __props__["scopes"] = scopes
        __props__["status"] = status
        __props__["subject_match_attribute"] = subject_match_attribute
        __props__["subject_match_type"] = subject_match_type
        __props__["suspended_action"] = suspended_action
        __props__["token_binding"] = token_binding
        __props__["token_url"] = token_url
        __props__["type"] = type
        __props__["user_info_binding"] = user_info_binding
        __props__["user_info_url"] = user_info_url
        __props__["username_template"] = username_template
        return Oidc(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

