# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from .. import utilities, tables

class SamlKey(pulumi.CustomResource):
    created: pulumi.Output[str]
    """
    Date created.
    """
    expires_at: pulumi.Output[str]
    """
    Date the cert expires.
    """
    kid: pulumi.Output[str]
    """
    Key ID.
    """
    kty: pulumi.Output[str]
    """
    Identifies the cryptographic algorithm family used with the key.
    """
    use: pulumi.Output[str]
    """
    Intended use of the public key.
    """
    x5cs: pulumi.Output[list]
    """
    base64-encoded X.509 certificate chain with DER encoding.
    """
    x5t_s256: pulumi.Output[str]
    """
    base64url-encoded SHA-256 thumbprint of the DER encoding of an X.509 certificate.
    """
    def __init__(__self__, resource_name, opts=None, x5cs=None, __props__=None, __name__=None, __opts__=None):
        """
        Creates a SAML Identity Provider Signing Key.

        This resource allows you to create and configure a SAML Identity Provider Signing Key.

        ## Example Usage



        ```python
        import pulumi
        import pulumi_okta as okta

        example = okta.idp.SamlKey("example", x5cs=[okta_app_saml["example"]["certificate"]])
        ```


        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[list] x5cs: base64-encoded X.509 certificate chain with DER encoding.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            if x5cs is None:
                raise TypeError("Missing required property 'x5cs'")
            __props__['x5cs'] = x5cs
            __props__['created'] = None
            __props__['expires_at'] = None
            __props__['kid'] = None
            __props__['kty'] = None
            __props__['use'] = None
            __props__['x5t_s256'] = None
        super(SamlKey, __self__).__init__(
            'okta:idp/samlKey:SamlKey',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, created=None, expires_at=None, kid=None, kty=None, use=None, x5cs=None, x5t_s256=None):
        """
        Get an existing SamlKey resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] created: Date created.
        :param pulumi.Input[str] expires_at: Date the cert expires.
        :param pulumi.Input[str] kid: Key ID.
        :param pulumi.Input[str] kty: Identifies the cryptographic algorithm family used with the key.
        :param pulumi.Input[str] use: Intended use of the public key.
        :param pulumi.Input[list] x5cs: base64-encoded X.509 certificate chain with DER encoding.
        :param pulumi.Input[str] x5t_s256: base64url-encoded SHA-256 thumbprint of the DER encoding of an X.509 certificate.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["created"] = created
        __props__["expires_at"] = expires_at
        __props__["kid"] = kid
        __props__["kty"] = kty
        __props__["use"] = use
        __props__["x5cs"] = x5cs
        __props__["x5t_s256"] = x5t_s256
        return SamlKey(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

