# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from .. import utilities, tables

class Zone(pulumi.CustomResource):
    dynamic_locations: pulumi.Output[list]
    """
    Array of locations ISO-3166-1(2). Format code: countryCode OR countryCode-regionCode.
    """
    gateways: pulumi.Output[list]
    """
    Array of values in CIDR/range form.
    """
    name: pulumi.Output[str]
    """
    Name of the Network Zone Resource.
    """
    proxies: pulumi.Output[list]
    """
    Array of values in CIDR/range form.
    """
    type: pulumi.Output[str]
    """
    Type of the Network Zone - can either be IP or DYNAMIC only.
    """
    def __init__(__self__, resource_name, opts=None, dynamic_locations=None, gateways=None, name=None, proxies=None, type=None, __props__=None, __name__=None, __opts__=None):
        """
        Creates an Okta Network Zone.

        This resource allows you to create and configure an Okta Network Zone.

        ## Example Usage



        ```python
        import pulumi
        import pulumi_okta as okta

        example = okta.network.Zone("example",
            gateways=[
                "1.2.3.4/24",
                "2.3.4.5-2.3.4.15",
            ],
            proxies=[
                "2.2.3.4/24",
                "3.3.4.5-3.3.4.15",
            ],
            type="IP")
        ```


        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[list] dynamic_locations: Array of locations ISO-3166-1(2). Format code: countryCode OR countryCode-regionCode.
        :param pulumi.Input[list] gateways: Array of values in CIDR/range form.
        :param pulumi.Input[str] name: Name of the Network Zone Resource.
        :param pulumi.Input[list] proxies: Array of values in CIDR/range form.
        :param pulumi.Input[str] type: Type of the Network Zone - can either be IP or DYNAMIC only.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['dynamic_locations'] = dynamic_locations
            __props__['gateways'] = gateways
            __props__['name'] = name
            __props__['proxies'] = proxies
            if type is None:
                raise TypeError("Missing required property 'type'")
            __props__['type'] = type
        super(Zone, __self__).__init__(
            'okta:network/zone:Zone',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, dynamic_locations=None, gateways=None, name=None, proxies=None, type=None):
        """
        Get an existing Zone resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[list] dynamic_locations: Array of locations ISO-3166-1(2). Format code: countryCode OR countryCode-regionCode.
        :param pulumi.Input[list] gateways: Array of values in CIDR/range form.
        :param pulumi.Input[str] name: Name of the Network Zone Resource.
        :param pulumi.Input[list] proxies: Array of values in CIDR/range form.
        :param pulumi.Input[str] type: Type of the Network Zone - can either be IP or DYNAMIC only.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["dynamic_locations"] = dynamic_locations
        __props__["gateways"] = gateways
        __props__["name"] = name
        __props__["proxies"] = proxies
        __props__["type"] = type
        return Zone(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

