# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from . import utilities, tables

class Provider(pulumi.ProviderResource):
    def __init__(__self__, resource_name, opts=None, api_token=None, backoff=None, base_url=None, max_retries=None, max_wait_seconds=None, min_wait_seconds=None, org_name=None, parallelism=None, __props__=None, __name__=None, __opts__=None):
        """
        The provider type for the okta package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] api_token: API Token granting privileges to Okta API.
        :param pulumi.Input[bool] backoff: Use exponential back off strategy for rate limits.
        :param pulumi.Input[str] base_url: The Okta url. (Use 'oktapreview.com' for Okta testing)
        :param pulumi.Input[float] max_retries: maximum number of retries to attempt before erroring out.
        :param pulumi.Input[float] max_wait_seconds: maximum seconds to wait when rate limit is hit. We use exponential backoffs when backoff is enabled.
        :param pulumi.Input[float] min_wait_seconds: minimum seconds to wait when rate limit is hit. We use exponential backoffs when backoff is enabled.
        :param pulumi.Input[str] org_name: The organization to manage in Okta.
        :param pulumi.Input[float] parallelism: Number of concurrent requests to make within a resource where bulk operations are not possible. Take note of
               https://developer.okta.com/docs/api/getting_started/rate-limits.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            if api_token is None:
                api_token = utilities.get_env('OKTA_API_TOKEN')
            __props__['api_token'] = api_token
            __props__['backoff'] = pulumi.Output.from_input(backoff).apply(json.dumps) if backoff is not None else None
            if base_url is None:
                base_url = utilities.get_env('OKTA_BASE_URL')
            __props__['base_url'] = base_url
            __props__['max_retries'] = pulumi.Output.from_input(max_retries).apply(json.dumps) if max_retries is not None else None
            __props__['max_wait_seconds'] = pulumi.Output.from_input(max_wait_seconds).apply(json.dumps) if max_wait_seconds is not None else None
            __props__['min_wait_seconds'] = pulumi.Output.from_input(min_wait_seconds).apply(json.dumps) if min_wait_seconds is not None else None
            if org_name is None:
                org_name = utilities.get_env('OKTA_ORG_NAME')
            __props__['org_name'] = org_name
            __props__['parallelism'] = pulumi.Output.from_input(parallelism).apply(json.dumps) if parallelism is not None else None
        super(Provider, __self__).__init__(
            'okta',
            resource_name,
            __props__,
            opts)

    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

