# -*- coding: utf-8 -*-
# Generated by Django 1.11.2 on 2019-06-08 19:18


import aparnik.contrib.tickets.models
from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django_enumfield.db.fields
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('filefields', '0010_filefield_is_decrypt_needed'),
        ('basemodels', '0010_basemodel_visit_count'),
    ]

    operations = [
        migrations.CreateModel(
            name='Ticket',
            fields=[
                ('basemodel_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='basemodels.BaseModel')),
                ('title', models.CharField(max_length=255, verbose_name='Title')),
                ('priority', django_enumfield.db.fields.EnumField(default=0, enum=aparnik.contrib.tickets.models.TicketPriority, verbose_name='Priority')),
                ('status', django_enumfield.db.fields.EnumField(default=0, enum=aparnik.contrib.tickets.models.TicketStatus, verbose_name='Status')),
                ('uuid', models.UUIDField(default=uuid.uuid4, editable=False, verbose_name='UUID')),
                ('department', django_enumfield.db.fields.EnumField(default=0, enum=aparnik.contrib.tickets.models.TicketDepartment, verbose_name='Department')),
                ('is_active', models.BooleanField(default=True, verbose_name='Is Active')),
                ('user_obj', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL, verbose_name='User')),
            ],
            options={
                'verbose_name': 'Ticket',
                'manager_inheritance_from_future': True,
                'verbose_name_plural': 'Tickets',
            },
            bases=('basemodels.basemodel',),
        ),
        migrations.CreateModel(
            name='TicketConversation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('content', models.TextField(verbose_name='Content')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='Created at')),
                ('update_at', models.DateTimeField(auto_now=True, verbose_name='Update at')),
                ('files_obj', models.ManyToManyField(to='filefields.FileField', verbose_name='Files')),
                ('ticket_obj', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='tickets.Ticket', verbose_name='Ticket')),
                ('user_obj', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL, verbose_name='User')),
            ],
            options={
                'ordering': ['-created_at'],
                'verbose_name': 'Ticket Conversation',
                'verbose_name_plural': 'Ticket Conversations',
            },
        ),
    ]
