# -*- coding: utf-8 -*-
# Generated by Django 1.11.2 on 2018-12-03 15:33


import aparnik.utils.fields
from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('basemodels', '0004_auto_20181103_2233'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('orders', '0002_auto_20181026_1301'),
    ]

    operations = [
        migrations.CreateModel(
            name='CoSale',
            fields=[
                ('basemodel_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='basemodels.BaseModel')),
                ('is_active', models.BooleanField(default=True, verbose_name='Is Active')),
                ('price', aparnik.utils.fields.PriceField(decimal_places=0, default=0, max_digits=20, verbose_name='Price')),
                ('order_obj', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='cosale_order', to='orders.Order', verbose_name='Order')),
                ('user_bought_obj', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='cosale_user_bought', to=settings.AUTH_USER_MODEL, verbose_name='User Bought')),
                ('user_co_sale_obj', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='cosale_user_co_sale', to=settings.AUTH_USER_MODEL, verbose_name='User Co Sale')),
            ],
            options={
                'verbose_name': 'Co Sale',
                'manager_inheritance_from_future': True,
                'verbose_name_plural': 'Co Sales',
            },
            bases=('basemodels.basemodel',),
        ),
        migrations.CreateModel(
            name='CoSaleHistory',
            fields=[
                ('basemodel_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='basemodels.BaseModel')),
                ('status', models.CharField(choices=[('C', 'Cleared'), ('NC', 'Not Cleared'), ('RSHBR', 'The request for settlement has been received')], default='NC', max_length=10, verbose_name='Status')),
                ('cosale_obj', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='cosales.CoSale', verbose_name='Co Sale')),
            ],
            options={
                'verbose_name': 'Co Sale History',
                'manager_inheritance_from_future': True,
                'verbose_name_plural': 'Co Sale Histories',
            },
            bases=('basemodels.basemodel',),
        ),
    ]
