# -*- coding: utf-8 -*-
# Generated by Django 1.11.2 on 2018-10-26 12:06


import aparnik.utils.fields
from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.db.models.manager


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('coupons', '0001_initial'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('basemodels', '0001_initial'),
        ('products', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Order',
            fields=[
                ('basemodel_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='basemodels.BaseModel')),
                ('status', models.CharField(choices=[('w', 'Waiting'), ('pa', 'Paid'), ('c', 'Cancel'), ('co', 'Complete'), ('d', 'Disputed'), ('ch', 'Challenged')], default='w', max_length=5, verbose_name='Status')),
                ('coupon', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='orders', to='coupons.Coupon', verbose_name='Coupon')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL, verbose_name='User')),
            ],
            options={
                'ordering': ('-created_at',),
                'verbose_name': 'Order',
                'verbose_name_plural': 'Orders',
            },
            bases=('basemodels.basemodel',),
        ),
        migrations.CreateModel(
            name='OrderItem',
            fields=[
                ('basemodel_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='basemodels.BaseModel')),
                ('price', aparnik.utils.fields.PriceField(decimal_places=0, max_digits=20, verbose_name='Price')),
                ('quantity', models.PositiveIntegerField(default=1, verbose_name='Quantity')),
                ('order_obj', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='items', to='orders.Order', verbose_name='Order')),
                ('product_obj', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='products', to='products.Product', verbose_name='Product')),
            ],
            options={
                'verbose_name': 'OrderItem',
                'verbose_name_plural': 'OrderItems',
            },
            bases=('basemodels.basemodel',),
            managers=[
                ('objects', django.db.models.manager.Manager()),
                ('base_objects', django.db.models.manager.Manager()),
            ],
        ),
    ]
