from skidl import SKIDL, TEMPLATE, Part, Pin, SchLib

SKIDL_lib_version = '0.0.1'

battery_management = SchLib(tool=SKIDL).add_parts(*[
        Part(name='AS8506C',dest=TEMPLATE,tool=SKIDL,keywords='battery balance lithium charge afe',description='Stackable cell monitor, cell balancer, 3-7 Cells, SPI Interface',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='TSECH',do_erc=True),
            Pin(num='2',name='TSECL',do_erc=True),
            Pin(num='3',name='VC7',do_erc=True),
            Pin(num='4',name='VC6',do_erc=True),
            Pin(num='5',name='VS5',do_erc=True),
            Pin(num='6',name='VC4',do_erc=True),
            Pin(num='7',name='VC3',do_erc=True),
            Pin(num='8',name='VC2',do_erc=True),
            Pin(num='9',name='VC1',do_erc=True),
            Pin(num='10',name='CGND',do_erc=True),
            Pin(num='20',name='NC_T',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='30',name='V5V',do_erc=True),
            Pin(num='40',name='VREF_H',do_erc=True),
            Pin(num='11',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='21',name='SDO',do_erc=True),
            Pin(num='31',name='V5V_IN',do_erc=True),
            Pin(num='41',name='PAD',func=Pin.PWRIN,do_erc=True),
            Pin(num='12',name='VREF_IN',do_erc=True),
            Pin(num='22',name='SDI',do_erc=True),
            Pin(num='32',name='WAKE_OUT',do_erc=True),
            Pin(num='13',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='23',name='SCKL',do_erc=True),
            Pin(num='33',name='FD_IN',do_erc=True),
            Pin(num='14',name='TRIG_IN',do_erc=True),
            Pin(num='24',name='~CS',do_erc=True),
            Pin(num='34',name='BD_IN',do_erc=True),
            Pin(num='15',name='CLK_IN',do_erc=True),
            Pin(num='25',name='CELL_THU',do_erc=True),
            Pin(num='35',name='CVT_NOK_IN',do_erc=True),
            Pin(num='16',name='CVT_NOK_OUT',do_erc=True),
            Pin(num='26',name='CELL_THL',do_erc=True),
            Pin(num='36',name='CLK_OUT',do_erc=True),
            Pin(num='17',name='BD_OUT',do_erc=True),
            Pin(num='27',name='TEMP_IN2',do_erc=True),
            Pin(num='37',name='TRIG_OUT',do_erc=True),
            Pin(num='18',name='FD_OUT',do_erc=True),
            Pin(num='28',name='TEMP_IN1',do_erc=True),
            Pin(num='38',name='VSUP',func=Pin.PWRIN,do_erc=True),
            Pin(num='19',name='WAKE_IN',do_erc=True),
            Pin(num='29',name='REF_T',do_erc=True),
            Pin(num='39',name='MS_SL',do_erc=True)]),
        Part(name='BQ2003',dest=TEMPLATE,tool=SKIDL,keywords='battery nickel cadmium metal hydride',description='Standalone switchmode NiCd/NiMH battery charger, 2-4 cells, negative dV and dT/dt termination',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='CCMD',do_erc=True),
            Pin(num='2',name='DCMD',do_erc=True),
            Pin(num='3',name='DVEN',do_erc=True),
            Pin(num='4',name='TM1',do_erc=True),
            Pin(num='5',name='TM2',do_erc=True),
            Pin(num='6',name='TS',do_erc=True),
            Pin(num='7',name='BAT',do_erc=True),
            Pin(num='8',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='SNS',do_erc=True),
            Pin(num='10',name='TCO',do_erc=True),
            Pin(num='11',name='MCV',do_erc=True),
            Pin(num='12',name='TEMP',func=Pin.OUTPUT,do_erc=True),
            Pin(num='13',name='CHG',func=Pin.OUTPUT,do_erc=True),
            Pin(num='14',name='MOD',func=Pin.OUTPUT,do_erc=True),
            Pin(num='15',name='DIS',func=Pin.OUTPUT,do_erc=True),
            Pin(num='16',name='VCC',func=Pin.PWRIN,do_erc=True)]),
        Part(name='BQ24075',dest=TEMPLATE,tool=SKIDL,keywords='USB Charge',description='USB-Friendly Li-Ion Battery Charger and Power-Path Management',ref_prefix='U',num_units=1,fplist=['RGT*', 'QFN*'],do_erc=True,pins=[
            Pin(num='1',name='TS',func=Pin.PWROUT,do_erc=True),
            Pin(num='2',name='BAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='BAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='~CE',do_erc=True),
            Pin(num='5',name='EN2',do_erc=True),
            Pin(num='6',name='EN1',do_erc=True),
            Pin(num='7',name='~PGOOD',func=Pin.OUTPUT,do_erc=True),
            Pin(num='8',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='~CHG',func=Pin.OUTPUT,do_erc=True),
            Pin(num='10',name='OUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='11',name='OUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='12',name='ILM',do_erc=True),
            Pin(num='13',name='IN',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='TMR',do_erc=True),
            Pin(num='15',name='SYSOFF',do_erc=True),
            Pin(num='16',name='ISET',do_erc=True),
            Pin(num='17',name='PAD',func=Pin.UNSPEC,do_erc=True)]),
        Part(name='BQ76940',dest=TEMPLATE,tool=SKIDL,keywords='lithium battery balance charge afe',description='Lithium battery monitor, 9-15 cells, integrated balancing, I2C interface',ref_prefix='U',num_units=1,fplist=['TSSOP*'],do_erc=True,pins=[
            Pin(num='6',name='TS1',do_erc=True),
            Pin(num='7',name='CAP1',do_erc=True),
            Pin(num='8',name='REGOUT',func=Pin.PWROUT,do_erc=True),
            Pin(num='9',name='REGSRC',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='VC5X',do_erc=True),
            Pin(num='20',name='BAT',do_erc=True),
            Pin(num='30',name='VC10',do_erc=True),
            Pin(num='40',name='VC1',do_erc=True),
            Pin(num='11',name='NC',do_erc=True),
            Pin(num='21',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='31',name='VC9',do_erc=True),
            Pin(num='41',name='VC0',do_erc=True),
            Pin(num='12',name='NC',do_erc=True),
            Pin(num='22',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='32',name='VC8',do_erc=True),
            Pin(num='42',name='SRP',do_erc=True),
            Pin(num='13',name='TS2',do_erc=True),
            Pin(num='23',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='33',name='VC7',do_erc=True),
            Pin(num='43',name='SRN',do_erc=True),
            Pin(num='14',name='CAP2',do_erc=True),
            Pin(num='24',name='VC15',do_erc=True),
            Pin(num='34',name='VC6',do_erc=True),
            Pin(num='44',name='ALERT',do_erc=True),
            Pin(num='15',name='VC10x',do_erc=True),
            Pin(num='25',name='VC14',do_erc=True),
            Pin(num='35',name='VC5B',do_erc=True),
            Pin(num='16',name='NC',do_erc=True),
            Pin(num='26',name='VC13',do_erc=True),
            Pin(num='36',name='VC5',do_erc=True),
            Pin(num='17',name='NC',do_erc=True),
            Pin(num='27',name='VC12',do_erc=True),
            Pin(num='37',name='VC4',do_erc=True),
            Pin(num='18',name='TS3',do_erc=True),
            Pin(num='28',name='VC11',do_erc=True),
            Pin(num='38',name='VC3',do_erc=True),
            Pin(num='19',name='CAP3',do_erc=True),
            Pin(num='29',name='VC10B',do_erc=True),
            Pin(num='39',name='VC2',do_erc=True),
            Pin(num='1',name='DSG',do_erc=True),
            Pin(num='2',name='CHG',do_erc=True),
            Pin(num='3',name='Vss',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='SDA',do_erc=True),
            Pin(num='5',name='SCL',do_erc=True)]),
        Part(name='BQ78350',dest=TEMPLATE,tool=SKIDL,keywords='lithium battery',description='Lithium battery fuel gauge, companion controller for BQ769x0',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='COM',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='ALERT',func=Pin.BIDIR,do_erc=True),
            Pin(num='3',name='SDA',func=Pin.BIDIR,do_erc=True),
            Pin(num='4',name='SCL',func=Pin.BIDIR,do_erc=True),
            Pin(num='5',name='~PRECHG',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='VAUX',do_erc=True),
            Pin(num='7',name='BAT',do_erc=True),
            Pin(num='8',name='~PRES',do_erc=True),
            Pin(num='9',name='~KEYIN',do_erc=True),
            Pin(num='10',name='~SAFE',func=Pin.OUTPUT,do_erc=True),
            Pin(num='20',name='LED5',func=Pin.OUTPUT,do_erc=True),
            Pin(num='30',name='SMBA',do_erc=True),
            Pin(num='11',name='SMBD',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='21',name='GPIO_A',func=Pin.BIDIR,do_erc=True),
            Pin(num='12',name='VEN',func=Pin.OUTPUT,do_erc=True),
            Pin(num='22',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='SMBC',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='23',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='14',name='~DISP',do_erc=True),
            Pin(num='24',name='~MRST',do_erc=True),
            Pin(num='15',name='PWRM',func=Pin.OUTPUT,do_erc=True),
            Pin(num='25',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='16',name='LED1',func=Pin.OUTPUT,do_erc=True),
            Pin(num='26',name='VCC',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='LED2',func=Pin.OUTPUT,do_erc=True),
            Pin(num='27',name='RBI',func=Pin.PWRIN,do_erc=True),
            Pin(num='18',name='LED3',func=Pin.OUTPUT,do_erc=True),
            Pin(num='28',name='GPIO_B',func=Pin.BIDIR,do_erc=True),
            Pin(num='19',name='LED4',func=Pin.OUTPUT,do_erc=True),
            Pin(num='29',name='ADREN',func=Pin.OUTPUT,do_erc=True)]),
        Part(name='LTC4001',dest=TEMPLATE,tool=SKIDL,keywords='Li-Ion Charger',description='Single cell (4.1V) programmable synchronous buck Li-Ion charger, 2A, 5.5V input',ref_prefix='U',num_units=1,fplist=['QFN*1EP*4x4mm*Pitch0.65mm*'],do_erc=True,aliases=['LTC4001-1'],pins=[
            Pin(num='1',name='BAT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='SENSE',do_erc=True),
            Pin(num='3',name='PGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='GNDSENS',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='SW',func=Pin.OUTPUT,do_erc=True),
            Pin(num='6',name='~EN',do_erc=True),
            Pin(num='7',name='~CHRG',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='8',name='PVin',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='Vinsense',func=Pin.PWRIN,do_erc=True),
            Pin(num='10',name='FAULT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='11',name='NTC',do_erc=True),
            Pin(num='12',name='PROG',do_erc=True),
            Pin(num='13',name='IDET',do_erc=True),
            Pin(num='14',name='SS',do_erc=True),
            Pin(num='15',name='TIMER',do_erc=True),
            Pin(num='16',name='BATSENS',do_erc=True),
            Pin(num='17',name='PAD',func=Pin.PWRIN,do_erc=True)]),
        Part(name='LTC6803-2',dest=TEMPLATE,tool=SKIDL,keywords='battery balance afe',description='Multicell Battery Stack Monitor, 12-cell max, multi-chemistry, integrated balancing, stackable, serial interface',ref_prefix='U',num_units=1,fplist=['SSOP*'],do_erc=True,pins=[
            Pin(num='1',name='V+',do_erc=True),
            Pin(num='2',name='C12',do_erc=True),
            Pin(num='3',name='S12',do_erc=True),
            Pin(num='4',name='C11',do_erc=True),
            Pin(num='5',name='S11',do_erc=True),
            Pin(num='6',name='C10',do_erc=True),
            Pin(num='7',name='S10',do_erc=True),
            Pin(num='8',name='C9',do_erc=True),
            Pin(num='9',name='S9',do_erc=True),
            Pin(num='10',name='C8',do_erc=True),
            Pin(num='20',name='C3',do_erc=True),
            Pin(num='30',name='Vref',do_erc=True),
            Pin(num='40',name='A3',do_erc=True),
            Pin(num='11',name='S8',do_erc=True),
            Pin(num='21',name='S3',do_erc=True),
            Pin(num='31',name='Vreg',do_erc=True),
            Pin(num='41',name='SCKI',do_erc=True),
            Pin(num='12',name='C7',do_erc=True),
            Pin(num='22',name='C2',do_erc=True),
            Pin(num='32',name='TOS',do_erc=True),
            Pin(num='42',name='SDI',do_erc=True),
            Pin(num='13',name='S7',do_erc=True),
            Pin(num='23',name='S2',do_erc=True),
            Pin(num='33',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='43',name='SDO',do_erc=True),
            Pin(num='14',name='C6',do_erc=True),
            Pin(num='24',name='C1',do_erc=True),
            Pin(num='34',name='WDTB',do_erc=True),
            Pin(num='44',name='CSBI',do_erc=True),
            Pin(num='15',name='S6',do_erc=True),
            Pin(num='25',name='S1',do_erc=True),
            Pin(num='35',name='GPIO1',do_erc=True),
            Pin(num='16',name='C5',do_erc=True),
            Pin(num='26',name='V-',do_erc=True),
            Pin(num='36',name='GPIO2',do_erc=True),
            Pin(num='17',name='S5',do_erc=True),
            Pin(num='27',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='37',name='A0',do_erc=True),
            Pin(num='18',name='C4',do_erc=True),
            Pin(num='28',name='Vtemp1',do_erc=True),
            Pin(num='38',name='A1',do_erc=True),
            Pin(num='19',name='S4',do_erc=True),
            Pin(num='29',name='Vtemp2',do_erc=True),
            Pin(num='39',name='A2',do_erc=True)]),
        Part(name='LTC6803-4',dest=TEMPLATE,tool=SKIDL,keywords='battery balance afe',description='Multicell Battery Stack Monitor, 12-cell max, multi-chemistry, integrated balancing, stackable, serial interface',ref_prefix='U',num_units=1,fplist=['SSOP*'],do_erc=True,pins=[
            Pin(num='1',name='V+',do_erc=True),
            Pin(num='2',name='C12',do_erc=True),
            Pin(num='3',name='S12',do_erc=True),
            Pin(num='4',name='C11',do_erc=True),
            Pin(num='5',name='S11',do_erc=True),
            Pin(num='6',name='C10',do_erc=True),
            Pin(num='7',name='S10',do_erc=True),
            Pin(num='8',name='C9',do_erc=True),
            Pin(num='9',name='S9',do_erc=True),
            Pin(num='10',name='C8',do_erc=True),
            Pin(num='20',name='C3',do_erc=True),
            Pin(num='30',name='Vtemp2',do_erc=True),
            Pin(num='40',name='A3',do_erc=True),
            Pin(num='11',name='S8',do_erc=True),
            Pin(num='21',name='S3',do_erc=True),
            Pin(num='31',name='Vref',do_erc=True),
            Pin(num='41',name='SCKI',do_erc=True),
            Pin(num='12',name='C7',do_erc=True),
            Pin(num='22',name='C2',do_erc=True),
            Pin(num='32',name='Vreg',do_erc=True),
            Pin(num='42',name='SDI',do_erc=True),
            Pin(num='13',name='S7',do_erc=True),
            Pin(num='23',name='S2',do_erc=True),
            Pin(num='33',name='TOS',do_erc=True),
            Pin(num='43',name='SDO',do_erc=True),
            Pin(num='14',name='C6',do_erc=True),
            Pin(num='24',name='C1',do_erc=True),
            Pin(num='34',name='WDTB',do_erc=True),
            Pin(num='44',name='CSBI',do_erc=True),
            Pin(num='15',name='S6',do_erc=True),
            Pin(num='25',name='S1',do_erc=True),
            Pin(num='35',name='GPIO1',do_erc=True),
            Pin(num='16',name='C5',do_erc=True),
            Pin(num='26',name='C0',do_erc=True),
            Pin(num='36',name='GPIO2',do_erc=True),
            Pin(num='17',name='S5',do_erc=True),
            Pin(num='27',name='V-',do_erc=True),
            Pin(num='37',name='A0',do_erc=True),
            Pin(num='18',name='C4',do_erc=True),
            Pin(num='28',name='NC',func=Pin.NOCONNECT,do_erc=True),
            Pin(num='38',name='A1',do_erc=True),
            Pin(num='19',name='S4',do_erc=True),
            Pin(num='29',name='Vtemp1',do_erc=True),
            Pin(num='39',name='A2',do_erc=True)]),
        Part(name='MAX1647',dest=TEMPLATE,tool=SKIDL,keywords='battery charger',description='Smart Battery Charger, 18V battery, 28V input, SMBus serial interface',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='IOUT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='DCIN',do_erc=True),
            Pin(num='3',name='VLout',func=Pin.OUTPUT,do_erc=True),
            Pin(num='4',name='CCV',do_erc=True),
            Pin(num='5',name='CCI',do_erc=True),
            Pin(num='6',name='SEL',do_erc=True),
            Pin(num='7',name='CurrSense',do_erc=True),
            Pin(num='8',name='BATT',do_erc=True),
            Pin(num='9',name='REF',func=Pin.BIDIR,do_erc=True),
            Pin(num='10',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='20',name='BootSt',do_erc=True),
            Pin(num='11',name='~INT',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='12',name='THM',do_erc=True),
            Pin(num='13',name='SCLK',do_erc=True),
            Pin(num='14',name='SDA',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='15',name='DACV',do_erc=True),
            Pin(num='16',name='PGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='17',name='DrvLO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='18',name='DrvHI',func=Pin.OUTPUT,do_erc=True),
            Pin(num='19',name='LX',do_erc=True)]),
        Part(name='MAX1648',dest=TEMPLATE,tool=SKIDL,keywords='battery charger',description='Smart Battery Charger, 18V battery, 28V input, standalone',ref_prefix='U',num_units=1,do_erc=True,pins=[
            Pin(num='1',name='DCIN',do_erc=True),
            Pin(num='2',name='VLout',func=Pin.OUTPUT,do_erc=True),
            Pin(num='3',name='CCV',do_erc=True),
            Pin(num='4',name='CCI',do_erc=True),
            Pin(num='5',name='CurrSense',do_erc=True),
            Pin(num='6',name='BATT',do_erc=True),
            Pin(num='7',name='REF',func=Pin.BIDIR,do_erc=True),
            Pin(num='8',name='AGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='9',name='THM',do_erc=True),
            Pin(num='10',name='SETI',func=Pin.OPENCOLL,do_erc=True),
            Pin(num='11',name='SETV',do_erc=True),
            Pin(num='12',name='PGND',func=Pin.PWRIN,do_erc=True),
            Pin(num='13',name='DrvLO',func=Pin.OUTPUT,do_erc=True),
            Pin(num='14',name='DrvHI',func=Pin.OUTPUT,do_erc=True),
            Pin(num='15',name='LX',do_erc=True),
            Pin(num='16',name='BootSt',do_erc=True)]),
        Part(name='MAX1811',dest=TEMPLATE,tool=SKIDL,keywords='USB Battery Charger',description='USB Powered Li+ Charger, 4.1V/4.2V battery, 5V input, 0.1/0.5A charging current',ref_prefix='U',num_units=1,fplist=['SOIC*'],do_erc=True,pins=[
            Pin(num='1',name='SELV',do_erc=True),
            Pin(num='2',name='SELI',do_erc=True),
            Pin(num='3',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='IN',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='BATT',func=Pin.PWROUT,do_erc=True),
            Pin(num='6',name='GND',func=Pin.PWRIN,do_erc=True),
            Pin(num='7',name='EN',do_erc=True),
            Pin(num='8',name='~CHG',func=Pin.OPENCOLL,do_erc=True)]),
        Part(name='MCP73812T-420I/OT',dest=TEMPLATE,tool=SKIDL,keywords='Lithium-Ion Battery Charger',description='Simple, Miniature Single-Cell, Fully Integrated Li-Ion / Li-Polymer Charge Management Controllers, 50mA-500mA',ref_prefix='U',num_units=1,fplist=['*SOT-23-5*'],do_erc=True,aliases=['MCP73812T-435I/OT', 'MCP73811T-420I/OT', 'MCP73811T-435I/OT'],pins=[
            Pin(num='1',name='CEN',do_erc=True),
            Pin(num='2',name='VSS',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='VBAT',func=Pin.PWRIN,do_erc=True),
            Pin(num='4',name='VDD',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='PROG',do_erc=True)]),
        Part(name='MCP73832-2-OT',dest=TEMPLATE,tool=SKIDL,keywords='battery charger lithium',description='Single cell, Li-Ion/Li-Po charge management controller, 4.50V, Open-Drain Status Output, in SOT23-5 package',ref_prefix='U',num_units=1,do_erc=True,aliases=['MCP73832-5-OT', 'MCP73832-4-OT', 'MCP73832-3-OT', 'MCP73831-2-OT', 'MCP73831-5-OT', 'MCP73831-4-OT', 'MCP73831-3-OT'],pins=[
            Pin(num='1',name='STAT',func=Pin.OUTPUT,do_erc=True),
            Pin(num='2',name='Vss',func=Pin.PWRIN,do_erc=True),
            Pin(num='3',name='Vbat',func=Pin.PWROUT,do_erc=True),
            Pin(num='4',name='Vdd',func=Pin.PWRIN,do_erc=True),
            Pin(num='5',name='PROG',do_erc=True)])])
