# Configs

Toolset to manage encrypted application configs and vaults. Or something.

## Usage

### Transform

    Usage:
    configs transform [options] <input> <format> <output>

Render a config file into a target format.

 * `input`: input file name, or `-` to use stdin
 * `format`: format to render
 * `output`: output file name, or `-` to use stdout

Options:

 * `-v`, `--vault`: specify a vault for resolving secrets; can be specified
   multiple times to allow for adding fallbacks

### Provision

    Usage:
    configs provision <input> <source-vault> <target-vault>

Resolve all secrets using one vault, and store them all in a target vault.

 * `input`: input file name, or `-` to use stdin
 * `source-vault`: vault to use to resolve all secrets
 * `target-vault`: vault to store all secrets in


## Supported Formats

### env

    env:
      fields:
        <field-name>: <config-path>
        <field-name>: <config-path>

Fetch values from the config or vaults and output them into a flat list of
key-value variables surrounded by double quotes. No effort is made to escape
the values right now.


## Supported Vaults

### sops

    sops:

Use mozilla's sops command line tool to decrypt the input config. Further config
should be done using the sops tool itself.

Encrypting a new file with a local pgp key:

    sops --encrypted-suffix _encrypted -i --pgp ABCD1234ABCD1234ABCD1234 --encrypt myfile.yaml

Encrypting a new file with AWS:

	sops --encrypted-suffix _encrypted -i --kms arn:aws:kms:us-west-2:123412341234:key/11111111-2222-3333-4444-555555555555 --encrypt myfile.yaml

### aws

    aws:
      base_path: base/path/name/

Fetch values from Amazon's Secret Manager service.

Values with the same prefix will be combined into values on a single secret.

E.g., with:

 * `database.connection.username` and
 * `database.connection.password`

A single secret will be created at `database/connection` with the `username` and
`password` properties.

Optionally, specify a base path that will be prepended to all secret names.


## Example Configuration

    # Required -- currently only version 0 is supported
    meta:
        version: 0

    # Unencrypted configuration values.
    # You can use any arbitrary structure here.
    config:
        database:
            connection:
                host: rds.url.amazonaws.com
                name: testdatabase
                asdf:
                    test: 1

    # Encrypted configuration values for sops.
    # Edit these by running `sops my-config.yaml`.
    secrets_encrypted:
        database:
            credentials:
                username: ENC[AES256_GCM,data:aWjCNsOBkPM=,iv:mZCd3CCdVu8Sfltb8wrzG32dk1+HlZkPO1FvqIdQ2BM=,tag:qtdcyuIBU6oQ/nwpN2OCzA==,type:str]
                password: ENC[AES256_GCM,data:YeNzC8nLVJ8=,iv:AFDV/Y5/c3002ToSMNFVZYj/nfzJp7oRZ83H/LizADc=,tag:6Gr77eepzFvfXmejKi23PA==,type:str]

    # Configurations for the various target formats.
    transform:
        env:
            fields:
                DB_HOST: database.connection.host
                DB_USER: database.credentials.username
                DB_PASS: database.credentials.password
                DB_NAME: database.connection.database
                DB_PORT: database.connection.port

    # Configurations for the various vault services.
    vault:
        aws:
            base_path: staging/my-app/
        sops:

    # Auto-generated by the sops tool. Do not edit.
    sops:
        kms: []
        gcp_kms: []
        azure_kv: []
        lastmodified: '2019-12-27T07:38:07Z'
        mac: ENC[AES256_GCM,data:ldCTC83ANEzs3COJQbsmO5bJqweCBe6pWqVy4NjSs00sybnO4L7TAQ5nuzxItQSj586uI2TwE3hU4olWaquFxoEf4+rLkvlIjawwZ3yfYT9pUGOYUH3gEFSYn5JcYmt5yujf8/QxI6GU18i6l9MJj/KDvyOigcgxVV7Mhd/7xJ0=,iv:ARpM/Zbour/1n2Vje3LvKFKmtBPiZ1xolKUhHJ4hUeQ=,tag:/XsFeupDr72o6foW6nHeFg==,type:str]
        pgp:
        -   created_at: '2019-12-27T07:38:05Z'
            enc: |-
                -----BEGIN PGP MESSAGE-----

                wcBMAyUpShfNkFB/AQgAAdocsGAUFAYb1kMFRVprKC/mLbh/yfrcFcsOgux8dXNr
                JsHY9U3qVx2N9h4IKx0yiOGY7I0soc6701BtiJugjTJwuPS9FzEE9lY7QcEsGXxk
                gKCPgNj47AyiJO8447xgmS9BEMwFZRZs+xtKttDh36tlLuaybugAUFBvDxcsJXPL
                1EhdzkexFMnGNXa1qATD7LVZHd96E5kt0VRou17ZtTH4QNWgEhYOlcr6juSmIlmO
                qyQXd4vKdGJXAfcwrJ6kDkLIpC96dtw966NtTC1mM2WzpwC0/Y/wPo3UfEvsLx1e
                LaC4T5eBHShpherJTwDxKTyvCaGAOseT0Ew1YVwGJ9LgAeTyrBRVFKGl1426NWAY
                U/lG4buk4MXgBuHeTODM4qakw8Pgc+WAdZyS3ihQpXHpD1pYMmtk8NZv5w3zviml
                cJX1RVHyl+BE5ICCNHcDXndVQgsZS5AbJ+7itPZaBOG9SwA=
                =Jfgz
                -----END PGP MESSAGE-----
            fp: FBC7B9E2A4F9289AC0C1D4843D16CEE4A27381B4
        encrypted_suffix: _encrypted
        version: 3.5.0
