import * as cdk from '@aws-cdk/core';
/**
 * Properties for defining a `AWS::Batch::ComputeEnvironment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html
 * @external
 */
export interface CfnComputeEnvironmentProps {
    /**
     * `AWS::Batch::ComputeEnvironment.ServiceRole`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html#cfn-batch-computeenvironment-servicerole
     * @external
     */
    readonly serviceRole: string;
    /**
     * `AWS::Batch::ComputeEnvironment.Type`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html#cfn-batch-computeenvironment-type
     * @external
     */
    readonly type: string;
    /**
     * `AWS::Batch::ComputeEnvironment.ComputeEnvironmentName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html#cfn-batch-computeenvironment-computeenvironmentname
     * @external
     */
    readonly computeEnvironmentName?: string;
    /**
     * `AWS::Batch::ComputeEnvironment.ComputeResources`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html#cfn-batch-computeenvironment-computeresources
     * @external
     */
    readonly computeResources?: CfnComputeEnvironment.ComputeResourcesProperty | cdk.IResolvable;
    /**
     * `AWS::Batch::ComputeEnvironment.State`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html#cfn-batch-computeenvironment-state
     * @external
     */
    readonly state?: string;
}
/**
 * A CloudFormation `AWS::Batch::ComputeEnvironment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html
 * @external
 * @cloudformationResource AWS::Batch::ComputeEnvironment
 */
export declare class CfnComputeEnvironment extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Batch::ComputeEnvironment";
    /**
     * `AWS::Batch::ComputeEnvironment.ServiceRole`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html#cfn-batch-computeenvironment-servicerole
     * @external
     */
    serviceRole: string;
    /**
     * `AWS::Batch::ComputeEnvironment.Type`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html#cfn-batch-computeenvironment-type
     * @external
     */
    type: string;
    /**
     * `AWS::Batch::ComputeEnvironment.ComputeEnvironmentName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html#cfn-batch-computeenvironment-computeenvironmentname
     * @external
     */
    computeEnvironmentName: string | undefined;
    /**
     * `AWS::Batch::ComputeEnvironment.ComputeResources`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html#cfn-batch-computeenvironment-computeresources
     * @external
     */
    computeResources: CfnComputeEnvironment.ComputeResourcesProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Batch::ComputeEnvironment.State`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html#cfn-batch-computeenvironment-state
     * @external
     */
    state: string | undefined;
    /**
     * Create a new `AWS::Batch::ComputeEnvironment`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnComputeEnvironmentProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Batch::ComputeEnvironment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html
 * @external
 * @cloudformationResource AWS::Batch::ComputeEnvironment
 */
export declare namespace CfnComputeEnvironment {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html
     * @external
     */
    interface ComputeResourcesProperty {
        /**
         * `CfnComputeEnvironment.ComputeResourcesProperty.AllocationStrategy`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-allocationstrategy
         * @external
         */
        readonly allocationStrategy?: string;
        /**
         * `CfnComputeEnvironment.ComputeResourcesProperty.BidPercentage`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-bidpercentage
         * @external
         */
        readonly bidPercentage?: number;
        /**
         * `CfnComputeEnvironment.ComputeResourcesProperty.DesiredvCpus`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-desiredvcpus
         * @external
         */
        readonly desiredvCpus?: number;
        /**
         * `CfnComputeEnvironment.ComputeResourcesProperty.Ec2KeyPair`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-ec2keypair
         * @external
         */
        readonly ec2KeyPair?: string;
        /**
         * `CfnComputeEnvironment.ComputeResourcesProperty.ImageId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-imageid
         * @external
         */
        readonly imageId?: string;
        /**
         * `CfnComputeEnvironment.ComputeResourcesProperty.InstanceRole`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-instancerole
         * @external
         */
        readonly instanceRole: string;
        /**
         * `CfnComputeEnvironment.ComputeResourcesProperty.InstanceTypes`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-instancetypes
         * @external
         */
        readonly instanceTypes: string[];
        /**
         * `CfnComputeEnvironment.ComputeResourcesProperty.LaunchTemplate`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-launchtemplate
         * @external
         */
        readonly launchTemplate?: CfnComputeEnvironment.LaunchTemplateSpecificationProperty | cdk.IResolvable;
        /**
         * `CfnComputeEnvironment.ComputeResourcesProperty.MaxvCpus`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-maxvcpus
         * @external
         */
        readonly maxvCpus: number;
        /**
         * `CfnComputeEnvironment.ComputeResourcesProperty.MinvCpus`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-minvcpus
         * @external
         */
        readonly minvCpus: number;
        /**
         * `CfnComputeEnvironment.ComputeResourcesProperty.PlacementGroup`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-placementgroup
         * @external
         */
        readonly placementGroup?: string;
        /**
         * `CfnComputeEnvironment.ComputeResourcesProperty.SecurityGroupIds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-securitygroupids
         * @external
         */
        readonly securityGroupIds?: string[];
        /**
         * `CfnComputeEnvironment.ComputeResourcesProperty.SpotIamFleetRole`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-spotiamfleetrole
         * @external
         */
        readonly spotIamFleetRole?: string;
        /**
         * `CfnComputeEnvironment.ComputeResourcesProperty.Subnets`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-subnets
         * @external
         */
        readonly subnets: string[];
        /**
         * `CfnComputeEnvironment.ComputeResourcesProperty.Tags`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-tags
         * @external
         */
        readonly tags?: any;
        /**
         * `CfnComputeEnvironment.ComputeResourcesProperty.Type`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-type
         * @external
         */
        readonly type: string;
    }
}
/**
 * A CloudFormation `AWS::Batch::ComputeEnvironment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html
 * @external
 * @cloudformationResource AWS::Batch::ComputeEnvironment
 */
export declare namespace CfnComputeEnvironment {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-launchtemplatespecification.html
     * @external
     */
    interface LaunchTemplateSpecificationProperty {
        /**
         * `CfnComputeEnvironment.LaunchTemplateSpecificationProperty.LaunchTemplateId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-launchtemplatespecification.html#cfn-batch-computeenvironment-launchtemplatespecification-launchtemplateid
         * @external
         */
        readonly launchTemplateId?: string;
        /**
         * `CfnComputeEnvironment.LaunchTemplateSpecificationProperty.LaunchTemplateName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-launchtemplatespecification.html#cfn-batch-computeenvironment-launchtemplatespecification-launchtemplatename
         * @external
         */
        readonly launchTemplateName?: string;
        /**
         * `CfnComputeEnvironment.LaunchTemplateSpecificationProperty.Version`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-launchtemplatespecification.html#cfn-batch-computeenvironment-launchtemplatespecification-version
         * @external
         */
        readonly version?: string;
    }
}
/**
 * Properties for defining a `AWS::Batch::JobDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html
 * @external
 */
export interface CfnJobDefinitionProps {
    /**
     * `AWS::Batch::JobDefinition.Type`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-type
     * @external
     */
    readonly type: string;
    /**
     * `AWS::Batch::JobDefinition.ContainerProperties`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-containerproperties
     * @external
     */
    readonly containerProperties?: CfnJobDefinition.ContainerPropertiesProperty | cdk.IResolvable;
    /**
     * `AWS::Batch::JobDefinition.JobDefinitionName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-jobdefinitionname
     * @external
     */
    readonly jobDefinitionName?: string;
    /**
     * `AWS::Batch::JobDefinition.NodeProperties`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-nodeproperties
     * @external
     */
    readonly nodeProperties?: CfnJobDefinition.NodePropertiesProperty | cdk.IResolvable;
    /**
     * `AWS::Batch::JobDefinition.Parameters`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-parameters
     * @external
     */
    readonly parameters?: any | cdk.IResolvable;
    /**
     * `AWS::Batch::JobDefinition.RetryStrategy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-retrystrategy
     * @external
     */
    readonly retryStrategy?: CfnJobDefinition.RetryStrategyProperty | cdk.IResolvable;
    /**
     * `AWS::Batch::JobDefinition.Timeout`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-timeout
     * @external
     */
    readonly timeout?: CfnJobDefinition.TimeoutProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Batch::JobDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html
 * @external
 * @cloudformationResource AWS::Batch::JobDefinition
 */
export declare class CfnJobDefinition extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Batch::JobDefinition";
    /**
     * `AWS::Batch::JobDefinition.Type`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-type
     * @external
     */
    type: string;
    /**
     * `AWS::Batch::JobDefinition.ContainerProperties`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-containerproperties
     * @external
     */
    containerProperties: CfnJobDefinition.ContainerPropertiesProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Batch::JobDefinition.JobDefinitionName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-jobdefinitionname
     * @external
     */
    jobDefinitionName: string | undefined;
    /**
     * `AWS::Batch::JobDefinition.NodeProperties`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-nodeproperties
     * @external
     */
    nodeProperties: CfnJobDefinition.NodePropertiesProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Batch::JobDefinition.Parameters`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-parameters
     * @external
     */
    parameters: any | cdk.IResolvable | undefined;
    /**
     * `AWS::Batch::JobDefinition.RetryStrategy`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-retrystrategy
     * @external
     */
    retryStrategy: CfnJobDefinition.RetryStrategyProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Batch::JobDefinition.Timeout`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html#cfn-batch-jobdefinition-timeout
     * @external
     */
    timeout: CfnJobDefinition.TimeoutProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::Batch::JobDefinition`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnJobDefinitionProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Batch::JobDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html
 * @external
 * @cloudformationResource AWS::Batch::JobDefinition
 */
export declare namespace CfnJobDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html
     * @external
     */
    interface ContainerPropertiesProperty {
        /**
         * `CfnJobDefinition.ContainerPropertiesProperty.Command`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-command
         * @external
         */
        readonly command?: string[];
        /**
         * `CfnJobDefinition.ContainerPropertiesProperty.Environment`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-environment
         * @external
         */
        readonly environment?: Array<CfnJobDefinition.EnvironmentProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnJobDefinition.ContainerPropertiesProperty.ExecutionRoleArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-executionrolearn
         * @external
         */
        readonly executionRoleArn?: string;
        /**
         * `CfnJobDefinition.ContainerPropertiesProperty.Image`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-image
         * @external
         */
        readonly image: string;
        /**
         * `CfnJobDefinition.ContainerPropertiesProperty.InstanceType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-instancetype
         * @external
         */
        readonly instanceType?: string;
        /**
         * `CfnJobDefinition.ContainerPropertiesProperty.JobRoleArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-jobrolearn
         * @external
         */
        readonly jobRoleArn?: string;
        /**
         * `CfnJobDefinition.ContainerPropertiesProperty.LinuxParameters`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-linuxparameters
         * @external
         */
        readonly linuxParameters?: CfnJobDefinition.LinuxParametersProperty | cdk.IResolvable;
        /**
         * `CfnJobDefinition.ContainerPropertiesProperty.LogConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-logconfiguration
         * @external
         */
        readonly logConfiguration?: CfnJobDefinition.LogConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnJobDefinition.ContainerPropertiesProperty.Memory`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-memory
         * @external
         */
        readonly memory?: number;
        /**
         * `CfnJobDefinition.ContainerPropertiesProperty.MountPoints`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-mountpoints
         * @external
         */
        readonly mountPoints?: Array<CfnJobDefinition.MountPointsProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnJobDefinition.ContainerPropertiesProperty.Privileged`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-privileged
         * @external
         */
        readonly privileged?: boolean | cdk.IResolvable;
        /**
         * `CfnJobDefinition.ContainerPropertiesProperty.ReadonlyRootFilesystem`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-readonlyrootfilesystem
         * @external
         */
        readonly readonlyRootFilesystem?: boolean | cdk.IResolvable;
        /**
         * `CfnJobDefinition.ContainerPropertiesProperty.ResourceRequirements`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-resourcerequirements
         * @external
         */
        readonly resourceRequirements?: Array<CfnJobDefinition.ResourceRequirementProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnJobDefinition.ContainerPropertiesProperty.Secrets`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-secrets
         * @external
         */
        readonly secrets?: Array<CfnJobDefinition.SecretProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnJobDefinition.ContainerPropertiesProperty.Ulimits`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-ulimits
         * @external
         */
        readonly ulimits?: Array<CfnJobDefinition.UlimitProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnJobDefinition.ContainerPropertiesProperty.User`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-user
         * @external
         */
        readonly user?: string;
        /**
         * `CfnJobDefinition.ContainerPropertiesProperty.Vcpus`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-vcpus
         * @external
         */
        readonly vcpus?: number;
        /**
         * `CfnJobDefinition.ContainerPropertiesProperty.Volumes`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties.html#cfn-batch-jobdefinition-containerproperties-volumes
         * @external
         */
        readonly volumes?: Array<CfnJobDefinition.VolumesProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Batch::JobDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html
 * @external
 * @cloudformationResource AWS::Batch::JobDefinition
 */
export declare namespace CfnJobDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-device.html
     * @external
     */
    interface DeviceProperty {
        /**
         * `CfnJobDefinition.DeviceProperty.ContainerPath`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-device.html#cfn-batch-jobdefinition-device-containerpath
         * @external
         */
        readonly containerPath?: string;
        /**
         * `CfnJobDefinition.DeviceProperty.HostPath`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-device.html#cfn-batch-jobdefinition-device-hostpath
         * @external
         */
        readonly hostPath?: string;
        /**
         * `CfnJobDefinition.DeviceProperty.Permissions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-device.html#cfn-batch-jobdefinition-device-permissions
         * @external
         */
        readonly permissions?: string[];
    }
}
/**
 * A CloudFormation `AWS::Batch::JobDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html
 * @external
 * @cloudformationResource AWS::Batch::JobDefinition
 */
export declare namespace CfnJobDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-environment.html
     * @external
     */
    interface EnvironmentProperty {
        /**
         * `CfnJobDefinition.EnvironmentProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-environment.html#cfn-batch-jobdefinition-environment-name
         * @external
         */
        readonly name?: string;
        /**
         * `CfnJobDefinition.EnvironmentProperty.Value`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-environment.html#cfn-batch-jobdefinition-environment-value
         * @external
         */
        readonly value?: string;
    }
}
/**
 * A CloudFormation `AWS::Batch::JobDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html
 * @external
 * @cloudformationResource AWS::Batch::JobDefinition
 */
export declare namespace CfnJobDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties-linuxparameters.html
     * @external
     */
    interface LinuxParametersProperty {
        /**
         * `CfnJobDefinition.LinuxParametersProperty.Devices`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties-linuxparameters.html#cfn-batch-jobdefinition-containerproperties-linuxparameters-devices
         * @external
         */
        readonly devices?: Array<CfnJobDefinition.DeviceProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnJobDefinition.LinuxParametersProperty.InitProcessEnabled`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties-linuxparameters.html#cfn-batch-jobdefinition-containerproperties-linuxparameters-initprocessenabled
         * @external
         */
        readonly initProcessEnabled?: boolean | cdk.IResolvable;
        /**
         * `CfnJobDefinition.LinuxParametersProperty.MaxSwap`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties-linuxparameters.html#cfn-batch-jobdefinition-containerproperties-linuxparameters-maxswap
         * @external
         */
        readonly maxSwap?: number;
        /**
         * `CfnJobDefinition.LinuxParametersProperty.SharedMemorySize`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties-linuxparameters.html#cfn-batch-jobdefinition-containerproperties-linuxparameters-sharedmemorysize
         * @external
         */
        readonly sharedMemorySize?: number;
        /**
         * `CfnJobDefinition.LinuxParametersProperty.Swappiness`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties-linuxparameters.html#cfn-batch-jobdefinition-containerproperties-linuxparameters-swappiness
         * @external
         */
        readonly swappiness?: number;
        /**
         * `CfnJobDefinition.LinuxParametersProperty.Tmpfs`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties-linuxparameters.html#cfn-batch-jobdefinition-containerproperties-linuxparameters-tmpfs
         * @external
         */
        readonly tmpfs?: Array<CfnJobDefinition.TmpfsProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Batch::JobDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html
 * @external
 * @cloudformationResource AWS::Batch::JobDefinition
 */
export declare namespace CfnJobDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties-logconfiguration.html
     * @external
     */
    interface LogConfigurationProperty {
        /**
         * `CfnJobDefinition.LogConfigurationProperty.LogDriver`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties-logconfiguration.html#cfn-batch-jobdefinition-containerproperties-logconfiguration-logdriver
         * @external
         */
        readonly logDriver: string;
        /**
         * `CfnJobDefinition.LogConfigurationProperty.Options`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties-logconfiguration.html#cfn-batch-jobdefinition-containerproperties-logconfiguration-options
         * @external
         */
        readonly options?: any | cdk.IResolvable;
        /**
         * `CfnJobDefinition.LogConfigurationProperty.SecretOptions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-containerproperties-logconfiguration.html#cfn-batch-jobdefinition-containerproperties-logconfiguration-secretoptions
         * @external
         */
        readonly secretOptions?: Array<CfnJobDefinition.SecretProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Batch::JobDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html
 * @external
 * @cloudformationResource AWS::Batch::JobDefinition
 */
export declare namespace CfnJobDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-mountpoints.html
     * @external
     */
    interface MountPointsProperty {
        /**
         * `CfnJobDefinition.MountPointsProperty.ContainerPath`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-mountpoints.html#cfn-batch-jobdefinition-mountpoints-containerpath
         * @external
         */
        readonly containerPath?: string;
        /**
         * `CfnJobDefinition.MountPointsProperty.ReadOnly`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-mountpoints.html#cfn-batch-jobdefinition-mountpoints-readonly
         * @external
         */
        readonly readOnly?: boolean | cdk.IResolvable;
        /**
         * `CfnJobDefinition.MountPointsProperty.SourceVolume`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-mountpoints.html#cfn-batch-jobdefinition-mountpoints-sourcevolume
         * @external
         */
        readonly sourceVolume?: string;
    }
}
/**
 * A CloudFormation `AWS::Batch::JobDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html
 * @external
 * @cloudformationResource AWS::Batch::JobDefinition
 */
export declare namespace CfnJobDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-nodeproperties.html
     * @external
     */
    interface NodePropertiesProperty {
        /**
         * `CfnJobDefinition.NodePropertiesProperty.MainNode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-nodeproperties.html#cfn-batch-jobdefinition-nodeproperties-mainnode
         * @external
         */
        readonly mainNode: number;
        /**
         * `CfnJobDefinition.NodePropertiesProperty.NodeRangeProperties`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-nodeproperties.html#cfn-batch-jobdefinition-nodeproperties-noderangeproperties
         * @external
         */
        readonly nodeRangeProperties: Array<CfnJobDefinition.NodeRangePropertyProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnJobDefinition.NodePropertiesProperty.NumNodes`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-nodeproperties.html#cfn-batch-jobdefinition-nodeproperties-numnodes
         * @external
         */
        readonly numNodes: number;
    }
}
/**
 * A CloudFormation `AWS::Batch::JobDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html
 * @external
 * @cloudformationResource AWS::Batch::JobDefinition
 */
export declare namespace CfnJobDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-noderangeproperty.html
     * @external
     */
    interface NodeRangePropertyProperty {
        /**
         * `CfnJobDefinition.NodeRangePropertyProperty.Container`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-noderangeproperty.html#cfn-batch-jobdefinition-noderangeproperty-container
         * @external
         */
        readonly container?: CfnJobDefinition.ContainerPropertiesProperty | cdk.IResolvable;
        /**
         * `CfnJobDefinition.NodeRangePropertyProperty.TargetNodes`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-noderangeproperty.html#cfn-batch-jobdefinition-noderangeproperty-targetnodes
         * @external
         */
        readonly targetNodes: string;
    }
}
/**
 * A CloudFormation `AWS::Batch::JobDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html
 * @external
 * @cloudformationResource AWS::Batch::JobDefinition
 */
export declare namespace CfnJobDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-resourcerequirement.html
     * @external
     */
    interface ResourceRequirementProperty {
        /**
         * `CfnJobDefinition.ResourceRequirementProperty.Type`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-resourcerequirement.html#cfn-batch-jobdefinition-resourcerequirement-type
         * @external
         */
        readonly type?: string;
        /**
         * `CfnJobDefinition.ResourceRequirementProperty.Value`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-resourcerequirement.html#cfn-batch-jobdefinition-resourcerequirement-value
         * @external
         */
        readonly value?: string;
    }
}
/**
 * A CloudFormation `AWS::Batch::JobDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html
 * @external
 * @cloudformationResource AWS::Batch::JobDefinition
 */
export declare namespace CfnJobDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-retrystrategy.html
     * @external
     */
    interface RetryStrategyProperty {
        /**
         * `CfnJobDefinition.RetryStrategyProperty.Attempts`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-retrystrategy.html#cfn-batch-jobdefinition-retrystrategy-attempts
         * @external
         */
        readonly attempts?: number;
    }
}
/**
 * A CloudFormation `AWS::Batch::JobDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html
 * @external
 * @cloudformationResource AWS::Batch::JobDefinition
 */
export declare namespace CfnJobDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-secret.html
     * @external
     */
    interface SecretProperty {
        /**
         * `CfnJobDefinition.SecretProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-secret.html#cfn-batch-jobdefinition-secret-name
         * @external
         */
        readonly name: string;
        /**
         * `CfnJobDefinition.SecretProperty.ValueFrom`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-secret.html#cfn-batch-jobdefinition-secret-valuefrom
         * @external
         */
        readonly valueFrom: string;
    }
}
/**
 * A CloudFormation `AWS::Batch::JobDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html
 * @external
 * @cloudformationResource AWS::Batch::JobDefinition
 */
export declare namespace CfnJobDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-timeout.html
     * @external
     */
    interface TimeoutProperty {
        /**
         * `CfnJobDefinition.TimeoutProperty.AttemptDurationSeconds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-timeout.html#cfn-batch-jobdefinition-timeout-attemptdurationseconds
         * @external
         */
        readonly attemptDurationSeconds?: number;
    }
}
/**
 * A CloudFormation `AWS::Batch::JobDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html
 * @external
 * @cloudformationResource AWS::Batch::JobDefinition
 */
export declare namespace CfnJobDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-tmpfs.html
     * @external
     */
    interface TmpfsProperty {
        /**
         * `CfnJobDefinition.TmpfsProperty.ContainerPath`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-tmpfs.html#cfn-batch-jobdefinition-tmpfs-containerpath
         * @external
         */
        readonly containerPath: string;
        /**
         * `CfnJobDefinition.TmpfsProperty.MountOptions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-tmpfs.html#cfn-batch-jobdefinition-tmpfs-mountoptions
         * @external
         */
        readonly mountOptions?: string[];
        /**
         * `CfnJobDefinition.TmpfsProperty.Size`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-tmpfs.html#cfn-batch-jobdefinition-tmpfs-size
         * @external
         */
        readonly size: number;
    }
}
/**
 * A CloudFormation `AWS::Batch::JobDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html
 * @external
 * @cloudformationResource AWS::Batch::JobDefinition
 */
export declare namespace CfnJobDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ulimit.html
     * @external
     */
    interface UlimitProperty {
        /**
         * `CfnJobDefinition.UlimitProperty.HardLimit`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ulimit.html#cfn-batch-jobdefinition-ulimit-hardlimit
         * @external
         */
        readonly hardLimit: number;
        /**
         * `CfnJobDefinition.UlimitProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ulimit.html#cfn-batch-jobdefinition-ulimit-name
         * @external
         */
        readonly name: string;
        /**
         * `CfnJobDefinition.UlimitProperty.SoftLimit`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-ulimit.html#cfn-batch-jobdefinition-ulimit-softlimit
         * @external
         */
        readonly softLimit: number;
    }
}
/**
 * A CloudFormation `AWS::Batch::JobDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html
 * @external
 * @cloudformationResource AWS::Batch::JobDefinition
 */
export declare namespace CfnJobDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-volumes.html
     * @external
     */
    interface VolumesProperty {
        /**
         * `CfnJobDefinition.VolumesProperty.Host`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-volumes.html#cfn-batch-jobdefinition-volumes-host
         * @external
         */
        readonly host?: CfnJobDefinition.VolumesHostProperty | cdk.IResolvable;
        /**
         * `CfnJobDefinition.VolumesProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-volumes.html#cfn-batch-jobdefinition-volumes-name
         * @external
         */
        readonly name?: string;
    }
}
/**
 * A CloudFormation `AWS::Batch::JobDefinition`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobdefinition.html
 * @external
 * @cloudformationResource AWS::Batch::JobDefinition
 */
export declare namespace CfnJobDefinition {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-volumeshost.html
     * @external
     */
    interface VolumesHostProperty {
        /**
         * `CfnJobDefinition.VolumesHostProperty.SourcePath`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobdefinition-volumeshost.html#cfn-batch-jobdefinition-volumeshost-sourcepath
         * @external
         */
        readonly sourcePath?: string;
    }
}
/**
 * Properties for defining a `AWS::Batch::JobQueue`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobqueue.html
 * @external
 */
export interface CfnJobQueueProps {
    /**
     * `AWS::Batch::JobQueue.ComputeEnvironmentOrder`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobqueue.html#cfn-batch-jobqueue-computeenvironmentorder
     * @external
     */
    readonly computeEnvironmentOrder: Array<CfnJobQueue.ComputeEnvironmentOrderProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::Batch::JobQueue.Priority`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobqueue.html#cfn-batch-jobqueue-priority
     * @external
     */
    readonly priority: number;
    /**
     * `AWS::Batch::JobQueue.JobQueueName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobqueue.html#cfn-batch-jobqueue-jobqueuename
     * @external
     */
    readonly jobQueueName?: string;
    /**
     * `AWS::Batch::JobQueue.State`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobqueue.html#cfn-batch-jobqueue-state
     * @external
     */
    readonly state?: string;
}
/**
 * A CloudFormation `AWS::Batch::JobQueue`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobqueue.html
 * @external
 * @cloudformationResource AWS::Batch::JobQueue
 */
export declare class CfnJobQueue extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Batch::JobQueue";
    /**
     * `AWS::Batch::JobQueue.ComputeEnvironmentOrder`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobqueue.html#cfn-batch-jobqueue-computeenvironmentorder
     * @external
     */
    computeEnvironmentOrder: Array<CfnJobQueue.ComputeEnvironmentOrderProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::Batch::JobQueue.Priority`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobqueue.html#cfn-batch-jobqueue-priority
     * @external
     */
    priority: number;
    /**
     * `AWS::Batch::JobQueue.JobQueueName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobqueue.html#cfn-batch-jobqueue-jobqueuename
     * @external
     */
    jobQueueName: string | undefined;
    /**
     * `AWS::Batch::JobQueue.State`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobqueue.html#cfn-batch-jobqueue-state
     * @external
     */
    state: string | undefined;
    /**
     * Create a new `AWS::Batch::JobQueue`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnJobQueueProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Batch::JobQueue`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-jobqueue.html
 * @external
 * @cloudformationResource AWS::Batch::JobQueue
 */
export declare namespace CfnJobQueue {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobqueue-computeenvironmentorder.html
     * @external
     */
    interface ComputeEnvironmentOrderProperty {
        /**
         * `CfnJobQueue.ComputeEnvironmentOrderProperty.ComputeEnvironment`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobqueue-computeenvironmentorder.html#cfn-batch-jobqueue-computeenvironmentorder-computeenvironment
         * @external
         */
        readonly computeEnvironment: string;
        /**
         * `CfnJobQueue.ComputeEnvironmentOrderProperty.Order`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-jobqueue-computeenvironmentorder.html#cfn-batch-jobqueue-computeenvironmentorder-order
         * @external
         */
        readonly order: number;
    }
}
