import * as ec2 from '@aws-cdk/aws-ec2';
import * as ecs from '@aws-cdk/aws-ecs';
import * as iam from '@aws-cdk/aws-iam';
import { Duration, IResource, Resource } from '@aws-cdk/core';
import { Construct } from 'constructs';
/**
 * (experimental) Properties of a job definition container.
 *
 * @experimental
 */
export interface JobDefinitionContainer {
    /**
     * (experimental) The command that is passed to the container.
     *
     * If you provide a shell command as a single string, you have to quote command-line arguments.
     *
     * @default - CMD value built into container image.
     * @experimental
     */
    readonly command?: string[];
    /**
     * (experimental) The environment variables to pass to the container.
     *
     * @default none
     * @experimental
     */
    readonly environment?: {
        [key: string]: string;
    };
    /**
     * (experimental) The image used to start a container.
     *
     * @experimental
     */
    readonly image: ecs.ContainerImage;
    /**
     * (experimental) The instance type to use for a multi-node parallel job.
     *
     * Currently all node groups in a
     * multi-node parallel job must use the same instance type. This parameter is not valid
     * for single-node container jobs.
     *
     * @default - None
     * @experimental
     */
    readonly instanceType?: ec2.InstanceType;
    /**
     * (experimental) The IAM role that the container can assume for AWS permissions.
     *
     * @default - An IAM role will created.
     * @experimental
     */
    readonly jobRole?: iam.IRole;
    /**
     * (experimental) Linux-specific modifications that are applied to the container, such as details for device mappings.
     *
     * For now, only the `devices` property is supported.
     *
     * @default - None will be used.
     * @experimental
     */
    readonly linuxParams?: ecs.LinuxParameters;
    /**
     * (experimental) The hard limit (in MiB) of memory to present to the container.
     *
     * If your container attempts to exceed
     * the memory specified here, the container is killed. You must specify at least 4 MiB of memory for a job.
     *
     * @default 4
     * @experimental
     */
    readonly memoryLimitMiB?: number;
    /**
     * (experimental) The mount points for data volumes in your container.
     *
     * @default - No mount points will be used.
     * @experimental
     */
    readonly mountPoints?: ecs.MountPoint[];
    /**
     * (experimental) When this parameter is true, the container is given elevated privileges on the host container instance (similar to the root user).
     *
     * @default false
     * @experimental
     */
    readonly privileged?: boolean;
    /**
     * (experimental) When this parameter is true, the container is given read-only access to its root file system.
     *
     * @default false
     * @experimental
     */
    readonly readOnly?: boolean;
    /**
     * (experimental) The number of physical GPUs to reserve for the container.
     *
     * The number of GPUs reserved for all
     * containers in a job should not exceed the number of available GPUs on the compute resource that the job is launched on.
     *
     * @default - No GPU reservation.
     * @experimental
     */
    readonly gpuCount?: number;
    /**
     * (experimental) A list of ulimits to set in the container.
     *
     * @default - No limits.
     * @experimental
     */
    readonly ulimits?: ecs.Ulimit[];
    /**
     * (experimental) The user name to use inside the container.
     *
     * @default - None will be used.
     * @experimental
     */
    readonly user?: string;
    /**
     * (experimental) The number of vCPUs reserved for the container.
     *
     * Each vCPU is equivalent to
     * 1,024 CPU shares. You must specify at least one vCPU.
     *
     * @default 1
     * @experimental
     */
    readonly vcpus?: number;
    /**
     * (experimental) A list of data volumes used in a job.
     *
     * @default - No data volumes will be used.
     * @experimental
     */
    readonly volumes?: ecs.Volume[];
}
/**
 * (experimental) Construction properties of the {@link JobDefinition} construct.
 *
 * @experimental
 */
export interface JobDefinitionProps {
    /**
     * (experimental) The name of the job definition.
     *
     * Up to 128 letters (uppercase and lowercase), numbers, hyphens, and underscores are allowed.
     *
     * @default Cloudformation-generated name
     * @experimental
     */
    readonly jobDefinitionName?: string;
    /**
     * (experimental) An object with various properties specific to container-based jobs.
     *
     * @experimental
     */
    readonly container: JobDefinitionContainer;
    /**
     * (experimental) An object with various properties specific to multi-node parallel jobs.
     *
     * @default - undefined
     * @experimental
     */
    readonly nodeProps?: IMultiNodeProps;
    /**
     * (experimental) When you submit a job, you can specify parameters that should replace the placeholders or override the default job definition parameters.
     *
     * Parameters
     * in job submission requests take precedence over the defaults in a job definition.
     * This allows you to use the same job definition for multiple jobs that use the same
     * format, and programmatically change values in the command at submission time.
     *
     * @default - undefined
     * @experimental
     * @link https://docs.aws.amazon.com/batch/latest/userguide/job_definition_parameters.html
     */
    readonly parameters?: {
        [key: string]: string;
    };
    /**
     * (experimental) The number of times to move a job to the RUNNABLE status.
     *
     * You may specify between 1 and
     * 10 attempts. If the value of attempts is greater than one, the job is retried on failure
     * the same number of attempts as the value.
     *
     * @default 1
     * @experimental
     */
    readonly retryAttempts?: number;
    /**
     * (experimental) The timeout configuration for jobs that are submitted with this job definition.
     *
     * You can specify
     * a timeout duration after which AWS Batch terminates your jobs if they have not finished.
     *
     * @default - undefined
     * @experimental
     */
    readonly timeout?: Duration;
}
/**
 * (experimental) Properties for specifying multi-node properties for compute resources.
 *
 * @experimental
 */
export interface IMultiNodeProps {
    /**
     * (experimental) Specifies the node index for the main node of a multi-node parallel job.
     *
     * This node index value must be fewer than the number of nodes.
     *
     * @experimental
     */
    mainNode: number;
    /**
     * (experimental) A list of node ranges and their properties associated with a multi-node parallel job.
     *
     * @experimental
     */
    rangeProps: INodeRangeProps[];
    /**
     * (experimental) The number of nodes associated with a multi-node parallel job.
     *
     * @experimental
     */
    count: number;
}
/**
 * (experimental) Properties for a multi-node batch job.
 *
 * @experimental
 */
export interface INodeRangeProps {
    /**
     * (experimental) The container details for the node range.
     *
     * @experimental
     */
    container: JobDefinitionContainer;
    /**
     * (experimental) The minimum node index value to apply this container definition against.
     *
     * You may nest node ranges, for example 0:10 and 4:5, in which case the 4:5 range properties override the 0:10 properties.
     *
     * @default 0
     * @experimental
     */
    fromNodeIndex?: number;
    /**
     * (experimental) The maximum node index value to apply this container definition against. If omitted, the highest value is used relative.
     *
     * to the number of nodes associated with the job. You may nest node ranges, for example 0:10 and 4:5,
     * in which case the 4:5 range properties override the 0:10 properties.
     *
     * @default {@link IMultiNodeprops.count}
     * @experimental
     */
    toNodeIndex?: number;
}
/**
 * (experimental) An interface representing a job definition - either a new one, created with the CDK, *using the {@link JobDefinition} class, or existing ones, referenced using the {@link JobDefinition.fromJobDefinitionArn} method.
 *
 * @experimental
 */
export interface IJobDefinition extends IResource {
    /**
     * (experimental) The ARN of this batch job definition.
     *
     * @experimental
     * @attribute true
     */
    readonly jobDefinitionArn: string;
    /**
     * (experimental) The name of the batch job definition.
     *
     * @experimental
     * @attribute true
     */
    readonly jobDefinitionName: string;
}
/**
 * (experimental) Batch Job Definition.
 *
 * Defines a batch job definition to execute a specific batch job.
 *
 * @experimental
 */
export declare class JobDefinition extends Resource implements IJobDefinition {
    /**
     * (experimental) Imports an existing batch job definition by its amazon resource name.
     *
     * @experimental
     */
    static fromJobDefinitionArn(scope: Construct, id: string, jobDefinitionArn: string): IJobDefinition;
    /**
     * (experimental) Imports an existing batch job definition by its name.
     *
     * If name is specified without a revision then the latest active revision is used.
     *
     * @experimental
     */
    static fromJobDefinitionName(scope: Construct, id: string, jobDefinitionName: string): IJobDefinition;
    /**
     * (experimental) The ARN of this batch job definition.
     *
     * @experimental
     */
    readonly jobDefinitionArn: string;
    /**
     * (experimental) The name of the batch job definition.
     *
     * @experimental
     */
    readonly jobDefinitionName: string;
    private readonly imageConfig;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: JobDefinitionProps);
    private deserializeEnvVariables;
    private buildJobContainer;
    private buildNodeRangeProps;
}
