import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement, Operator } from "../shared";
/**
 * (experimental) Statement provider for service [iam](https://docs.aws.amazon.com/service-authorization/latest/reference/list_identityandaccessmanagement.html).
 *
 * @experimental
 */
export declare class Iam extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Statement provider for service [iam](https://docs.aws.amazon.com/service-authorization/latest/reference/list_identityandaccessmanagement.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid?: string);
    /**
     * (experimental) Grants permission to add a new client ID (audience) to the list of registered IDs for the specified IAM OpenID Connect (OIDC) provider resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_AddClientIDToOpenIDConnectProvider.html
     *
     * @experimental
     */
    toAddClientIDToOpenIDConnectProvider(): this;
    /**
     * (experimental) Grants permission to add an IAM role to the specified instance profile.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:PassRole
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_AddRoleToInstanceProfile.html
     *
     * @experimental
     */
    toAddRoleToInstanceProfile(): this;
    /**
     * (experimental) Grants permission to add an IAM user to the specified IAM group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_AddUserToGroup.html
     *
     * @experimental
     */
    toAddUserToGroup(): this;
    /**
     * (experimental) Grants permission to attach a managed policy to the specified IAM group.
     *
     * Access Level: Permissions management
     *
     * Possible conditions:
     * - .ifPolicyARN()
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_AttachGroupPolicy.html
     *
     * @experimental
     */
    toAttachGroupPolicy(): this;
    /**
     * (experimental) Grants permission to attach a managed policy to the specified IAM role.
     *
     * Access Level: Permissions management
     *
     * Possible conditions:
     * - .ifPolicyARN()
     * - .ifPermissionsBoundary()
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_AttachRolePolicy.html
     *
     * @experimental
     */
    toAttachRolePolicy(): this;
    /**
     * (experimental) Grants permission to attach a managed policy to the specified IAM user.
     *
     * Access Level: Permissions management
     *
     * Possible conditions:
     * - .ifPolicyARN()
     * - .ifPermissionsBoundary()
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_AttachUserPolicy.html
     *
     * @experimental
     */
    toAttachUserPolicy(): this;
    /**
     * (experimental) Grants permission for an IAM user to to change their own password.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ChangePassword.html
     *
     * @experimental
     */
    toChangePassword(): this;
    /**
     * (experimental) Grants permission to create access key and secret access key for the specified IAM user.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateAccessKey.html
     *
     * @experimental
     */
    toCreateAccessKey(): this;
    /**
     * (experimental) Grants permission to create an alias for your AWS account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateAccountAlias.html
     *
     * @experimental
     */
    toCreateAccountAlias(): this;
    /**
     * (experimental) Grants permission to create a new group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateGroup.html
     *
     * @experimental
     */
    toCreateGroup(): this;
    /**
     * (experimental) Grants permission to create a new instance profile.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateInstanceProfile.html
     *
     * @experimental
     */
    toCreateInstanceProfile(): this;
    /**
     * (experimental) Grants permission to create a password for the specified IAM user.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateLoginProfile.html
     *
     * @experimental
     */
    toCreateLoginProfile(): this;
    /**
     * (experimental) Grants permission to create an IAM resource that describes an identity provider (IdP) that supports OpenID Connect (OIDC).
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateOpenIDConnectProvider.html
     *
     * @experimental
     */
    toCreateOpenIDConnectProvider(): this;
    /**
     * (experimental) Grants permission to create a new managed policy.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreatePolicy.html
     *
     * @experimental
     */
    toCreatePolicy(): this;
    /**
     * (experimental) Grants permission to create a new version of the specified managed policy.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreatePolicyVersion.html
     *
     * @experimental
     */
    toCreatePolicyVersion(): this;
    /**
     * (experimental) Grants permission to create a new role.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifPermissionsBoundary()
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateRole.html
     *
     * @experimental
     */
    toCreateRole(): this;
    /**
     * (experimental) Grants permission to create an IAM resource that describes an identity provider (IdP) that supports SAML 2.0.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateSAMLProvider.html
     *
     * @experimental
     */
    toCreateSAMLProvider(): this;
    /**
     * (experimental) Grants permission to create an IAM role that allows an AWS service to perform actions on your behalf.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAWSServiceName()
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateServiceLinkedRole.html
     *
     * @experimental
     */
    toCreateServiceLinkedRole(): this;
    /**
     * (experimental) Grants permission to create a new service-specific credential for an IAM user.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateServiceSpecificCredential.html
     *
     * @experimental
     */
    toCreateServiceSpecificCredential(): this;
    /**
     * (experimental) Grants permission to create a new IAM user.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifPermissionsBoundary()
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateUser.html
     *
     * @experimental
     */
    toCreateUser(): this;
    /**
     * (experimental) Grants permission to create a new virtual MFA device.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_CreateVirtualMFADevice.html
     *
     * @experimental
     */
    toCreateVirtualMFADevice(): this;
    /**
     * (experimental) Grants permission to deactivate the specified MFA device and remove its association with the IAM user for which it was originally enabled.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeactivateMFADevice.html
     *
     * @experimental
     */
    toDeactivateMFADevice(): this;
    /**
     * (experimental) Grants permission to delete the access key pair that is associated with the specified IAM user.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteAccessKey.html
     *
     * @experimental
     */
    toDeleteAccessKey(): this;
    /**
     * (experimental) Grants permission to delete the specified AWS account alias.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteAccountAlias.html
     *
     * @experimental
     */
    toDeleteAccountAlias(): this;
    /**
     * (experimental) Grants permission to delete the password policy for the AWS account.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteAccountPasswordPolicy.html
     *
     * @experimental
     */
    toDeleteAccountPasswordPolicy(): this;
    /**
     * (experimental) Grants permission to delete the specified IAM group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteGroup.html
     *
     * @experimental
     */
    toDeleteGroup(): this;
    /**
     * (experimental) Grants permission to delete the specified inline policy from its group.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteGroupPolicy.html
     *
     * @experimental
     */
    toDeleteGroupPolicy(): this;
    /**
     * (experimental) Grants permission to delete the specified instance profile.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteInstanceProfile.html
     *
     * @experimental
     */
    toDeleteInstanceProfile(): this;
    /**
     * (experimental) Grants permission to delete the password for the specified IAM user.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteLoginProfile.html
     *
     * @experimental
     */
    toDeleteLoginProfile(): this;
    /**
     * (experimental) Grants permission to delete an OpenID Connect identity provider (IdP) resource object in IAM.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteOpenIDConnectProvider.html
     *
     * @experimental
     */
    toDeleteOpenIDConnectProvider(): this;
    /**
     * (experimental) Grants permission to delete the specified managed policy and remove it from any IAM entities (users, groups, or roles) to which it is attached.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeletePolicy.html
     *
     * @experimental
     */
    toDeletePolicy(): this;
    /**
     * (experimental) Grants permission to delete a version from the specified managed policy.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeletePolicyVersion.html
     *
     * @experimental
     */
    toDeletePolicyVersion(): this;
    /**
     * (experimental) Grants permission to delete the specified role.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteRole.html
     *
     * @experimental
     */
    toDeleteRole(): this;
    /**
     * (experimental) Grants permission to remove the permissions boundary from a role.
     *
     * Access Level: Permissions management
     *
     * Possible conditions:
     * - .ifPermissionsBoundary()
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteRolePermissionsBoundary.html
     *
     * @experimental
     */
    toDeleteRolePermissionsBoundary(): this;
    /**
     * (experimental) Grants permission to delete the specified inline policy from the specified role.
     *
     * Access Level: Permissions management
     *
     * Possible conditions:
     * - .ifPermissionsBoundary()
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteRolePolicy.html
     *
     * @experimental
     */
    toDeleteRolePolicy(): this;
    /**
     * (experimental) Grants permission to delete a SAML provider resource in IAM.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteSAMLProvider.html
     *
     * @experimental
     */
    toDeleteSAMLProvider(): this;
    /**
     * (experimental) Grants permission to delete the specified SSH public key.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteSSHPublicKey.html
     *
     * @experimental
     */
    toDeleteSSHPublicKey(): this;
    /**
     * (experimental) Grants permission to delete the specified server certificate.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteServerCertificate.html
     *
     * @experimental
     */
    toDeleteServerCertificate(): this;
    /**
     * (experimental) Grants permission to delete an IAM role that is linked to a specific AWS service, if the service is no longer using it.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteServiceLinkedRole.html
     *
     * @experimental
     */
    toDeleteServiceLinkedRole(): this;
    /**
     * (experimental) Grants permission to delete the specified service-specific credential for an IAM user.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteServiceSpecificCredential.html
     *
     * @experimental
     */
    toDeleteServiceSpecificCredential(): this;
    /**
     * (experimental) Grants permission to delete a signing certificate that is associated with the specified IAM user.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteSigningCertificate.html
     *
     * @experimental
     */
    toDeleteSigningCertificate(): this;
    /**
     * (experimental) Grants permission to delete the specified IAM user.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteUser.html
     *
     * @experimental
     */
    toDeleteUser(): this;
    /**
     * (experimental) Grants permission to remove the permissions boundary from the specified IAM user.
     *
     * Access Level: Permissions management
     *
     * Possible conditions:
     * - .ifPermissionsBoundary()
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteUserPermissionsBoundary.html
     *
     * @experimental
     */
    toDeleteUserPermissionsBoundary(): this;
    /**
     * (experimental) Grants permission to delete the specified inline policy from an IAM user.
     *
     * Access Level: Permissions management
     *
     * Possible conditions:
     * - .ifPermissionsBoundary()
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteUserPolicy.html
     *
     * @experimental
     */
    toDeleteUserPolicy(): this;
    /**
     * (experimental) Grants permission to delete a virtual MFA device.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_DeleteVirtualMFADevice.html
     *
     * @experimental
     */
    toDeleteVirtualMFADevice(): this;
    /**
     * (experimental) Grants permission to detach a managed policy from the specified IAM group.
     *
     * Access Level: Permissions management
     *
     * Possible conditions:
     * - .ifPolicyARN()
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_DetachGroupPolicy.html
     *
     * @experimental
     */
    toDetachGroupPolicy(): this;
    /**
     * (experimental) Grants permission to detach a managed policy from the specified role.
     *
     * Access Level: Permissions management
     *
     * Possible conditions:
     * - .ifPolicyARN()
     * - .ifPermissionsBoundary()
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_DetachRolePolicy.html
     *
     * @experimental
     */
    toDetachRolePolicy(): this;
    /**
     * (experimental) Grants permission to detach a managed policy from the specified IAM user.
     *
     * Access Level: Permissions management
     *
     * Possible conditions:
     * - .ifPolicyARN()
     * - .ifPermissionsBoundary()
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_DetachUserPolicy.html
     *
     * @experimental
     */
    toDetachUserPolicy(): this;
    /**
     * (experimental) Grants permission to enable an MFA device and associate it with the specified IAM user.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_EnableMFADevice.html
     *
     * @experimental
     */
    toEnableMFADevice(): this;
    /**
     * (experimental) Grants permission to generate a credential report for the AWS account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_GenerateCredentialReport.html
     *
     * @experimental
     */
    toGenerateCredentialReport(): this;
    /**
     * (experimental) Grants permission to generate an access report for an AWS Organizations entity.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifOrganizationsPolicyId()
     *
     * Dependent actions:
     * - organizations:DescribePolicy
     * - organizations:ListChildren
     * - organizations:ListParents
     * - organizations:ListPoliciesForTarget
     * - organizations:ListRoots
     * - organizations:ListTargetsForPolicy
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_GenerateOrganizationsAccessReport.html
     *
     * @experimental
     */
    toGenerateOrganizationsAccessReport(): this;
    /**
     * (experimental) Grants permission to generate a service last accessed data report for an IAM resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_GenerateServiceLastAccessedDetails.html
     *
     * @experimental
     */
    toGenerateServiceLastAccessedDetails(): this;
    /**
     * (experimental) Grants permission to retrieve information about when the specified access key was last used.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetAccessKeyLastUsed.html
     *
     * @experimental
     */
    toGetAccessKeyLastUsed(): this;
    /**
     * (experimental) Grants permission to retrieve information about all IAM users, groups, roles, and policies in your AWS account, including their relationships to one another.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetAccountAuthorizationDetails.html
     *
     * @experimental
     */
    toGetAccountAuthorizationDetails(): this;
    /**
     * (experimental) Grants permission to retrieve the password policy for the AWS account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetAccountPasswordPolicy.html
     *
     * @experimental
     */
    toGetAccountPasswordPolicy(): this;
    /**
     * (experimental) Grants permission to retrieve information about IAM entity usage and IAM quotas in the AWS account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetAccountSummary.html
     *
     * @experimental
     */
    toGetAccountSummary(): this;
    /**
     * (experimental) Grants permission to retrieve a list of all of the context keys that are referenced in the specified policy.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetContextKeysForCustomPolicy.html
     *
     * @experimental
     */
    toGetContextKeysForCustomPolicy(): this;
    /**
     * (experimental) Grants permission to retrieve a list of all context keys that are referenced in all IAM policies that are attached to the specified IAM identity (user, group, or role).
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetContextKeysForPrincipalPolicy.html
     *
     * @experimental
     */
    toGetContextKeysForPrincipalPolicy(): this;
    /**
     * (experimental) Grants permission to retrieve a credential report for the AWS account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetCredentialReport.html
     *
     * @experimental
     */
    toGetCredentialReport(): this;
    /**
     * (experimental) Grants permission to retrieve a list of IAM users in the specified IAM group.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetGroup.html
     *
     * @experimental
     */
    toGetGroup(): this;
    /**
     * (experimental) Grants permission to retrieve an inline policy document that is embedded in the specified IAM group.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetGroupPolicy.html
     *
     * @experimental
     */
    toGetGroupPolicy(): this;
    /**
     * (experimental) Grants permission to retrieve information about the specified instance profile, including the instance profile's path, GUID, ARN, and role.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetInstanceProfile.html
     *
     * @experimental
     */
    toGetInstanceProfile(): this;
    /**
     * (experimental) Grants permission to retrieve the user name and password creation date for the specified IAM user.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetLoginProfile.html
     *
     * @experimental
     */
    toGetLoginProfile(): this;
    /**
     * (experimental) Grants permission to retrieve information about the specified OpenID Connect (OIDC) provider resource in IAM.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetOpenIDConnectProvider.html
     *
     * @experimental
     */
    toGetOpenIDConnectProvider(): this;
    /**
     * (experimental) Grants permission to retrieve an AWS Organizations access report.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetOrganizationsAccessReport.html
     *
     * @experimental
     */
    toGetOrganizationsAccessReport(): this;
    /**
     * (experimental) Grants permission to retrieve information about the specified managed policy, including the policy's default version and the total number of identities to which the policy is attached.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetPolicy.html
     *
     * @experimental
     */
    toGetPolicy(): this;
    /**
     * (experimental) Grants permission to retrieve information about a version of the specified managed policy, including the policy document.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetPolicyVersion.html
     *
     * @experimental
     */
    toGetPolicyVersion(): this;
    /**
     * (experimental) Grants permission to retrieve information about the specified role, including the role's path, GUID, ARN, and the role's trust policy.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetRole.html
     *
     * @experimental
     */
    toGetRole(): this;
    /**
     * (experimental) Grants permission to retrieve an inline policy document that is embedded with the specified IAM role.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetRolePolicy.html
     *
     * @experimental
     */
    toGetRolePolicy(): this;
    /**
     * (experimental) Grants permission to retrieve the SAML provider metadocument that was uploaded when the IAM SAML provider resource was created or updated.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetSAMLProvider.html
     *
     * @experimental
     */
    toGetSAMLProvider(): this;
    /**
     * (experimental) Grants permission to retrieve the specified SSH public key, including metadata about the key.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetSSHPublicKey.html
     *
     * @experimental
     */
    toGetSSHPublicKey(): this;
    /**
     * (experimental) Grants permission to retrieve information about the specified server certificate stored in IAM.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetServerCertificate.html
     *
     * @experimental
     */
    toGetServerCertificate(): this;
    /**
     * (experimental) Grants permission to retrieve information about the service last accessed data report.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetServiceLastAccessedDetails.html
     *
     * @experimental
     */
    toGetServiceLastAccessedDetails(): this;
    /**
     * (experimental) Grants permission to retrieve information about the entities from the service last accessed data report.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetServiceLastAccessedDetailsWithEntities.html
     *
     * @experimental
     */
    toGetServiceLastAccessedDetailsWithEntities(): this;
    /**
     * (experimental) Grants permission to retrieve an IAM service-linked role deletion status.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetServiceLinkedRoleDeletionStatus.html
     *
     * @experimental
     */
    toGetServiceLinkedRoleDeletionStatus(): this;
    /**
     * (experimental) Grants permission to retrieve information about the specified IAM user, including the user's creation date, path, unique ID, and ARN.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetUser.html
     *
     * @experimental
     */
    toGetUser(): this;
    /**
     * (experimental) Grants permission to retrieve an inline policy document that is embedded in the specified IAM user.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_GetUserPolicy.html
     *
     * @experimental
     */
    toGetUserPolicy(): this;
    /**
     * (experimental) Grants permission to list information about the access key IDs that are associated with the specified IAM user.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListAccessKeys.html
     *
     * @experimental
     */
    toListAccessKeys(): this;
    /**
     * (experimental) Grants permission to list the account alias that is associated with the AWS account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListAccountAliases.html
     *
     * @experimental
     */
    toListAccountAliases(): this;
    /**
     * (experimental) Grants permission to list all managed policies that are attached to the specified IAM group.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListAttachedGroupPolicies.html
     *
     * @experimental
     */
    toListAttachedGroupPolicies(): this;
    /**
     * (experimental) Grants permission to list all managed policies that are attached to the specified IAM role.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListAttachedRolePolicies.html
     *
     * @experimental
     */
    toListAttachedRolePolicies(): this;
    /**
     * (experimental) Grants permission to list all managed policies that are attached to the specified IAM user.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListAttachedUserPolicies.html
     *
     * @experimental
     */
    toListAttachedUserPolicies(): this;
    /**
     * (experimental) Grants permission to list all IAM identities to which the specified managed policy is attached.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListEntitiesForPolicy.html
     *
     * @experimental
     */
    toListEntitiesForPolicy(): this;
    /**
     * (experimental) Grants permission to list the names of the inline policies that are embedded in the specified IAM group.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListGroupPolicies.html
     *
     * @experimental
     */
    toListGroupPolicies(): this;
    /**
     * (experimental) Grants permission to list the IAM groups that have the specified path prefix.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListGroups.html
     *
     * @experimental
     */
    toListGroups(): this;
    /**
     * (experimental) Grants permission to list the IAM groups that the specified IAM user belongs to.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListGroupsForUser.html
     *
     * @experimental
     */
    toListGroupsForUser(): this;
    /**
     * (experimental) Grants permission to list the tags that are attached to the specified instance profile.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListInstanceProfileTags.html
     *
     * @experimental
     */
    toListInstanceProfileTags(): this;
    /**
     * (experimental) Grants permission to list the instance profiles that have the specified path prefix.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListInstanceProfiles.html
     *
     * @experimental
     */
    toListInstanceProfiles(): this;
    /**
     * (experimental) Grants permission to list the instance profiles that have the specified associated IAM role.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListInstanceProfilesForRole.html
     *
     * @experimental
     */
    toListInstanceProfilesForRole(): this;
    /**
     * (experimental) Grants permission to list the tags that are attached to the specified virtual mfa device.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListMFADeviceTags.html
     *
     * @experimental
     */
    toListMFADeviceTags(): this;
    /**
     * (experimental) Grants permission to list the MFA devices for an IAM user.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListMFADevices.html
     *
     * @experimental
     */
    toListMFADevices(): this;
    /**
     * (experimental) Grants permission to list the tags that are attached to the specified OpenID Connect provider.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListOpenIDConnectProviderTags.html
     *
     * @experimental
     */
    toListOpenIDConnectProviderTags(): this;
    /**
     * (experimental) Grants permission to list information about the IAM OpenID Connect (OIDC) provider resource objects that are defined in the AWS account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListOpenIDConnectProviders.html
     *
     * @experimental
     */
    toListOpenIDConnectProviders(): this;
    /**
     * (experimental) Grants permission to list all managed policies.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListPolicies.html
     *
     * @experimental
     */
    toListPolicies(): this;
    /**
     * (experimental) Grants permission to list information about the policies that grant an entity access to a specific service.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListPoliciesGrantingServiceAccess.html
     *
     * @experimental
     */
    toListPoliciesGrantingServiceAccess(): this;
    /**
     * (experimental) Grants permission to list the tags that are attached to the specified managed policy.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListPolicyTags.html
     *
     * @experimental
     */
    toListPolicyTags(): this;
    /**
     * (experimental) Grants permission to list information about the versions of the specified managed policy, including the version that is currently set as the policy's default version.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListPolicyVersions.html
     *
     * @experimental
     */
    toListPolicyVersions(): this;
    /**
     * (experimental) Grants permission to list the names of the inline policies that are embedded in the specified IAM role.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListRolePolicies.html
     *
     * @experimental
     */
    toListRolePolicies(): this;
    /**
     * (experimental) Grants permission to list the tags that are attached to the specified IAM role.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListRoleTags.html
     *
     * @experimental
     */
    toListRoleTags(): this;
    /**
     * (experimental) Grants permission to list the IAM roles that have the specified path prefix.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListRoles.html
     *
     * @experimental
     */
    toListRoles(): this;
    /**
     * (experimental) Grants permission to list the tags that are attached to the specified SAML provider.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListSAMLProviderTags.html
     *
     * @experimental
     */
    toListSAMLProviderTags(): this;
    /**
     * (experimental) Grants permission to list the SAML provider resources in IAM.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListSAMLProviders.html
     *
     * @experimental
     */
    toListSAMLProviders(): this;
    /**
     * (experimental) Grants permission to list information about the SSH public keys that are associated with the specified IAM user.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListSSHPublicKeys.html
     *
     * @experimental
     */
    toListSSHPublicKeys(): this;
    /**
     * (experimental) Grants permission to list the tags that are attached to the specified server certificate.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListServerCertificateTags.html
     *
     * @experimental
     */
    toListServerCertificateTags(): this;
    /**
     * (experimental) Grants permission to list the server certificates that have the specified path prefix.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListServerCertificates.html
     *
     * @experimental
     */
    toListServerCertificates(): this;
    /**
     * (experimental) Grants permission to list the service-specific credentials that are associated with the specified IAM user.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListServiceSpecificCredentials.html
     *
     * @experimental
     */
    toListServiceSpecificCredentials(): this;
    /**
     * (experimental) Grants permission to list information about the signing certificates that are associated with the specified IAM user.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListSigningCertificates.html
     *
     * @experimental
     */
    toListSigningCertificates(): this;
    /**
     * (experimental) Grants permission to list the names of the inline policies that are embedded in the specified IAM user.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListUserPolicies.html
     *
     * @experimental
     */
    toListUserPolicies(): this;
    /**
     * (experimental) Grants permission to list the tags that are attached to the specified IAM user.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListUserTags.html
     *
     * @experimental
     */
    toListUserTags(): this;
    /**
     * (experimental) Grants permission to list the IAM users that have the specified path prefix.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListUsers.html
     *
     * @experimental
     */
    toListUsers(): this;
    /**
     * (experimental) Grants permission to list virtual MFA devices by assignment status.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ListVirtualMFADevices.html
     *
     * @experimental
     */
    toListVirtualMFADevices(): this;
    /**
     * (experimental) Grants permission to pass a role to a service.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAssociatedResourceArn()
     * - .ifPassedToService()
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_passrole.html
     *
     * @experimental
     */
    toPassRole(): this;
    /**
     * (experimental) Grants permission to create or update an inline policy document that is embedded in the specified IAM group.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_PutGroupPolicy.html
     *
     * @experimental
     */
    toPutGroupPolicy(): this;
    /**
     * (experimental) Grants permission to set a managed policy as a permissions boundary for a role.
     *
     * Access Level: Permissions management
     *
     * Possible conditions:
     * - .ifPermissionsBoundary()
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_PutRolePermissionsBoundary.html
     *
     * @experimental
     */
    toPutRolePermissionsBoundary(): this;
    /**
     * (experimental) Grants permission to create or update an inline policy document that is embedded in the specified IAM role.
     *
     * Access Level: Permissions management
     *
     * Possible conditions:
     * - .ifPermissionsBoundary()
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_PutRolePolicy.html
     *
     * @experimental
     */
    toPutRolePolicy(): this;
    /**
     * (experimental) Grants permission to set a managed policy as a permissions boundary for an IAM user.
     *
     * Access Level: Permissions management
     *
     * Possible conditions:
     * - .ifPermissionsBoundary()
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_PutUserPermissionsBoundary.html
     *
     * @experimental
     */
    toPutUserPermissionsBoundary(): this;
    /**
     * (experimental) Grants permission to create or update an inline policy document that is embedded in the specified IAM user.
     *
     * Access Level: Permissions management
     *
     * Possible conditions:
     * - .ifPermissionsBoundary()
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_PutUserPolicy.html
     *
     * @experimental
     */
    toPutUserPolicy(): this;
    /**
     * (experimental) Grants permission to remove the client ID (audience) from the list of client IDs in the specified IAM OpenID Connect (OIDC) provider resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_RemoveClientIDFromOpenIDConnectProvider.html
     *
     * @experimental
     */
    toRemoveClientIDFromOpenIDConnectProvider(): this;
    /**
     * (experimental) Grants permission to remove an IAM role from the specified EC2 instance profile.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_RemoveRoleFromInstanceProfile.html
     *
     * @experimental
     */
    toRemoveRoleFromInstanceProfile(): this;
    /**
     * (experimental) Grants permission to remove an IAM user from the specified group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_RemoveUserFromGroup.html
     *
     * @experimental
     */
    toRemoveUserFromGroup(): this;
    /**
     * (experimental) Grants permission to reset the password for an existing service-specific credential for an IAM user.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ResetServiceSpecificCredential.html
     *
     * @experimental
     */
    toResetServiceSpecificCredential(): this;
    /**
     * (experimental) Grants permission to synchronize the specified MFA device with its IAM entity (user or role).
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_ResyncMFADevice.html
     *
     * @experimental
     */
    toResyncMFADevice(): this;
    /**
     * (experimental) Grants permission to set the version of the specified policy as the policy's default version.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_SetDefaultPolicyVersion.html
     *
     * @experimental
     */
    toSetDefaultPolicyVersion(): this;
    /**
     * (experimental) Grants permission to set the STS global endpoint token version.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_SetSecurityTokenServicePreferences.html
     *
     * @experimental
     */
    toSetSecurityTokenServicePreferences(): this;
    /**
     * (experimental) Grants permission to simulate whether an identity-based policy or resource-based policy provides permissions for specific API operations and resources.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_SimulateCustomPolicy.html
     *
     * @experimental
     */
    toSimulateCustomPolicy(): this;
    /**
     * (experimental) Grants permission to simulate whether an identity-based policy that is attached to a specified IAM entity (user or role) provides permissions for specific API operations and resources.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_SimulatePrincipalPolicy.html
     *
     * @experimental
     */
    toSimulatePrincipalPolicy(): this;
    /**
     * (experimental) Grants permission to add tags to an instance profile.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_TagInstanceProfile.html
     *
     * @experimental
     */
    toTagInstanceProfile(): this;
    /**
     * (experimental) Grants permission to add tags to a virtual mfa device.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_TagMFADevice.html
     *
     * @experimental
     */
    toTagMFADevice(): this;
    /**
     * (experimental) Grants permission to add tags to an OpenID Connect provider.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_TagOpenIDConnectProvider.html
     *
     * @experimental
     */
    toTagOpenIDConnectProvider(): this;
    /**
     * (experimental) Grants permission to add tags to a managed policy.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_TagPolicy.html
     *
     * @experimental
     */
    toTagPolicy(): this;
    /**
     * (experimental) Grants permission to add tags to an IAM role.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_TagRole.html
     *
     * @experimental
     */
    toTagRole(): this;
    /**
     * (experimental) Grants permission to add tags to a SAML Provider.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_TagSAMLProvider.html
     *
     * @experimental
     */
    toTagSAMLProvider(): this;
    /**
     * (experimental) Grants permission to add tags to a server certificate.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_TagServerCertificate.html
     *
     * @experimental
     */
    toTagServerCertificate(): this;
    /**
     * (experimental) Grants permission to add tags to an IAM user.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_TagUser.html
     *
     * @experimental
     */
    toTagUser(): this;
    /**
     * (experimental) Grants permission to remove the specified tags from the instance profile.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_UntagInstanceProfile.html
     *
     * @experimental
     */
    toUntagInstanceProfile(): this;
    /**
     * (experimental) Grants permission to remove the specified tags from the virtual mfa device.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_UntagMFADevice.html
     *
     * @experimental
     */
    toUntagMFADevice(): this;
    /**
     * (experimental) Grants permission to remove the specified tags from the OpenID Connect provider.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_UntagOpenIDConnectProvider.html
     *
     * @experimental
     */
    toUntagOpenIDConnectProvider(): this;
    /**
     * (experimental) Grants permission to remove the specified tags from the managed policy.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_UntagPolicy.html
     *
     * @experimental
     */
    toUntagPolicy(): this;
    /**
     * (experimental) Grants permission to remove the specified tags from the role.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_UntagRole.html
     *
     * @experimental
     */
    toUntagRole(): this;
    /**
     * (experimental) Grants permission to remove the specified tags from the SAML Provider.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_UntagSAMLProvider.html
     *
     * @experimental
     */
    toUntagSAMLProvider(): this;
    /**
     * (experimental) Grants permission to remove the specified tags from the server certificate.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_UntagServerCertificate.html
     *
     * @experimental
     */
    toUntagServerCertificate(): this;
    /**
     * (experimental) Grants permission to remove the specified tags from the user.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_UntagUser.html
     *
     * @experimental
     */
    toUntagUser(): this;
    /**
     * (experimental) Grants permission to update the status of the specified access key as Active or Inactive.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_UpdateAccessKey.html
     *
     * @experimental
     */
    toUpdateAccessKey(): this;
    /**
     * (experimental) Grants permission to update the password policy settings for the AWS account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_UpdateAccountPasswordPolicy.html
     *
     * @experimental
     */
    toUpdateAccountPasswordPolicy(): this;
    /**
     * (experimental) Grants permission to update the policy that grants an IAM entity permission to assume a role.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_UpdateAssumeRolePolicy.html
     *
     * @experimental
     */
    toUpdateAssumeRolePolicy(): this;
    /**
     * (experimental) Grants permission to update the name or path of the specified IAM group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_UpdateGroup.html
     *
     * @experimental
     */
    toUpdateGroup(): this;
    /**
     * (experimental) Grants permission to change the password for the specified IAM user.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_UpdateLoginProfile.html
     *
     * @experimental
     */
    toUpdateLoginProfile(): this;
    /**
     * (experimental) Grants permission to update the entire list of server certificate thumbprints that are associated with an OpenID Connect (OIDC) provider resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_UpdateOpenIDConnectProviderThumbprint.html
     *
     * @experimental
     */
    toUpdateOpenIDConnectProviderThumbprint(): this;
    /**
     * (experimental) Grants permission to update the description or maximum session duration setting of a role.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_UpdateRole.html
     *
     * @experimental
     */
    toUpdateRole(): this;
    /**
     * (experimental) Grants permission to update only the description of a role.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_UpdateRoleDescription.html
     *
     * @experimental
     */
    toUpdateRoleDescription(): this;
    /**
     * (experimental) Grants permission to update the metadata document for an existing SAML provider resource.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_UpdateSAMLProvider.html
     *
     * @experimental
     */
    toUpdateSAMLProvider(): this;
    /**
     * (experimental) Grants permission to update the status of an IAM user's SSH public key to active or inactive.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_UpdateSSHPublicKey.html
     *
     * @experimental
     */
    toUpdateSSHPublicKey(): this;
    /**
     * (experimental) Grants permission to update the name or the path of the specified server certificate stored in IAM.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_UpdateServerCertificate.html
     *
     * @experimental
     */
    toUpdateServerCertificate(): this;
    /**
     * (experimental) Grants permission to update the status of a service-specific credential to active or inactive for an IAM user.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_UpdateServiceSpecificCredential.html
     *
     * @experimental
     */
    toUpdateServiceSpecificCredential(): this;
    /**
     * (experimental) Grants permission to update the status of the specified user signing certificate to active or disabled.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_UpdateSigningCertificate.html
     *
     * @experimental
     */
    toUpdateSigningCertificate(): this;
    /**
     * (experimental) Grants permission to update the name or the path of the specified IAM user.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_UpdateUser.html
     *
     * @experimental
     */
    toUpdateUser(): this;
    /**
     * (experimental) Grants permission to upload an SSH public key and associate it with the specified IAM user.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_UploadSSHPublicKey.html
     *
     * @experimental
     */
    toUploadSSHPublicKey(): this;
    /**
     * (experimental) Grants permission to upload a server certificate entity for the AWS account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_UploadServerCertificate.html
     *
     * @experimental
     */
    toUploadServerCertificate(): this;
    /**
     * (experimental) Grants permission to upload an X.509 signing certificate and associate it with the specified IAM user.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/IAM/latest/APIReference/API_UploadSigningCertificate.html
     *
     * @experimental
     */
    toUploadSigningCertificate(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type access-report to the statement.
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor-view-data-orgs.html
     *
     * @param entityPath - Identifier for the entityPath.
     * @param account - Account of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onAccessReport(entityPath: string, account?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type assumed-role to the statement.
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_use-resources.html
     *
     * @param roleName - Identifier for the roleName.
     * @param roleSessionName - Identifier for the roleSessionName.
     * @param account - Account of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onAssumedRole(roleName: string, roleSessionName: string, account?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type federated-user to the statement.
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_saml.html
     *
     * @param userName - Identifier for the userName.
     * @param account - Account of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onFederatedUser(userName: string, account?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type group to the statement.
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/id_groups.html
     *
     * @param groupNameWithPath - Identifier for the groupNameWithPath.
     * @param account - Account of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onGroup(groupNameWithPath: string, account?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type instance-profile to the statement.
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-ec2_instance-profiles.html
     *
     * @param instanceProfileNameWithPath - Identifier for the instanceProfileNameWithPath.
     * @param account - Account of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onInstanceProfile(instanceProfileNameWithPath: string, account?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type mfa to the statement.
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_mfa.html
     *
     * @param mfaTokenIdWithPath - Identifier for the mfaTokenIdWithPath.
     * @param account - Account of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onMfa(mfaTokenIdWithPath: string, account?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type oidc-provider to the statement.
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_create_oidc.html
     *
     * @param oidcProviderName - Identifier for the oidcProviderName.
     * @param account - Account of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onOidcProvider(oidcProviderName: string, account?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type policy to the statement.
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_managed-vs-inline.html
     *
     * @param policyNameWithPath - Identifier for the policyNameWithPath.
     * @param account - Account of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onPolicy(policyNameWithPath: string, account?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type role to the statement.
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html
     *
     * @param roleNameWithPath - Identifier for the roleNameWithPath.
     * @param account - Account of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onRole(roleNameWithPath: string, account?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type saml-provider to the statement.
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_saml.html
     *
     * @param samlProviderName - Identifier for the samlProviderName.
     * @param account - Account of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onSamlProvider(samlProviderName: string, account?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type server-certificate to the statement.
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html
     *
     * @param certificateNameWithPath - Identifier for the certificateNameWithPath.
     * @param account - Account of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onServerCertificate(certificateNameWithPath: string, account?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type sms-mfa to the statement.
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_mfa_enable_sms.html
     *
     * @param mfaTokenIdWithPath - Identifier for the mfaTokenIdWithPath.
     * @param account - Account of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onSmsMfa(mfaTokenIdWithPath: string, account?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type user to the statement.
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/id_users.html
     *
     * @param userNameWithPath - Identifier for the userNameWithPath.
     * @param account - Account of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onUser(userNameWithPath: string, account?: string, partition?: string): this;
    /**
     * (experimental) Filters access by the AWS service to which this role is attached.
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_iam-condition-keys.html#ck_AWSServiceName
     *
     * Applies to actions:
     * - .toCreateServiceLinkedRole()
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifAWSServiceName(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters by the resource that the role will be used on behalf of.
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_iam-condition-keys.html#ck_AssociatedResourceArn
     *
     * Applies to actions:
     * - .toPassRole()
     *
     * @param value The value(s) to check.
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`.
     * @experimental
     */
    ifAssociatedResourceArn(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the ID of an AWS Organizations policy.
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_iam-condition-keys.html#ck_OrganizationsPolicyId
     *
     * Applies to actions:
     * - .toGenerateOrganizationsAccessReport()
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifOrganizationsPolicyId(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the AWS service to which this role is passed.
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_iam-condition-keys.html#ck_PassedToService
     *
     * Applies to actions:
     * - .toPassRole()
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifPassedToService(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access if the specified policy is set as the permissions boundary on the IAM entity (user or role).
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_iam-condition-keys.html#ck_PermissionsBoundary
     *
     * Applies to actions:
     * - .toAttachRolePolicy()
     * - .toAttachUserPolicy()
     * - .toCreateRole()
     * - .toCreateUser()
     * - .toDeleteRolePermissionsBoundary()
     * - .toDeleteRolePolicy()
     * - .toDeleteUserPermissionsBoundary()
     * - .toDeleteUserPolicy()
     * - .toDetachRolePolicy()
     * - .toDetachUserPolicy()
     * - .toPutRolePermissionsBoundary()
     * - .toPutRolePolicy()
     * - .toPutUserPermissionsBoundary()
     * - .toPutUserPolicy()
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifPermissionsBoundary(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the ARN of an IAM policy.
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_iam-condition-keys.html#ck_PolicyARN
     *
     * Applies to actions:
     * - .toAttachGroupPolicy()
     * - .toAttachRolePolicy()
     * - .toAttachUserPolicy()
     * - .toDetachGroupPolicy()
     * - .toDetachRolePolicy()
     * - .toDetachUserPolicy()
     *
     * @param value The value(s) to check.
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`.
     * @experimental
     */
    ifPolicyARN(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the tags attached to an IAM entity (user or role).
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_iam-condition-keys.html#ck_ResourceTag
     *
     * Applies to resource types:
     * - role
     * - user
     *
     * @param tagKey The tag key to check.
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifResourceTag(tagKey: string, value: string | string[], operator?: Operator | string): this;
}
