# coding: utf-8

"""
    Dockstore API

    This describes the dockstore API, a webservice that manages pairs of Docker images and associated metadata such as CWL documents and Dockerfiles used to build those images. Explore swagger.json for a Swagger 2.0 description of our API and explore openapi.yaml for OpenAPI 3.0 descriptions.  # noqa: E501

    OpenAPI spec version: 1.12.0-alpha.1-SNAPSHOT
    Contact: theglobalalliance@genomicsandhealth.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from jgreenepack.api_client import ApiClient


class AliasesApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_aliases(self, workflow_version_id, aliases, **kwargs):  # noqa: E501
        """Add aliases linked to a workflow version in Dockstore.  # noqa: E501

        Aliases are alphanumerical (case-insensitive and may contain internal hyphens), given in a comma-delimited list.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_aliases(workflow_version_id, aliases, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int workflow_version_id: workflow version to modify. (required)
        :param str aliases: Comma-delimited list of aliases. (required)
        :return: WorkflowVersion
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_aliases_with_http_info(workflow_version_id, aliases, **kwargs)  # noqa: E501
        else:
            (data) = self.add_aliases_with_http_info(workflow_version_id, aliases, **kwargs)  # noqa: E501
            return data

    def add_aliases_with_http_info(self, workflow_version_id, aliases, **kwargs):  # noqa: E501
        """Add aliases linked to a workflow version in Dockstore.  # noqa: E501

        Aliases are alphanumerical (case-insensitive and may contain internal hyphens), given in a comma-delimited list.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_aliases_with_http_info(workflow_version_id, aliases, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int workflow_version_id: workflow version to modify. (required)
        :param str aliases: Comma-delimited list of aliases. (required)
        :return: WorkflowVersion
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workflow_version_id', 'aliases']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_aliases" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workflow_version_id' is set
        if self.api_client.client_side_validation and ('workflow_version_id' not in params or
                                                       params['workflow_version_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `workflow_version_id` when calling `add_aliases`")  # noqa: E501
        # verify the required parameter 'aliases' is set
        if self.api_client.client_side_validation and ('aliases' not in params or
                                                       params['aliases'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `aliases` when calling `add_aliases`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workflow_version_id' in params:
            path_params['workflowVersionId'] = params['workflow_version_id']  # noqa: E501

        query_params = []
        if 'aliases' in params:
            query_params.append(('aliases', params['aliases']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/aliases/workflow-versions/{workflowVersionId}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='WorkflowVersion',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_workflow_version_path_info_by_alias(self, alias, **kwargs):  # noqa: E501
        """Retrieves workflow version path information by alias.  # noqa: E501

        Does not require authentication for published workflows, authentication can be provided for restricted workflows  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_workflow_version_path_info_by_alias(alias, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str alias: Alias (required)
        :return: WorkflowVersionPathInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_workflow_version_path_info_by_alias_with_http_info(alias, **kwargs)  # noqa: E501
        else:
            (data) = self.get_workflow_version_path_info_by_alias_with_http_info(alias, **kwargs)  # noqa: E501
            return data

    def get_workflow_version_path_info_by_alias_with_http_info(self, alias, **kwargs):  # noqa: E501
        """Retrieves workflow version path information by alias.  # noqa: E501

        Does not require authentication for published workflows, authentication can be provided for restricted workflows  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_workflow_version_path_info_by_alias_with_http_info(alias, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str alias: Alias (required)
        :return: WorkflowVersionPathInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['alias']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workflow_version_path_info_by_alias" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'alias' is set
        if self.api_client.client_side_validation and ('alias' not in params or
                                                       params['alias'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `alias` when calling `get_workflow_version_path_info_by_alias`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'alias' in params:
            path_params['alias'] = params['alias']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/aliases/workflow-versions/{alias}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='WorkflowVersionPathInfo',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
