# coding: utf-8

"""
    Dockstore API

    This describes the dockstore API, a webservice that manages pairs of Docker images and associated metadata such as CWL documents and Dockerfiles used to build those images. Explore swagger.json for a Swagger 2.0 description of our API and explore openapi.yaml for OpenAPI 3.0 descriptions.  # noqa: E501

    OpenAPI spec version: 1.12.0-alpha.1-SNAPSHOT
    Contact: theglobalalliance@genomicsandhealth.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from jgreenepack.api_client import ApiClient


class ContainersApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_test_parameter_files(self, container_id, test_parameter_paths, descriptor_type, **kwargs):  # noqa: E501
        """Add test parameter files to a tag.  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_test_parameter_files(container_id, test_parameter_paths, descriptor_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int container_id: Tool to modify. (required)
        :param list[str] test_parameter_paths: List of paths. (required)
        :param str descriptor_type: Descriptor Type (required)
        :param str body: This is here to appease Swagger. It requires PUT methods to have a body, even if it is empty. Please leave it empty.
        :param str tag_name:
        :return: list[SourceFile]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_test_parameter_files_with_http_info(container_id, test_parameter_paths, descriptor_type, **kwargs)  # noqa: E501
        else:
            (data) = self.add_test_parameter_files_with_http_info(container_id, test_parameter_paths, descriptor_type, **kwargs)  # noqa: E501
            return data

    def add_test_parameter_files_with_http_info(self, container_id, test_parameter_paths, descriptor_type, **kwargs):  # noqa: E501
        """Add test parameter files to a tag.  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_test_parameter_files_with_http_info(container_id, test_parameter_paths, descriptor_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int container_id: Tool to modify. (required)
        :param list[str] test_parameter_paths: List of paths. (required)
        :param str descriptor_type: Descriptor Type (required)
        :param str body: This is here to appease Swagger. It requires PUT methods to have a body, even if it is empty. Please leave it empty.
        :param str tag_name:
        :return: list[SourceFile]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['container_id', 'test_parameter_paths', 'descriptor_type', 'body', 'tag_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_test_parameter_files" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'container_id' is set
        if self.api_client.client_side_validation and ('container_id' not in params or
                                                       params['container_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `container_id` when calling `add_test_parameter_files`")  # noqa: E501
        # verify the required parameter 'test_parameter_paths' is set
        if self.api_client.client_side_validation and ('test_parameter_paths' not in params or
                                                       params['test_parameter_paths'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `test_parameter_paths` when calling `add_test_parameter_files`")  # noqa: E501
        # verify the required parameter 'descriptor_type' is set
        if self.api_client.client_side_validation and ('descriptor_type' not in params or
                                                       params['descriptor_type'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `descriptor_type` when calling `add_test_parameter_files`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'container_id' in params:
            path_params['containerId'] = params['container_id']  # noqa: E501

        query_params = []
        if 'test_parameter_paths' in params:
            query_params.append(('testParameterPaths', params['test_parameter_paths']))  # noqa: E501
            collection_formats['testParameterPaths'] = 'multi'  # noqa: E501
        if 'tag_name' in params:
            query_params.append(('tagName', params['tag_name']))  # noqa: E501
        if 'descriptor_type' in params:
            query_params.append(('descriptorType', params['descriptor_type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/containers/{containerId}/testParameterFiles', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[SourceFile]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def all_published_containers(self, **kwargs):  # noqa: E501
        """List all published tools.  # noqa: E501

        NO authentication  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.all_published_containers(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str offset: Start index of paging. Pagination results can be based on numbers or other values chosen by the registry implementor (for example, SHA values). If this exceeds the current result set return an empty set.  If not specified in the request, this will start at the beginning of the results.
        :param int limit: Amount of records to return in a given page, limited to 100
        :param str filter: Filter, this is a search string that filters the results.
        :param str sort_col: Sort column
        :param str sort_order: Sort order
        :return: list[DockstoreTool]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.all_published_containers_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.all_published_containers_with_http_info(**kwargs)  # noqa: E501
            return data

    def all_published_containers_with_http_info(self, **kwargs):  # noqa: E501
        """List all published tools.  # noqa: E501

        NO authentication  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.all_published_containers_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str offset: Start index of paging. Pagination results can be based on numbers or other values chosen by the registry implementor (for example, SHA values). If this exceeds the current result set return an empty set.  If not specified in the request, this will start at the beginning of the results.
        :param int limit: Amount of records to return in a given page, limited to 100
        :param str filter: Filter, this is a search string that filters the results.
        :param str sort_col: Sort column
        :param str sort_order: Sort order
        :return: list[DockstoreTool]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['offset', 'limit', 'filter', 'sort_col', 'sort_order']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method all_published_containers" % key
                )
            params[key] = val
        del params['kwargs']

        if self.api_client.client_side_validation and ('limit' in params and params['limit'] > 100):  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `all_published_containers`, must be a value less than or equal to `100`")  # noqa: E501
        if self.api_client.client_side_validation and ('limit' in params and params['limit'] < 1):  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `all_published_containers`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501
        if 'sort_col' in params:
            query_params.append(('sortCol', params['sort_col']))  # noqa: E501
        if 'sort_order' in params:
            query_params.append(('sortOrder', params['sort_order']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/containers/published', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[DockstoreTool]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_container(self, container_id, **kwargs):  # noqa: E501
        """Delete a tool.  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_container(container_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int container_id: Tool id to delete (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_container_with_http_info(container_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_container_with_http_info(container_id, **kwargs)  # noqa: E501
            return data

    def delete_container_with_http_info(self, container_id, **kwargs):  # noqa: E501
        """Delete a tool.  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_container_with_http_info(container_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int container_id: Tool id to delete (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['container_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_container" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'container_id' is set
        if self.api_client.client_side_validation and ('container_id' not in params or
                                                       params['container_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `container_id` when calling `delete_container`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'container_id' in params:
            path_params['containerId'] = params['container_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/containers/{containerId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_test_parameter_files(self, container_id, test_parameter_paths, descriptor_type, **kwargs):  # noqa: E501
        """Delete test parameter files to a tag.  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_test_parameter_files(container_id, test_parameter_paths, descriptor_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int container_id: Tool to modify. (required)
        :param list[str] test_parameter_paths: List of paths. (required)
        :param str descriptor_type: Descriptor Type (required)
        :param str tag_name:
        :return: list[SourceFile]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_test_parameter_files_with_http_info(container_id, test_parameter_paths, descriptor_type, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_test_parameter_files_with_http_info(container_id, test_parameter_paths, descriptor_type, **kwargs)  # noqa: E501
            return data

    def delete_test_parameter_files_with_http_info(self, container_id, test_parameter_paths, descriptor_type, **kwargs):  # noqa: E501
        """Delete test parameter files to a tag.  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_test_parameter_files_with_http_info(container_id, test_parameter_paths, descriptor_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int container_id: Tool to modify. (required)
        :param list[str] test_parameter_paths: List of paths. (required)
        :param str descriptor_type: Descriptor Type (required)
        :param str tag_name:
        :return: list[SourceFile]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['container_id', 'test_parameter_paths', 'descriptor_type', 'tag_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_test_parameter_files" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'container_id' is set
        if self.api_client.client_side_validation and ('container_id' not in params or
                                                       params['container_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `container_id` when calling `delete_test_parameter_files`")  # noqa: E501
        # verify the required parameter 'test_parameter_paths' is set
        if self.api_client.client_side_validation and ('test_parameter_paths' not in params or
                                                       params['test_parameter_paths'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `test_parameter_paths` when calling `delete_test_parameter_files`")  # noqa: E501
        # verify the required parameter 'descriptor_type' is set
        if self.api_client.client_side_validation and ('descriptor_type' not in params or
                                                       params['descriptor_type'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `descriptor_type` when calling `delete_test_parameter_files`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'container_id' in params:
            path_params['containerId'] = params['container_id']  # noqa: E501

        query_params = []
        if 'test_parameter_paths' in params:
            query_params.append(('testParameterPaths', params['test_parameter_paths']))  # noqa: E501
            collection_formats['testParameterPaths'] = 'multi'  # noqa: E501
        if 'tag_name' in params:
            query_params.append(('tagName', params['tag_name']))  # noqa: E501
        if 'descriptor_type' in params:
            query_params.append(('descriptorType', params['descriptor_type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/containers/{containerId}/testParameterFiles', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[SourceFile]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def dockerfile(self, container_id, **kwargs):  # noqa: E501
        """Get the corresponding Dockerfile.  # noqa: E501

        Does not require authentication for published tools, authentication can be provided for restricted tools  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.dockerfile(container_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int container_id: Tool id (required)
        :param str tag:
        :return: SourceFile
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.dockerfile_with_http_info(container_id, **kwargs)  # noqa: E501
        else:
            (data) = self.dockerfile_with_http_info(container_id, **kwargs)  # noqa: E501
            return data

    def dockerfile_with_http_info(self, container_id, **kwargs):  # noqa: E501
        """Get the corresponding Dockerfile.  # noqa: E501

        Does not require authentication for published tools, authentication can be provided for restricted tools  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.dockerfile_with_http_info(container_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int container_id: Tool id (required)
        :param str tag:
        :return: SourceFile
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['container_id', 'tag']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method dockerfile" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'container_id' is set
        if self.api_client.client_side_validation and ('container_id' not in params or
                                                       params['container_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `container_id` when calling `dockerfile`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'container_id' in params:
            path_params['containerId'] = params['container_id']  # noqa: E501

        query_params = []
        if 'tag' in params:
            query_params.append(('tag', params['tag']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/containers/{containerId}/dockerfile', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SourceFile',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_container(self, container_id, **kwargs):  # noqa: E501
        """Retrieve a tool.  # noqa: E501

        This is one of the few endpoints that returns the user object with populated properties (minus the userProfiles property)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_container(container_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int container_id: Tool ID (required)
        :param str include: Comma-delimited list of fields to include: validations
        :return: DockstoreTool
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_container_with_http_info(container_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_container_with_http_info(container_id, **kwargs)  # noqa: E501
            return data

    def get_container_with_http_info(self, container_id, **kwargs):  # noqa: E501
        """Retrieve a tool.  # noqa: E501

        This is one of the few endpoints that returns the user object with populated properties (minus the userProfiles property)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_container_with_http_info(container_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int container_id: Tool ID (required)
        :param str include: Comma-delimited list of fields to include: validations
        :return: DockstoreTool
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['container_id', 'include']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_container" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'container_id' is set
        if self.api_client.client_side_validation and ('container_id' not in params or
                                                       params['container_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `container_id` when calling `get_container`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'container_id' in params:
            path_params['containerId'] = params['container_id']  # noqa: E501

        query_params = []
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/containers/{containerId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DockstoreTool',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_container_by_path(self, repository, **kwargs):  # noqa: E501
        """Get a list of tools by path.  # noqa: E501

        Do not include tool name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_container_by_path(repository, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repository: repository path (required)
        :return: list[DockstoreTool]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_container_by_path_with_http_info(repository, **kwargs)  # noqa: E501
        else:
            (data) = self.get_container_by_path_with_http_info(repository, **kwargs)  # noqa: E501
            return data

    def get_container_by_path_with_http_info(self, repository, **kwargs):  # noqa: E501
        """Get a list of tools by path.  # noqa: E501

        Do not include tool name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_container_by_path_with_http_info(repository, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repository: repository path (required)
        :return: list[DockstoreTool]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['repository']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_container_by_path" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'repository' is set
        if self.api_client.client_side_validation and ('repository' not in params or
                                                       params['repository'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `repository` when calling `get_container_by_path`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'repository' in params:
            path_params['repository'] = params['repository']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/containers/path/{repository}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[DockstoreTool]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_container_by_tool_path(self, repository, **kwargs):  # noqa: E501
        """Get a tool by the specific tool path  # noqa: E501

        Requires full path (including tool name if applicable).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_container_by_tool_path(repository, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repository: repository path (required)
        :param str include: Comma-delimited list of fields to include: validations
        :return: DockstoreTool
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_container_by_tool_path_with_http_info(repository, **kwargs)  # noqa: E501
        else:
            (data) = self.get_container_by_tool_path_with_http_info(repository, **kwargs)  # noqa: E501
            return data

    def get_container_by_tool_path_with_http_info(self, repository, **kwargs):  # noqa: E501
        """Get a tool by the specific tool path  # noqa: E501

        Requires full path (including tool name if applicable).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_container_by_tool_path_with_http_info(repository, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repository: repository path (required)
        :param str include: Comma-delimited list of fields to include: validations
        :return: DockstoreTool
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['repository', 'include']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_container_by_tool_path" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'repository' is set
        if self.api_client.client_side_validation and ('repository' not in params or
                                                       params['repository'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `repository` when calling `get_container_by_tool_path`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'repository' in params:
            path_params['repository'] = params['repository']  # noqa: E501

        query_params = []
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/containers/path/tool/{repository}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DockstoreTool',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_published_container(self, container_id, **kwargs):  # noqa: E501
        """Get a published tool.  # noqa: E501

        NO authentication  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_published_container(container_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int container_id: Tool ID (required)
        :param str include: Comma-delimited list of fields to include: validations
        :return: DockstoreTool
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_published_container_with_http_info(container_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_published_container_with_http_info(container_id, **kwargs)  # noqa: E501
            return data

    def get_published_container_with_http_info(self, container_id, **kwargs):  # noqa: E501
        """Get a published tool.  # noqa: E501

        NO authentication  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_published_container_with_http_info(container_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int container_id: Tool ID (required)
        :param str include: Comma-delimited list of fields to include: validations
        :return: DockstoreTool
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['container_id', 'include']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_published_container" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'container_id' is set
        if self.api_client.client_side_validation and ('container_id' not in params or
                                                       params['container_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `container_id` when calling `get_published_container`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'container_id' in params:
            path_params['containerId'] = params['container_id']  # noqa: E501

        query_params = []
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/containers/published/{containerId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DockstoreTool',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_published_container_by_path(self, repository, **kwargs):  # noqa: E501
        """Get a list of published tools by path.  # noqa: E501

        NO authentication. Do not include tool name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_published_container_by_path(repository, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repository: repository path (required)
        :return: list[DockstoreTool]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_published_container_by_path_with_http_info(repository, **kwargs)  # noqa: E501
        else:
            (data) = self.get_published_container_by_path_with_http_info(repository, **kwargs)  # noqa: E501
            return data

    def get_published_container_by_path_with_http_info(self, repository, **kwargs):  # noqa: E501
        """Get a list of published tools by path.  # noqa: E501

        NO authentication. Do not include tool name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_published_container_by_path_with_http_info(repository, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repository: repository path (required)
        :return: list[DockstoreTool]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['repository']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_published_container_by_path" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'repository' is set
        if self.api_client.client_side_validation and ('repository' not in params or
                                                       params['repository'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `repository` when calling `get_published_container_by_path`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'repository' in params:
            path_params['repository'] = params['repository']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/containers/path/{repository}/published', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[DockstoreTool]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_published_container_by_tool_path(self, repository, **kwargs):  # noqa: E501
        """Get a published tool by the specific tool path.  # noqa: E501

        Requires full path (including tool name if applicable).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_published_container_by_tool_path(repository, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repository: repository path (required)
        :param str include: Comma-delimited list of fields to include: validations
        :return: DockstoreTool
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_published_container_by_tool_path_with_http_info(repository, **kwargs)  # noqa: E501
        else:
            (data) = self.get_published_container_by_tool_path_with_http_info(repository, **kwargs)  # noqa: E501
            return data

    def get_published_container_by_tool_path_with_http_info(self, repository, **kwargs):  # noqa: E501
        """Get a published tool by the specific tool path.  # noqa: E501

        Requires full path (including tool name if applicable).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_published_container_by_tool_path_with_http_info(repository, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repository: repository path (required)
        :param str include: Comma-delimited list of fields to include: validations
        :return: DockstoreTool
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['repository', 'include']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_published_container_by_tool_path" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'repository' is set
        if self.api_client.client_side_validation and ('repository' not in params or
                                                       params['repository'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `repository` when calling `get_published_container_by_tool_path`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'repository' in params:
            path_params['repository'] = params['repository']  # noqa: E501

        query_params = []
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/containers/path/tool/{repository}/published', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DockstoreTool',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_published_container_schema(self, container_id, **kwargs):  # noqa: E501
        """Get a published tool's schema by ID.  # noqa: E501

        NO authentication  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_published_container_schema(container_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int container_id: Tool ID (required)
        :return: list[list[object]]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_published_container_schema_with_http_info(container_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_published_container_schema_with_http_info(container_id, **kwargs)  # noqa: E501
            return data

    def get_published_container_schema_with_http_info(self, container_id, **kwargs):  # noqa: E501
        """Get a published tool's schema by ID.  # noqa: E501

        NO authentication  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_published_container_schema_with_http_info(container_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int container_id: Tool ID (required)
        :return: list[list[object]]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['container_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_published_container_schema" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'container_id' is set
        if self.api_client.client_side_validation and ('container_id' not in params or
                                                       params['container_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `container_id` when calling `get_published_container_schema`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'container_id' in params:
            path_params['containerId'] = params['container_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/containers/schema/{containerId}/published', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[list[object]]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_published_containers_by_namespace(self, namespace, **kwargs):  # noqa: E501
        """List all published tools belonging to the specified namespace.  # noqa: E501

        NO authentication  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_published_containers_by_namespace(namespace, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str namespace: namespace (required)
        :return: list[DockstoreTool]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_published_containers_by_namespace_with_http_info(namespace, **kwargs)  # noqa: E501
        else:
            (data) = self.get_published_containers_by_namespace_with_http_info(namespace, **kwargs)  # noqa: E501
            return data

    def get_published_containers_by_namespace_with_http_info(self, namespace, **kwargs):  # noqa: E501
        """List all published tools belonging to the specified namespace.  # noqa: E501

        NO authentication  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_published_containers_by_namespace_with_http_info(namespace, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str namespace: namespace (required)
        :return: list[DockstoreTool]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['namespace']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_published_containers_by_namespace" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'namespace' is set
        if self.api_client.client_side_validation and ('namespace' not in params or
                                                       params['namespace'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `namespace` when calling `get_published_containers_by_namespace`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'namespace' in params:
            path_params['namespace'] = params['namespace']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/containers/namespace/{namespace}/published', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[DockstoreTool]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_starred_users(self, container_id, **kwargs):  # noqa: E501
        """Returns list of users who starred a tool.  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_starred_users(container_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int container_id: Tool to grab starred users for. (required)
        :return: list[User]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_starred_users_with_http_info(container_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_starred_users_with_http_info(container_id, **kwargs)  # noqa: E501
            return data

    def get_starred_users_with_http_info(self, container_id, **kwargs):  # noqa: E501
        """Returns list of users who starred a tool.  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_starred_users_with_http_info(container_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int container_id: Tool to grab starred users for. (required)
        :return: list[User]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['container_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_starred_users" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'container_id' is set
        if self.api_client.client_side_validation and ('container_id' not in params or
                                                       params['container_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `container_id` when calling `get_starred_users`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'container_id' in params:
            path_params['containerId'] = params['container_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/containers/{containerId}/starredUsers', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[User]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_test_parameter_files(self, container_id, descriptor_type, **kwargs):  # noqa: E501
        """Get the corresponding test parameter files.  # noqa: E501

        Does not require authentication for published tools, authentication can be provided for restricted tools  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_test_parameter_files(container_id, descriptor_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int container_id: Tool id (required)
        :param str descriptor_type: Descriptor Type (required)
        :param str tag:
        :return: list[SourceFile]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_test_parameter_files_with_http_info(container_id, descriptor_type, **kwargs)  # noqa: E501
        else:
            (data) = self.get_test_parameter_files_with_http_info(container_id, descriptor_type, **kwargs)  # noqa: E501
            return data

    def get_test_parameter_files_with_http_info(self, container_id, descriptor_type, **kwargs):  # noqa: E501
        """Get the corresponding test parameter files.  # noqa: E501

        Does not require authentication for published tools, authentication can be provided for restricted tools  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_test_parameter_files_with_http_info(container_id, descriptor_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int container_id: Tool id (required)
        :param str descriptor_type: Descriptor Type (required)
        :param str tag:
        :return: list[SourceFile]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['container_id', 'descriptor_type', 'tag']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_test_parameter_files" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'container_id' is set
        if self.api_client.client_side_validation and ('container_id' not in params or
                                                       params['container_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `container_id` when calling `get_test_parameter_files`")  # noqa: E501
        # verify the required parameter 'descriptor_type' is set
        if self.api_client.client_side_validation and ('descriptor_type' not in params or
                                                       params['descriptor_type'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `descriptor_type` when calling `get_test_parameter_files`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'container_id' in params:
            path_params['containerId'] = params['container_id']  # noqa: E501

        query_params = []
        if 'tag' in params:
            query_params.append(('tag', params['tag']))  # noqa: E501
        if 'descriptor_type' in params:
            query_params.append(('descriptorType', params['descriptor_type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/containers/{containerId}/testParameterFiles', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[SourceFile]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_tool_by_alias(self, alias, **kwargs):  # noqa: E501
        """Retrieves a tool by alias.  # noqa: E501

        Does not require authentication for published tools, authentication can be provided for restricted tools  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tool_by_alias(alias, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str alias: Alias (required)
        :return: DockstoreTool
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_tool_by_alias_with_http_info(alias, **kwargs)  # noqa: E501
        else:
            (data) = self.get_tool_by_alias_with_http_info(alias, **kwargs)  # noqa: E501
            return data

    def get_tool_by_alias_with_http_info(self, alias, **kwargs):  # noqa: E501
        """Retrieves a tool by alias.  # noqa: E501

        Does not require authentication for published tools, authentication can be provided for restricted tools  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tool_by_alias_with_http_info(alias, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str alias: Alias (required)
        :return: DockstoreTool
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['alias']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_tool_by_alias" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'alias' is set
        if self.api_client.client_side_validation and ('alias' not in params or
                                                       params['alias'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `alias` when calling `get_tool_by_alias`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'alias' in params:
            path_params['alias'] = params['alias']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/containers/{alias}/aliases', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DockstoreTool',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_tool_zip(self, tool_id, tag_id, **kwargs):  # noqa: E501
        """Download a ZIP file of a tool and all associated files.  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tool_zip(tool_id, tag_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int tool_id: toolId (required)
        :param int tag_id: tagId (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_tool_zip_with_http_info(tool_id, tag_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_tool_zip_with_http_info(tool_id, tag_id, **kwargs)  # noqa: E501
            return data

    def get_tool_zip_with_http_info(self, tool_id, tag_id, **kwargs):  # noqa: E501
        """Download a ZIP file of a tool and all associated files.  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tool_zip_with_http_info(tool_id, tag_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int tool_id: toolId (required)
        :param int tag_id: tagId (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['tool_id', 'tag_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_tool_zip" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'tool_id' is set
        if self.api_client.client_side_validation and ('tool_id' not in params or
                                                       params['tool_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `tool_id` when calling `get_tool_zip`")  # noqa: E501
        # verify the required parameter 'tag_id' is set
        if self.api_client.client_side_validation and ('tag_id' not in params or
                                                       params['tag_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `tag_id` when calling `get_tool_zip`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tool_id' in params:
            path_params['toolId'] = params['tool_id']  # noqa: E501
        if 'tag_id' in params:
            path_params['tagId'] = params['tag_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/zip'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/containers/{toolId}/zip/{tagId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_users(self, container_id, **kwargs):  # noqa: E501
        """Get users of a tool.  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_users(container_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int container_id: Tool ID (required)
        :return: list[User]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_users_with_http_info(container_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_users_with_http_info(container_id, **kwargs)  # noqa: E501
            return data

    def get_users_with_http_info(self, container_id, **kwargs):  # noqa: E501
        """Get users of a tool.  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_users_with_http_info(container_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int container_id: Tool ID (required)
        :return: list[User]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['container_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_users" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'container_id' is set
        if self.api_client.client_side_validation and ('container_id' not in params or
                                                       params['container_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `container_id` when calling `get_users`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'container_id' in params:
            path_params['containerId'] = params['container_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/containers/{containerId}/users', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[User]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def primary_descriptor(self, container_id, **kwargs):  # noqa: E501
        """Get the primary descriptor file.  # noqa: E501

        Does not require authentication for published tools, authentication can be provided for restricted tools  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.primary_descriptor(container_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int container_id: Tool id (required)
        :param str tag:
        :param str language:
        :return: SourceFile
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.primary_descriptor_with_http_info(container_id, **kwargs)  # noqa: E501
        else:
            (data) = self.primary_descriptor_with_http_info(container_id, **kwargs)  # noqa: E501
            return data

    def primary_descriptor_with_http_info(self, container_id, **kwargs):  # noqa: E501
        """Get the primary descriptor file.  # noqa: E501

        Does not require authentication for published tools, authentication can be provided for restricted tools  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.primary_descriptor_with_http_info(container_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int container_id: Tool id (required)
        :param str tag:
        :param str language:
        :return: SourceFile
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['container_id', 'tag', 'language']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method primary_descriptor" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'container_id' is set
        if self.api_client.client_side_validation and ('container_id' not in params or
                                                       params['container_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `container_id` when calling `primary_descriptor`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'container_id' in params:
            path_params['containerId'] = params['container_id']  # noqa: E501

        query_params = []
        if 'tag' in params:
            query_params.append(('tag', params['tag']))  # noqa: E501
        if 'language' in params:
            query_params.append(('language', params['language']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/containers/{containerId}/primaryDescriptor', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SourceFile',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def publish(self, container_id, body, **kwargs):  # noqa: E501
        """Publish or unpublish a tool.  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.publish(container_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int container_id: Tool id to publish (required)
        :param PublishRequest body: PublishRequest to refresh the list of repos for a user (required)
        :return: DockstoreTool
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.publish_with_http_info(container_id, body, **kwargs)  # noqa: E501
        else:
            (data) = self.publish_with_http_info(container_id, body, **kwargs)  # noqa: E501
            return data

    def publish_with_http_info(self, container_id, body, **kwargs):  # noqa: E501
        """Publish or unpublish a tool.  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.publish_with_http_info(container_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int container_id: Tool id to publish (required)
        :param PublishRequest body: PublishRequest to refresh the list of repos for a user (required)
        :return: DockstoreTool
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['container_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method publish" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'container_id' is set
        if self.api_client.client_side_validation and ('container_id' not in params or
                                                       params['container_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `container_id` when calling `publish`")  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `publish`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'container_id' in params:
            path_params['containerId'] = params['container_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/containers/{containerId}/publish', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DockstoreTool',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def refresh(self, container_id, **kwargs):  # noqa: E501
        """Refresh one particular tool.  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.refresh(container_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int container_id: Tool ID (required)
        :return: DockstoreTool
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.refresh_with_http_info(container_id, **kwargs)  # noqa: E501
        else:
            (data) = self.refresh_with_http_info(container_id, **kwargs)  # noqa: E501
            return data

    def refresh_with_http_info(self, container_id, **kwargs):  # noqa: E501
        """Refresh one particular tool.  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.refresh_with_http_info(container_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int container_id: Tool ID (required)
        :return: DockstoreTool
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['container_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method refresh" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'container_id' is set
        if self.api_client.client_side_validation and ('container_id' not in params or
                                                       params['container_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `container_id` when calling `refresh`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'container_id' in params:
            path_params['containerId'] = params['container_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/containers/{containerId}/refresh', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DockstoreTool',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def register_manual(self, body, **kwargs):  # noqa: E501
        """Register a tool manually, along with tags.  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.register_manual(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DockstoreTool body: Tool to be registered (required)
        :return: DockstoreTool
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.register_manual_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.register_manual_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def register_manual_with_http_info(self, body, **kwargs):  # noqa: E501
        """Register a tool manually, along with tags.  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.register_manual_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param DockstoreTool body: Tool to be registered (required)
        :return: DockstoreTool
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method register_manual" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `register_manual`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/containers/registerManual', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DockstoreTool',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def secondary_descriptor_path(self, container_id, relative_path, **kwargs):  # noqa: E501
        """Get the corresponding descriptor file.  # noqa: E501

        Does not require authentication for published tools, authentication can be provided for restricted tools  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.secondary_descriptor_path(container_id, relative_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int container_id: Tool id (required)
        :param str relative_path: (required)
        :param str tag:
        :param str language:
        :return: SourceFile
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.secondary_descriptor_path_with_http_info(container_id, relative_path, **kwargs)  # noqa: E501
        else:
            (data) = self.secondary_descriptor_path_with_http_info(container_id, relative_path, **kwargs)  # noqa: E501
            return data

    def secondary_descriptor_path_with_http_info(self, container_id, relative_path, **kwargs):  # noqa: E501
        """Get the corresponding descriptor file.  # noqa: E501

        Does not require authentication for published tools, authentication can be provided for restricted tools  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.secondary_descriptor_path_with_http_info(container_id, relative_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int container_id: Tool id (required)
        :param str relative_path: (required)
        :param str tag:
        :param str language:
        :return: SourceFile
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['container_id', 'relative_path', 'tag', 'language']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method secondary_descriptor_path" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'container_id' is set
        if self.api_client.client_side_validation and ('container_id' not in params or
                                                       params['container_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `container_id` when calling `secondary_descriptor_path`")  # noqa: E501
        # verify the required parameter 'relative_path' is set
        if self.api_client.client_side_validation and ('relative_path' not in params or
                                                       params['relative_path'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `relative_path` when calling `secondary_descriptor_path`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'container_id' in params:
            path_params['containerId'] = params['container_id']  # noqa: E501
        if 'relative_path' in params:
            path_params['relative-path'] = params['relative_path']  # noqa: E501

        query_params = []
        if 'tag' in params:
            query_params.append(('tag', params['tag']))  # noqa: E501
        if 'language' in params:
            query_params.append(('language', params['language']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/containers/{containerId}/descriptor/{relative-path}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SourceFile',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def secondary_descriptors(self, container_id, **kwargs):  # noqa: E501
        """Get a list of secondary descriptor files.  # noqa: E501

        Does not require authentication for published tools, authentication can be provided for restricted tools  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.secondary_descriptors(container_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int container_id: Tool id (required)
        :param str tag:
        :param str language:
        :return: list[SourceFile]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.secondary_descriptors_with_http_info(container_id, **kwargs)  # noqa: E501
        else:
            (data) = self.secondary_descriptors_with_http_info(container_id, **kwargs)  # noqa: E501
            return data

    def secondary_descriptors_with_http_info(self, container_id, **kwargs):  # noqa: E501
        """Get a list of secondary descriptor files.  # noqa: E501

        Does not require authentication for published tools, authentication can be provided for restricted tools  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.secondary_descriptors_with_http_info(container_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int container_id: Tool id (required)
        :param str tag:
        :param str language:
        :return: list[SourceFile]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['container_id', 'tag', 'language']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method secondary_descriptors" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'container_id' is set
        if self.api_client.client_side_validation and ('container_id' not in params or
                                                       params['container_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `container_id` when calling `secondary_descriptors`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'container_id' in params:
            path_params['containerId'] = params['container_id']  # noqa: E501

        query_params = []
        if 'tag' in params:
            query_params.append(('tag', params['tag']))  # noqa: E501
        if 'language' in params:
            query_params.append(('language', params['language']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/containers/{containerId}/secondaryDescriptors', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[SourceFile]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def star_entry(self, container_id, body, **kwargs):  # noqa: E501
        """Star a tool.  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.star_entry(container_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int container_id: Tool to star. (required)
        :param StarRequest body: StarRequest to star a repo for a user (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.star_entry_with_http_info(container_id, body, **kwargs)  # noqa: E501
        else:
            (data) = self.star_entry_with_http_info(container_id, body, **kwargs)  # noqa: E501
            return data

    def star_entry_with_http_info(self, container_id, body, **kwargs):  # noqa: E501
        """Star a tool.  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.star_entry_with_http_info(container_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int container_id: Tool to star. (required)
        :param StarRequest body: StarRequest to star a repo for a user (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['container_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method star_entry" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'container_id' is set
        if self.api_client.client_side_validation and ('container_id' not in params or
                                                       params['container_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `container_id` when calling `star_entry`")  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `star_entry`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'container_id' in params:
            path_params['containerId'] = params['container_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/containers/{containerId}/star', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_container(self, container_id, body, **kwargs):  # noqa: E501
        """Update the tool with the given tool.  # noqa: E501

        Updates default descriptor paths, default Dockerfile paths, default test parameter paths, git url, and default version. Also updates tool maintainer email, and private access for manual tools.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_container(container_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int container_id: Tool to modify. (required)
        :param DockstoreTool body: Tool with updated information (required)
        :return: DockstoreTool
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_container_with_http_info(container_id, body, **kwargs)  # noqa: E501
        else:
            (data) = self.update_container_with_http_info(container_id, body, **kwargs)  # noqa: E501
            return data

    def update_container_with_http_info(self, container_id, body, **kwargs):  # noqa: E501
        """Update the tool with the given tool.  # noqa: E501

        Updates default descriptor paths, default Dockerfile paths, default test parameter paths, git url, and default version. Also updates tool maintainer email, and private access for manual tools.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_container_with_http_info(container_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int container_id: Tool to modify. (required)
        :param DockstoreTool body: Tool with updated information (required)
        :return: DockstoreTool
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['container_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_container" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'container_id' is set
        if self.api_client.client_side_validation and ('container_id' not in params or
                                                       params['container_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `container_id` when calling `update_container`")  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `update_container`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'container_id' in params:
            path_params['containerId'] = params['container_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/containers/{containerId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DockstoreTool',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_labels(self, container_id, labels, **kwargs):  # noqa: E501
        """Update the labels linked to a tool.  # noqa: E501

        Labels are alphanumerical (case-insensitive and may contain internal hyphens), given in a comma-delimited list.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_labels(container_id, labels, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int container_id: Tool to modify. (required)
        :param str labels: Comma-delimited list of labels. (required)
        :param str body: This is here to appease Swagger. It requires PUT methods to have a body, even if it is empty. Please leave it empty.
        :return: DockstoreTool
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_labels_with_http_info(container_id, labels, **kwargs)  # noqa: E501
        else:
            (data) = self.update_labels_with_http_info(container_id, labels, **kwargs)  # noqa: E501
            return data

    def update_labels_with_http_info(self, container_id, labels, **kwargs):  # noqa: E501
        """Update the labels linked to a tool.  # noqa: E501

        Labels are alphanumerical (case-insensitive and may contain internal hyphens), given in a comma-delimited list.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_labels_with_http_info(container_id, labels, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int container_id: Tool to modify. (required)
        :param str labels: Comma-delimited list of labels. (required)
        :param str body: This is here to appease Swagger. It requires PUT methods to have a body, even if it is empty. Please leave it empty.
        :return: DockstoreTool
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['container_id', 'labels', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_labels" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'container_id' is set
        if self.api_client.client_side_validation and ('container_id' not in params or
                                                       params['container_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `container_id` when calling `update_labels`")  # noqa: E501
        # verify the required parameter 'labels' is set
        if self.api_client.client_side_validation and ('labels' not in params or
                                                       params['labels'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `labels` when calling `update_labels`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'container_id' in params:
            path_params['containerId'] = params['container_id']  # noqa: E501

        query_params = []
        if 'labels' in params:
            query_params.append(('labels', params['labels']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/containers/{containerId}/labels', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DockstoreTool',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_tag_container_path(self, container_id, body, **kwargs):  # noqa: E501
        """Change the tool paths.  # noqa: E501

        Resets the descriptor paths and dockerfile path of all versions to match the default paths from the tool object passed.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_tag_container_path(container_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int container_id: Tool to modify. (required)
        :param DockstoreTool body: Tool with updated information (required)
        :return: DockstoreTool
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_tag_container_path_with_http_info(container_id, body, **kwargs)  # noqa: E501
        else:
            (data) = self.update_tag_container_path_with_http_info(container_id, body, **kwargs)  # noqa: E501
            return data

    def update_tag_container_path_with_http_info(self, container_id, body, **kwargs):  # noqa: E501
        """Change the tool paths.  # noqa: E501

        Resets the descriptor paths and dockerfile path of all versions to match the default paths from the tool object passed.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_tag_container_path_with_http_info(container_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int container_id: Tool to modify. (required)
        :param DockstoreTool body: Tool with updated information (required)
        :return: DockstoreTool
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['container_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_tag_container_path" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'container_id' is set
        if self.api_client.client_side_validation and ('container_id' not in params or
                                                       params['container_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `container_id` when calling `update_tag_container_path`")  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `update_tag_container_path`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'container_id' in params:
            path_params['containerId'] = params['container_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/containers/{containerId}/updateTagPaths', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DockstoreTool',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_tool_default_version(self, tool_id, body, **kwargs):  # noqa: E501
        """Update the default version of the given tool.  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_tool_default_version(tool_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int tool_id: Tool to modify. (required)
        :param str body: Tag name to set as default. (required)
        :return: DockstoreTool
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_tool_default_version_with_http_info(tool_id, body, **kwargs)  # noqa: E501
        else:
            (data) = self.update_tool_default_version_with_http_info(tool_id, body, **kwargs)  # noqa: E501
            return data

    def update_tool_default_version_with_http_info(self, tool_id, body, **kwargs):  # noqa: E501
        """Update the default version of the given tool.  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_tool_default_version_with_http_info(tool_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int tool_id: Tool to modify. (required)
        :param str body: Tag name to set as default. (required)
        :return: DockstoreTool
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['tool_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_tool_default_version" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'tool_id' is set
        if self.api_client.client_side_validation and ('tool_id' not in params or
                                                       params['tool_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `tool_id` when calling `update_tool_default_version`")  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `update_tool_default_version`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'tool_id' in params:
            path_params['toolId'] = params['tool_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/containers/{toolId}/defaultVersion', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DockstoreTool',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
