# coding: utf-8

"""
    Dockstore API

    This describes the dockstore API, a webservice that manages pairs of Docker images and associated metadata such as CWL documents and Dockerfiles used to build those images. Explore swagger.json for a Swagger 2.0 description of our API and explore openapi.yaml for OpenAPI 3.0 descriptions.  # noqa: E501

    OpenAPI spec version: 1.12.0-alpha.1-SNAPSHOT
    Contact: theglobalalliance@genomicsandhealth.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from jgreenepack.api_client import ApiClient


class EntriesApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_aliases(self, id, aliases, **kwargs):  # noqa: E501
        """Add aliases linked to a entry in Dockstore.  # noqa: E501

        Aliases are alphanumerical (case-insensitive and may contain internal hyphens), given in a comma-delimited list.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_aliases(id, aliases, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Entry to modify. (required)
        :param str aliases: Comma-delimited list of aliases. (required)
        :return: Entry
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_aliases_with_http_info(id, aliases, **kwargs)  # noqa: E501
        else:
            (data) = self.add_aliases_with_http_info(id, aliases, **kwargs)  # noqa: E501
            return data

    def add_aliases_with_http_info(self, id, aliases, **kwargs):  # noqa: E501
        """Add aliases linked to a entry in Dockstore.  # noqa: E501

        Aliases are alphanumerical (case-insensitive and may contain internal hyphens), given in a comma-delimited list.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_aliases_with_http_info(id, aliases, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Entry to modify. (required)
        :param str aliases: Comma-delimited list of aliases. (required)
        :return: Entry
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'aliases']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_aliases" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in params or
                                                       params['id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `id` when calling `add_aliases`")  # noqa: E501
        # verify the required parameter 'aliases' is set
        if self.api_client.client_side_validation and ('aliases' not in params or
                                                       params['aliases'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `aliases` when calling `add_aliases`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'aliases' in params:
            query_params.append(('aliases', params['aliases']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/entries/{id}/aliases', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Entry',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def calculate_description_metrics(self, entry_id, version_id, **kwargs):  # noqa: E501
        """Retrieve metrics on the description of an entry  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.calculate_description_metrics(entry_id, version_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int entry_id: (required)
        :param int version_id: (required)
        :param User body:
        :return: DescriptionMetrics
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.calculate_description_metrics_with_http_info(entry_id, version_id, **kwargs)  # noqa: E501
        else:
            (data) = self.calculate_description_metrics_with_http_info(entry_id, version_id, **kwargs)  # noqa: E501
            return data

    def calculate_description_metrics_with_http_info(self, entry_id, version_id, **kwargs):  # noqa: E501
        """Retrieve metrics on the description of an entry  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.calculate_description_metrics_with_http_info(entry_id, version_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int entry_id: (required)
        :param int version_id: (required)
        :param User body:
        :return: DescriptionMetrics
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['entry_id', 'version_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method calculate_description_metrics" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'entry_id' is set
        if self.api_client.client_side_validation and ('entry_id' not in params or
                                                       params['entry_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `entry_id` when calling `calculate_description_metrics`")  # noqa: E501
        # verify the required parameter 'version_id' is set
        if self.api_client.client_side_validation and ('version_id' not in params or
                                                       params['version_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `version_id` when calling `calculate_description_metrics`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'entry_id' in params:
            path_params['entryId'] = params['entry_id']  # noqa: E501
        if 'version_id' in params:
            path_params['versionId'] = params['version_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/entries/{entryId}/versions/{versionId}/descriptionMetrics', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DescriptionMetrics',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def entry_collections(self, id, **kwargs):  # noqa: E501
        """Get the collections and organizations that contain the published entry  # noqa: E501

        Entry must be published  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.entry_collections(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: id (required)
        :return: list[CollectionOrganization]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.entry_collections_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.entry_collections_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def entry_collections_with_http_info(self, id, **kwargs):  # noqa: E501
        """Get the collections and organizations that contain the published entry  # noqa: E501

        Entry must be published  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.entry_collections_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: id (required)
        :return: list[CollectionOrganization]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method entry_collections" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in params or
                                                       params['id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `id` when calling `entry_collections`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/entries/{id}/collections', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[CollectionOrganization]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def set_discourse_topic(self, id, **kwargs):  # noqa: E501
        """Create a discourse topic for an entry.  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_discourse_topic(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: The id of the entry to add a topic to. (required)
        :return: Entry
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.set_discourse_topic_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.set_discourse_topic_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def set_discourse_topic_with_http_info(self, id, **kwargs):  # noqa: E501
        """Create a discourse topic for an entry.  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_discourse_topic_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: The id of the entry to add a topic to. (required)
        :return: Entry
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_discourse_topic" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in params or
                                                       params['id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `id` when calling `set_discourse_topic`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/entries/{id}/topic', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Entry',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
