# coding: utf-8

"""
    Dockstore API

    This describes the dockstore API, a webservice that manages pairs of Docker images and associated metadata such as CWL documents and Dockerfiles used to build those images. Explore swagger.json for a Swagger 2.0 description of our API and explore openapi.yaml for OpenAPI 3.0 descriptions.  # noqa: E501

    OpenAPI spec version: 1.12.0-alpha.1-SNAPSHOT
    Contact: theglobalalliance@genomicsandhealth.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from jgreenepack.api_client import ApiClient


class ExtendedGA4GHApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def entries_org_get(self, organization, **kwargs):  # noqa: E501
        """List entries of an organization  # noqa: E501

        This endpoint returns entries of an organization.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.entries_org_get(organization, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str organization: An organization, for example `cancercollaboratory` (required)
        :return: list[ToolV1]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.entries_org_get_with_http_info(organization, **kwargs)  # noqa: E501
        else:
            (data) = self.entries_org_get_with_http_info(organization, **kwargs)  # noqa: E501
            return data

    def entries_org_get_with_http_info(self, organization, **kwargs):  # noqa: E501
        """List entries of an organization  # noqa: E501

        This endpoint returns entries of an organization.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.entries_org_get_with_http_info(organization, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str organization: An organization, for example `cancercollaboratory` (required)
        :return: list[ToolV1]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['organization']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method entries_org_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'organization' is set
        if self.api_client.client_side_validation and ('organization' not in params or
                                                       params['organization'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `organization` when calling `entries_org_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization' in params:
            path_params['organization'] = params['organization']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/ga4gh/v2/extended/containers/{organization}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ToolV1]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def entries_orgs_get(self, **kwargs):  # noqa: E501
        """List all organizations  # noqa: E501

        This endpoint returns list of all organizations.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.entries_orgs_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[str]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.entries_orgs_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.entries_orgs_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def entries_orgs_get_with_http_info(self, **kwargs):  # noqa: E501
        """List all organizations  # noqa: E501

        This endpoint returns list of all organizations.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.entries_orgs_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[str]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method entries_orgs_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/ga4gh/v2/extended/organizations', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[str]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def tools_id_versions_version_id_type_tests_post(self, type, id, version_id, relative_path, platform, platform_version, metadata, **kwargs):  # noqa: E501
        """Annotate test JSON with information on whether it ran successfully on particular platforms plus metadata  # noqa: E501

        Test JSON can be annotated with whether they ran correctly keyed by platform and associated with some metadata.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.tools_id_versions_version_id_type_tests_post(type, id, version_id, relative_path, platform, platform_version, metadata, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str type: The type of the underlying descriptor. Allowable values include \"CWL\", \"WDL\", \"NFL\". (required)
        :param str id: A unique identifier of the tool, scoped to this registry, for example `123456` (required)
        :param str version_id: An identifier of the tool version for this particular tool registry, for example `v1` (required)
        :param str relative_path: A relative path to the test json as retrieved from the files endpoint or the tests endpoint (required)
        :param str platform: Platform to report on (required)
        :param str platform_version: Version of the platform to report on (required)
        :param str metadata: Additional information on the verification (notes, explanation) (required)
        :param bool verified: Verification status, omit to delete key
        :return: dict(str, object)
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.tools_id_versions_version_id_type_tests_post_with_http_info(type, id, version_id, relative_path, platform, platform_version, metadata, **kwargs)  # noqa: E501
        else:
            (data) = self.tools_id_versions_version_id_type_tests_post_with_http_info(type, id, version_id, relative_path, platform, platform_version, metadata, **kwargs)  # noqa: E501
            return data

    def tools_id_versions_version_id_type_tests_post_with_http_info(self, type, id, version_id, relative_path, platform, platform_version, metadata, **kwargs):  # noqa: E501
        """Annotate test JSON with information on whether it ran successfully on particular platforms plus metadata  # noqa: E501

        Test JSON can be annotated with whether they ran correctly keyed by platform and associated with some metadata.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.tools_id_versions_version_id_type_tests_post_with_http_info(type, id, version_id, relative_path, platform, platform_version, metadata, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str type: The type of the underlying descriptor. Allowable values include \"CWL\", \"WDL\", \"NFL\". (required)
        :param str id: A unique identifier of the tool, scoped to this registry, for example `123456` (required)
        :param str version_id: An identifier of the tool version for this particular tool registry, for example `v1` (required)
        :param str relative_path: A relative path to the test json as retrieved from the files endpoint or the tests endpoint (required)
        :param str platform: Platform to report on (required)
        :param str platform_version: Version of the platform to report on (required)
        :param str metadata: Additional information on the verification (notes, explanation) (required)
        :param bool verified: Verification status, omit to delete key
        :return: dict(str, object)
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['type', 'id', 'version_id', 'relative_path', 'platform', 'platform_version', 'metadata', 'verified']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method tools_id_versions_version_id_type_tests_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'type' is set
        if self.api_client.client_side_validation and ('type' not in params or
                                                       params['type'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `type` when calling `tools_id_versions_version_id_type_tests_post`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in params or
                                                       params['id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `id` when calling `tools_id_versions_version_id_type_tests_post`")  # noqa: E501
        # verify the required parameter 'version_id' is set
        if self.api_client.client_side_validation and ('version_id' not in params or
                                                       params['version_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `version_id` when calling `tools_id_versions_version_id_type_tests_post`")  # noqa: E501
        # verify the required parameter 'relative_path' is set
        if self.api_client.client_side_validation and ('relative_path' not in params or
                                                       params['relative_path'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `relative_path` when calling `tools_id_versions_version_id_type_tests_post`")  # noqa: E501
        # verify the required parameter 'platform' is set
        if self.api_client.client_side_validation and ('platform' not in params or
                                                       params['platform'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `platform` when calling `tools_id_versions_version_id_type_tests_post`")  # noqa: E501
        # verify the required parameter 'platform_version' is set
        if self.api_client.client_side_validation and ('platform_version' not in params or
                                                       params['platform_version'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `platform_version` when calling `tools_id_versions_version_id_type_tests_post`")  # noqa: E501
        # verify the required parameter 'metadata' is set
        if self.api_client.client_side_validation and ('metadata' not in params or
                                                       params['metadata'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `metadata` when calling `tools_id_versions_version_id_type_tests_post`")  # noqa: E501

        if self.api_client.client_side_validation and ('relative_path' in params and not re.search(r'.+', params['relative_path'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `relative_path` when calling `tools_id_versions_version_id_type_tests_post`, must conform to the pattern `/.+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'type' in params:
            path_params['type'] = params['type']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501
        if 'version_id' in params:
            path_params['version_id'] = params['version_id']  # noqa: E501
        if 'relative_path' in params:
            path_params['relative_path'] = params['relative_path']  # noqa: E501

        query_params = []
        if 'platform' in params:
            query_params.append(('platform', params['platform']))  # noqa: E501
        if 'platform_version' in params:
            query_params.append(('platform_version', params['platform_version']))  # noqa: E501
        if 'verified' in params:
            query_params.append(('verified', params['verified']))  # noqa: E501
        if 'metadata' in params:
            query_params.append(('metadata', params['metadata']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/api/ga4gh/v2/extended/{id}/versions/{version_id}/{type}/tests/{relative_path}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='dict(str, object)',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def tools_index_get(self, **kwargs):  # noqa: E501
        """Update the workflows and tools indices  # noqa: E501

        This endpoint updates the indices for all published tools and workflows.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.tools_index_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.tools_index_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.tools_index_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def tools_index_get_with_http_info(self, **kwargs):  # noqa: E501
        """Update the workflows and tools indices  # noqa: E501

        This endpoint updates the indices for all published tools and workflows.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.tools_index_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method tools_index_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/api/ga4gh/v2/extended/tools/index', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def tools_index_search(self, body, **kwargs):  # noqa: E501
        """Search the tools and workflows indices.  # noqa: E501

        This endpoint searches the indices for all published tools and workflows. Used by utilities that expect to talk to an elastic search endpoint.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.tools_index_search(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str body: elastic search query (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.tools_index_search_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.tools_index_search_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def tools_index_search_with_http_info(self, body, **kwargs):  # noqa: E501
        """Search the tools and workflows indices.  # noqa: E501

        This endpoint searches the indices for all published tools and workflows. Used by utilities that expect to talk to an elastic search endpoint.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.tools_index_search_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str body: elastic search query (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method tools_index_search" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `tools_index_search`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/ga4gh/v2/extended/tools/entry/_search', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def tools_org_get(self, organization, **kwargs):  # noqa: E501
        """List tools of an organization  # noqa: E501

        This endpoint returns tools of an organization.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.tools_org_get(organization, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str organization: An organization, for example `cancercollaboratory` (required)
        :return: list[ToolV1]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.tools_org_get_with_http_info(organization, **kwargs)  # noqa: E501
        else:
            (data) = self.tools_org_get_with_http_info(organization, **kwargs)  # noqa: E501
            return data

    def tools_org_get_with_http_info(self, organization, **kwargs):  # noqa: E501
        """List tools of an organization  # noqa: E501

        This endpoint returns tools of an organization.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.tools_org_get_with_http_info(organization, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str organization: An organization, for example `cancercollaboratory` (required)
        :return: list[ToolV1]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['organization']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method tools_org_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'organization' is set
        if self.api_client.client_side_validation and ('organization' not in params or
                                                       params['organization'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `organization` when calling `tools_org_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization' in params:
            path_params['organization'] = params['organization']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/ga4gh/v2/extended/tools/{organization}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ToolV1]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def workflows_org_get(self, organization, **kwargs):  # noqa: E501
        """List workflows of an organization  # noqa: E501

        This endpoint returns workflows of an organization.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.workflows_org_get(organization, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str organization: An organization, for example `cancercollaboratory` (required)
        :return: list[ToolV1]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.workflows_org_get_with_http_info(organization, **kwargs)  # noqa: E501
        else:
            (data) = self.workflows_org_get_with_http_info(organization, **kwargs)  # noqa: E501
            return data

    def workflows_org_get_with_http_info(self, organization, **kwargs):  # noqa: E501
        """List workflows of an organization  # noqa: E501

        This endpoint returns workflows of an organization.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.workflows_org_get_with_http_info(organization, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str organization: An organization, for example `cancercollaboratory` (required)
        :return: list[ToolV1]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['organization']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method workflows_org_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'organization' is set
        if self.api_client.client_side_validation and ('organization' not in params or
                                                       params['organization'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `organization` when calling `workflows_org_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization' in params:
            path_params['organization'] = params['organization']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/ga4gh/v2/extended/workflows/{organization}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ToolV1]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
