# coding: utf-8

"""
    Dockstore API

    This describes the dockstore API, a webservice that manages pairs of Docker images and associated metadata such as CWL documents and Dockerfiles used to build those images. Explore swagger.json for a Swagger 2.0 description of our API and explore openapi.yaml for OpenAPI 3.0 descriptions.  # noqa: E501

    OpenAPI spec version: 1.12.0-alpha.1-SNAPSHOT
    Contact: theglobalalliance@genomicsandhealth.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from jgreenepack.api_client import ApiClient


class GA4GHApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def metadata_get(self, **kwargs):  # noqa: E501
        """Return some metadata that is useful for describing this registry  # noqa: E501

        Return some metadata that is useful for describing this registry  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.metadata_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: Metadata
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.metadata_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.metadata_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def metadata_get_with_http_info(self, **kwargs):  # noqa: E501
        """Return some metadata that is useful for describing this registry  # noqa: E501

        Return some metadata that is useful for describing this registry  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.metadata_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: Metadata
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method metadata_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/ga4gh/v2/metadata', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Metadata',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def tool_classes_get(self, **kwargs):  # noqa: E501
        """List all tool types  # noqa: E501

        This endpoint returns all tool-classes available   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.tool_classes_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[ToolClass]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.tool_classes_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.tool_classes_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def tool_classes_get_with_http_info(self, **kwargs):  # noqa: E501
        """List all tool types  # noqa: E501

        This endpoint returns all tool-classes available   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.tool_classes_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[ToolClass]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method tool_classes_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/ga4gh/v2/toolClasses', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ToolClass]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def tools_get(self, **kwargs):  # noqa: E501
        """List all tools  # noqa: E501

        This endpoint returns all tools available or a filtered subset using metadata query parameters.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.tools_get(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: A unique identifier of the tool, scoped to this registry, for example `123456`
        :param str alias: OPTIONAL for tool registries that support aliases. If provided will only return entries with the given alias.
        :param str registry: The image registry that contains the image.
        :param str organization: The organization in the registry that published the image.
        :param str name: The name of the image.
        :param str toolname: The name of the tool.
        :param str description: The description of the tool.
        :param str author: The author of the tool (TODO a thought occurs, are we assuming that the author of the CWL and the image are the same?).
        :param bool checker: Return only checker workflows
        :param str offset: Start index of paging. Pagination results can be based on numbers or other values chosen by the registry implementor (for example, SHA values). If this exceeds the current result set return an empty set.  If not specified in the request, this will start at the beginning of the results.
        :param int limit: Amount of records to return in a given page.
        :return: list[Tool]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.tools_get_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.tools_get_with_http_info(**kwargs)  # noqa: E501
            return data

    def tools_get_with_http_info(self, **kwargs):  # noqa: E501
        """List all tools  # noqa: E501

        This endpoint returns all tools available or a filtered subset using metadata query parameters.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.tools_get_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: A unique identifier of the tool, scoped to this registry, for example `123456`
        :param str alias: OPTIONAL for tool registries that support aliases. If provided will only return entries with the given alias.
        :param str registry: The image registry that contains the image.
        :param str organization: The organization in the registry that published the image.
        :param str name: The name of the image.
        :param str toolname: The name of the tool.
        :param str description: The description of the tool.
        :param str author: The author of the tool (TODO a thought occurs, are we assuming that the author of the CWL and the image are the same?).
        :param bool checker: Return only checker workflows
        :param str offset: Start index of paging. Pagination results can be based on numbers or other values chosen by the registry implementor (for example, SHA values). If this exceeds the current result set return an empty set.  If not specified in the request, this will start at the beginning of the results.
        :param int limit: Amount of records to return in a given page.
        :return: list[Tool]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'alias', 'registry', 'organization', 'name', 'toolname', 'description', 'author', 'checker', 'offset', 'limit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method tools_get" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'id' in params:
            query_params.append(('id', params['id']))  # noqa: E501
        if 'alias' in params:
            query_params.append(('alias', params['alias']))  # noqa: E501
        if 'registry' in params:
            query_params.append(('registry', params['registry']))  # noqa: E501
        if 'organization' in params:
            query_params.append(('organization', params['organization']))  # noqa: E501
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'toolname' in params:
            query_params.append(('toolname', params['toolname']))  # noqa: E501
        if 'description' in params:
            query_params.append(('description', params['description']))  # noqa: E501
        if 'author' in params:
            query_params.append(('author', params['author']))  # noqa: E501
        if 'checker' in params:
            query_params.append(('checker', params['checker']))  # noqa: E501
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/ga4gh/v2/tools', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Tool]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def tools_id_get(self, id, **kwargs):  # noqa: E501
        """List one specific tool, acts as an anchor for self references  # noqa: E501

        This endpoint returns one specific tool (which has ToolVersions nested inside it)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.tools_id_get(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: A unique identifier of the tool, scoped to this registry, for example `123456` (required)
        :return: Tool
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.tools_id_get_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.tools_id_get_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def tools_id_get_with_http_info(self, id, **kwargs):  # noqa: E501
        """List one specific tool, acts as an anchor for self references  # noqa: E501

        This endpoint returns one specific tool (which has ToolVersions nested inside it)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.tools_id_get_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: A unique identifier of the tool, scoped to this registry, for example `123456` (required)
        :return: Tool
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method tools_id_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in params or
                                                       params['id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `id` when calling `tools_id_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/ga4gh/v2/tools/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Tool',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def tools_id_versions_get(self, id, **kwargs):  # noqa: E501
        """List versions of a tool  # noqa: E501

        Returns all versions of the specified tool  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.tools_id_versions_get(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: A unique identifier of the tool, scoped to this registry, for example `123456` (required)
        :return: list[ToolVersion]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.tools_id_versions_get_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.tools_id_versions_get_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def tools_id_versions_get_with_http_info(self, id, **kwargs):  # noqa: E501
        """List versions of a tool  # noqa: E501

        Returns all versions of the specified tool  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.tools_id_versions_get_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: A unique identifier of the tool, scoped to this registry, for example `123456` (required)
        :return: list[ToolVersion]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method tools_id_versions_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in params or
                                                       params['id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `id` when calling `tools_id_versions_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/ga4gh/v2/tools/{id}/versions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ToolVersion]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def tools_id_versions_version_id_containerfile_get(self, id, version_id, **kwargs):  # noqa: E501
        """Get the container specification(s) for the specified image.  # noqa: E501

        Returns the container specifications(s) for the specified image. For example, a CWL CommandlineTool can be associated with one specification for a container, a CWL Workflow can be associated with multiple specifications for containers  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.tools_id_versions_version_id_containerfile_get(id, version_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: A unique identifier of the tool, scoped to this registry, for example `123456` (required)
        :param str version_id: An identifier of the tool version for this particular tool registry, for example `v1` (required)
        :return: list[FileWrapper]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.tools_id_versions_version_id_containerfile_get_with_http_info(id, version_id, **kwargs)  # noqa: E501
        else:
            (data) = self.tools_id_versions_version_id_containerfile_get_with_http_info(id, version_id, **kwargs)  # noqa: E501
            return data

    def tools_id_versions_version_id_containerfile_get_with_http_info(self, id, version_id, **kwargs):  # noqa: E501
        """Get the container specification(s) for the specified image.  # noqa: E501

        Returns the container specifications(s) for the specified image. For example, a CWL CommandlineTool can be associated with one specification for a container, a CWL Workflow can be associated with multiple specifications for containers  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.tools_id_versions_version_id_containerfile_get_with_http_info(id, version_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: A unique identifier of the tool, scoped to this registry, for example `123456` (required)
        :param str version_id: An identifier of the tool version for this particular tool registry, for example `v1` (required)
        :return: list[FileWrapper]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'version_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method tools_id_versions_version_id_containerfile_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in params or
                                                       params['id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `id` when calling `tools_id_versions_version_id_containerfile_get`")  # noqa: E501
        # verify the required parameter 'version_id' is set
        if self.api_client.client_side_validation and ('version_id' not in params or
                                                       params['version_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `version_id` when calling `tools_id_versions_version_id_containerfile_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501
        if 'version_id' in params:
            path_params['version_id'] = params['version_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/ga4gh/v2/tools/{id}/versions/{version_id}/containerfile', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[FileWrapper]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def tools_id_versions_version_id_get(self, id, version_id, **kwargs):  # noqa: E501
        """List one specific tool version, acts as an anchor for self references  # noqa: E501

        This endpoint returns one specific tool version  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.tools_id_versions_version_id_get(id, version_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: A unique identifier of the tool, scoped to this registry, for example `123456` (required)
        :param str version_id: An identifier of the tool version, scoped to this registry, for example `v1` (required)
        :return: ToolVersion
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.tools_id_versions_version_id_get_with_http_info(id, version_id, **kwargs)  # noqa: E501
        else:
            (data) = self.tools_id_versions_version_id_get_with_http_info(id, version_id, **kwargs)  # noqa: E501
            return data

    def tools_id_versions_version_id_get_with_http_info(self, id, version_id, **kwargs):  # noqa: E501
        """List one specific tool version, acts as an anchor for self references  # noqa: E501

        This endpoint returns one specific tool version  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.tools_id_versions_version_id_get_with_http_info(id, version_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: A unique identifier of the tool, scoped to this registry, for example `123456` (required)
        :param str version_id: An identifier of the tool version, scoped to this registry, for example `v1` (required)
        :return: ToolVersion
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'version_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method tools_id_versions_version_id_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in params or
                                                       params['id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `id` when calling `tools_id_versions_version_id_get`")  # noqa: E501
        # verify the required parameter 'version_id' is set
        if self.api_client.client_side_validation and ('version_id' not in params or
                                                       params['version_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `version_id` when calling `tools_id_versions_version_id_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501
        if 'version_id' in params:
            path_params['version_id'] = params['version_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/ga4gh/v2/tools/{id}/versions/{version_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ToolVersion',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def tools_id_versions_version_id_type_descriptor_get(self, type, id, version_id, **kwargs):  # noqa: E501
        """Get the tool descriptor for the specified tool  # noqa: E501

        Returns the descriptor for the specified tool (examples include CWL, WDL, or Nextflow documents).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.tools_id_versions_version_id_type_descriptor_get(type, id, version_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str type: The output type of the descriptor. If not specified, it is up to the underlying implementation to determine which output type to return. Plain types return the bare descriptor while the \"non-plain\" types return a descriptor wrapped with metadata. Allowable values include \"CWL\", \"WDL\", \"NFL\", \"PLAIN_CWL\", \"PLAIN_WDL\", \"PLAIN_NFL\". (required)
        :param str id: A unique identifier of the tool, scoped to this registry, for example `123456` (required)
        :param str version_id: An identifier of the tool version, scoped to this registry, for example `v1` (required)
        :return: FileWrapper
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.tools_id_versions_version_id_type_descriptor_get_with_http_info(type, id, version_id, **kwargs)  # noqa: E501
        else:
            (data) = self.tools_id_versions_version_id_type_descriptor_get_with_http_info(type, id, version_id, **kwargs)  # noqa: E501
            return data

    def tools_id_versions_version_id_type_descriptor_get_with_http_info(self, type, id, version_id, **kwargs):  # noqa: E501
        """Get the tool descriptor for the specified tool  # noqa: E501

        Returns the descriptor for the specified tool (examples include CWL, WDL, or Nextflow documents).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.tools_id_versions_version_id_type_descriptor_get_with_http_info(type, id, version_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str type: The output type of the descriptor. If not specified, it is up to the underlying implementation to determine which output type to return. Plain types return the bare descriptor while the \"non-plain\" types return a descriptor wrapped with metadata. Allowable values include \"CWL\", \"WDL\", \"NFL\", \"PLAIN_CWL\", \"PLAIN_WDL\", \"PLAIN_NFL\". (required)
        :param str id: A unique identifier of the tool, scoped to this registry, for example `123456` (required)
        :param str version_id: An identifier of the tool version, scoped to this registry, for example `v1` (required)
        :return: FileWrapper
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['type', 'id', 'version_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method tools_id_versions_version_id_type_descriptor_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'type' is set
        if self.api_client.client_side_validation and ('type' not in params or
                                                       params['type'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `type` when calling `tools_id_versions_version_id_type_descriptor_get`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in params or
                                                       params['id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `id` when calling `tools_id_versions_version_id_type_descriptor_get`")  # noqa: E501
        # verify the required parameter 'version_id' is set
        if self.api_client.client_side_validation and ('version_id' not in params or
                                                       params['version_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `version_id` when calling `tools_id_versions_version_id_type_descriptor_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'type' in params:
            path_params['type'] = params['type']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501
        if 'version_id' in params:
            path_params['version_id'] = params['version_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/ga4gh/v2/tools/{id}/versions/{version_id}/{type}/descriptor', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FileWrapper',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def tools_id_versions_version_id_type_descriptor_relative_path_get(self, type, id, version_id, relative_path, **kwargs):  # noqa: E501
        """Get additional tool descriptor files relative to the main file  # noqa: E501

        Descriptors can often include imports that refer to additional descriptors. This returns additional descriptors for the specified tool in the same or other directories that can be reached as a relative path. This endpoint can be useful for workflow engine implementations like cwltool to programmatically download all the descriptors for a tool and run it. This can optionally include other files described with FileWrappers such as test parameters and containerfiles.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.tools_id_versions_version_id_type_descriptor_relative_path_get(type, id, version_id, relative_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str type: The output type of the descriptor. If not specified, it is up to the underlying implementation to determine which output type to return. Plain types return the bare descriptor while the \"non-plain\" types return a descriptor wrapped with metadata. Allowable values are \"CWL\", \"WDL\", \"NFL\", \"PLAIN_CWL\", \"PLAIN_WDL\", \"PLAIN_NFL\". (required)
        :param str id: A unique identifier of the tool, scoped to this registry, for example `123456` (required)
        :param str version_id: An identifier of the tool version for this particular tool registry, for example `v1` (required)
        :param str relative_path: A relative path to the additional file (same directory or subdirectories), for example 'foo.cwl' would return a 'foo.cwl' from the same directory as the main descriptor. 'nestedDirectory/foo.cwl' would return the file  from a nested subdirectory.  Unencoded paths such 'sampleDirectory/foo.cwl' should also be allowed (required)
        :return: FileWrapper
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.tools_id_versions_version_id_type_descriptor_relative_path_get_with_http_info(type, id, version_id, relative_path, **kwargs)  # noqa: E501
        else:
            (data) = self.tools_id_versions_version_id_type_descriptor_relative_path_get_with_http_info(type, id, version_id, relative_path, **kwargs)  # noqa: E501
            return data

    def tools_id_versions_version_id_type_descriptor_relative_path_get_with_http_info(self, type, id, version_id, relative_path, **kwargs):  # noqa: E501
        """Get additional tool descriptor files relative to the main file  # noqa: E501

        Descriptors can often include imports that refer to additional descriptors. This returns additional descriptors for the specified tool in the same or other directories that can be reached as a relative path. This endpoint can be useful for workflow engine implementations like cwltool to programmatically download all the descriptors for a tool and run it. This can optionally include other files described with FileWrappers such as test parameters and containerfiles.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.tools_id_versions_version_id_type_descriptor_relative_path_get_with_http_info(type, id, version_id, relative_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str type: The output type of the descriptor. If not specified, it is up to the underlying implementation to determine which output type to return. Plain types return the bare descriptor while the \"non-plain\" types return a descriptor wrapped with metadata. Allowable values are \"CWL\", \"WDL\", \"NFL\", \"PLAIN_CWL\", \"PLAIN_WDL\", \"PLAIN_NFL\". (required)
        :param str id: A unique identifier of the tool, scoped to this registry, for example `123456` (required)
        :param str version_id: An identifier of the tool version for this particular tool registry, for example `v1` (required)
        :param str relative_path: A relative path to the additional file (same directory or subdirectories), for example 'foo.cwl' would return a 'foo.cwl' from the same directory as the main descriptor. 'nestedDirectory/foo.cwl' would return the file  from a nested subdirectory.  Unencoded paths such 'sampleDirectory/foo.cwl' should also be allowed (required)
        :return: FileWrapper
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['type', 'id', 'version_id', 'relative_path']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method tools_id_versions_version_id_type_descriptor_relative_path_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'type' is set
        if self.api_client.client_side_validation and ('type' not in params or
                                                       params['type'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `type` when calling `tools_id_versions_version_id_type_descriptor_relative_path_get`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in params or
                                                       params['id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `id` when calling `tools_id_versions_version_id_type_descriptor_relative_path_get`")  # noqa: E501
        # verify the required parameter 'version_id' is set
        if self.api_client.client_side_validation and ('version_id' not in params or
                                                       params['version_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `version_id` when calling `tools_id_versions_version_id_type_descriptor_relative_path_get`")  # noqa: E501
        # verify the required parameter 'relative_path' is set
        if self.api_client.client_side_validation and ('relative_path' not in params or
                                                       params['relative_path'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `relative_path` when calling `tools_id_versions_version_id_type_descriptor_relative_path_get`")  # noqa: E501

        if self.api_client.client_side_validation and ('relative_path' in params and not re.search(r'.+', params['relative_path'])):  # noqa: E501
            raise ValueError("Invalid value for parameter `relative_path` when calling `tools_id_versions_version_id_type_descriptor_relative_path_get`, must conform to the pattern `/.+/`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'type' in params:
            path_params['type'] = params['type']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501
        if 'version_id' in params:
            path_params['version_id'] = params['version_id']  # noqa: E501
        if 'relative_path' in params:
            path_params['relative_path'] = params['relative_path']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/ga4gh/v2/tools/{id}/versions/{version_id}/{type}/descriptor/{relative_path}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FileWrapper',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def tools_id_versions_version_id_type_files_get(self, type, id, version_id, **kwargs):  # noqa: E501
        """Get a list of objects that contain the relative path and file type  # noqa: E501

        Get a list of objects that contain the relative path and file type. The descriptors are intended for use with the /tools/{id}/versions/{version_id}/{type}/descriptor/{relative_path : .+} endpoint.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.tools_id_versions_version_id_type_files_get(type, id, version_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str type: The output type of the descriptor. Examples of allowable values are \"CWL\", \"WDL\", and \"NextFlow.\" (required)
        :param str id: A unique identifier of the tool, scoped to this registry, for example `123456` (required)
        :param str version_id: An identifier of the tool version for this particular tool registry, for example `v1` (required)
        :return: list[ToolFile]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.tools_id_versions_version_id_type_files_get_with_http_info(type, id, version_id, **kwargs)  # noqa: E501
        else:
            (data) = self.tools_id_versions_version_id_type_files_get_with_http_info(type, id, version_id, **kwargs)  # noqa: E501
            return data

    def tools_id_versions_version_id_type_files_get_with_http_info(self, type, id, version_id, **kwargs):  # noqa: E501
        """Get a list of objects that contain the relative path and file type  # noqa: E501

        Get a list of objects that contain the relative path and file type. The descriptors are intended for use with the /tools/{id}/versions/{version_id}/{type}/descriptor/{relative_path : .+} endpoint.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.tools_id_versions_version_id_type_files_get_with_http_info(type, id, version_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str type: The output type of the descriptor. Examples of allowable values are \"CWL\", \"WDL\", and \"NextFlow.\" (required)
        :param str id: A unique identifier of the tool, scoped to this registry, for example `123456` (required)
        :param str version_id: An identifier of the tool version for this particular tool registry, for example `v1` (required)
        :return: list[ToolFile]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['type', 'id', 'version_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method tools_id_versions_version_id_type_files_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'type' is set
        if self.api_client.client_side_validation and ('type' not in params or
                                                       params['type'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `type` when calling `tools_id_versions_version_id_type_files_get`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in params or
                                                       params['id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `id` when calling `tools_id_versions_version_id_type_files_get`")  # noqa: E501
        # verify the required parameter 'version_id' is set
        if self.api_client.client_side_validation and ('version_id' not in params or
                                                       params['version_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `version_id` when calling `tools_id_versions_version_id_type_files_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'type' in params:
            path_params['type'] = params['type']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501
        if 'version_id' in params:
            path_params['version_id'] = params['version_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/ga4gh/v2/tools/{id}/versions/{version_id}/{type}/files', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ToolFile]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def tools_id_versions_version_id_type_tests_get(self, type, id, version_id, **kwargs):  # noqa: E501
        """Get a list of test JSONs  # noqa: E501

        Get a list of test JSONs (these allow you to execute the tool successfully) suitable for use with this descriptor type.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.tools_id_versions_version_id_type_tests_get(type, id, version_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str type: The type of the underlying descriptor. Allowable values include \"CWL\", \"WDL\", \"NFL\", \"PLAIN_CWL\", \"PLAIN_WDL\", \"PLAIN_NFL\". For example, \"CWL\" would return an list of ToolTests objects while \"PLAIN_CWL\" would return a bare JSON list with the content of the tests.  (required)
        :param str id: A unique identifier of the tool, scoped to this registry, for example `123456` (required)
        :param str version_id: An identifier of the tool version for this particular tool registry, for example `v1` (required)
        :return: list[FileWrapper]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.tools_id_versions_version_id_type_tests_get_with_http_info(type, id, version_id, **kwargs)  # noqa: E501
        else:
            (data) = self.tools_id_versions_version_id_type_tests_get_with_http_info(type, id, version_id, **kwargs)  # noqa: E501
            return data

    def tools_id_versions_version_id_type_tests_get_with_http_info(self, type, id, version_id, **kwargs):  # noqa: E501
        """Get a list of test JSONs  # noqa: E501

        Get a list of test JSONs (these allow you to execute the tool successfully) suitable for use with this descriptor type.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.tools_id_versions_version_id_type_tests_get_with_http_info(type, id, version_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str type: The type of the underlying descriptor. Allowable values include \"CWL\", \"WDL\", \"NFL\", \"PLAIN_CWL\", \"PLAIN_WDL\", \"PLAIN_NFL\". For example, \"CWL\" would return an list of ToolTests objects while \"PLAIN_CWL\" would return a bare JSON list with the content of the tests.  (required)
        :param str id: A unique identifier of the tool, scoped to this registry, for example `123456` (required)
        :param str version_id: An identifier of the tool version for this particular tool registry, for example `v1` (required)
        :return: list[FileWrapper]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['type', 'id', 'version_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method tools_id_versions_version_id_type_tests_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'type' is set
        if self.api_client.client_side_validation and ('type' not in params or
                                                       params['type'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `type` when calling `tools_id_versions_version_id_type_tests_get`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in params or
                                                       params['id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `id` when calling `tools_id_versions_version_id_type_tests_get`")  # noqa: E501
        # verify the required parameter 'version_id' is set
        if self.api_client.client_side_validation and ('version_id' not in params or
                                                       params['version_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `version_id` when calling `tools_id_versions_version_id_type_tests_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'type' in params:
            path_params['type'] = params['type']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501
        if 'version_id' in params:
            path_params['version_id'] = params['version_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/api/ga4gh/v2/tools/{id}/versions/{version_id}/{type}/tests', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[FileWrapper]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
