# coding: utf-8

"""
    Dockstore API

    This describes the dockstore API, a webservice that manages pairs of Docker images and associated metadata such as CWL documents and Dockerfiles used to build those images. Explore swagger.json for a Swagger 2.0 description of our API and explore openapi.yaml for OpenAPI 3.0 descriptions.  # noqa: E501

    OpenAPI spec version: 1.12.0-alpha.1-SNAPSHOT
    Contact: theglobalalliance@genomicsandhealth.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from jgreenepack.api_client import ApiClient


class HostedApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_zip(self, entry_id, **kwargs):  # noqa: E501
        """Creates a new revision of a hosted workflow from a zip  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_zip(entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int entry_id: hosted entry ID (required)
        :param file file:
        :return: Workflow
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_zip_with_http_info(entry_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_zip_with_http_info(entry_id, **kwargs)  # noqa: E501
            return data

    def add_zip_with_http_info(self, entry_id, **kwargs):  # noqa: E501
        """Creates a new revision of a hosted workflow from a zip  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_zip_with_http_info(entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int entry_id: hosted entry ID (required)
        :param file file:
        :return: Workflow
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['entry_id', 'file']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_zip" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'entry_id' is set
        if self.api_client.client_side_validation and ('entry_id' not in params or
                                                       params['entry_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `entry_id` when calling `add_zip`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'entry_id' in params:
            path_params['entryId'] = params['entry_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'file' in params:
            local_var_files['file'] = params['file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/workflows/hostedEntry/{entryId}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Workflow',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_hosted_tool(self, name, **kwargs):  # noqa: E501
        """Create a hosted tool.  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_hosted_tool(name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: The repository name (required)
        :param str registry: The Docker registry (Tools only)
        :param str descriptor_type: The descriptor type (Workflows only)
        :param str namespace: The Docker namespace (Tools only)
        :param str entry_name: Optional entry name (Tools only)
        :return: DockstoreTool
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_hosted_tool_with_http_info(name, **kwargs)  # noqa: E501
        else:
            (data) = self.create_hosted_tool_with_http_info(name, **kwargs)  # noqa: E501
            return data

    def create_hosted_tool_with_http_info(self, name, **kwargs):  # noqa: E501
        """Create a hosted tool.  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_hosted_tool_with_http_info(name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: The repository name (required)
        :param str registry: The Docker registry (Tools only)
        :param str descriptor_type: The descriptor type (Workflows only)
        :param str namespace: The Docker namespace (Tools only)
        :param str entry_name: Optional entry name (Tools only)
        :return: DockstoreTool
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'registry', 'descriptor_type', 'namespace', 'entry_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_hosted_tool" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and ('name' not in params or
                                                       params['name'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `name` when calling `create_hosted_tool`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'registry' in params:
            query_params.append(('registry', params['registry']))  # noqa: E501
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'descriptor_type' in params:
            query_params.append(('descriptorType', params['descriptor_type']))  # noqa: E501
        if 'namespace' in params:
            query_params.append(('namespace', params['namespace']))  # noqa: E501
        if 'entry_name' in params:
            query_params.append(('entryName', params['entry_name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/containers/hostedEntry', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DockstoreTool',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_hosted_workflow(self, name, **kwargs):  # noqa: E501
        """Create a hosted workflow.  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_hosted_workflow(name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: The repository name (required)
        :param str registry: The Docker registry (Tools only)
        :param str descriptor_type: The descriptor type (Workflows only)
        :param str namespace: The Docker namespace (Tools only)
        :param str entry_name: Optional entry name (Tools only)
        :return: Workflow
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_hosted_workflow_with_http_info(name, **kwargs)  # noqa: E501
        else:
            (data) = self.create_hosted_workflow_with_http_info(name, **kwargs)  # noqa: E501
            return data

    def create_hosted_workflow_with_http_info(self, name, **kwargs):  # noqa: E501
        """Create a hosted workflow.  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_hosted_workflow_with_http_info(name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: The repository name (required)
        :param str registry: The Docker registry (Tools only)
        :param str descriptor_type: The descriptor type (Workflows only)
        :param str namespace: The Docker namespace (Tools only)
        :param str entry_name: Optional entry name (Tools only)
        :return: Workflow
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'registry', 'descriptor_type', 'namespace', 'entry_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_hosted_workflow" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and ('name' not in params or
                                                       params['name'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `name` when calling `create_hosted_workflow`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'registry' in params:
            query_params.append(('registry', params['registry']))  # noqa: E501
        if 'name' in params:
            query_params.append(('name', params['name']))  # noqa: E501
        if 'descriptor_type' in params:
            query_params.append(('descriptorType', params['descriptor_type']))  # noqa: E501
        if 'namespace' in params:
            query_params.append(('namespace', params['namespace']))  # noqa: E501
        if 'entry_name' in params:
            query_params.append(('entryName', params['entry_name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/workflows/hostedEntry', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Workflow',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_hosted_tool_version(self, entry_id, version, **kwargs):  # noqa: E501
        """Delete a revision of a hosted tool.  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_hosted_tool_version(entry_id, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int entry_id: Entry to modify. (required)
        :param str version: version (required)
        :return: DockstoreTool
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_hosted_tool_version_with_http_info(entry_id, version, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_hosted_tool_version_with_http_info(entry_id, version, **kwargs)  # noqa: E501
            return data

    def delete_hosted_tool_version_with_http_info(self, entry_id, version, **kwargs):  # noqa: E501
        """Delete a revision of a hosted tool.  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_hosted_tool_version_with_http_info(entry_id, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int entry_id: Entry to modify. (required)
        :param str version: version (required)
        :return: DockstoreTool
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['entry_id', 'version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_hosted_tool_version" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'entry_id' is set
        if self.api_client.client_side_validation and ('entry_id' not in params or
                                                       params['entry_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `entry_id` when calling `delete_hosted_tool_version`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in params or
                                                       params['version'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `version` when calling `delete_hosted_tool_version`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'entry_id' in params:
            path_params['entryId'] = params['entry_id']  # noqa: E501

        query_params = []
        if 'version' in params:
            query_params.append(('version', params['version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/containers/hostedEntry/{entryId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DockstoreTool',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_hosted_workflow_version(self, entry_id, version, **kwargs):  # noqa: E501
        """Delete a revision of a hosted workflow  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_hosted_workflow_version(entry_id, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int entry_id: Entry to modify. (required)
        :param str version: version (required)
        :return: Workflow
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_hosted_workflow_version_with_http_info(entry_id, version, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_hosted_workflow_version_with_http_info(entry_id, version, **kwargs)  # noqa: E501
            return data

    def delete_hosted_workflow_version_with_http_info(self, entry_id, version, **kwargs):  # noqa: E501
        """Delete a revision of a hosted workflow  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_hosted_workflow_version_with_http_info(entry_id, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int entry_id: Entry to modify. (required)
        :param str version: version (required)
        :return: Workflow
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['entry_id', 'version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_hosted_workflow_version" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'entry_id' is set
        if self.api_client.client_side_validation and ('entry_id' not in params or
                                                       params['entry_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `entry_id` when calling `delete_hosted_workflow_version`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in params or
                                                       params['version'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `version` when calling `delete_hosted_workflow_version`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'entry_id' in params:
            path_params['entryId'] = params['entry_id']  # noqa: E501

        query_params = []
        if 'version' in params:
            query_params.append(('version', params['version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/workflows/hostedEntry/{entryId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Workflow',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_hosted_tool(self, entry_id, body, **kwargs):  # noqa: E501
        """Non-idempotent operation for creating new revisions of hosted tools.  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_hosted_tool(entry_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int entry_id: Entry to modify. (required)
        :param list[SourceFile] body: Set of updated sourcefiles, add files by adding new files with unknown paths, delete files by including them with emptied content (required)
        :return: DockstoreTool
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_hosted_tool_with_http_info(entry_id, body, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_hosted_tool_with_http_info(entry_id, body, **kwargs)  # noqa: E501
            return data

    def edit_hosted_tool_with_http_info(self, entry_id, body, **kwargs):  # noqa: E501
        """Non-idempotent operation for creating new revisions of hosted tools.  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_hosted_tool_with_http_info(entry_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int entry_id: Entry to modify. (required)
        :param list[SourceFile] body: Set of updated sourcefiles, add files by adding new files with unknown paths, delete files by including them with emptied content (required)
        :return: DockstoreTool
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['entry_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_hosted_tool" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'entry_id' is set
        if self.api_client.client_side_validation and ('entry_id' not in params or
                                                       params['entry_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `entry_id` when calling `edit_hosted_tool`")  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `edit_hosted_tool`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'entry_id' in params:
            path_params['entryId'] = params['entry_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/containers/hostedEntry/{entryId}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DockstoreTool',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def edit_hosted_workflow(self, entry_id, body, **kwargs):  # noqa: E501
        """Non-idempotent operation for creating new revisions of hosted workflows  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_hosted_workflow(entry_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int entry_id: Entry to modify. (required)
        :param list[SourceFile] body: Set of updated sourcefiles, add files by adding new files with unknown paths, delete files by including them with emptied content (required)
        :return: Workflow
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.edit_hosted_workflow_with_http_info(entry_id, body, **kwargs)  # noqa: E501
        else:
            (data) = self.edit_hosted_workflow_with_http_info(entry_id, body, **kwargs)  # noqa: E501
            return data

    def edit_hosted_workflow_with_http_info(self, entry_id, body, **kwargs):  # noqa: E501
        """Non-idempotent operation for creating new revisions of hosted workflows  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.edit_hosted_workflow_with_http_info(entry_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int entry_id: Entry to modify. (required)
        :param list[SourceFile] body: Set of updated sourcefiles, add files by adding new files with unknown paths, delete files by including them with emptied content (required)
        :return: Workflow
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['entry_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method edit_hosted_workflow" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'entry_id' is set
        if self.api_client.client_side_validation and ('entry_id' not in params or
                                                       params['entry_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `entry_id` when calling `edit_hosted_workflow`")  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `edit_hosted_workflow`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'entry_id' in params:
            path_params['entryId'] = params['entry_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/workflows/hostedEntry/{entryId}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Workflow',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
