# coding: utf-8

"""
    Dockstore API

    This describes the dockstore API, a webservice that manages pairs of Docker images and associated metadata such as CWL documents and Dockerfiles used to build those images. Explore swagger.json for a Swagger 2.0 description of our API and explore openapi.yaml for OpenAPI 3.0 descriptions.  # noqa: E501

    OpenAPI spec version: 1.12.0-alpha.1-SNAPSHOT
    Contact: theglobalalliance@genomicsandhealth.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from jgreenepack.api_client import ApiClient


class LambdaEventsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_lambda_events_by_organization(self, organization, **kwargs):  # noqa: E501
        """See OpenApi for details  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_lambda_events_by_organization(organization, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str organization: organization (required)
        :param str offset: Start index of paging. Pagination results can be based on numbers or other values chosen by the registry implementor (for example, SHA values). If this exceeds the current result set return an empty set.  If not specified in the request, this will start at the beginning of the results.
        :param int limit: Amount of records to return in a given page, limited to 100
        :return: list[LambdaEvent]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_lambda_events_by_organization_with_http_info(organization, **kwargs)  # noqa: E501
        else:
            (data) = self.get_lambda_events_by_organization_with_http_info(organization, **kwargs)  # noqa: E501
            return data

    def get_lambda_events_by_organization_with_http_info(self, organization, **kwargs):  # noqa: E501
        """See OpenApi for details  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_lambda_events_by_organization_with_http_info(organization, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str organization: organization (required)
        :param str offset: Start index of paging. Pagination results can be based on numbers or other values chosen by the registry implementor (for example, SHA values). If this exceeds the current result set return an empty set.  If not specified in the request, this will start at the beginning of the results.
        :param int limit: Amount of records to return in a given page, limited to 100
        :return: list[LambdaEvent]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['organization', 'offset', 'limit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_lambda_events_by_organization" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'organization' is set
        if self.api_client.client_side_validation and ('organization' not in params or
                                                       params['organization'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `organization` when calling `get_lambda_events_by_organization`")  # noqa: E501

        if self.api_client.client_side_validation and ('limit' in params and params['limit'] > 100):  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_lambda_events_by_organization`, must be a value less than or equal to `100`")  # noqa: E501
        if self.api_client.client_side_validation and ('limit' in params and params['limit'] < 1):  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_lambda_events_by_organization`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'organization' in params:
            path_params['organization'] = params['organization']  # noqa: E501

        query_params = []
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/lambdaEvents/{organization}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[LambdaEvent]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
