# coding: utf-8

"""
    Dockstore API

    This describes the dockstore API, a webservice that manages pairs of Docker images and associated metadata such as CWL documents and Dockerfiles used to build those images. Explore swagger.json for a Swagger 2.0 description of our API and explore openapi.yaml for OpenAPI 3.0 descriptions.  # noqa: E501

    OpenAPI spec version: 1.12.0-alpha.1-SNAPSHOT
    Contact: theglobalalliance@genomicsandhealth.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from jgreenepack.api_client import ApiClient


class OrganizationsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def accept_or_reject_invitation(self, organization_id, accept, **kwargs):  # noqa: E501
        """Accept or reject an organization invitation.  # noqa: E501

        True accepts the invitation, false rejects the invitation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.accept_or_reject_invitation(organization_id, accept, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int organization_id: Organization ID. (required)
        :param bool accept: Accept or reject. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.accept_or_reject_invitation_with_http_info(organization_id, accept, **kwargs)  # noqa: E501
        else:
            (data) = self.accept_or_reject_invitation_with_http_info(organization_id, accept, **kwargs)  # noqa: E501
            return data

    def accept_or_reject_invitation_with_http_info(self, organization_id, accept, **kwargs):  # noqa: E501
        """Accept or reject an organization invitation.  # noqa: E501

        True accepts the invitation, false rejects the invitation.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.accept_or_reject_invitation_with_http_info(organization_id, accept, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int organization_id: Organization ID. (required)
        :param bool accept: Accept or reject. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['organization_id', 'accept']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method accept_or_reject_invitation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'organization_id' is set
        if self.api_client.client_side_validation and ('organization_id' not in params or
                                                       params['organization_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `organization_id` when calling `accept_or_reject_invitation`")  # noqa: E501
        # verify the required parameter 'accept' is set
        if self.api_client.client_side_validation and ('accept' not in params or
                                                       params['accept'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `accept` when calling `accept_or_reject_invitation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_id' in params:
            path_params['organizationId'] = params['organization_id']  # noqa: E501

        query_params = []
        if 'accept' in params:
            query_params.append(('accept', params['accept']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organizationId}/invitation', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_collection_aliases(self, collection_id, aliases, **kwargs):  # noqa: E501
        """Add aliases linked to a collection in Dockstore.  # noqa: E501

        Aliases are alphanumerical (case-insensitive and may contain internal hyphens), given in a comma-delimited list.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_collection_aliases(collection_id, aliases, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int collection_id: Collection to modify. (required)
        :param str aliases: Comma-delimited list of aliases. (required)
        :return: Collection
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_collection_aliases_with_http_info(collection_id, aliases, **kwargs)  # noqa: E501
        else:
            (data) = self.add_collection_aliases_with_http_info(collection_id, aliases, **kwargs)  # noqa: E501
            return data

    def add_collection_aliases_with_http_info(self, collection_id, aliases, **kwargs):  # noqa: E501
        """Add aliases linked to a collection in Dockstore.  # noqa: E501

        Aliases are alphanumerical (case-insensitive and may contain internal hyphens), given in a comma-delimited list.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_collection_aliases_with_http_info(collection_id, aliases, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int collection_id: Collection to modify. (required)
        :param str aliases: Comma-delimited list of aliases. (required)
        :return: Collection
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['collection_id', 'aliases']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_collection_aliases" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'collection_id' is set
        if self.api_client.client_side_validation and ('collection_id' not in params or
                                                       params['collection_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `collection_id` when calling `add_collection_aliases`")  # noqa: E501
        # verify the required parameter 'aliases' is set
        if self.api_client.client_side_validation and ('aliases' not in params or
                                                       params['aliases'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `aliases` when calling `add_collection_aliases`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'collection_id' in params:
            path_params['collectionId'] = params['collection_id']  # noqa: E501

        query_params = []
        if 'aliases' in params:
            query_params.append(('aliases', params['aliases']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/collections/{collectionId}/aliases', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Collection',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_entry_to_collection(self, organization_id, collection_id, entry_id, **kwargs):  # noqa: E501
        """Add an entry to a collection.  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_entry_to_collection(organization_id, collection_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int organization_id: Organization ID. (required)
        :param int collection_id: Collection ID. (required)
        :param int entry_id: Entry ID (required)
        :param int version_id: Version ID
        :return: Collection
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_entry_to_collection_with_http_info(organization_id, collection_id, entry_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_entry_to_collection_with_http_info(organization_id, collection_id, entry_id, **kwargs)  # noqa: E501
            return data

    def add_entry_to_collection_with_http_info(self, organization_id, collection_id, entry_id, **kwargs):  # noqa: E501
        """Add an entry to a collection.  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_entry_to_collection_with_http_info(organization_id, collection_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int organization_id: Organization ID. (required)
        :param int collection_id: Collection ID. (required)
        :param int entry_id: Entry ID (required)
        :param int version_id: Version ID
        :return: Collection
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['organization_id', 'collection_id', 'entry_id', 'version_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_entry_to_collection" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'organization_id' is set
        if self.api_client.client_side_validation and ('organization_id' not in params or
                                                       params['organization_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `organization_id` when calling `add_entry_to_collection`")  # noqa: E501
        # verify the required parameter 'collection_id' is set
        if self.api_client.client_side_validation and ('collection_id' not in params or
                                                       params['collection_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `collection_id` when calling `add_entry_to_collection`")  # noqa: E501
        # verify the required parameter 'entry_id' is set
        if self.api_client.client_side_validation and ('entry_id' not in params or
                                                       params['entry_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `entry_id` when calling `add_entry_to_collection`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_id' in params:
            path_params['organizationId'] = params['organization_id']  # noqa: E501
        if 'collection_id' in params:
            path_params['collectionId'] = params['collection_id']  # noqa: E501

        query_params = []
        if 'entry_id' in params:
            query_params.append(('entryId', params['entry_id']))  # noqa: E501
        if 'version_id' in params:
            query_params.append(('versionId', params['version_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organizationId}/collections/{collectionId}/entry', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Collection',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_organization_aliases(self, organization_id, aliases, **kwargs):  # noqa: E501
        """Add aliases linked to a listing in Dockstore.  # noqa: E501

        Aliases are alphanumerical (case-insensitive and may contain internal hyphens), given in a comma-delimited list.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_organization_aliases(organization_id, aliases, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int organization_id: Organization to modify. (required)
        :param str aliases: Comma-delimited list of aliases. (required)
        :return: Organization
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_organization_aliases_with_http_info(organization_id, aliases, **kwargs)  # noqa: E501
        else:
            (data) = self.add_organization_aliases_with_http_info(organization_id, aliases, **kwargs)  # noqa: E501
            return data

    def add_organization_aliases_with_http_info(self, organization_id, aliases, **kwargs):  # noqa: E501
        """Add aliases linked to a listing in Dockstore.  # noqa: E501

        Aliases are alphanumerical (case-insensitive and may contain internal hyphens), given in a comma-delimited list.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_organization_aliases_with_http_info(organization_id, aliases, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int organization_id: Organization to modify. (required)
        :param str aliases: Comma-delimited list of aliases. (required)
        :return: Organization
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['organization_id', 'aliases']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_organization_aliases" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'organization_id' is set
        if self.api_client.client_side_validation and ('organization_id' not in params or
                                                       params['organization_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `organization_id` when calling `add_organization_aliases`")  # noqa: E501
        # verify the required parameter 'aliases' is set
        if self.api_client.client_side_validation and ('aliases' not in params or
                                                       params['aliases'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `aliases` when calling `add_organization_aliases`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_id' in params:
            path_params['organizationId'] = params['organization_id']  # noqa: E501

        query_params = []
        if 'aliases' in params:
            query_params.append(('aliases', params['aliases']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organizationId}/aliases', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Organization',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_user_to_org(self, role, user_id, organization_id, **kwargs):  # noqa: E501
        """Add a user role to an organization.  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_user_to_org(role, user_id, organization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str role: Role of user. (required)
        :param int user_id: User ID of user to add to organization. (required)
        :param int organization_id: Organization ID. (required)
        :param str body: This is here to appease Swagger. It requires PUT methods to have a body, even if it is empty. Please leave it empty.
        :return: OrganizationUser
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_user_to_org_with_http_info(role, user_id, organization_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_user_to_org_with_http_info(role, user_id, organization_id, **kwargs)  # noqa: E501
            return data

    def add_user_to_org_with_http_info(self, role, user_id, organization_id, **kwargs):  # noqa: E501
        """Add a user role to an organization.  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_user_to_org_with_http_info(role, user_id, organization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str role: Role of user. (required)
        :param int user_id: User ID of user to add to organization. (required)
        :param int organization_id: Organization ID. (required)
        :param str body: This is here to appease Swagger. It requires PUT methods to have a body, even if it is empty. Please leave it empty.
        :return: OrganizationUser
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['role', 'user_id', 'organization_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_user_to_org" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'role' is set
        if self.api_client.client_side_validation and ('role' not in params or
                                                       params['role'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `role` when calling `add_user_to_org`")  # noqa: E501
        # verify the required parameter 'user_id' is set
        if self.api_client.client_side_validation and ('user_id' not in params or
                                                       params['user_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `user_id` when calling `add_user_to_org`")  # noqa: E501
        # verify the required parameter 'organization_id' is set
        if self.api_client.client_side_validation and ('organization_id' not in params or
                                                       params['organization_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `organization_id` when calling `add_user_to_org`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_id' in params:
            path_params['organizationId'] = params['organization_id']  # noqa: E501

        query_params = []
        if 'role' in params:
            query_params.append(('role', params['role']))  # noqa: E501
        if 'user_id' in params:
            query_params.append(('userId', params['user_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organizationId}/user', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrganizationUser',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_user_to_org_by_username(self, body, username, organization_id, **kwargs):  # noqa: E501
        """Add a user role to an organization.  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_user_to_org_by_username(body, username, organization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str body: Role of user. (required)
        :param str username: User to add to org. (required)
        :param int organization_id: Organization ID. (required)
        :return: OrganizationUser
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_user_to_org_by_username_with_http_info(body, username, organization_id, **kwargs)  # noqa: E501
        else:
            (data) = self.add_user_to_org_by_username_with_http_info(body, username, organization_id, **kwargs)  # noqa: E501
            return data

    def add_user_to_org_by_username_with_http_info(self, body, username, organization_id, **kwargs):  # noqa: E501
        """Add a user role to an organization.  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_user_to_org_by_username_with_http_info(body, username, organization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str body: Role of user. (required)
        :param str username: User to add to org. (required)
        :param int organization_id: Organization ID. (required)
        :return: OrganizationUser
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'username', 'organization_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_user_to_org_by_username" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `add_user_to_org_by_username`")  # noqa: E501
        # verify the required parameter 'username' is set
        if self.api_client.client_side_validation and ('username' not in params or
                                                       params['username'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `username` when calling `add_user_to_org_by_username`")  # noqa: E501
        # verify the required parameter 'organization_id' is set
        if self.api_client.client_side_validation and ('organization_id' not in params or
                                                       params['organization_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `organization_id` when calling `add_user_to_org_by_username`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'username' in params:
            path_params['username'] = params['username']  # noqa: E501
        if 'organization_id' in params:
            path_params['organizationId'] = params['organization_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organizationId}/users/{username}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrganizationUser',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def approve_organization(self, organization_id, **kwargs):  # noqa: E501
        """Approve an organization.  # noqa: E501

        Admin/curator only  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.approve_organization(organization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int organization_id: Organization ID. (required)
        :return: Organization
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.approve_organization_with_http_info(organization_id, **kwargs)  # noqa: E501
        else:
            (data) = self.approve_organization_with_http_info(organization_id, **kwargs)  # noqa: E501
            return data

    def approve_organization_with_http_info(self, organization_id, **kwargs):  # noqa: E501
        """Approve an organization.  # noqa: E501

        Admin/curator only  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.approve_organization_with_http_info(organization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int organization_id: Organization ID. (required)
        :return: Organization
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['organization_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method approve_organization" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'organization_id' is set
        if self.api_client.client_side_validation and ('organization_id' not in params or
                                                       params['organization_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `organization_id` when calling `approve_organization`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_id' in params:
            path_params['organizationId'] = params['organization_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organizationId}/approve', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Organization',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_collection(self, organization_id, body, **kwargs):  # noqa: E501
        """Create a collection in the given organization.  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_collection(organization_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int organization_id: Organization ID. (required)
        :param Collection body: Collection to register. (required)
        :return: Collection
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_collection_with_http_info(organization_id, body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_collection_with_http_info(organization_id, body, **kwargs)  # noqa: E501
            return data

    def create_collection_with_http_info(self, organization_id, body, **kwargs):  # noqa: E501
        """Create a collection in the given organization.  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_collection_with_http_info(organization_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int organization_id: Organization ID. (required)
        :param Collection body: Collection to register. (required)
        :return: Collection
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['organization_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_collection" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'organization_id' is set
        if self.api_client.client_side_validation and ('organization_id' not in params or
                                                       params['organization_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `organization_id` when calling `create_collection`")  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `create_collection`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_id' in params:
            path_params['organizationId'] = params['organization_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organizationId}/collections', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Collection',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_organization(self, body, **kwargs):  # noqa: E501
        """Create an organization.  # noqa: E501

        Organization requires approval by an admin before being made public.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_organization(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Organization body: Organization to register. (required)
        :return: Organization
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_organization_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_organization_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_organization_with_http_info(self, body, **kwargs):  # noqa: E501
        """Create an organization.  # noqa: E501

        Organization requires approval by an admin before being made public.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_organization_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Organization body: Organization to register. (required)
        :return: Organization
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_organization" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `create_organization`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/organizations', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Organization',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_entry_from_collection(self, organization_id, collection_id, entry_id, **kwargs):  # noqa: E501
        """Delete an entry from a collection.  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_entry_from_collection(organization_id, collection_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int organization_id: Organization ID. (required)
        :param int collection_id: Collection ID. (required)
        :param int entry_id: Entry ID (required)
        :param str version_name: Version ID
        :return: Collection
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_entry_from_collection_with_http_info(organization_id, collection_id, entry_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_entry_from_collection_with_http_info(organization_id, collection_id, entry_id, **kwargs)  # noqa: E501
            return data

    def delete_entry_from_collection_with_http_info(self, organization_id, collection_id, entry_id, **kwargs):  # noqa: E501
        """Delete an entry from a collection.  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_entry_from_collection_with_http_info(organization_id, collection_id, entry_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int organization_id: Organization ID. (required)
        :param int collection_id: Collection ID. (required)
        :param int entry_id: Entry ID (required)
        :param str version_name: Version ID
        :return: Collection
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['organization_id', 'collection_id', 'entry_id', 'version_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_entry_from_collection" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'organization_id' is set
        if self.api_client.client_side_validation and ('organization_id' not in params or
                                                       params['organization_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `organization_id` when calling `delete_entry_from_collection`")  # noqa: E501
        # verify the required parameter 'collection_id' is set
        if self.api_client.client_side_validation and ('collection_id' not in params or
                                                       params['collection_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `collection_id` when calling `delete_entry_from_collection`")  # noqa: E501
        # verify the required parameter 'entry_id' is set
        if self.api_client.client_side_validation and ('entry_id' not in params or
                                                       params['entry_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `entry_id` when calling `delete_entry_from_collection`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_id' in params:
            path_params['organizationId'] = params['organization_id']  # noqa: E501
        if 'collection_id' in params:
            path_params['collectionId'] = params['collection_id']  # noqa: E501

        query_params = []
        if 'entry_id' in params:
            query_params.append(('entryId', params['entry_id']))  # noqa: E501
        if 'version_name' in params:
            query_params.append(('versionName', params['version_name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organizationId}/collections/{collectionId}/entry', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Collection',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_user_role(self, user_id, organization_id, **kwargs):  # noqa: E501
        """Remove a user from an organization.  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_user_role(user_id, organization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int user_id: User ID of user to remove from organization. (required)
        :param int organization_id: Organization ID. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_user_role_with_http_info(user_id, organization_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_user_role_with_http_info(user_id, organization_id, **kwargs)  # noqa: E501
            return data

    def delete_user_role_with_http_info(self, user_id, organization_id, **kwargs):  # noqa: E501
        """Remove a user from an organization.  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_user_role_with_http_info(user_id, organization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int user_id: User ID of user to remove from organization. (required)
        :param int organization_id: Organization ID. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id', 'organization_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_user_role" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'user_id' is set
        if self.api_client.client_side_validation and ('user_id' not in params or
                                                       params['user_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `user_id` when calling `delete_user_role`")  # noqa: E501
        # verify the required parameter 'organization_id' is set
        if self.api_client.client_side_validation and ('organization_id' not in params or
                                                       params['organization_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `organization_id` when calling `delete_user_role`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_id' in params:
            path_params['organizationId'] = params['organization_id']  # noqa: E501

        query_params = []
        if 'user_id' in params:
            query_params.append(('userId', params['user_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organizationId}/user', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_all_organizations(self, type, **kwargs):  # noqa: E501
        """List all organizations.  # noqa: E501

        Admin/curator only  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_organizations(type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str type: Filter to apply to organizations. (required)
        :return: list[Organization]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_all_organizations_with_http_info(type, **kwargs)  # noqa: E501
        else:
            (data) = self.get_all_organizations_with_http_info(type, **kwargs)  # noqa: E501
            return data

    def get_all_organizations_with_http_info(self, type, **kwargs):  # noqa: E501
        """List all organizations.  # noqa: E501

        Admin/curator only  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_organizations_with_http_info(type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str type: Filter to apply to organizations. (required)
        :return: list[Organization]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_organizations" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'type' is set
        if self.api_client.client_side_validation and ('type' not in params or
                                                       params['type'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `type` when calling `get_all_organizations`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'type' in params:
            query_params.append(('type', params['type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/all', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Organization]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_approved_organizations(self, **kwargs):  # noqa: E501
        """List all available organizations.  # noqa: E501

        NO Authentication  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_approved_organizations(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[Organization]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_approved_organizations_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_approved_organizations_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_approved_organizations_with_http_info(self, **kwargs):  # noqa: E501
        """List all available organizations.  # noqa: E501

        NO Authentication  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_approved_organizations_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[Organization]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_approved_organizations" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/organizations', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Organization]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_collection_by_alias(self, alias, **kwargs):  # noqa: E501
        """Retrieve a collection by alias.  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_collection_by_alias(alias, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str alias: Alias of the collection (required)
        :return: Collection
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_collection_by_alias_with_http_info(alias, **kwargs)  # noqa: E501
        else:
            (data) = self.get_collection_by_alias_with_http_info(alias, **kwargs)  # noqa: E501
            return data

    def get_collection_by_alias_with_http_info(self, alias, **kwargs):  # noqa: E501
        """Retrieve a collection by alias.  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_collection_by_alias_with_http_info(alias, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str alias: Alias of the collection (required)
        :return: Collection
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['alias']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_collection_by_alias" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'alias' is set
        if self.api_client.client_side_validation and ('alias' not in params or
                                                       params['alias'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `alias` when calling `get_collection_by_alias`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'alias' in params:
            path_params['alias'] = params['alias']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/organizations/collections/{alias}/aliases', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Collection',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_collection_by_id(self, organization_id, collection_id, **kwargs):  # noqa: E501
        """Retrieve a collection by ID.  # noqa: E501

        Does not require authentication for approved organizations, authentication can be provided for unapproved organizations  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_collection_by_id(organization_id, collection_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int organization_id: Organization ID. (required)
        :param int collection_id: Collection ID. (required)
        :return: Collection
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_collection_by_id_with_http_info(organization_id, collection_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_collection_by_id_with_http_info(organization_id, collection_id, **kwargs)  # noqa: E501
            return data

    def get_collection_by_id_with_http_info(self, organization_id, collection_id, **kwargs):  # noqa: E501
        """Retrieve a collection by ID.  # noqa: E501

        Does not require authentication for approved organizations, authentication can be provided for unapproved organizations  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_collection_by_id_with_http_info(organization_id, collection_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int organization_id: Organization ID. (required)
        :param int collection_id: Collection ID. (required)
        :return: Collection
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['organization_id', 'collection_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_collection_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'organization_id' is set
        if self.api_client.client_side_validation and ('organization_id' not in params or
                                                       params['organization_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `organization_id` when calling `get_collection_by_id`")  # noqa: E501
        # verify the required parameter 'collection_id' is set
        if self.api_client.client_side_validation and ('collection_id' not in params or
                                                       params['collection_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `collection_id` when calling `get_collection_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_id' in params:
            path_params['organizationId'] = params['organization_id']  # noqa: E501
        if 'collection_id' in params:
            path_params['collectionId'] = params['collection_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organizationId}/collections/{collectionId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Collection',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_collection_by_name(self, organization_name, collection_name, **kwargs):  # noqa: E501
        """Retrieve a collection by name.  # noqa: E501

        Does not require authentication for approved organizations, authentication can be provided for unapproved organizations  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_collection_by_name(organization_name, collection_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str organization_name: Organization name. (required)
        :param str collection_name: Collection name. (required)
        :return: Collection
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_collection_by_name_with_http_info(organization_name, collection_name, **kwargs)  # noqa: E501
        else:
            (data) = self.get_collection_by_name_with_http_info(organization_name, collection_name, **kwargs)  # noqa: E501
            return data

    def get_collection_by_name_with_http_info(self, organization_name, collection_name, **kwargs):  # noqa: E501
        """Retrieve a collection by name.  # noqa: E501

        Does not require authentication for approved organizations, authentication can be provided for unapproved organizations  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_collection_by_name_with_http_info(organization_name, collection_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str organization_name: Organization name. (required)
        :param str collection_name: Collection name. (required)
        :return: Collection
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['organization_name', 'collection_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_collection_by_name" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'organization_name' is set
        if self.api_client.client_side_validation and ('organization_name' not in params or
                                                       params['organization_name'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `organization_name` when calling `get_collection_by_name`")  # noqa: E501
        # verify the required parameter 'collection_name' is set
        if self.api_client.client_side_validation and ('collection_name' not in params or
                                                       params['collection_name'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `collection_name` when calling `get_collection_by_name`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_name' in params:
            path_params['organizationName'] = params['organization_name']  # noqa: E501
        if 'collection_name' in params:
            path_params['collectionName'] = params['collection_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organizationName}/collections/{collectionName}/name', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Collection',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_collection_description(self, organization_id, collection_id, **kwargs):  # noqa: E501
        """Retrieve a collection description by organization ID and collection ID.  # noqa: E501

        Does not require authentication for approved organizations, authentication can be provided for unapproved organizations  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_collection_description(organization_id, collection_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int organization_id: Organization ID (required)
        :param int collection_id: Collection ID (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_collection_description_with_http_info(organization_id, collection_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_collection_description_with_http_info(organization_id, collection_id, **kwargs)  # noqa: E501
            return data

    def get_collection_description_with_http_info(self, organization_id, collection_id, **kwargs):  # noqa: E501
        """Retrieve a collection description by organization ID and collection ID.  # noqa: E501

        Does not require authentication for approved organizations, authentication can be provided for unapproved organizations  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_collection_description_with_http_info(organization_id, collection_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int organization_id: Organization ID (required)
        :param int collection_id: Collection ID (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['organization_id', 'collection_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_collection_description" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'organization_id' is set
        if self.api_client.client_side_validation and ('organization_id' not in params or
                                                       params['organization_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `organization_id` when calling `get_collection_description`")  # noqa: E501
        # verify the required parameter 'collection_id' is set
        if self.api_client.client_side_validation and ('collection_id' not in params or
                                                       params['collection_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `collection_id` when calling `get_collection_description`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_id' in params:
            path_params['organizationId'] = params['organization_id']  # noqa: E501
        if 'collection_id' in params:
            path_params['collectionId'] = params['collection_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organizationId}/collections/{collectionId}/description', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_collections_from_organization(self, organization_id, **kwargs):  # noqa: E501
        """Retrieve all collections for an organization.  # noqa: E501

        Does not require authentication for approved organizations, authentication can be provided for unapproved organizations  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_collections_from_organization(organization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int organization_id: Organization ID. (required)
        :param str include: Included fields
        :return: list[Collection]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_collections_from_organization_with_http_info(organization_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_collections_from_organization_with_http_info(organization_id, **kwargs)  # noqa: E501
            return data

    def get_collections_from_organization_with_http_info(self, organization_id, **kwargs):  # noqa: E501
        """Retrieve all collections for an organization.  # noqa: E501

        Does not require authentication for approved organizations, authentication can be provided for unapproved organizations  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_collections_from_organization_with_http_info(organization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int organization_id: Organization ID. (required)
        :param str include: Included fields
        :return: list[Collection]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['organization_id', 'include']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_collections_from_organization" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'organization_id' is set
        if self.api_client.client_side_validation and ('organization_id' not in params or
                                                       params['organization_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `organization_id` when calling `get_collections_from_organization`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_id' in params:
            path_params['organizationId'] = params['organization_id']  # noqa: E501

        query_params = []
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organizationId}/collections', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Collection]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_organization_by_alias(self, alias, **kwargs):  # noqa: E501
        """Retrieve an organization by alias.  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_organization_by_alias(alias, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str alias: Alias. (required)
        :return: Organization
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_organization_by_alias_with_http_info(alias, **kwargs)  # noqa: E501
        else:
            (data) = self.get_organization_by_alias_with_http_info(alias, **kwargs)  # noqa: E501
            return data

    def get_organization_by_alias_with_http_info(self, alias, **kwargs):  # noqa: E501
        """Retrieve an organization by alias.  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_organization_by_alias_with_http_info(alias, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str alias: Alias. (required)
        :return: Organization
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['alias']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_organization_by_alias" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'alias' is set
        if self.api_client.client_side_validation and ('alias' not in params or
                                                       params['alias'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `alias` when calling `get_organization_by_alias`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'alias' in params:
            path_params['alias'] = params['alias']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{alias}/aliases', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Organization',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_organization_by_id(self, organization_id, **kwargs):  # noqa: E501
        """Retrieve an organization by ID.  # noqa: E501

        Does not require authentication for approved organizations, authentication can be provided for unapproved organizations  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_organization_by_id(organization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int organization_id: Organization ID. (required)
        :return: Organization
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_organization_by_id_with_http_info(organization_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_organization_by_id_with_http_info(organization_id, **kwargs)  # noqa: E501
            return data

    def get_organization_by_id_with_http_info(self, organization_id, **kwargs):  # noqa: E501
        """Retrieve an organization by ID.  # noqa: E501

        Does not require authentication for approved organizations, authentication can be provided for unapproved organizations  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_organization_by_id_with_http_info(organization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int organization_id: Organization ID. (required)
        :return: Organization
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['organization_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_organization_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'organization_id' is set
        if self.api_client.client_side_validation and ('organization_id' not in params or
                                                       params['organization_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `organization_id` when calling `get_organization_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_id' in params:
            path_params['organizationId'] = params['organization_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organizationId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Organization',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_organization_by_name(self, name, **kwargs):  # noqa: E501
        """Retrieve an organization by name.  # noqa: E501

        Does not require authentication for approved organizations, authentication can be provided for unapproved organizations  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_organization_by_name(name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Organization name. (required)
        :return: Organization
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_organization_by_name_with_http_info(name, **kwargs)  # noqa: E501
        else:
            (data) = self.get_organization_by_name_with_http_info(name, **kwargs)  # noqa: E501
            return data

    def get_organization_by_name_with_http_info(self, name, **kwargs):  # noqa: E501
        """Retrieve an organization by name.  # noqa: E501

        Does not require authentication for approved organizations, authentication can be provided for unapproved organizations  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_organization_by_name_with_http_info(name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str name: Organization name. (required)
        :return: Organization
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_organization_by_name" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if self.api_client.client_side_validation and ('name' not in params or
                                                       params['name'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `name` when calling `get_organization_by_name`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'name' in params:
            path_params['name'] = params['name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/name/{name}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Organization',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_organization_description(self, organization_id, **kwargs):  # noqa: E501
        """Retrieve an organization description by organization ID.  # noqa: E501

        Does not require authentication for approved organizations, authentication can be provided for unapproved organizations  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_organization_description(organization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int organization_id: Organization ID. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_organization_description_with_http_info(organization_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_organization_description_with_http_info(organization_id, **kwargs)  # noqa: E501
            return data

    def get_organization_description_with_http_info(self, organization_id, **kwargs):  # noqa: E501
        """Retrieve an organization description by organization ID.  # noqa: E501

        Does not require authentication for approved organizations, authentication can be provided for unapproved organizations  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_organization_description_with_http_info(organization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int organization_id: Organization ID. (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['organization_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_organization_description" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'organization_id' is set
        if self.api_client.client_side_validation and ('organization_id' not in params or
                                                       params['organization_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `organization_id` when calling `get_organization_description`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_id' in params:
            path_params['organizationId'] = params['organization_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organizationId}/description', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_organization_events(self, organization_id, **kwargs):  # noqa: E501
        """Retrieve all events for an organization.  # noqa: E501

        Does not require authentication for approved organizations, authentication can be provided for unapproved organizations  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_organization_events(organization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int organization_id: Organization ID. (required)
        :param int offset: Start index of paging.  If this exceeds the current result set return an empty set.  If not specified in the request, this will start at the beginning of the results.
        :param int limit: Amount of records to return in a given page, limited to 100
        :return: list[Event]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_organization_events_with_http_info(organization_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_organization_events_with_http_info(organization_id, **kwargs)  # noqa: E501
            return data

    def get_organization_events_with_http_info(self, organization_id, **kwargs):  # noqa: E501
        """Retrieve all events for an organization.  # noqa: E501

        Does not require authentication for approved organizations, authentication can be provided for unapproved organizations  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_organization_events_with_http_info(organization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int organization_id: Organization ID. (required)
        :param int offset: Start index of paging.  If this exceeds the current result set return an empty set.  If not specified in the request, this will start at the beginning of the results.
        :param int limit: Amount of records to return in a given page, limited to 100
        :return: list[Event]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['organization_id', 'offset', 'limit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_organization_events" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'organization_id' is set
        if self.api_client.client_side_validation and ('organization_id' not in params or
                                                       params['organization_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `organization_id` when calling `get_organization_events`")  # noqa: E501

        if self.api_client.client_side_validation and ('limit' in params and params['limit'] > 100):  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_organization_events`, must be a value less than or equal to `100`")  # noqa: E501
        if self.api_client.client_side_validation and ('limit' in params and params['limit'] < 1):  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_organization_events`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'organization_id' in params:
            path_params['organizationId'] = params['organization_id']  # noqa: E501

        query_params = []
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organizationId}/events', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Event]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_organization_members(self, organization_id, **kwargs):  # noqa: E501
        """Retrieve all members for an organization.  # noqa: E501

        Does not require authentication for approved organizations, authentication can be provided for unapproved organizations  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_organization_members(organization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int organization_id: Organization ID. (required)
        :return: list[OrganizationUser]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_organization_members_with_http_info(organization_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_organization_members_with_http_info(organization_id, **kwargs)  # noqa: E501
            return data

    def get_organization_members_with_http_info(self, organization_id, **kwargs):  # noqa: E501
        """Retrieve all members for an organization.  # noqa: E501

        Does not require authentication for approved organizations, authentication can be provided for unapproved organizations  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_organization_members_with_http_info(organization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int organization_id: Organization ID. (required)
        :return: list[OrganizationUser]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['organization_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_organization_members" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'organization_id' is set
        if self.api_client.client_side_validation and ('organization_id' not in params or
                                                       params['organization_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `organization_id` when calling `get_organization_members`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_id' in params:
            path_params['organizationId'] = params['organization_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organizationId}/members', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[OrganizationUser]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_starred_users_for_approved_organization(self, organization_id, **kwargs):  # noqa: E501
        """Return list of users who starred the given approved organization.  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_starred_users_for_approved_organization(organization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int organization_id: Organization ID. (required)
        :return: list[User]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_starred_users_for_approved_organization_with_http_info(organization_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_starred_users_for_approved_organization_with_http_info(organization_id, **kwargs)  # noqa: E501
            return data

    def get_starred_users_for_approved_organization_with_http_info(self, organization_id, **kwargs):  # noqa: E501
        """Return list of users who starred the given approved organization.  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_starred_users_for_approved_organization_with_http_info(organization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int organization_id: Organization ID. (required)
        :return: list[User]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['organization_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_starred_users_for_approved_organization" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'organization_id' is set
        if self.api_client.client_side_validation and ('organization_id' not in params or
                                                       params['organization_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `organization_id` when calling `get_starred_users_for_approved_organization`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_id' in params:
            path_params['organizationId'] = params['organization_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organizationId}/starredUsers', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[User]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def reject_organization(self, organization_id, **kwargs):  # noqa: E501
        """Reject an organization.  # noqa: E501

        Admin/curator only  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.reject_organization(organization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int organization_id: Organization ID. (required)
        :return: Organization
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.reject_organization_with_http_info(organization_id, **kwargs)  # noqa: E501
        else:
            (data) = self.reject_organization_with_http_info(organization_id, **kwargs)  # noqa: E501
            return data

    def reject_organization_with_http_info(self, organization_id, **kwargs):  # noqa: E501
        """Reject an organization.  # noqa: E501

        Admin/curator only  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.reject_organization_with_http_info(organization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int organization_id: Organization ID. (required)
        :return: Organization
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['organization_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method reject_organization" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'organization_id' is set
        if self.api_client.client_side_validation and ('organization_id' not in params or
                                                       params['organization_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `organization_id` when calling `reject_organization`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_id' in params:
            path_params['organizationId'] = params['organization_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organizationId}/reject', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Organization',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def request_organization_review(self, organization_id, **kwargs):  # noqa: E501
        """Re-request an organization approval.  # noqa: E501

        Only for rejected organizations  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.request_organization_review(organization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int organization_id: Organization ID. (required)
        :return: Organization
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.request_organization_review_with_http_info(organization_id, **kwargs)  # noqa: E501
        else:
            (data) = self.request_organization_review_with_http_info(organization_id, **kwargs)  # noqa: E501
            return data

    def request_organization_review_with_http_info(self, organization_id, **kwargs):  # noqa: E501
        """Re-request an organization approval.  # noqa: E501

        Only for rejected organizations  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.request_organization_review_with_http_info(organization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int organization_id: Organization ID. (required)
        :return: Organization
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['organization_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method request_organization_review" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'organization_id' is set
        if self.api_client.client_side_validation and ('organization_id' not in params or
                                                       params['organization_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `organization_id` when calling `request_organization_review`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_id' in params:
            path_params['organizationId'] = params['organization_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organizationId}/request', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Organization',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def star_organization(self, organization_id, body, **kwargs):  # noqa: E501
        """Star an organization.  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.star_organization(organization_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int organization_id: Organization ID. (required)
        :param StarRequest body: StarRequest to star an organization for a user. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.star_organization_with_http_info(organization_id, body, **kwargs)  # noqa: E501
        else:
            (data) = self.star_organization_with_http_info(organization_id, body, **kwargs)  # noqa: E501
            return data

    def star_organization_with_http_info(self, organization_id, body, **kwargs):  # noqa: E501
        """Star an organization.  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.star_organization_with_http_info(organization_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int organization_id: Organization ID. (required)
        :param StarRequest body: StarRequest to star an organization for a user. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['organization_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method star_organization" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'organization_id' is set
        if self.api_client.client_side_validation and ('organization_id' not in params or
                                                       params['organization_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `organization_id` when calling `star_organization`")  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `star_organization`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_id' in params:
            path_params['organizationId'] = params['organization_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organizationId}/star', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_collection(self, body, organization_id, collection_id, **kwargs):  # noqa: E501
        """Update a collection.  # noqa: E501

        Currently only name, display name, description, and topic can be updated.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_collection(body, organization_id, collection_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Collection body: Collection to update with. (required)
        :param int organization_id: Organization ID. (required)
        :param int collection_id: Collection ID. (required)
        :return: Collection
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_collection_with_http_info(body, organization_id, collection_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_collection_with_http_info(body, organization_id, collection_id, **kwargs)  # noqa: E501
            return data

    def update_collection_with_http_info(self, body, organization_id, collection_id, **kwargs):  # noqa: E501
        """Update a collection.  # noqa: E501

        Currently only name, display name, description, and topic can be updated.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_collection_with_http_info(body, organization_id, collection_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Collection body: Collection to update with. (required)
        :param int organization_id: Organization ID. (required)
        :param int collection_id: Collection ID. (required)
        :return: Collection
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'organization_id', 'collection_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_collection" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `update_collection`")  # noqa: E501
        # verify the required parameter 'organization_id' is set
        if self.api_client.client_side_validation and ('organization_id' not in params or
                                                       params['organization_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `organization_id` when calling `update_collection`")  # noqa: E501
        # verify the required parameter 'collection_id' is set
        if self.api_client.client_side_validation and ('collection_id' not in params or
                                                       params['collection_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `collection_id` when calling `update_collection`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_id' in params:
            path_params['organizationId'] = params['organization_id']  # noqa: E501
        if 'collection_id' in params:
            path_params['collectionId'] = params['collection_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organizationId}/collections/{collectionId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Collection',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_collection_description(self, organization_id, collection_id, body, **kwargs):  # noqa: E501
        """Update a collection's description.  # noqa: E501

        Description in markdown  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_collection_description(organization_id, collection_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int organization_id: Organization ID. (required)
        :param int collection_id: Collection ID. (required)
        :param str body: Collections's description in markdown. (required)
        :return: Collection
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_collection_description_with_http_info(organization_id, collection_id, body, **kwargs)  # noqa: E501
        else:
            (data) = self.update_collection_description_with_http_info(organization_id, collection_id, body, **kwargs)  # noqa: E501
            return data

    def update_collection_description_with_http_info(self, organization_id, collection_id, body, **kwargs):  # noqa: E501
        """Update a collection's description.  # noqa: E501

        Description in markdown  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_collection_description_with_http_info(organization_id, collection_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int organization_id: Organization ID. (required)
        :param int collection_id: Collection ID. (required)
        :param str body: Collections's description in markdown. (required)
        :return: Collection
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['organization_id', 'collection_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_collection_description" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'organization_id' is set
        if self.api_client.client_side_validation and ('organization_id' not in params or
                                                       params['organization_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `organization_id` when calling `update_collection_description`")  # noqa: E501
        # verify the required parameter 'collection_id' is set
        if self.api_client.client_side_validation and ('collection_id' not in params or
                                                       params['collection_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `collection_id` when calling `update_collection_description`")  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `update_collection_description`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_id' in params:
            path_params['organizationId'] = params['organization_id']  # noqa: E501
        if 'collection_id' in params:
            path_params['collectionId'] = params['collection_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organizationId}/collections/{collectionId}/description', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Collection',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_organization(self, body, organization_id, **kwargs):  # noqa: E501
        """Update an organization.  # noqa: E501

        Currently only name, display name, description, topic, email, link, avatarUrl, and location can be updated.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_organization(body, organization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Organization body: Organization to update with. (required)
        :param int organization_id: Organization ID. (required)
        :return: Organization
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_organization_with_http_info(body, organization_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_organization_with_http_info(body, organization_id, **kwargs)  # noqa: E501
            return data

    def update_organization_with_http_info(self, body, organization_id, **kwargs):  # noqa: E501
        """Update an organization.  # noqa: E501

        Currently only name, display name, description, topic, email, link, avatarUrl, and location can be updated.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_organization_with_http_info(body, organization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Organization body: Organization to update with. (required)
        :param int organization_id: Organization ID. (required)
        :return: Organization
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'organization_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_organization" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `update_organization`")  # noqa: E501
        # verify the required parameter 'organization_id' is set
        if self.api_client.client_side_validation and ('organization_id' not in params or
                                                       params['organization_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `organization_id` when calling `update_organization`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_id' in params:
            path_params['organizationId'] = params['organization_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organizationId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Organization',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_organization_description(self, organization_id, body, **kwargs):  # noqa: E501
        """Update an organization's description.  # noqa: E501

        Description in markdown  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_organization_description(organization_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int organization_id: Organization ID. (required)
        :param str body: Organization's description in markdown. (required)
        :return: Organization
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_organization_description_with_http_info(organization_id, body, **kwargs)  # noqa: E501
        else:
            (data) = self.update_organization_description_with_http_info(organization_id, body, **kwargs)  # noqa: E501
            return data

    def update_organization_description_with_http_info(self, organization_id, body, **kwargs):  # noqa: E501
        """Update an organization's description.  # noqa: E501

        Description in markdown  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_organization_description_with_http_info(organization_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int organization_id: Organization ID. (required)
        :param str body: Organization's description in markdown. (required)
        :return: Organization
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['organization_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_organization_description" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'organization_id' is set
        if self.api_client.client_side_validation and ('organization_id' not in params or
                                                       params['organization_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `organization_id` when calling `update_organization_description`")  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `update_organization_description`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_id' in params:
            path_params['organizationId'] = params['organization_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organizationId}/description', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Organization',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_user_role(self, role, user_id, organization_id, **kwargs):  # noqa: E501
        """Update a user role in an organization.  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_user_role(role, user_id, organization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str role: Role of user. (required)
        :param int user_id: User ID of user to update within organization. (required)
        :param int organization_id: Organization ID. (required)
        :return: OrganizationUser
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_user_role_with_http_info(role, user_id, organization_id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_user_role_with_http_info(role, user_id, organization_id, **kwargs)  # noqa: E501
            return data

    def update_user_role_with_http_info(self, role, user_id, organization_id, **kwargs):  # noqa: E501
        """Update a user role in an organization.  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_user_role_with_http_info(role, user_id, organization_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str role: Role of user. (required)
        :param int user_id: User ID of user to update within organization. (required)
        :param int organization_id: Organization ID. (required)
        :return: OrganizationUser
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['role', 'user_id', 'organization_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_user_role" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'role' is set
        if self.api_client.client_side_validation and ('role' not in params or
                                                       params['role'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `role` when calling `update_user_role`")  # noqa: E501
        # verify the required parameter 'user_id' is set
        if self.api_client.client_side_validation and ('user_id' not in params or
                                                       params['user_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `user_id` when calling `update_user_role`")  # noqa: E501
        # verify the required parameter 'organization_id' is set
        if self.api_client.client_side_validation and ('organization_id' not in params or
                                                       params['organization_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `organization_id` when calling `update_user_role`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization_id' in params:
            path_params['organizationId'] = params['organization_id']  # noqa: E501

        query_params = []
        if 'role' in params:
            query_params.append(('role', params['role']))  # noqa: E501
        if 'user_id' in params:
            query_params.append(('userId', params['user_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/organizations/{organizationId}/user', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='OrganizationUser',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
