# coding: utf-8

"""
    Dockstore API

    This describes the dockstore API, a webservice that manages pairs of Docker images and associated metadata such as CWL documents and Dockerfiles used to build those images. Explore swagger.json for a Swagger 2.0 description of our API and explore openapi.yaml for OpenAPI 3.0 descriptions.  # noqa: E501

    OpenAPI spec version: 1.12.0-alpha.1-SNAPSHOT
    Contact: theglobalalliance@genomicsandhealth.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from jgreenepack.api_client import ApiClient


class TokensApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_bitbucket_token(self, **kwargs):  # noqa: E501
        """Add a new bitbucket.org token, used by quay.io redirect.  # noqa: E501

        This is used as part of the OAuth 2 web flow. Once a user has approved permissions for CollaboratoryTheir browser will load the redirect URI which should resolve here  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_bitbucket_token(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str code:
        :return: TokenUser
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_bitbucket_token_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.add_bitbucket_token_with_http_info(**kwargs)  # noqa: E501
            return data

    def add_bitbucket_token_with_http_info(self, **kwargs):  # noqa: E501
        """Add a new bitbucket.org token, used by quay.io redirect.  # noqa: E501

        This is used as part of the OAuth 2 web flow. Once a user has approved permissions for CollaboratoryTheir browser will load the redirect URI which should resolve here  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_bitbucket_token_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str code:
        :return: TokenUser
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_bitbucket_token" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'code' in params:
            query_params.append(('code', params['code']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/auth/tokens/bitbucket.org', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TokenUser',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_github_token(self, **kwargs):  # noqa: E501
        """Add a new github.com token, used by accounts page.  # noqa: E501

        This is used as part of the OAuth 2 web flow. Once a user has approved permissions for CollaboratoryTheir browser will load the redirect URI which should resolve here  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_github_token(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str code:
        :return: TokenUser
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_github_token_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.add_github_token_with_http_info(**kwargs)  # noqa: E501
            return data

    def add_github_token_with_http_info(self, **kwargs):  # noqa: E501
        """Add a new github.com token, used by accounts page.  # noqa: E501

        This is used as part of the OAuth 2 web flow. Once a user has approved permissions for CollaboratoryTheir browser will load the redirect URI which should resolve here  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_github_token_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str code:
        :return: TokenUser
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_github_token" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'code' in params:
            query_params.append(('code', params['code']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/auth/tokens/github.com', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TokenUser',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_gitlab_token(self, **kwargs):  # noqa: E501
        """Add a new gitlab.com token.  # noqa: E501

        This is used as part of the OAuth 2 web flow. Once a user has approved permissions for CollaboratoryTheir browser will load the redirect URI which should resolve here  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_gitlab_token(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str code:
        :return: TokenUser
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_gitlab_token_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.add_gitlab_token_with_http_info(**kwargs)  # noqa: E501
            return data

    def add_gitlab_token_with_http_info(self, **kwargs):  # noqa: E501
        """Add a new gitlab.com token.  # noqa: E501

        This is used as part of the OAuth 2 web flow. Once a user has approved permissions for CollaboratoryTheir browser will load the redirect URI which should resolve here  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_gitlab_token_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str code:
        :return: TokenUser
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_gitlab_token" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'code' in params:
            query_params.append(('code', params['code']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/auth/tokens/gitlab.com', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TokenUser',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_google_token(self, **kwargs):  # noqa: E501
        """Allow satellizer to post a new Google token to Dockstore.  # noqa: E501

        A post method is required by satellizer to send the Google token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_google_token(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str body: code
        :return: TokenAuth
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_google_token_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.add_google_token_with_http_info(**kwargs)  # noqa: E501
            return data

    def add_google_token_with_http_info(self, **kwargs):  # noqa: E501
        """Allow satellizer to post a new Google token to Dockstore.  # noqa: E501

        A post method is required by satellizer to send the Google token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_google_token_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str body: code
        :return: TokenAuth
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_google_token" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/auth/tokens/google', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TokenAuth',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_orcid_token(self, **kwargs):  # noqa: E501
        """Add a new orcid.org token  # noqa: E501

        Using OAuth code from ORCID, request and store tokens from ORCID API  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_orcid_token(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str code:
        :return: TokenUser
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_orcid_token_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.add_orcid_token_with_http_info(**kwargs)  # noqa: E501
            return data

    def add_orcid_token_with_http_info(self, **kwargs):  # noqa: E501
        """Add a new orcid.org token  # noqa: E501

        Using OAuth code from ORCID, request and store tokens from ORCID API  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_orcid_token_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str code:
        :return: TokenUser
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_orcid_token" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'code' in params:
            query_params.append(('code', params['code']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/auth/tokens/orcid.org', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TokenUser',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_quay_token(self, **kwargs):  # noqa: E501
        """Add a new Quay.io token.  # noqa: E501

        This is used as part of the OAuth 2 web flow. Once a user has approved permissions for CollaboratoryTheir browser will load the redirect URI which should resolve here  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_quay_token(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str access_token:
        :return: TokenUser
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_quay_token_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.add_quay_token_with_http_info(**kwargs)  # noqa: E501
            return data

    def add_quay_token_with_http_info(self, **kwargs):  # noqa: E501
        """Add a new Quay.io token.  # noqa: E501

        This is used as part of the OAuth 2 web flow. Once a user has approved permissions for CollaboratoryTheir browser will load the redirect URI which should resolve here  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_quay_token_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str access_token:
        :return: TokenUser
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['access_token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_quay_token" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'access_token' in params:
            query_params.append(('access_token', params['access_token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/auth/tokens/quay.io', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TokenUser',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_token(self, **kwargs):  # noqa: E501
        """Allow satellizer to post a new GitHub token to dockstore, used by login, can create new users.  # noqa: E501

        A post method is required by satellizer to send the GitHub token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_token(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str body: code
        :return: TokenAuth
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_token_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.add_token_with_http_info(**kwargs)  # noqa: E501
            return data

    def add_token_with_http_info(self, **kwargs):  # noqa: E501
        """Allow satellizer to post a new GitHub token to dockstore, used by login, can create new users.  # noqa: E501

        A post method is required by satellizer to send the GitHub token  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_token_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str body: code
        :return: TokenAuth
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_token" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/auth/tokens/github', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TokenAuth',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_zenodo_token(self, **kwargs):  # noqa: E501
        """Add a new zenodo.org token, used by accounts page.  # noqa: E501

        This is used as part of the OAuth 2 web flow. Once a user has approved permissions for CollaboratoryTheir browser will load the redirect URI which should resolve here  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_zenodo_token(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str code:
        :return: TokenUser
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_zenodo_token_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.add_zenodo_token_with_http_info(**kwargs)  # noqa: E501
            return data

    def add_zenodo_token_with_http_info(self, **kwargs):  # noqa: E501
        """Add a new zenodo.org token, used by accounts page.  # noqa: E501

        This is used as part of the OAuth 2 web flow. Once a user has approved permissions for CollaboratoryTheir browser will load the redirect URI which should resolve here  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_zenodo_token_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str code:
        :return: TokenUser
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['code']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_zenodo_token" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'code' in params:
            query_params.append(('code', params['code']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/auth/tokens/zenodo.org', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TokenUser',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_token(self, token_id, **kwargs):  # noqa: E501
        """Delete a token.  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_token(token_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int token_id: Token id to delete (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_token_with_http_info(token_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_token_with_http_info(token_id, **kwargs)  # noqa: E501
            return data

    def delete_token_with_http_info(self, token_id, **kwargs):  # noqa: E501
        """Delete a token.  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_token_with_http_info(token_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int token_id: Token id to delete (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['token_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_token" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'token_id' is set
        if self.api_client.client_side_validation and ('token_id' not in params or
                                                       params['token_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `token_id` when calling `delete_token`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'token_id' in params:
            path_params['tokenId'] = params['token_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/auth/tokens/{tokenId}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_token(self, token_id, **kwargs):  # noqa: E501
        """Get information about a specific token by id.  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_token(token_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int token_id: ID of token to return (required)
        :return: TokenUser
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_token_with_http_info(token_id, **kwargs)  # noqa: E501
        else:
            (data) = self.list_token_with_http_info(token_id, **kwargs)  # noqa: E501
            return data

    def list_token_with_http_info(self, token_id, **kwargs):  # noqa: E501
        """Get information about a specific token by id.  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_token_with_http_info(token_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int token_id: ID of token to return (required)
        :return: TokenUser
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['token_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_token" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'token_id' is set
        if self.api_client.client_side_validation and ('token_id' not in params or
                                                       params['token_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `token_id` when calling `list_token`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'token_id' in params:
            path_params['tokenId'] = params['token_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/auth/tokens/{tokenId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TokenUser',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
