# coding: utf-8

"""
    Dockstore API

    This describes the dockstore API, a webservice that manages pairs of Docker images and associated metadata such as CWL documents and Dockerfiles used to build those images. Explore swagger.json for a Swagger 2.0 description of our API and explore openapi.yaml for OpenAPI 3.0 descriptions.  # noqa: E501

    OpenAPI spec version: 1.12.0-alpha.1-SNAPSHOT
    Contact: theglobalalliance@genomicsandhealth.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from jgreenepack.api_client import ApiClient


class ToolTesterApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_tool_tester_log(self, **kwargs):  # noqa: E501
        """get_tool_tester_log  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tool_tester_log(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str tool_id:
        :param str tool_version_name:
        :param str test_filename:
        :param str runner:
        :param str log_type:
        :param str filename:
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_tool_tester_log_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_tool_tester_log_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_tool_tester_log_with_http_info(self, **kwargs):  # noqa: E501
        """get_tool_tester_log  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_tool_tester_log_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str tool_id:
        :param str tool_version_name:
        :param str test_filename:
        :param str runner:
        :param str log_type:
        :param str filename:
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['tool_id', 'tool_version_name', 'test_filename', 'runner', 'log_type', 'filename']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_tool_tester_log" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'tool_id' in params:
            query_params.append(('tool_id', params['tool_id']))  # noqa: E501
        if 'tool_version_name' in params:
            query_params.append(('tool_version_name', params['tool_version_name']))  # noqa: E501
        if 'test_filename' in params:
            query_params.append(('test_filename', params['test_filename']))  # noqa: E501
        if 'runner' in params:
            query_params.append(('runner', params['runner']))  # noqa: E501
        if 'log_type' in params:
            query_params.append(('log_type', params['log_type']))  # noqa: E501
        if 'filename' in params:
            query_params.append(('filename', params['filename']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/toolTester/logs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search(self, **kwargs):  # noqa: E501
        """search  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str tool_id:
        :param str tool_version_name:
        :return: list[ToolTesterLog]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.search_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.search_with_http_info(**kwargs)  # noqa: E501
            return data

    def search_with_http_info(self, **kwargs):  # noqa: E501
        """search  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.search_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str tool_id:
        :param str tool_version_name:
        :return: list[ToolTesterLog]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['tool_id', 'tool_version_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'tool_id' in params:
            query_params.append(('tool_id', params['tool_id']))  # noqa: E501
        if 'tool_version_name' in params:
            query_params.append(('tool_version_name', params['tool_version_name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/toolTester/logs/search', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ToolTesterLog]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
