# coding: utf-8

"""
    Dockstore API

    This describes the dockstore API, a webservice that manages pairs of Docker images and associated metadata such as CWL documents and Dockerfiles used to build those images. Explore swagger.json for a Swagger 2.0 description of our API and explore openapi.yaml for OpenAPI 3.0 descriptions.  # noqa: E501

    OpenAPI spec version: 1.12.0-alpha.1-SNAPSHOT
    Contact: theglobalalliance@genomicsandhealth.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from jgreenepack.api_client import ApiClient


class WorkflowsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_test_parameter_files(self, workflow_id, test_parameter_paths, **kwargs):  # noqa: E501
        """Add test parameter files for a given version.  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_test_parameter_files(workflow_id, test_parameter_paths, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int workflow_id: Workflow to modify. (required)
        :param list[str] test_parameter_paths: List of paths. (required)
        :param str body: This is here to appease Swagger. It requires PUT methods to have a body, even if it is empty. Please leave it empty.
        :param str version:
        :return: list[SourceFile]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_test_parameter_files_with_http_info(workflow_id, test_parameter_paths, **kwargs)  # noqa: E501
        else:
            (data) = self.add_test_parameter_files_with_http_info(workflow_id, test_parameter_paths, **kwargs)  # noqa: E501
            return data

    def add_test_parameter_files_with_http_info(self, workflow_id, test_parameter_paths, **kwargs):  # noqa: E501
        """Add test parameter files for a given version.  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_test_parameter_files_with_http_info(workflow_id, test_parameter_paths, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int workflow_id: Workflow to modify. (required)
        :param list[str] test_parameter_paths: List of paths. (required)
        :param str body: This is here to appease Swagger. It requires PUT methods to have a body, even if it is empty. Please leave it empty.
        :param str version:
        :return: list[SourceFile]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workflow_id', 'test_parameter_paths', 'body', 'version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_test_parameter_files" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workflow_id' is set
        if self.api_client.client_side_validation and ('workflow_id' not in params or
                                                       params['workflow_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `workflow_id` when calling `add_test_parameter_files`")  # noqa: E501
        # verify the required parameter 'test_parameter_paths' is set
        if self.api_client.client_side_validation and ('test_parameter_paths' not in params or
                                                       params['test_parameter_paths'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `test_parameter_paths` when calling `add_test_parameter_files`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workflow_id' in params:
            path_params['workflowId'] = params['workflow_id']  # noqa: E501

        query_params = []
        if 'test_parameter_paths' in params:
            query_params.append(('testParameterPaths', params['test_parameter_paths']))  # noqa: E501
            collection_formats['testParameterPaths'] = 'multi'  # noqa: E501
        if 'version' in params:
            query_params.append(('version', params['version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/workflows/{workflowId}/testParameterFiles', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[SourceFile]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_workflow(self, git_registry, organization, repository_name, **kwargs):  # noqa: E501
        """See OpenApi for details  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_workflow(git_registry, organization, repository_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str git_registry: (required)
        :param str organization: (required)
        :param str repository_name: (required)
        :return: BioWorkflow
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_workflow_with_http_info(git_registry, organization, repository_name, **kwargs)  # noqa: E501
        else:
            (data) = self.add_workflow_with_http_info(git_registry, organization, repository_name, **kwargs)  # noqa: E501
            return data

    def add_workflow_with_http_info(self, git_registry, organization, repository_name, **kwargs):  # noqa: E501
        """See OpenApi for details  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_workflow_with_http_info(git_registry, organization, repository_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str git_registry: (required)
        :param str organization: (required)
        :param str repository_name: (required)
        :return: BioWorkflow
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['git_registry', 'organization', 'repository_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_workflow" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'git_registry' is set
        if self.api_client.client_side_validation and ('git_registry' not in params or
                                                       params['git_registry'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `git_registry` when calling `add_workflow`")  # noqa: E501
        # verify the required parameter 'organization' is set
        if self.api_client.client_side_validation and ('organization' not in params or
                                                       params['organization'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `organization` when calling `add_workflow`")  # noqa: E501
        # verify the required parameter 'repository_name' is set
        if self.api_client.client_side_validation and ('repository_name' not in params or
                                                       params['repository_name'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `repository_name` when calling `add_workflow`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'git_registry' in params:
            path_params['gitRegistry'] = params['git_registry']  # noqa: E501
        if 'organization' in params:
            path_params['organization'] = params['organization']  # noqa: E501
        if 'repository_name' in params:
            path_params['repositoryName'] = params['repository_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/workflows/registries/{gitRegistry}/organizations/{organization}/repositories/{repositoryName}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BioWorkflow',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def add_workflow_permission(self, repository, body, **kwargs):  # noqa: E501
        """Set the specified permission for a user on a workflow.  # noqa: E501

        The user must be the workflow owner. Currently only supported on hosted workflows.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_workflow_permission(repository, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repository: repository path (required)
        :param Permission body: user permission (required)
        :param bool services: services
        :return: list[Permission]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_workflow_permission_with_http_info(repository, body, **kwargs)  # noqa: E501
        else:
            (data) = self.add_workflow_permission_with_http_info(repository, body, **kwargs)  # noqa: E501
            return data

    def add_workflow_permission_with_http_info(self, repository, body, **kwargs):  # noqa: E501
        """Set the specified permission for a user on a workflow.  # noqa: E501

        The user must be the workflow owner. Currently only supported on hosted workflows.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_workflow_permission_with_http_info(repository, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repository: repository path (required)
        :param Permission body: user permission (required)
        :param bool services: services
        :return: list[Permission]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['repository', 'body', 'services']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_workflow_permission" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'repository' is set
        if self.api_client.client_side_validation and ('repository' not in params or
                                                       params['repository'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `repository` when calling `add_workflow_permission`")  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `add_workflow_permission`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'repository' in params:
            path_params['repository'] = params['repository']  # noqa: E501

        query_params = []
        if 'services' in params:
            query_params.append(('services', params['services']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/workflows/path/workflow/{repository}/permissions', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Permission]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def all_published_workflows(self, **kwargs):  # noqa: E501
        """List all published workflows.  # noqa: E501

        NO authentication  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.all_published_workflows(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str offset: Start index of paging. Pagination results can be based on numbers or other values chosen by the registry implementor (for example, SHA values). If this exceeds the current result set return an empty set.  If not specified in the request, this will start at the beginning of the results.
        :param int limit: Amount of records to return in a given page, limited to 100
        :param str filter: Filter, this is a search string that filters the results.
        :param str sort_col: Sort column
        :param str sort_order: Sort order
        :param bool services: services
        :return: list[Workflow]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.all_published_workflows_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.all_published_workflows_with_http_info(**kwargs)  # noqa: E501
            return data

    def all_published_workflows_with_http_info(self, **kwargs):  # noqa: E501
        """List all published workflows.  # noqa: E501

        NO authentication  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.all_published_workflows_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str offset: Start index of paging. Pagination results can be based on numbers or other values chosen by the registry implementor (for example, SHA values). If this exceeds the current result set return an empty set.  If not specified in the request, this will start at the beginning of the results.
        :param int limit: Amount of records to return in a given page, limited to 100
        :param str filter: Filter, this is a search string that filters the results.
        :param str sort_col: Sort column
        :param str sort_order: Sort order
        :param bool services: services
        :return: list[Workflow]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['offset', 'limit', 'filter', 'sort_col', 'sort_order', 'services']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method all_published_workflows" % key
                )
            params[key] = val
        del params['kwargs']

        if self.api_client.client_side_validation and ('limit' in params and params['limit'] > 100):  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `all_published_workflows`, must be a value less than or equal to `100`")  # noqa: E501
        if self.api_client.client_side_validation and ('limit' in params and params['limit'] < 1):  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `all_published_workflows`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'offset' in params:
            query_params.append(('offset', params['offset']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501
        if 'sort_col' in params:
            query_params.append(('sortCol', params['sort_col']))  # noqa: E501
        if 'sort_order' in params:
            query_params.append(('sortOrder', params['sort_order']))  # noqa: E501
        if 'services' in params:
            query_params.append(('services', params['services']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/workflows/published', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Workflow]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_test_parameter_files(self, workflow_id, test_parameter_paths, **kwargs):  # noqa: E501
        """Delete test parameter files for a given version.  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_test_parameter_files(workflow_id, test_parameter_paths, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int workflow_id: Workflow to modify. (required)
        :param list[str] test_parameter_paths: List of paths. (required)
        :param str version:
        :return: list[SourceFile]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_test_parameter_files_with_http_info(workflow_id, test_parameter_paths, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_test_parameter_files_with_http_info(workflow_id, test_parameter_paths, **kwargs)  # noqa: E501
            return data

    def delete_test_parameter_files_with_http_info(self, workflow_id, test_parameter_paths, **kwargs):  # noqa: E501
        """Delete test parameter files for a given version.  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_test_parameter_files_with_http_info(workflow_id, test_parameter_paths, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int workflow_id: Workflow to modify. (required)
        :param list[str] test_parameter_paths: List of paths. (required)
        :param str version:
        :return: list[SourceFile]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workflow_id', 'test_parameter_paths', 'version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_test_parameter_files" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workflow_id' is set
        if self.api_client.client_side_validation and ('workflow_id' not in params or
                                                       params['workflow_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `workflow_id` when calling `delete_test_parameter_files`")  # noqa: E501
        # verify the required parameter 'test_parameter_paths' is set
        if self.api_client.client_side_validation and ('test_parameter_paths' not in params or
                                                       params['test_parameter_paths'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `test_parameter_paths` when calling `delete_test_parameter_files`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workflow_id' in params:
            path_params['workflowId'] = params['workflow_id']  # noqa: E501

        query_params = []
        if 'test_parameter_paths' in params:
            query_params.append(('testParameterPaths', params['test_parameter_paths']))  # noqa: E501
            collection_formats['testParameterPaths'] = 'multi'  # noqa: E501
        if 'version' in params:
            query_params.append(('version', params['version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/workflows/{workflowId}/testParameterFiles', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[SourceFile]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_workflow(self, git_registry, organization, repository_name, **kwargs):  # noqa: E501
        """See OpenApi for details  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_workflow(git_registry, organization, repository_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str git_registry: (required)
        :param str organization: (required)
        :param str repository_name: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_workflow_with_http_info(git_registry, organization, repository_name, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_workflow_with_http_info(git_registry, organization, repository_name, **kwargs)  # noqa: E501
            return data

    def delete_workflow_with_http_info(self, git_registry, organization, repository_name, **kwargs):  # noqa: E501
        """See OpenApi for details  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_workflow_with_http_info(git_registry, organization, repository_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str git_registry: (required)
        :param str organization: (required)
        :param str repository_name: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['git_registry', 'organization', 'repository_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_workflow" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'git_registry' is set
        if self.api_client.client_side_validation and ('git_registry' not in params or
                                                       params['git_registry'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `git_registry` when calling `delete_workflow`")  # noqa: E501
        # verify the required parameter 'organization' is set
        if self.api_client.client_side_validation and ('organization' not in params or
                                                       params['organization'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `organization` when calling `delete_workflow`")  # noqa: E501
        # verify the required parameter 'repository_name' is set
        if self.api_client.client_side_validation and ('repository_name' not in params or
                                                       params['repository_name'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `repository_name` when calling `delete_workflow`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'git_registry' in params:
            path_params['gitRegistry'] = params['git_registry']  # noqa: E501
        if 'organization' in params:
            path_params['organization'] = params['organization']  # noqa: E501
        if 'repository_name' in params:
            path_params['repositoryName'] = params['repository_name']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/workflows/registries/{gitRegistry}/organizations/{organization}/repositories/{repositoryName}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_all_workflow_by_path(self, repository, **kwargs):  # noqa: E501
        """Get a list of workflows by path.  # noqa: E501

        Do not include workflow name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_workflow_by_path(repository, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repository: repository path (required)
        :return: list[Workflow]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_all_workflow_by_path_with_http_info(repository, **kwargs)  # noqa: E501
        else:
            (data) = self.get_all_workflow_by_path_with_http_info(repository, **kwargs)  # noqa: E501
            return data

    def get_all_workflow_by_path_with_http_info(self, repository, **kwargs):  # noqa: E501
        """Get a list of workflows by path.  # noqa: E501

        Do not include workflow name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_all_workflow_by_path_with_http_info(repository, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repository: repository path (required)
        :return: list[Workflow]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['repository']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_workflow_by_path" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'repository' is set
        if self.api_client.client_side_validation and ('repository' not in params or
                                                       params['repository'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `repository` when calling `get_all_workflow_by_path`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'repository' in params:
            path_params['repository'] = params['repository']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/workflows/path/{repository}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Workflow]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_entry_by_path(self, repository, **kwargs):  # noqa: E501
        """Get an entry by path.  # noqa: E501

        Requires full path (including entry name if applicable).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_entry_by_path(repository, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repository: repository path (required)
        :return: Entry
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_entry_by_path_with_http_info(repository, **kwargs)  # noqa: E501
        else:
            (data) = self.get_entry_by_path_with_http_info(repository, **kwargs)  # noqa: E501
            return data

    def get_entry_by_path_with_http_info(self, repository, **kwargs):  # noqa: E501
        """Get an entry by path.  # noqa: E501

        Requires full path (including entry name if applicable).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_entry_by_path_with_http_info(repository, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repository: repository path (required)
        :return: Entry
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['repository']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_entry_by_path" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'repository' is set
        if self.api_client.client_side_validation and ('repository' not in params or
                                                       params['repository'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `repository` when calling `get_entry_by_path`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'repository' in params:
            path_params['repository'] = params['repository']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/workflows/path/entry/{repository}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Entry',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_published_entry_by_path(self, repository, **kwargs):  # noqa: E501
        """Get a published entry by path.  # noqa: E501

        Requires full path (including entry name if applicable).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_published_entry_by_path(repository, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repository: repository path (required)
        :return: Entry
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_published_entry_by_path_with_http_info(repository, **kwargs)  # noqa: E501
        else:
            (data) = self.get_published_entry_by_path_with_http_info(repository, **kwargs)  # noqa: E501
            return data

    def get_published_entry_by_path_with_http_info(self, repository, **kwargs):  # noqa: E501
        """Get a published entry by path.  # noqa: E501

        Requires full path (including entry name if applicable).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_published_entry_by_path_with_http_info(repository, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repository: repository path (required)
        :return: Entry
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['repository']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_published_entry_by_path" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'repository' is set
        if self.api_client.client_side_validation and ('repository' not in params or
                                                       params['repository'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `repository` when calling `get_published_entry_by_path`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'repository' in params:
            path_params['repository'] = params['repository']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/workflows/path/entry/{repository}/published', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Entry',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_published_workflow(self, workflow_id, **kwargs):  # noqa: E501
        """Get a published workflow.  # noqa: E501

        Hidden versions will not be visible. NO authentication  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_published_workflow(workflow_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int workflow_id: Workflow ID (required)
        :param str include: Comma-delimited list of fields to include: validations, aliases
        :return: Workflow
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_published_workflow_with_http_info(workflow_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_published_workflow_with_http_info(workflow_id, **kwargs)  # noqa: E501
            return data

    def get_published_workflow_with_http_info(self, workflow_id, **kwargs):  # noqa: E501
        """Get a published workflow.  # noqa: E501

        Hidden versions will not be visible. NO authentication  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_published_workflow_with_http_info(workflow_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int workflow_id: Workflow ID (required)
        :param str include: Comma-delimited list of fields to include: validations, aliases
        :return: Workflow
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workflow_id', 'include']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_published_workflow" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workflow_id' is set
        if self.api_client.client_side_validation and ('workflow_id' not in params or
                                                       params['workflow_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `workflow_id` when calling `get_published_workflow`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workflow_id' in params:
            path_params['workflowId'] = params['workflow_id']  # noqa: E501

        query_params = []
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/workflows/published/{workflowId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Workflow',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_published_workflow_by_path(self, repository, **kwargs):  # noqa: E501
        """Get a published workflow by path  # noqa: E501

        Does not require workflow name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_published_workflow_by_path(repository, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repository: repository path (required)
        :param str include: Comma-delimited list of fields to include: validations, aliases
        :param bool services: services
        :param str version_name: Version name
        :return: Workflow
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_published_workflow_by_path_with_http_info(repository, **kwargs)  # noqa: E501
        else:
            (data) = self.get_published_workflow_by_path_with_http_info(repository, **kwargs)  # noqa: E501
            return data

    def get_published_workflow_by_path_with_http_info(self, repository, **kwargs):  # noqa: E501
        """Get a published workflow by path  # noqa: E501

        Does not require workflow name.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_published_workflow_by_path_with_http_info(repository, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repository: repository path (required)
        :param str include: Comma-delimited list of fields to include: validations, aliases
        :param bool services: services
        :param str version_name: Version name
        :return: Workflow
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['repository', 'include', 'services', 'version_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_published_workflow_by_path" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'repository' is set
        if self.api_client.client_side_validation and ('repository' not in params or
                                                       params['repository'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `repository` when calling `get_published_workflow_by_path`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'repository' in params:
            path_params['repository'] = params['repository']  # noqa: E501

        query_params = []
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501
        if 'services' in params:
            query_params.append(('services', params['services']))  # noqa: E501
        if 'version_name' in params:
            query_params.append(('versionName', params['version_name']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/workflows/path/workflow/{repository}/published', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Workflow',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_published_workflows_by_organization(self, organization, **kwargs):  # noqa: E501
        """List all published workflows of an organization.  # noqa: E501

        NO authentication  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_published_workflows_by_organization(organization, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str organization: organization (required)
        :return: list[Workflow]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_published_workflows_by_organization_with_http_info(organization, **kwargs)  # noqa: E501
        else:
            (data) = self.get_published_workflows_by_organization_with_http_info(organization, **kwargs)  # noqa: E501
            return data

    def get_published_workflows_by_organization_with_http_info(self, organization, **kwargs):  # noqa: E501
        """List all published workflows of an organization.  # noqa: E501

        NO authentication  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_published_workflows_by_organization_with_http_info(organization, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str organization: organization (required)
        :return: list[Workflow]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['organization']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_published_workflows_by_organization" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'organization' is set
        if self.api_client.client_side_validation and ('organization' not in params or
                                                       params['organization'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `organization` when calling `get_published_workflows_by_organization`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'organization' in params:
            path_params['organization'] = params['organization']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/workflows/organization/{organization}/published', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Workflow]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_starred_users(self, workflow_id, **kwargs):  # noqa: E501
        """Returns list of users who starred the given workflow.  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_starred_users(workflow_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int workflow_id: Workflow to grab starred users for. (required)
        :return: list[User]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_starred_users_with_http_info(workflow_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_starred_users_with_http_info(workflow_id, **kwargs)  # noqa: E501
            return data

    def get_starred_users_with_http_info(self, workflow_id, **kwargs):  # noqa: E501
        """Returns list of users who starred the given workflow.  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_starred_users_with_http_info(workflow_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int workflow_id: Workflow to grab starred users for. (required)
        :return: list[User]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workflow_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_starred_users" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workflow_id' is set
        if self.api_client.client_side_validation and ('workflow_id' not in params or
                                                       params['workflow_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `workflow_id` when calling `get_starred_users`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workflow_id' in params:
            path_params['workflowId'] = params['workflow_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/workflows/{workflowId}/starredUsers', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[User]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_table_tool_content(self, workflow_id, workflow_version_id, **kwargs):  # noqa: E501
        """Get the Tools for a given workflow version.  # noqa: E501

        Does not require authentication for published workflows, authentication can be provided for restricted workflows  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_table_tool_content(workflow_id, workflow_version_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int workflow_id: workflowId (required)
        :param int workflow_version_id: workflowVersionId (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_table_tool_content_with_http_info(workflow_id, workflow_version_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_table_tool_content_with_http_info(workflow_id, workflow_version_id, **kwargs)  # noqa: E501
            return data

    def get_table_tool_content_with_http_info(self, workflow_id, workflow_version_id, **kwargs):  # noqa: E501
        """Get the Tools for a given workflow version.  # noqa: E501

        Does not require authentication for published workflows, authentication can be provided for restricted workflows  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_table_tool_content_with_http_info(workflow_id, workflow_version_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int workflow_id: workflowId (required)
        :param int workflow_version_id: workflowVersionId (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workflow_id', 'workflow_version_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_table_tool_content" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workflow_id' is set
        if self.api_client.client_side_validation and ('workflow_id' not in params or
                                                       params['workflow_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `workflow_id` when calling `get_table_tool_content`")  # noqa: E501
        # verify the required parameter 'workflow_version_id' is set
        if self.api_client.client_side_validation and ('workflow_version_id' not in params or
                                                       params['workflow_version_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `workflow_version_id` when calling `get_table_tool_content`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workflow_id' in params:
            path_params['workflowId'] = params['workflow_id']  # noqa: E501
        if 'workflow_version_id' in params:
            path_params['workflowVersionId'] = params['workflow_version_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/workflows/{workflowId}/tools/{workflowVersionId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_test_parameter_files(self, workflow_id, **kwargs):  # noqa: E501
        """Get the corresponding test parameter files.  # noqa: E501

        Does not require authentication for published workflows, authentication can be provided for restricted workflows  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_test_parameter_files(workflow_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int workflow_id: Workflow id (required)
        :param str version:
        :return: list[SourceFile]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_test_parameter_files_with_http_info(workflow_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_test_parameter_files_with_http_info(workflow_id, **kwargs)  # noqa: E501
            return data

    def get_test_parameter_files_with_http_info(self, workflow_id, **kwargs):  # noqa: E501
        """Get the corresponding test parameter files.  # noqa: E501

        Does not require authentication for published workflows, authentication can be provided for restricted workflows  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_test_parameter_files_with_http_info(workflow_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int workflow_id: Workflow id (required)
        :param str version:
        :return: list[SourceFile]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workflow_id', 'version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_test_parameter_files" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workflow_id' is set
        if self.api_client.client_side_validation and ('workflow_id' not in params or
                                                       params['workflow_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `workflow_id` when calling `get_test_parameter_files`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workflow_id' in params:
            path_params['workflowId'] = params['workflow_id']  # noqa: E501

        query_params = []
        if 'version' in params:
            query_params.append(('version', params['version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/workflows/{workflowId}/testParameterFiles', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[SourceFile]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_users(self, workflow_id, **kwargs):  # noqa: E501
        """Get users of a workflow.  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_users(workflow_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int workflow_id: workflow ID (required)
        :return: list[User]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_users_with_http_info(workflow_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_users_with_http_info(workflow_id, **kwargs)  # noqa: E501
            return data

    def get_users_with_http_info(self, workflow_id, **kwargs):  # noqa: E501
        """Get users of a workflow.  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_users_with_http_info(workflow_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int workflow_id: workflow ID (required)
        :return: list[User]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workflow_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_users" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workflow_id' is set
        if self.api_client.client_side_validation and ('workflow_id' not in params or
                                                       params['workflow_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `workflow_id` when calling `get_users`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workflow_id' in params:
            path_params['workflowId'] = params['workflow_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/workflows/{workflowId}/users', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[User]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_workflow(self, workflow_id, **kwargs):  # noqa: E501
        """Retrieve a workflow  # noqa: E501

        This is one of the few endpoints that returns the user object with populated properties (minus the userProfiles property)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_workflow(workflow_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int workflow_id: workflow ID (required)
        :param str include: Comma-delimited list of fields to include: validations, aliases
        :return: Workflow
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_workflow_with_http_info(workflow_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_workflow_with_http_info(workflow_id, **kwargs)  # noqa: E501
            return data

    def get_workflow_with_http_info(self, workflow_id, **kwargs):  # noqa: E501
        """Retrieve a workflow  # noqa: E501

        This is one of the few endpoints that returns the user object with populated properties (minus the userProfiles property)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_workflow_with_http_info(workflow_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int workflow_id: workflow ID (required)
        :param str include: Comma-delimited list of fields to include: validations, aliases
        :return: Workflow
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workflow_id', 'include']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workflow" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workflow_id' is set
        if self.api_client.client_side_validation and ('workflow_id' not in params or
                                                       params['workflow_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `workflow_id` when calling `get_workflow`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workflow_id' in params:
            path_params['workflowId'] = params['workflow_id']  # noqa: E501

        query_params = []
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/workflows/{workflowId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Workflow',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_workflow_actions(self, repository, **kwargs):  # noqa: E501
        """Gets all actions a user can perform on a workflow.  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_workflow_actions(repository, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repository: repository path (required)
        :param bool services: services
        :return: list[str]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_workflow_actions_with_http_info(repository, **kwargs)  # noqa: E501
        else:
            (data) = self.get_workflow_actions_with_http_info(repository, **kwargs)  # noqa: E501
            return data

    def get_workflow_actions_with_http_info(self, repository, **kwargs):  # noqa: E501
        """Gets all actions a user can perform on a workflow.  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_workflow_actions_with_http_info(repository, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repository: repository path (required)
        :param bool services: services
        :return: list[str]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['repository', 'services']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workflow_actions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'repository' is set
        if self.api_client.client_side_validation and ('repository' not in params or
                                                       params['repository'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `repository` when calling `get_workflow_actions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'repository' in params:
            path_params['repository'] = params['repository']  # noqa: E501

        query_params = []
        if 'services' in params:
            query_params.append(('services', params['services']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/workflows/path/workflow/{repository}/actions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[str]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_workflow_by_alias(self, alias, **kwargs):  # noqa: E501
        """Retrieves a workflow by alias.  # noqa: E501

        Does not require authentication for published workflows, authentication can be provided for restricted workflows  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_workflow_by_alias(alias, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str alias: Alias (required)
        :return: Workflow
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_workflow_by_alias_with_http_info(alias, **kwargs)  # noqa: E501
        else:
            (data) = self.get_workflow_by_alias_with_http_info(alias, **kwargs)  # noqa: E501
            return data

    def get_workflow_by_alias_with_http_info(self, alias, **kwargs):  # noqa: E501
        """Retrieves a workflow by alias.  # noqa: E501

        Does not require authentication for published workflows, authentication can be provided for restricted workflows  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_workflow_by_alias_with_http_info(alias, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str alias: Alias (required)
        :return: Workflow
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['alias']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workflow_by_alias" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'alias' is set
        if self.api_client.client_side_validation and ('alias' not in params or
                                                       params['alias'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `alias` when calling `get_workflow_by_alias`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'alias' in params:
            path_params['alias'] = params['alias']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/workflows/{alias}/aliases', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Workflow',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_workflow_by_path(self, repository, subclass, **kwargs):  # noqa: E501
        """Get a workflow by path.  # noqa: E501

        Requires full path (including workflow name if applicable).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_workflow_by_path(repository, subclass, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repository: repository path (required)
        :param str subclass: Which Workflow subclass to retrieve. (required)
        :param str include: Comma-delimited list of fields to include: validations, aliases
        :return: Workflow
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_workflow_by_path_with_http_info(repository, subclass, **kwargs)  # noqa: E501
        else:
            (data) = self.get_workflow_by_path_with_http_info(repository, subclass, **kwargs)  # noqa: E501
            return data

    def get_workflow_by_path_with_http_info(self, repository, subclass, **kwargs):  # noqa: E501
        """Get a workflow by path.  # noqa: E501

        Requires full path (including workflow name if applicable).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_workflow_by_path_with_http_info(repository, subclass, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repository: repository path (required)
        :param str subclass: Which Workflow subclass to retrieve. (required)
        :param str include: Comma-delimited list of fields to include: validations, aliases
        :return: Workflow
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['repository', 'subclass', 'include']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workflow_by_path" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'repository' is set
        if self.api_client.client_side_validation and ('repository' not in params or
                                                       params['repository'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `repository` when calling `get_workflow_by_path`")  # noqa: E501
        # verify the required parameter 'subclass' is set
        if self.api_client.client_side_validation and ('subclass' not in params or
                                                       params['subclass'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `subclass` when calling `get_workflow_by_path`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'repository' in params:
            path_params['repository'] = params['repository']  # noqa: E501

        query_params = []
        if 'include' in params:
            query_params.append(('include', params['include']))  # noqa: E501
        if 'subclass' in params:
            query_params.append(('subclass', params['subclass']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/workflows/path/workflow/{repository}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Workflow',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_workflow_dag(self, workflow_id, workflow_version_id, **kwargs):  # noqa: E501
        """Get the DAG for a given workflow version.  # noqa: E501

        Does not require authentication for published workflows, authentication can be provided for restricted workflows  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_workflow_dag(workflow_id, workflow_version_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int workflow_id: workflowId (required)
        :param int workflow_version_id: workflowVersionId (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_workflow_dag_with_http_info(workflow_id, workflow_version_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_workflow_dag_with_http_info(workflow_id, workflow_version_id, **kwargs)  # noqa: E501
            return data

    def get_workflow_dag_with_http_info(self, workflow_id, workflow_version_id, **kwargs):  # noqa: E501
        """Get the DAG for a given workflow version.  # noqa: E501

        Does not require authentication for published workflows, authentication can be provided for restricted workflows  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_workflow_dag_with_http_info(workflow_id, workflow_version_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int workflow_id: workflowId (required)
        :param int workflow_version_id: workflowVersionId (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workflow_id', 'workflow_version_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workflow_dag" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workflow_id' is set
        if self.api_client.client_side_validation and ('workflow_id' not in params or
                                                       params['workflow_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `workflow_id` when calling `get_workflow_dag`")  # noqa: E501
        # verify the required parameter 'workflow_version_id' is set
        if self.api_client.client_side_validation and ('workflow_version_id' not in params or
                                                       params['workflow_version_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `workflow_version_id` when calling `get_workflow_dag`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workflow_id' in params:
            path_params['workflowId'] = params['workflow_id']  # noqa: E501
        if 'workflow_version_id' in params:
            path_params['workflowVersionId'] = params['workflow_version_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/workflows/{workflowId}/dag/{workflowVersionId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_workflow_permissions(self, repository, **kwargs):  # noqa: E501
        """Get all permissions for a workflow.  # noqa: E501

        The user must be the workflow owner.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_workflow_permissions(repository, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repository: repository path (required)
        :param bool services: services
        :return: list[Permission]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_workflow_permissions_with_http_info(repository, **kwargs)  # noqa: E501
        else:
            (data) = self.get_workflow_permissions_with_http_info(repository, **kwargs)  # noqa: E501
            return data

    def get_workflow_permissions_with_http_info(self, repository, **kwargs):  # noqa: E501
        """Get all permissions for a workflow.  # noqa: E501

        The user must be the workflow owner.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_workflow_permissions_with_http_info(repository, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repository: repository path (required)
        :param bool services: services
        :return: list[Permission]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['repository', 'services']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workflow_permissions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'repository' is set
        if self.api_client.client_side_validation and ('repository' not in params or
                                                       params['repository'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `repository` when calling `get_workflow_permissions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'repository' in params:
            path_params['repository'] = params['repository']  # noqa: E501

        query_params = []
        if 'services' in params:
            query_params.append(('services', params['services']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/workflows/path/workflow/{repository}/permissions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Permission]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_workflow_versions(self, workflow_id, **kwargs):  # noqa: E501
        """Return first 200 versions in an entry  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_workflow_versions(workflow_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int workflow_id: workflowID (required)
        :return: list[WorkflowVersion]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_workflow_versions_with_http_info(workflow_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_workflow_versions_with_http_info(workflow_id, **kwargs)  # noqa: E501
            return data

    def get_workflow_versions_with_http_info(self, workflow_id, **kwargs):  # noqa: E501
        """Return first 200 versions in an entry  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_workflow_versions_with_http_info(workflow_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int workflow_id: workflowID (required)
        :return: list[WorkflowVersion]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workflow_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workflow_versions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workflow_id' is set
        if self.api_client.client_side_validation and ('workflow_id' not in params or
                                                       params['workflow_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `workflow_id` when calling `get_workflow_versions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workflow_id' in params:
            path_params['workflowId'] = params['workflow_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/workflows/{workflowId}/workflowVersions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[WorkflowVersion]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_workflow_zip(self, workflow_id, workflow_version_id, **kwargs):  # noqa: E501
        """Download a ZIP file of a workflow and all associated files.  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_workflow_zip(workflow_id, workflow_version_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int workflow_id: workflowId (required)
        :param int workflow_version_id: workflowVersionId (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_workflow_zip_with_http_info(workflow_id, workflow_version_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_workflow_zip_with_http_info(workflow_id, workflow_version_id, **kwargs)  # noqa: E501
            return data

    def get_workflow_zip_with_http_info(self, workflow_id, workflow_version_id, **kwargs):  # noqa: E501
        """Download a ZIP file of a workflow and all associated files.  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_workflow_zip_with_http_info(workflow_id, workflow_version_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int workflow_id: workflowId (required)
        :param int workflow_version_id: workflowVersionId (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workflow_id', 'workflow_version_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_workflow_zip" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workflow_id' is set
        if self.api_client.client_side_validation and ('workflow_id' not in params or
                                                       params['workflow_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `workflow_id` when calling `get_workflow_zip`")  # noqa: E501
        # verify the required parameter 'workflow_version_id' is set
        if self.api_client.client_side_validation and ('workflow_version_id' not in params or
                                                       params['workflow_version_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `workflow_version_id` when calling `get_workflow_zip`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workflow_id' in params:
            path_params['workflowId'] = params['workflow_id']  # noqa: E501
        if 'workflow_version_id' in params:
            path_params['workflowVersionId'] = params['workflow_version_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/zip'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/workflows/{workflowId}/zip/{workflowVersionId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def handle_git_hub_branch_deletion(self, **kwargs):  # noqa: E501
        """Handles the deletion of a branch on GitHub. Will delete all workflow versions that match in all workflows that share the same repository.  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.handle_git_hub_branch_deletion(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repository:
        :param str username:
        :param str git_reference:
        :param str installation_id:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.handle_git_hub_branch_deletion_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.handle_git_hub_branch_deletion_with_http_info(**kwargs)  # noqa: E501
            return data

    def handle_git_hub_branch_deletion_with_http_info(self, **kwargs):  # noqa: E501
        """Handles the deletion of a branch on GitHub. Will delete all workflow versions that match in all workflows that share the same repository.  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.handle_git_hub_branch_deletion_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repository:
        :param str username:
        :param str git_reference:
        :param str installation_id:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['repository', 'username', 'git_reference', 'installation_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method handle_git_hub_branch_deletion" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'repository' in params:
            query_params.append(('repository', params['repository']))  # noqa: E501
        if 'username' in params:
            query_params.append(('username', params['username']))  # noqa: E501
        if 'git_reference' in params:
            query_params.append(('gitReference', params['git_reference']))  # noqa: E501
        if 'installation_id' in params:
            query_params.append(('installationId', params['installation_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/workflows/github', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def handle_git_hub_installation(self, **kwargs):  # noqa: E501
        """Handle the installation of our GitHub app onto a repository or organization.  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.handle_git_hub_installation(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repositories:
        :param str username:
        :param str installation_id:
        :return: list[Workflow]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.handle_git_hub_installation_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.handle_git_hub_installation_with_http_info(**kwargs)  # noqa: E501
            return data

    def handle_git_hub_installation_with_http_info(self, **kwargs):  # noqa: E501
        """Handle the installation of our GitHub app onto a repository or organization.  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.handle_git_hub_installation_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repositories:
        :param str username:
        :param str installation_id:
        :return: list[Workflow]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['repositories', 'username', 'installation_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method handle_git_hub_installation" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'repositories' in params:
            form_params.append(('repositories', params['repositories']))  # noqa: E501
        if 'username' in params:
            form_params.append(('username', params['username']))  # noqa: E501
        if 'installation_id' in params:
            form_params.append(('installationId', params['installation_id']))  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/x-www-form-urlencoded'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/workflows/github/install', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Workflow]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def handle_git_hub_release(self, **kwargs):  # noqa: E501
        """Handle a release of a repository on GitHub. Will create a workflow/service and version when necessary.  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.handle_git_hub_release(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repository:
        :param str username:
        :param str git_reference:
        :param str installation_id:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.handle_git_hub_release_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.handle_git_hub_release_with_http_info(**kwargs)  # noqa: E501
            return data

    def handle_git_hub_release_with_http_info(self, **kwargs):  # noqa: E501
        """Handle a release of a repository on GitHub. Will create a workflow/service and version when necessary.  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.handle_git_hub_release_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repository:
        :param str username:
        :param str git_reference:
        :param str installation_id:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['repository', 'username', 'git_reference', 'installation_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method handle_git_hub_release" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'repository' in params:
            form_params.append(('repository', params['repository']))  # noqa: E501
        if 'username' in params:
            form_params.append(('username', params['username']))  # noqa: E501
        if 'git_reference' in params:
            form_params.append(('gitReference', params['git_reference']))  # noqa: E501
        if 'installation_id' in params:
            form_params.append(('installationId', params['installation_id']))  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/x-www-form-urlencoded'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/workflows/github/release', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def manual_register(self, workflow_registry, workflow_path, default_workflow_path, workflow_name, descriptor_type, **kwargs):  # noqa: E501
        """Manually register a workflow.  # noqa: E501

        Manually register workflow (public or private).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.manual_register(workflow_registry, workflow_path, default_workflow_path, workflow_name, descriptor_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str workflow_registry: Workflow registry (required)
        :param str workflow_path: Workflow repository (required)
        :param str default_workflow_path: Workflow container new descriptor path (CWL or WDL) and/or name (required)
        :param str workflow_name: Workflow name, set to empty if none required (required)
        :param str descriptor_type: Descriptor type (required)
        :param str default_test_parameter_file_path: Default test parameter file path
        :return: Workflow
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.manual_register_with_http_info(workflow_registry, workflow_path, default_workflow_path, workflow_name, descriptor_type, **kwargs)  # noqa: E501
        else:
            (data) = self.manual_register_with_http_info(workflow_registry, workflow_path, default_workflow_path, workflow_name, descriptor_type, **kwargs)  # noqa: E501
            return data

    def manual_register_with_http_info(self, workflow_registry, workflow_path, default_workflow_path, workflow_name, descriptor_type, **kwargs):  # noqa: E501
        """Manually register a workflow.  # noqa: E501

        Manually register workflow (public or private).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.manual_register_with_http_info(workflow_registry, workflow_path, default_workflow_path, workflow_name, descriptor_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str workflow_registry: Workflow registry (required)
        :param str workflow_path: Workflow repository (required)
        :param str default_workflow_path: Workflow container new descriptor path (CWL or WDL) and/or name (required)
        :param str workflow_name: Workflow name, set to empty if none required (required)
        :param str descriptor_type: Descriptor type (required)
        :param str default_test_parameter_file_path: Default test parameter file path
        :return: Workflow
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workflow_registry', 'workflow_path', 'default_workflow_path', 'workflow_name', 'descriptor_type', 'default_test_parameter_file_path']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method manual_register" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workflow_registry' is set
        if self.api_client.client_side_validation and ('workflow_registry' not in params or
                                                       params['workflow_registry'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `workflow_registry` when calling `manual_register`")  # noqa: E501
        # verify the required parameter 'workflow_path' is set
        if self.api_client.client_side_validation and ('workflow_path' not in params or
                                                       params['workflow_path'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `workflow_path` when calling `manual_register`")  # noqa: E501
        # verify the required parameter 'default_workflow_path' is set
        if self.api_client.client_side_validation and ('default_workflow_path' not in params or
                                                       params['default_workflow_path'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `default_workflow_path` when calling `manual_register`")  # noqa: E501
        # verify the required parameter 'workflow_name' is set
        if self.api_client.client_side_validation and ('workflow_name' not in params or
                                                       params['workflow_name'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `workflow_name` when calling `manual_register`")  # noqa: E501
        # verify the required parameter 'descriptor_type' is set
        if self.api_client.client_side_validation and ('descriptor_type' not in params or
                                                       params['descriptor_type'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `descriptor_type` when calling `manual_register`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'workflow_registry' in params:
            query_params.append(('workflowRegistry', params['workflow_registry']))  # noqa: E501
        if 'workflow_path' in params:
            query_params.append(('workflowPath', params['workflow_path']))  # noqa: E501
        if 'default_workflow_path' in params:
            query_params.append(('defaultWorkflowPath', params['default_workflow_path']))  # noqa: E501
        if 'workflow_name' in params:
            query_params.append(('workflowName', params['workflow_name']))  # noqa: E501
        if 'descriptor_type' in params:
            query_params.append(('descriptorType', params['descriptor_type']))  # noqa: E501
        if 'default_test_parameter_file_path' in params:
            query_params.append(('defaultTestParameterFilePath', params['default_test_parameter_file_path']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/workflows/manualRegister', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Workflow',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def primary_descriptor(self, workflow_id, **kwargs):  # noqa: E501
        """Get the primary descriptor file.  # noqa: E501

        Does not require authentication for published workflows, authentication can be provided for restricted workflows  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.primary_descriptor(workflow_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int workflow_id: Workflow id (required)
        :param str tag:
        :param str language:
        :return: SourceFile
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.primary_descriptor_with_http_info(workflow_id, **kwargs)  # noqa: E501
        else:
            (data) = self.primary_descriptor_with_http_info(workflow_id, **kwargs)  # noqa: E501
            return data

    def primary_descriptor_with_http_info(self, workflow_id, **kwargs):  # noqa: E501
        """Get the primary descriptor file.  # noqa: E501

        Does not require authentication for published workflows, authentication can be provided for restricted workflows  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.primary_descriptor_with_http_info(workflow_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int workflow_id: Workflow id (required)
        :param str tag:
        :param str language:
        :return: SourceFile
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workflow_id', 'tag', 'language']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method primary_descriptor" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workflow_id' is set
        if self.api_client.client_side_validation and ('workflow_id' not in params or
                                                       params['workflow_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `workflow_id` when calling `primary_descriptor`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workflow_id' in params:
            path_params['workflowId'] = params['workflow_id']  # noqa: E501

        query_params = []
        if 'tag' in params:
            query_params.append(('tag', params['tag']))  # noqa: E501
        if 'language' in params:
            query_params.append(('language', params['language']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/workflows/{workflowId}/primaryDescriptor', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SourceFile',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def publish(self, workflow_id, body, **kwargs):  # noqa: E501
        """Publish or unpublish a workflow.  # noqa: E501

        Publish/publish a workflow (public or private).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.publish(workflow_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int workflow_id: Workflow id to publish/unpublish (required)
        :param PublishRequest body: PublishRequest to refresh the list of repos for a user (required)
        :return: Workflow
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.publish_with_http_info(workflow_id, body, **kwargs)  # noqa: E501
        else:
            (data) = self.publish_with_http_info(workflow_id, body, **kwargs)  # noqa: E501
            return data

    def publish_with_http_info(self, workflow_id, body, **kwargs):  # noqa: E501
        """Publish or unpublish a workflow.  # noqa: E501

        Publish/publish a workflow (public or private).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.publish_with_http_info(workflow_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int workflow_id: Workflow id to publish/unpublish (required)
        :param PublishRequest body: PublishRequest to refresh the list of repos for a user (required)
        :return: Workflow
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workflow_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method publish" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workflow_id' is set
        if self.api_client.client_side_validation and ('workflow_id' not in params or
                                                       params['workflow_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `workflow_id` when calling `publish`")  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `publish`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workflow_id' in params:
            path_params['workflowId'] = params['workflow_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/workflows/{workflowId}/publish', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Workflow',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def refresh(self, workflow_id, **kwargs):  # noqa: E501
        """Refresh one particular workflow.  # noqa: E501

        Full refresh  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.refresh(workflow_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int workflow_id: workflow ID (required)
        :param bool hard_refresh: completely refresh all versions, even if they have not changed
        :return: Workflow
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.refresh_with_http_info(workflow_id, **kwargs)  # noqa: E501
        else:
            (data) = self.refresh_with_http_info(workflow_id, **kwargs)  # noqa: E501
            return data

    def refresh_with_http_info(self, workflow_id, **kwargs):  # noqa: E501
        """Refresh one particular workflow.  # noqa: E501

        Full refresh  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.refresh_with_http_info(workflow_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int workflow_id: workflow ID (required)
        :param bool hard_refresh: completely refresh all versions, even if they have not changed
        :return: Workflow
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workflow_id', 'hard_refresh']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method refresh" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workflow_id' is set
        if self.api_client.client_side_validation and ('workflow_id' not in params or
                                                       params['workflow_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `workflow_id` when calling `refresh`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workflow_id' in params:
            path_params['workflowId'] = params['workflow_id']  # noqa: E501

        query_params = []
        if 'hard_refresh' in params:
            query_params.append(('hardRefresh', params['hard_refresh']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/workflows/{workflowId}/refresh', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Workflow',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def refresh_version(self, workflow_id, version, **kwargs):  # noqa: E501
        """Refresh one particular workflow version.  # noqa: E501

        Refresh existing or new version of a workflow.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.refresh_version(workflow_id, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int workflow_id: workflow ID (required)
        :param str version: version (required)
        :param bool hard_refresh: completely refresh version, even if it has not changed
        :return: Workflow
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.refresh_version_with_http_info(workflow_id, version, **kwargs)  # noqa: E501
        else:
            (data) = self.refresh_version_with_http_info(workflow_id, version, **kwargs)  # noqa: E501
            return data

    def refresh_version_with_http_info(self, workflow_id, version, **kwargs):  # noqa: E501
        """Refresh one particular workflow version.  # noqa: E501

        Refresh existing or new version of a workflow.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.refresh_version_with_http_info(workflow_id, version, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int workflow_id: workflow ID (required)
        :param str version: version (required)
        :param bool hard_refresh: completely refresh version, even if it has not changed
        :return: Workflow
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workflow_id', 'version', 'hard_refresh']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method refresh_version" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workflow_id' is set
        if self.api_client.client_side_validation and ('workflow_id' not in params or
                                                       params['workflow_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `workflow_id` when calling `refresh_version`")  # noqa: E501
        # verify the required parameter 'version' is set
        if self.api_client.client_side_validation and ('version' not in params or
                                                       params['version'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `version` when calling `refresh_version`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workflow_id' in params:
            path_params['workflowId'] = params['workflow_id']  # noqa: E501
        if 'version' in params:
            path_params['version'] = params['version']  # noqa: E501

        query_params = []
        if 'hard_refresh' in params:
            query_params.append(('hardRefresh', params['hard_refresh']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/workflows/{workflowId}/refresh/{version}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Workflow',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def register_checker_workflow(self, checker_workflow_path, entry_id, descriptor_type, **kwargs):  # noqa: E501
        """Register a checker workflow and associates it with the given tool/workflow.  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.register_checker_workflow(checker_workflow_path, entry_id, descriptor_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str checker_workflow_path: Path of the main descriptor of the checker workflow (located in associated tool/workflow repository) (required)
        :param int entry_id: Entry Id of parent tool/workflow. (required)
        :param str descriptor_type: Descriptor type of the workflow, only CWL or WDL are support. (required)
        :param str test_parameter_path: Default path to test parameter files for the checker workflow. If not specified will use that of the entry.
        :return: Entry
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.register_checker_workflow_with_http_info(checker_workflow_path, entry_id, descriptor_type, **kwargs)  # noqa: E501
        else:
            (data) = self.register_checker_workflow_with_http_info(checker_workflow_path, entry_id, descriptor_type, **kwargs)  # noqa: E501
            return data

    def register_checker_workflow_with_http_info(self, checker_workflow_path, entry_id, descriptor_type, **kwargs):  # noqa: E501
        """Register a checker workflow and associates it with the given tool/workflow.  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.register_checker_workflow_with_http_info(checker_workflow_path, entry_id, descriptor_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str checker_workflow_path: Path of the main descriptor of the checker workflow (located in associated tool/workflow repository) (required)
        :param int entry_id: Entry Id of parent tool/workflow. (required)
        :param str descriptor_type: Descriptor type of the workflow, only CWL or WDL are support. (required)
        :param str test_parameter_path: Default path to test parameter files for the checker workflow. If not specified will use that of the entry.
        :return: Entry
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['checker_workflow_path', 'entry_id', 'descriptor_type', 'test_parameter_path']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method register_checker_workflow" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'checker_workflow_path' is set
        if self.api_client.client_side_validation and ('checker_workflow_path' not in params or
                                                       params['checker_workflow_path'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `checker_workflow_path` when calling `register_checker_workflow`")  # noqa: E501
        # verify the required parameter 'entry_id' is set
        if self.api_client.client_side_validation and ('entry_id' not in params or
                                                       params['entry_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `entry_id` when calling `register_checker_workflow`")  # noqa: E501
        # verify the required parameter 'descriptor_type' is set
        if self.api_client.client_side_validation and ('descriptor_type' not in params or
                                                       params['descriptor_type'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `descriptor_type` when calling `register_checker_workflow`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'entry_id' in params:
            path_params['entryId'] = params['entry_id']  # noqa: E501
        if 'descriptor_type' in params:
            path_params['descriptorType'] = params['descriptor_type']  # noqa: E501

        query_params = []
        if 'checker_workflow_path' in params:
            query_params.append(('checkerWorkflowPath', params['checker_workflow_path']))  # noqa: E501
        if 'test_parameter_path' in params:
            query_params.append(('testParameterPath', params['test_parameter_path']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/workflows/{entryId}/registerCheckerWorkflow/{descriptorType}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Entry',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_workflow_role(self, repository, email, role, **kwargs):  # noqa: E501
        """Remove the specified user role for a workflow.  # noqa: E501

        The user must be the workflow owner.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_workflow_role(repository, email, role, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repository: repository path (required)
        :param str email: user email (required)
        :param str role: role (required)
        :param bool services: services
        :return: list[Permission]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.remove_workflow_role_with_http_info(repository, email, role, **kwargs)  # noqa: E501
        else:
            (data) = self.remove_workflow_role_with_http_info(repository, email, role, **kwargs)  # noqa: E501
            return data

    def remove_workflow_role_with_http_info(self, repository, email, role, **kwargs):  # noqa: E501
        """Remove the specified user role for a workflow.  # noqa: E501

        The user must be the workflow owner.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_workflow_role_with_http_info(repository, email, role, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repository: repository path (required)
        :param str email: user email (required)
        :param str role: role (required)
        :param bool services: services
        :return: list[Permission]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['repository', 'email', 'role', 'services']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_workflow_role" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'repository' is set
        if self.api_client.client_side_validation and ('repository' not in params or
                                                       params['repository'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `repository` when calling `remove_workflow_role`")  # noqa: E501
        # verify the required parameter 'email' is set
        if self.api_client.client_side_validation and ('email' not in params or
                                                       params['email'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `email` when calling `remove_workflow_role`")  # noqa: E501
        # verify the required parameter 'role' is set
        if self.api_client.client_side_validation and ('role' not in params or
                                                       params['role'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `role` when calling `remove_workflow_role`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'repository' in params:
            path_params['repository'] = params['repository']  # noqa: E501

        query_params = []
        if 'email' in params:
            query_params.append(('email', params['email']))  # noqa: E501
        if 'role' in params:
            query_params.append(('role', params['role']))  # noqa: E501
        if 'services' in params:
            query_params.append(('services', params['services']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/workflows/path/workflow/{repository}/permissions', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Permission]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def request_doi_for_workflow_version(self, workflow_id, workflow_version_id, **kwargs):  # noqa: E501
        """Request a DOI for this version of a workflow.  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.request_doi_for_workflow_version(workflow_id, workflow_version_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int workflow_id: Workflow to modify. (required)
        :param int workflow_version_id: workflowVersionId (required)
        :param str body: This is here to appease Swagger. It requires PUT methods to have a body, even if it is empty. Please leave it empty.
        :return: list[WorkflowVersion]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.request_doi_for_workflow_version_with_http_info(workflow_id, workflow_version_id, **kwargs)  # noqa: E501
        else:
            (data) = self.request_doi_for_workflow_version_with_http_info(workflow_id, workflow_version_id, **kwargs)  # noqa: E501
            return data

    def request_doi_for_workflow_version_with_http_info(self, workflow_id, workflow_version_id, **kwargs):  # noqa: E501
        """Request a DOI for this version of a workflow.  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.request_doi_for_workflow_version_with_http_info(workflow_id, workflow_version_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int workflow_id: Workflow to modify. (required)
        :param int workflow_version_id: workflowVersionId (required)
        :param str body: This is here to appease Swagger. It requires PUT methods to have a body, even if it is empty. Please leave it empty.
        :return: list[WorkflowVersion]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workflow_id', 'workflow_version_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method request_doi_for_workflow_version" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workflow_id' is set
        if self.api_client.client_side_validation and ('workflow_id' not in params or
                                                       params['workflow_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `workflow_id` when calling `request_doi_for_workflow_version`")  # noqa: E501
        # verify the required parameter 'workflow_version_id' is set
        if self.api_client.client_side_validation and ('workflow_version_id' not in params or
                                                       params['workflow_version_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `workflow_version_id` when calling `request_doi_for_workflow_version`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workflow_id' in params:
            path_params['workflowId'] = params['workflow_id']  # noqa: E501
        if 'workflow_version_id' in params:
            path_params['workflowVersionId'] = params['workflow_version_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/workflows/{workflowId}/requestDOI/{workflowVersionId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[WorkflowVersion]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def restub(self, workflow_id, **kwargs):  # noqa: E501
        """Restub a workflow  # noqa: E501

        Restubs a full, unpublished workflow.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.restub(workflow_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int workflow_id: workflow ID (required)
        :return: Workflow
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.restub_with_http_info(workflow_id, **kwargs)  # noqa: E501
        else:
            (data) = self.restub_with_http_info(workflow_id, **kwargs)  # noqa: E501
            return data

    def restub_with_http_info(self, workflow_id, **kwargs):  # noqa: E501
        """Restub a workflow  # noqa: E501

        Restubs a full, unpublished workflow.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.restub_with_http_info(workflow_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int workflow_id: workflow ID (required)
        :return: Workflow
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workflow_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method restub" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workflow_id' is set
        if self.api_client.client_side_validation and ('workflow_id' not in params or
                                                       params['workflow_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `workflow_id` when calling `restub`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workflow_id' in params:
            path_params['workflowId'] = params['workflow_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/workflows/{workflowId}/restub', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Workflow',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def secondary_descriptor_path(self, workflow_id, relative_path, **kwargs):  # noqa: E501
        """Get the corresponding descriptor file from source control.  # noqa: E501

        Does not require authentication for published workflows, authentication can be provided for restricted workflows  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.secondary_descriptor_path(workflow_id, relative_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int workflow_id: Workflow id (required)
        :param str relative_path: (required)
        :param str tag:
        :param str language:
        :return: SourceFile
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.secondary_descriptor_path_with_http_info(workflow_id, relative_path, **kwargs)  # noqa: E501
        else:
            (data) = self.secondary_descriptor_path_with_http_info(workflow_id, relative_path, **kwargs)  # noqa: E501
            return data

    def secondary_descriptor_path_with_http_info(self, workflow_id, relative_path, **kwargs):  # noqa: E501
        """Get the corresponding descriptor file from source control.  # noqa: E501

        Does not require authentication for published workflows, authentication can be provided for restricted workflows  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.secondary_descriptor_path_with_http_info(workflow_id, relative_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int workflow_id: Workflow id (required)
        :param str relative_path: (required)
        :param str tag:
        :param str language:
        :return: SourceFile
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workflow_id', 'relative_path', 'tag', 'language']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method secondary_descriptor_path" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workflow_id' is set
        if self.api_client.client_side_validation and ('workflow_id' not in params or
                                                       params['workflow_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `workflow_id` when calling `secondary_descriptor_path`")  # noqa: E501
        # verify the required parameter 'relative_path' is set
        if self.api_client.client_side_validation and ('relative_path' not in params or
                                                       params['relative_path'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `relative_path` when calling `secondary_descriptor_path`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workflow_id' in params:
            path_params['workflowId'] = params['workflow_id']  # noqa: E501
        if 'relative_path' in params:
            path_params['relative-path'] = params['relative_path']  # noqa: E501

        query_params = []
        if 'tag' in params:
            query_params.append(('tag', params['tag']))  # noqa: E501
        if 'language' in params:
            query_params.append(('language', params['language']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/workflows/{workflowId}/descriptor/{relative-path}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SourceFile',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def secondary_descriptors(self, workflow_id, **kwargs):  # noqa: E501
        """Get the corresponding descriptor documents from source control.  # noqa: E501

        Does not require authentication for published workflows, authentication can be provided for restricted workflows  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.secondary_descriptors(workflow_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int workflow_id: Workflow id (required)
        :param str tag:
        :param str language:
        :return: list[SourceFile]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.secondary_descriptors_with_http_info(workflow_id, **kwargs)  # noqa: E501
        else:
            (data) = self.secondary_descriptors_with_http_info(workflow_id, **kwargs)  # noqa: E501
            return data

    def secondary_descriptors_with_http_info(self, workflow_id, **kwargs):  # noqa: E501
        """Get the corresponding descriptor documents from source control.  # noqa: E501

        Does not require authentication for published workflows, authentication can be provided for restricted workflows  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.secondary_descriptors_with_http_info(workflow_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int workflow_id: Workflow id (required)
        :param str tag:
        :param str language:
        :return: list[SourceFile]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workflow_id', 'tag', 'language']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method secondary_descriptors" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workflow_id' is set
        if self.api_client.client_side_validation and ('workflow_id' not in params or
                                                       params['workflow_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `workflow_id` when calling `secondary_descriptors`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workflow_id' in params:
            path_params['workflowId'] = params['workflow_id']  # noqa: E501

        query_params = []
        if 'tag' in params:
            query_params.append(('tag', params['tag']))  # noqa: E501
        if 'language' in params:
            query_params.append(('language', params['language']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/workflows/{workflowId}/secondaryDescriptors', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[SourceFile]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def shared_workflows(self, **kwargs):  # noqa: E501
        """Retrieve all workflows shared with user.  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.shared_workflows(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[SharedWorkflows]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.shared_workflows_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.shared_workflows_with_http_info(**kwargs)  # noqa: E501
            return data

    def shared_workflows_with_http_info(self, **kwargs):  # noqa: E501
        """Retrieve all workflows shared with user.  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.shared_workflows_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[SharedWorkflows]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method shared_workflows" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/workflows/shared', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[SharedWorkflows]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def star_entry(self, workflow_id, body, **kwargs):  # noqa: E501
        """Star a workflow.  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.star_entry(workflow_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int workflow_id: Tool to star. (required)
        :param StarRequest body: StarRequest to star a repo for a user (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.star_entry_with_http_info(workflow_id, body, **kwargs)  # noqa: E501
        else:
            (data) = self.star_entry_with_http_info(workflow_id, body, **kwargs)  # noqa: E501
            return data

    def star_entry_with_http_info(self, workflow_id, body, **kwargs):  # noqa: E501
        """Star a workflow.  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.star_entry_with_http_info(workflow_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int workflow_id: Tool to star. (required)
        :param StarRequest body: StarRequest to star a repo for a user (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workflow_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method star_entry" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workflow_id' is set
        if self.api_client.client_side_validation and ('workflow_id' not in params or
                                                       params['workflow_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `workflow_id` when calling `star_entry`")  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `star_entry`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workflow_id' in params:
            path_params['workflowId'] = params['workflow_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/workflows/{workflowId}/star', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_labels(self, workflow_id, labels, **kwargs):  # noqa: E501
        """Update the labels linked to a workflow.  # noqa: E501

        Labels are alphanumerical (case-insensitive and may contain internal hyphens), given in a comma-delimited list.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_labels(workflow_id, labels, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int workflow_id: Tool to modify. (required)
        :param str labels: Comma-delimited list of labels. (required)
        :param str body: This is here to appease Swagger. It requires PUT methods to have a body, even if it is empty. Please leave it empty.
        :return: Workflow
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_labels_with_http_info(workflow_id, labels, **kwargs)  # noqa: E501
        else:
            (data) = self.update_labels_with_http_info(workflow_id, labels, **kwargs)  # noqa: E501
            return data

    def update_labels_with_http_info(self, workflow_id, labels, **kwargs):  # noqa: E501
        """Update the labels linked to a workflow.  # noqa: E501

        Labels are alphanumerical (case-insensitive and may contain internal hyphens), given in a comma-delimited list.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_labels_with_http_info(workflow_id, labels, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int workflow_id: Tool to modify. (required)
        :param str labels: Comma-delimited list of labels. (required)
        :param str body: This is here to appease Swagger. It requires PUT methods to have a body, even if it is empty. Please leave it empty.
        :return: Workflow
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workflow_id', 'labels', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_labels" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workflow_id' is set
        if self.api_client.client_side_validation and ('workflow_id' not in params or
                                                       params['workflow_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `workflow_id` when calling `update_labels`")  # noqa: E501
        # verify the required parameter 'labels' is set
        if self.api_client.client_side_validation and ('labels' not in params or
                                                       params['labels'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `labels` when calling `update_labels`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workflow_id' in params:
            path_params['workflowId'] = params['workflow_id']  # noqa: E501

        query_params = []
        if 'labels' in params:
            query_params.append(('labels', params['labels']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/workflows/{workflowId}/labels', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Workflow',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_workflow(self, workflow_id, body, **kwargs):  # noqa: E501
        """Update the workflow with the given workflow.  # noqa: E501

        Updates descriptor type (if stub), default workflow path, default file path, and default version  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_workflow(workflow_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int workflow_id: Workflow to modify. (required)
        :param Workflow body: Workflow with updated information (required)
        :return: Workflow
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_workflow_with_http_info(workflow_id, body, **kwargs)  # noqa: E501
        else:
            (data) = self.update_workflow_with_http_info(workflow_id, body, **kwargs)  # noqa: E501
            return data

    def update_workflow_with_http_info(self, workflow_id, body, **kwargs):  # noqa: E501
        """Update the workflow with the given workflow.  # noqa: E501

        Updates descriptor type (if stub), default workflow path, default file path, and default version  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_workflow_with_http_info(workflow_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int workflow_id: Workflow to modify. (required)
        :param Workflow body: Workflow with updated information (required)
        :return: Workflow
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workflow_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_workflow" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workflow_id' is set
        if self.api_client.client_side_validation and ('workflow_id' not in params or
                                                       params['workflow_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `workflow_id` when calling `update_workflow`")  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `update_workflow`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workflow_id' in params:
            path_params['workflowId'] = params['workflow_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/workflows/{workflowId}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Workflow',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_workflow_default_version(self, workflow_id, body, **kwargs):  # noqa: E501
        """Update the default version of a workflow.  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_workflow_default_version(workflow_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int workflow_id: Workflow to modify. (required)
        :param str body: Version name to set as default (required)
        :return: Workflow
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_workflow_default_version_with_http_info(workflow_id, body, **kwargs)  # noqa: E501
        else:
            (data) = self.update_workflow_default_version_with_http_info(workflow_id, body, **kwargs)  # noqa: E501
            return data

    def update_workflow_default_version_with_http_info(self, workflow_id, body, **kwargs):  # noqa: E501
        """Update the default version of a workflow.  # noqa: E501

          # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_workflow_default_version_with_http_info(workflow_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int workflow_id: Workflow to modify. (required)
        :param str body: Version name to set as default (required)
        :return: Workflow
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workflow_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_workflow_default_version" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workflow_id' is set
        if self.api_client.client_side_validation and ('workflow_id' not in params or
                                                       params['workflow_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `workflow_id` when calling `update_workflow_default_version`")  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `update_workflow_default_version`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workflow_id' in params:
            path_params['workflowId'] = params['workflow_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/workflows/{workflowId}/defaultVersion', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Workflow',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_workflow_path(self, workflow_id, body, **kwargs):  # noqa: E501
        """Reset the workflow paths.  # noqa: E501

        Resets the workflow paths of all versions to match the default workflow path from the workflow object passed.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_workflow_path(workflow_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int workflow_id: Workflow to modify. (required)
        :param Workflow body: Workflow with updated information (required)
        :return: Workflow
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_workflow_path_with_http_info(workflow_id, body, **kwargs)  # noqa: E501
        else:
            (data) = self.update_workflow_path_with_http_info(workflow_id, body, **kwargs)  # noqa: E501
            return data

    def update_workflow_path_with_http_info(self, workflow_id, body, **kwargs):  # noqa: E501
        """Reset the workflow paths.  # noqa: E501

        Resets the workflow paths of all versions to match the default workflow path from the workflow object passed.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_workflow_path_with_http_info(workflow_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int workflow_id: Workflow to modify. (required)
        :param Workflow body: Workflow with updated information (required)
        :return: Workflow
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workflow_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_workflow_path" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workflow_id' is set
        if self.api_client.client_side_validation and ('workflow_id' not in params or
                                                       params['workflow_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `workflow_id` when calling `update_workflow_path`")  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `update_workflow_path`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workflow_id' in params:
            path_params['workflowId'] = params['workflow_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/workflows/{workflowId}/resetVersionPaths', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Workflow',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_workflow_version(self, workflow_id, body, **kwargs):  # noqa: E501
        """Update the workflow versions linked to a workflow.  # noqa: E501

        Updates workflow path, reference, and hidden attributes.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_workflow_version(workflow_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int workflow_id: Workflow to modify. (required)
        :param list[WorkflowVersion] body: List of modified workflow versions (required)
        :return: list[WorkflowVersion]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_workflow_version_with_http_info(workflow_id, body, **kwargs)  # noqa: E501
        else:
            (data) = self.update_workflow_version_with_http_info(workflow_id, body, **kwargs)  # noqa: E501
            return data

    def update_workflow_version_with_http_info(self, workflow_id, body, **kwargs):  # noqa: E501
        """Update the workflow versions linked to a workflow.  # noqa: E501

        Updates workflow path, reference, and hidden attributes.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_workflow_version_with_http_info(workflow_id, body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int workflow_id: Workflow to modify. (required)
        :param list[WorkflowVersion] body: List of modified workflow versions (required)
        :return: list[WorkflowVersion]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['workflow_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_workflow_version" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'workflow_id' is set
        if self.api_client.client_side_validation and ('workflow_id' not in params or
                                                       params['workflow_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `workflow_id` when calling `update_workflow_version`")  # noqa: E501
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `update_workflow_version`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'workflow_id' in params:
            path_params['workflowId'] = params['workflow_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['BEARER']  # noqa: E501

        return self.api_client.call_api(
            '/workflows/{workflowId}/workflowVersions', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[WorkflowVersion]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
