# coding: utf-8

"""
    Dockstore API

    This describes the dockstore API, a webservice that manages pairs of Docker images and associated metadata such as CWL documents and Dockerfiles used to build those images. Explore swagger.json for a Swagger 2.0 description of our API and explore openapi.yaml for OpenAPI 3.0 descriptions.  # noqa: E501

    OpenAPI spec version: 1.12.0-alpha.1-SNAPSHOT
    Contact: theglobalalliance@genomicsandhealth.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from jgreenepack.configuration import Configuration


class Author(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'affiliation': 'str',
        'email': 'str',
        'role': 'str',
        'name': 'str'
    }

    attribute_map = {
        'affiliation': 'affiliation',
        'email': 'email',
        'role': 'role',
        'name': 'name'
    }

    def __init__(self, affiliation=None, email=None, role=None, name=None, _configuration=None):  # noqa: E501
        """Author - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._affiliation = None
        self._email = None
        self._role = None
        self._name = None
        self.discriminator = None

        if affiliation is not None:
            self.affiliation = affiliation
        if email is not None:
            self.email = email
        if role is not None:
            self.role = role
        self.name = name

    @property
    def affiliation(self):
        """Gets the affiliation of this Author.  # noqa: E501

        Affiliation of the author  # noqa: E501

        :return: The affiliation of this Author.  # noqa: E501
        :rtype: str
        """
        return self._affiliation

    @affiliation.setter
    def affiliation(self, affiliation):
        """Sets the affiliation of this Author.

        Affiliation of the author  # noqa: E501

        :param affiliation: The affiliation of this Author.  # noqa: E501
        :type: str
        """

        self._affiliation = affiliation

    @property
    def email(self):
        """Gets the email of this Author.  # noqa: E501

        Email of the author  # noqa: E501

        :return: The email of this Author.  # noqa: E501
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email):
        """Sets the email of this Author.

        Email of the author  # noqa: E501

        :param email: The email of this Author.  # noqa: E501
        :type: str
        """

        self._email = email

    @property
    def role(self):
        """Gets the role of this Author.  # noqa: E501

        Role of the author  # noqa: E501

        :return: The role of this Author.  # noqa: E501
        :rtype: str
        """
        return self._role

    @role.setter
    def role(self, role):
        """Sets the role of this Author.

        Role of the author  # noqa: E501

        :param role: The role of this Author.  # noqa: E501
        :type: str
        """

        self._role = role

    @property
    def name(self):
        """Gets the name of this Author.  # noqa: E501

        Name of the author  # noqa: E501

        :return: The name of this Author.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Author.

        Name of the author  # noqa: E501

        :param name: The name of this Author.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Author, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Author):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Author):
            return True

        return self.to_dict() != other.to_dict()
