# coding: utf-8

"""
    Dockstore API

    This describes the dockstore API, a webservice that manages pairs of Docker images and associated metadata such as CWL documents and Dockerfiles used to build those images. Explore swagger.json for a Swagger 2.0 description of our API and explore openapi.yaml for OpenAPI 3.0 descriptions.  # noqa: E501

    OpenAPI spec version: 1.12.0-alpha.1-SNAPSHOT
    Contact: theglobalalliance@genomicsandhealth.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from jgreenepack.configuration import Configuration


class Collection(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'aliases': 'dict(str, Alias)',
        'db_create_date': 'int',
        'db_update_date': 'int',
        'entries': 'list[CollectionEntry]',
        'id': 'int',
        'organization_id': 'int',
        'organization_name': 'str',
        'name': 'str',
        'description': 'str',
        'display_name': 'str',
        'topic': 'str',
        'workflows_length': 'int',
        'tools_length': 'int'
    }

    attribute_map = {
        'aliases': 'aliases',
        'db_create_date': 'dbCreateDate',
        'db_update_date': 'dbUpdateDate',
        'entries': 'entries',
        'id': 'id',
        'organization_id': 'organizationID',
        'organization_name': 'organizationName',
        'name': 'name',
        'description': 'description',
        'display_name': 'displayName',
        'topic': 'topic',
        'workflows_length': 'workflowsLength',
        'tools_length': 'toolsLength'
    }

    def __init__(self, aliases=None, db_create_date=None, db_update_date=None, entries=None, id=None, organization_id=None, organization_name=None, name=None, description=None, display_name=None, topic=None, workflows_length=None, tools_length=None, _configuration=None):  # noqa: E501
        """Collection - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._aliases = None
        self._db_create_date = None
        self._db_update_date = None
        self._entries = None
        self._id = None
        self._organization_id = None
        self._organization_name = None
        self._name = None
        self._description = None
        self._display_name = None
        self._topic = None
        self._workflows_length = None
        self._tools_length = None
        self.discriminator = None

        if aliases is not None:
            self.aliases = aliases
        if db_create_date is not None:
            self.db_create_date = db_create_date
        if db_update_date is not None:
            self.db_update_date = db_update_date
        if entries is not None:
            self.entries = entries
        if id is not None:
            self.id = id
        if organization_id is not None:
            self.organization_id = organization_id
        if organization_name is not None:
            self.organization_name = organization_name
        self.name = name
        if description is not None:
            self.description = description
        if display_name is not None:
            self.display_name = display_name
        if topic is not None:
            self.topic = topic
        if workflows_length is not None:
            self.workflows_length = workflows_length
        if tools_length is not None:
            self.tools_length = tools_length

    @property
    def aliases(self):
        """Gets the aliases of this Collection.  # noqa: E501

        aliases can be used as an alternate unique id for collections  # noqa: E501

        :return: The aliases of this Collection.  # noqa: E501
        :rtype: dict(str, Alias)
        """
        return self._aliases

    @aliases.setter
    def aliases(self, aliases):
        """Sets the aliases of this Collection.

        aliases can be used as an alternate unique id for collections  # noqa: E501

        :param aliases: The aliases of this Collection.  # noqa: E501
        :type: dict(str, Alias)
        """

        self._aliases = aliases

    @property
    def db_create_date(self):
        """Gets the db_create_date of this Collection.  # noqa: E501


        :return: The db_create_date of this Collection.  # noqa: E501
        :rtype: int
        """
        return self._db_create_date

    @db_create_date.setter
    def db_create_date(self, db_create_date):
        """Sets the db_create_date of this Collection.


        :param db_create_date: The db_create_date of this Collection.  # noqa: E501
        :type: int
        """

        self._db_create_date = db_create_date

    @property
    def db_update_date(self):
        """Gets the db_update_date of this Collection.  # noqa: E501


        :return: The db_update_date of this Collection.  # noqa: E501
        :rtype: int
        """
        return self._db_update_date

    @db_update_date.setter
    def db_update_date(self, db_update_date):
        """Sets the db_update_date of this Collection.


        :param db_update_date: The db_update_date of this Collection.  # noqa: E501
        :type: int
        """

        self._db_update_date = db_update_date

    @property
    def entries(self):
        """Gets the entries of this Collection.  # noqa: E501


        :return: The entries of this Collection.  # noqa: E501
        :rtype: list[CollectionEntry]
        """
        return self._entries

    @entries.setter
    def entries(self, entries):
        """Sets the entries of this Collection.


        :param entries: The entries of this Collection.  # noqa: E501
        :type: list[CollectionEntry]
        """

        self._entries = entries

    @property
    def id(self):
        """Gets the id of this Collection.  # noqa: E501

        Implementation specific ID for the collection in this web service  # noqa: E501

        :return: The id of this Collection.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Collection.

        Implementation specific ID for the collection in this web service  # noqa: E501

        :param id: The id of this Collection.  # noqa: E501
        :type: int
        """

        self._id = id

    @property
    def organization_id(self):
        """Gets the organization_id of this Collection.  # noqa: E501


        :return: The organization_id of this Collection.  # noqa: E501
        :rtype: int
        """
        return self._organization_id

    @organization_id.setter
    def organization_id(self, organization_id):
        """Sets the organization_id of this Collection.


        :param organization_id: The organization_id of this Collection.  # noqa: E501
        :type: int
        """

        self._organization_id = organization_id

    @property
    def organization_name(self):
        """Gets the organization_name of this Collection.  # noqa: E501

        The name of the organization the collection belongs to  # noqa: E501

        :return: The organization_name of this Collection.  # noqa: E501
        :rtype: str
        """
        return self._organization_name

    @organization_name.setter
    def organization_name(self, organization_name):
        """Sets the organization_name of this Collection.

        The name of the organization the collection belongs to  # noqa: E501

        :param organization_name: The organization_name of this Collection.  # noqa: E501
        :type: str
        """

        self._organization_name = organization_name

    @property
    def name(self):
        """Gets the name of this Collection.  # noqa: E501

        Name of the collection.  # noqa: E501

        :return: The name of this Collection.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Collection.

        Name of the collection.  # noqa: E501

        :param name: The name of this Collection.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501
        if (self._configuration.client_side_validation and
                name is not None and len(name) > 39):
            raise ValueError("Invalid value for `name`, length must be less than or equal to `39`")  # noqa: E501
        if (self._configuration.client_side_validation and
                name is not None and len(name) < 3):
            raise ValueError("Invalid value for `name`, length must be greater than or equal to `3`")  # noqa: E501
        if (self._configuration.client_side_validation and
                name is not None and not re.search(r'[a-zA-Z][a-zA-Z\\d]*', name)):  # noqa: E501
            raise ValueError(r"Invalid value for `name`, must be a follow pattern or equal to `/[a-zA-Z][a-zA-Z\\d]*/`")  # noqa: E501

        self._name = name

    @property
    def description(self):
        """Gets the description of this Collection.  # noqa: E501

        Description of the collection  # noqa: E501

        :return: The description of this Collection.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this Collection.

        Description of the collection  # noqa: E501

        :param description: The description of this Collection.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def display_name(self):
        """Gets the display_name of this Collection.  # noqa: E501

        Display name for a collection (Ex. Recommended Alignment Algorithms). Not used for links.  # noqa: E501

        :return: The display_name of this Collection.  # noqa: E501
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """Sets the display_name of this Collection.

        Display name for a collection (Ex. Recommended Alignment Algorithms). Not used for links.  # noqa: E501

        :param display_name: The display_name of this Collection.  # noqa: E501
        :type: str
        """
        if (self._configuration.client_side_validation and
                display_name is not None and len(display_name) > 50):
            raise ValueError("Invalid value for `display_name`, length must be less than or equal to `50`")  # noqa: E501
        if (self._configuration.client_side_validation and
                display_name is not None and len(display_name) < 3):
            raise ValueError("Invalid value for `display_name`, length must be greater than or equal to `3`")  # noqa: E501
        if (self._configuration.client_side_validation and
                display_name is not None and not re.search(r'[\\w ,_\\-&()\']*', display_name)):  # noqa: E501
            raise ValueError(r"Invalid value for `display_name`, must be a follow pattern or equal to `/[\\w ,_\\-&()']*/`")  # noqa: E501

        self._display_name = display_name

    @property
    def topic(self):
        """Gets the topic of this Collection.  # noqa: E501

        Short description of the collection  # noqa: E501

        :return: The topic of this Collection.  # noqa: E501
        :rtype: str
        """
        return self._topic

    @topic.setter
    def topic(self, topic):
        """Sets the topic of this Collection.

        Short description of the collection  # noqa: E501

        :param topic: The topic of this Collection.  # noqa: E501
        :type: str
        """

        self._topic = topic

    @property
    def workflows_length(self):
        """Gets the workflows_length of this Collection.  # noqa: E501

        Number of workflows inside this collection  # noqa: E501

        :return: The workflows_length of this Collection.  # noqa: E501
        :rtype: int
        """
        return self._workflows_length

    @workflows_length.setter
    def workflows_length(self, workflows_length):
        """Sets the workflows_length of this Collection.

        Number of workflows inside this collection  # noqa: E501

        :param workflows_length: The workflows_length of this Collection.  # noqa: E501
        :type: int
        """

        self._workflows_length = workflows_length

    @property
    def tools_length(self):
        """Gets the tools_length of this Collection.  # noqa: E501

        Number of tools inside this collection  # noqa: E501

        :return: The tools_length of this Collection.  # noqa: E501
        :rtype: int
        """
        return self._tools_length

    @tools_length.setter
    def tools_length(self, tools_length):
        """Sets the tools_length of this Collection.

        Number of tools inside this collection  # noqa: E501

        :param tools_length: The tools_length of this Collection.  # noqa: E501
        :type: int
        """

        self._tools_length = tools_length

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Collection, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Collection):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Collection):
            return True

        return self.to_dict() != other.to_dict()
