# coding: utf-8

"""
    Dockstore API

    This describes the dockstore API, a webservice that manages pairs of Docker images and associated metadata such as CWL documents and Dockerfiles used to build those images. Explore swagger.json for a Swagger 2.0 description of our API and explore openapi.yaml for OpenAPI 3.0 descriptions.  # noqa: E501

    OpenAPI spec version: 1.12.0-alpha.1-SNAPSHOT
    Contact: theglobalalliance@genomicsandhealth.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from jgreenepack.configuration import Configuration


class CollectionEntry(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'db_update_date': 'int',
        'descriptor_types': 'list[str]',
        'entry_path': 'str',
        'entry_type': 'str',
        'id': 'int',
        'labels': 'list[str]',
        'verified': 'bool',
        'version_name': 'str'
    }

    attribute_map = {
        'db_update_date': 'dbUpdateDate',
        'descriptor_types': 'descriptorTypes',
        'entry_path': 'entryPath',
        'entry_type': 'entryType',
        'id': 'id',
        'labels': 'labels',
        'verified': 'verified',
        'version_name': 'versionName'
    }

    def __init__(self, db_update_date=None, descriptor_types=None, entry_path=None, entry_type=None, id=None, labels=None, verified=None, version_name=None, _configuration=None):  # noqa: E501
        """CollectionEntry - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._db_update_date = None
        self._descriptor_types = None
        self._entry_path = None
        self._entry_type = None
        self._id = None
        self._labels = None
        self._verified = None
        self._version_name = None
        self.discriminator = None

        if db_update_date is not None:
            self.db_update_date = db_update_date
        if descriptor_types is not None:
            self.descriptor_types = descriptor_types
        if entry_path is not None:
            self.entry_path = entry_path
        if entry_type is not None:
            self.entry_type = entry_type
        if id is not None:
            self.id = id
        if labels is not None:
            self.labels = labels
        if verified is not None:
            self.verified = verified
        if version_name is not None:
            self.version_name = version_name

    @property
    def db_update_date(self):
        """Gets the db_update_date of this CollectionEntry.  # noqa: E501


        :return: The db_update_date of this CollectionEntry.  # noqa: E501
        :rtype: int
        """
        return self._db_update_date

    @db_update_date.setter
    def db_update_date(self, db_update_date):
        """Sets the db_update_date of this CollectionEntry.


        :param db_update_date: The db_update_date of this CollectionEntry.  # noqa: E501
        :type: int
        """

        self._db_update_date = db_update_date

    @property
    def descriptor_types(self):
        """Gets the descriptor_types of this CollectionEntry.  # noqa: E501


        :return: The descriptor_types of this CollectionEntry.  # noqa: E501
        :rtype: list[str]
        """
        return self._descriptor_types

    @descriptor_types.setter
    def descriptor_types(self, descriptor_types):
        """Sets the descriptor_types of this CollectionEntry.


        :param descriptor_types: The descriptor_types of this CollectionEntry.  # noqa: E501
        :type: list[str]
        """

        self._descriptor_types = descriptor_types

    @property
    def entry_path(self):
        """Gets the entry_path of this CollectionEntry.  # noqa: E501


        :return: The entry_path of this CollectionEntry.  # noqa: E501
        :rtype: str
        """
        return self._entry_path

    @entry_path.setter
    def entry_path(self, entry_path):
        """Sets the entry_path of this CollectionEntry.


        :param entry_path: The entry_path of this CollectionEntry.  # noqa: E501
        :type: str
        """

        self._entry_path = entry_path

    @property
    def entry_type(self):
        """Gets the entry_type of this CollectionEntry.  # noqa: E501


        :return: The entry_type of this CollectionEntry.  # noqa: E501
        :rtype: str
        """
        return self._entry_type

    @entry_type.setter
    def entry_type(self, entry_type):
        """Sets the entry_type of this CollectionEntry.


        :param entry_type: The entry_type of this CollectionEntry.  # noqa: E501
        :type: str
        """

        self._entry_type = entry_type

    @property
    def id(self):
        """Gets the id of this CollectionEntry.  # noqa: E501


        :return: The id of this CollectionEntry.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this CollectionEntry.


        :param id: The id of this CollectionEntry.  # noqa: E501
        :type: int
        """

        self._id = id

    @property
    def labels(self):
        """Gets the labels of this CollectionEntry.  # noqa: E501


        :return: The labels of this CollectionEntry.  # noqa: E501
        :rtype: list[str]
        """
        return self._labels

    @labels.setter
    def labels(self, labels):
        """Sets the labels of this CollectionEntry.


        :param labels: The labels of this CollectionEntry.  # noqa: E501
        :type: list[str]
        """

        self._labels = labels

    @property
    def verified(self):
        """Gets the verified of this CollectionEntry.  # noqa: E501


        :return: The verified of this CollectionEntry.  # noqa: E501
        :rtype: bool
        """
        return self._verified

    @verified.setter
    def verified(self, verified):
        """Sets the verified of this CollectionEntry.


        :param verified: The verified of this CollectionEntry.  # noqa: E501
        :type: bool
        """

        self._verified = verified

    @property
    def version_name(self):
        """Gets the version_name of this CollectionEntry.  # noqa: E501


        :return: The version_name of this CollectionEntry.  # noqa: E501
        :rtype: str
        """
        return self._version_name

    @version_name.setter
    def version_name(self, version_name):
        """Sets the version_name of this CollectionEntry.


        :param version_name: The version_name of this CollectionEntry.  # noqa: E501
        :type: str
        """

        self._version_name = version_name

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(CollectionEntry, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CollectionEntry):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, CollectionEntry):
            return True

        return self.to_dict() != other.to_dict()
