# coding: utf-8

"""
    Dockstore API

    This describes the dockstore API, a webservice that manages pairs of Docker images and associated metadata such as CWL documents and Dockerfiles used to build those images. Explore swagger.json for a Swagger 2.0 description of our API and explore openapi.yaml for OpenAPI 3.0 descriptions.  # noqa: E501

    OpenAPI spec version: 1.12.0-alpha.1-SNAPSHOT
    Contact: theglobalalliance@genomicsandhealth.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from jgreenepack.configuration import Configuration


class DockstoreTool(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'aliases': 'dict(str, Alias)',
        'custom_docker_registry_path': 'str',
        'db_create_date': 'int',
        'db_update_date': 'int',
        'forum_url': 'str',
        'has_checker': 'bool',
        'id': 'int',
        'last_modified_date': 'int',
        'license_information': 'LicenseInformation',
        'orcid_put_code': 'str',
        'tags': 'list[Tag]',
        'topic_id': 'int',
        'author': 'str',
        'description': 'str',
        'labels': 'list[Label]',
        'users': 'list[User]',
        'starred_users': 'list[User]',
        'email': 'str',
        'default_version': 'str',
        'is_published': 'bool',
        'last_modified': 'int',
        'last_updated': 'int',
        'git_url': 'str',
        'checker_id': 'int',
        'mode': 'str',
        'concept_doi': 'str',
        'name': 'str',
        'default_dockerfile_path': 'str',
        'input_file_formats': 'list[FileFormat]',
        'default_cwl_path': 'str',
        'output_file_formats': 'list[FileFormat]',
        'default_wdl_path': 'str',
        'default_cwl_test_parameter_file': 'str',
        'default_wdl_test_parameter_file': 'str',
        'tool_maintainer_email': 'str',
        'private_access': 'bool',
        'toolname': 'str',
        'namespace': 'str',
        'registry_string': 'str',
        'last_build': 'int',
        'workflow_versions': 'list[Tag]',
        'path': 'str',
        'descriptor_type': 'list[str]',
        'tool_path': 'str',
        'registry': 'str'
    }

    attribute_map = {
        'aliases': 'aliases',
        'custom_docker_registry_path': 'custom_docker_registry_path',
        'db_create_date': 'dbCreateDate',
        'db_update_date': 'dbUpdateDate',
        'forum_url': 'forumUrl',
        'has_checker': 'has_checker',
        'id': 'id',
        'last_modified_date': 'last_modified_date',
        'license_information': 'licenseInformation',
        'orcid_put_code': 'orcidPutCode',
        'tags': 'tags',
        'topic_id': 'topicId',
        'author': 'author',
        'description': 'description',
        'labels': 'labels',
        'users': 'users',
        'starred_users': 'starredUsers',
        'email': 'email',
        'default_version': 'defaultVersion',
        'is_published': 'is_published',
        'last_modified': 'last_modified',
        'last_updated': 'lastUpdated',
        'git_url': 'gitUrl',
        'checker_id': 'checker_id',
        'mode': 'mode',
        'concept_doi': 'conceptDoi',
        'name': 'name',
        'default_dockerfile_path': 'default_dockerfile_path',
        'input_file_formats': 'input_file_formats',
        'default_cwl_path': 'default_cwl_path',
        'output_file_formats': 'output_file_formats',
        'default_wdl_path': 'default_wdl_path',
        'default_cwl_test_parameter_file': 'defaultCWLTestParameterFile',
        'default_wdl_test_parameter_file': 'defaultWDLTestParameterFile',
        'tool_maintainer_email': 'tool_maintainer_email',
        'private_access': 'private_access',
        'toolname': 'toolname',
        'namespace': 'namespace',
        'registry_string': 'registry_string',
        'last_build': 'lastBuild',
        'workflow_versions': 'workflowVersions',
        'path': 'path',
        'descriptor_type': 'descriptorType',
        'tool_path': 'tool_path',
        'registry': 'registry'
    }

    def __init__(self, aliases=None, custom_docker_registry_path=None, db_create_date=None, db_update_date=None, forum_url=None, has_checker=None, id=None, last_modified_date=None, license_information=None, orcid_put_code=None, tags=None, topic_id=None, author=None, description=None, labels=None, users=None, starred_users=None, email=None, default_version=None, is_published=None, last_modified=None, last_updated=None, git_url=None, checker_id=None, mode=None, concept_doi=None, name=None, default_dockerfile_path=None, input_file_formats=None, default_cwl_path=None, output_file_formats=None, default_wdl_path=None, default_cwl_test_parameter_file=None, default_wdl_test_parameter_file=None, tool_maintainer_email=None, private_access=None, toolname=None, namespace=None, registry_string=None, last_build=None, workflow_versions=None, path=None, descriptor_type=None, tool_path=None, registry=None, _configuration=None):  # noqa: E501
        """DockstoreTool - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._aliases = None
        self._custom_docker_registry_path = None
        self._db_create_date = None
        self._db_update_date = None
        self._forum_url = None
        self._has_checker = None
        self._id = None
        self._last_modified_date = None
        self._license_information = None
        self._orcid_put_code = None
        self._tags = None
        self._topic_id = None
        self._author = None
        self._description = None
        self._labels = None
        self._users = None
        self._starred_users = None
        self._email = None
        self._default_version = None
        self._is_published = None
        self._last_modified = None
        self._last_updated = None
        self._git_url = None
        self._checker_id = None
        self._mode = None
        self._concept_doi = None
        self._name = None
        self._default_dockerfile_path = None
        self._input_file_formats = None
        self._default_cwl_path = None
        self._output_file_formats = None
        self._default_wdl_path = None
        self._default_cwl_test_parameter_file = None
        self._default_wdl_test_parameter_file = None
        self._tool_maintainer_email = None
        self._private_access = None
        self._toolname = None
        self._namespace = None
        self._registry_string = None
        self._last_build = None
        self._workflow_versions = None
        self._path = None
        self._descriptor_type = None
        self._tool_path = None
        self._registry = None
        self.discriminator = None

        if aliases is not None:
            self.aliases = aliases
        if custom_docker_registry_path is not None:
            self.custom_docker_registry_path = custom_docker_registry_path
        if db_create_date is not None:
            self.db_create_date = db_create_date
        if db_update_date is not None:
            self.db_update_date = db_update_date
        if forum_url is not None:
            self.forum_url = forum_url
        if has_checker is not None:
            self.has_checker = has_checker
        if id is not None:
            self.id = id
        if last_modified_date is not None:
            self.last_modified_date = last_modified_date
        if license_information is not None:
            self.license_information = license_information
        if orcid_put_code is not None:
            self.orcid_put_code = orcid_put_code
        if tags is not None:
            self.tags = tags
        if topic_id is not None:
            self.topic_id = topic_id
        if author is not None:
            self.author = author
        if description is not None:
            self.description = description
        if labels is not None:
            self.labels = labels
        if users is not None:
            self.users = users
        if starred_users is not None:
            self.starred_users = starred_users
        if email is not None:
            self.email = email
        if default_version is not None:
            self.default_version = default_version
        if is_published is not None:
            self.is_published = is_published
        if last_modified is not None:
            self.last_modified = last_modified
        if last_updated is not None:
            self.last_updated = last_updated
        self.git_url = git_url
        if checker_id is not None:
            self.checker_id = checker_id
        self.mode = mode
        if concept_doi is not None:
            self.concept_doi = concept_doi
        self.name = name
        self.default_dockerfile_path = default_dockerfile_path
        if input_file_formats is not None:
            self.input_file_formats = input_file_formats
        self.default_cwl_path = default_cwl_path
        if output_file_formats is not None:
            self.output_file_formats = output_file_formats
        self.default_wdl_path = default_wdl_path
        self.default_cwl_test_parameter_file = default_cwl_test_parameter_file
        self.default_wdl_test_parameter_file = default_wdl_test_parameter_file
        if tool_maintainer_email is not None:
            self.tool_maintainer_email = tool_maintainer_email
        self.private_access = private_access
        if toolname is not None:
            self.toolname = toolname
        self.namespace = namespace
        self.registry_string = registry_string
        if last_build is not None:
            self.last_build = last_build
        if workflow_versions is not None:
            self.workflow_versions = workflow_versions
        if path is not None:
            self.path = path
        if descriptor_type is not None:
            self.descriptor_type = descriptor_type
        if tool_path is not None:
            self.tool_path = tool_path
        if registry is not None:
            self.registry = registry

    @property
    def aliases(self):
        """Gets the aliases of this DockstoreTool.  # noqa: E501

        aliases can be used as an alternate unique id for entries  # noqa: E501

        :return: The aliases of this DockstoreTool.  # noqa: E501
        :rtype: dict(str, Alias)
        """
        return self._aliases

    @aliases.setter
    def aliases(self, aliases):
        """Sets the aliases of this DockstoreTool.

        aliases can be used as an alternate unique id for entries  # noqa: E501

        :param aliases: The aliases of this DockstoreTool.  # noqa: E501
        :type: dict(str, Alias)
        """

        self._aliases = aliases

    @property
    def custom_docker_registry_path(self):
        """Gets the custom_docker_registry_path of this DockstoreTool.  # noqa: E501


        :return: The custom_docker_registry_path of this DockstoreTool.  # noqa: E501
        :rtype: str
        """
        return self._custom_docker_registry_path

    @custom_docker_registry_path.setter
    def custom_docker_registry_path(self, custom_docker_registry_path):
        """Sets the custom_docker_registry_path of this DockstoreTool.


        :param custom_docker_registry_path: The custom_docker_registry_path of this DockstoreTool.  # noqa: E501
        :type: str
        """

        self._custom_docker_registry_path = custom_docker_registry_path

    @property
    def db_create_date(self):
        """Gets the db_create_date of this DockstoreTool.  # noqa: E501


        :return: The db_create_date of this DockstoreTool.  # noqa: E501
        :rtype: int
        """
        return self._db_create_date

    @db_create_date.setter
    def db_create_date(self, db_create_date):
        """Sets the db_create_date of this DockstoreTool.


        :param db_create_date: The db_create_date of this DockstoreTool.  # noqa: E501
        :type: int
        """

        self._db_create_date = db_create_date

    @property
    def db_update_date(self):
        """Gets the db_update_date of this DockstoreTool.  # noqa: E501


        :return: The db_update_date of this DockstoreTool.  # noqa: E501
        :rtype: int
        """
        return self._db_update_date

    @db_update_date.setter
    def db_update_date(self, db_update_date):
        """Sets the db_update_date of this DockstoreTool.


        :param db_update_date: The db_update_date of this DockstoreTool.  # noqa: E501
        :type: int
        """

        self._db_update_date = db_update_date

    @property
    def forum_url(self):
        """Gets the forum_url of this DockstoreTool.  # noqa: E501

        This is a link to a forum or discussion board  # noqa: E501

        :return: The forum_url of this DockstoreTool.  # noqa: E501
        :rtype: str
        """
        return self._forum_url

    @forum_url.setter
    def forum_url(self, forum_url):
        """Sets the forum_url of this DockstoreTool.

        This is a link to a forum or discussion board  # noqa: E501

        :param forum_url: The forum_url of this DockstoreTool.  # noqa: E501
        :type: str
        """
        if (self._configuration.client_side_validation and
                forum_url is not None and len(forum_url) > 256):
            raise ValueError("Invalid value for `forum_url`, length must be less than or equal to `256`")  # noqa: E501
        if (self._configuration.client_side_validation and
                forum_url is not None and len(forum_url) < 0):
            raise ValueError("Invalid value for `forum_url`, length must be greater than or equal to `0`")  # noqa: E501

        self._forum_url = forum_url

    @property
    def has_checker(self):
        """Gets the has_checker of this DockstoreTool.  # noqa: E501


        :return: The has_checker of this DockstoreTool.  # noqa: E501
        :rtype: bool
        """
        return self._has_checker

    @has_checker.setter
    def has_checker(self, has_checker):
        """Sets the has_checker of this DockstoreTool.


        :param has_checker: The has_checker of this DockstoreTool.  # noqa: E501
        :type: bool
        """

        self._has_checker = has_checker

    @property
    def id(self):
        """Gets the id of this DockstoreTool.  # noqa: E501

        Implementation specific ID for the container in this web service  # noqa: E501

        :return: The id of this DockstoreTool.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this DockstoreTool.

        Implementation specific ID for the container in this web service  # noqa: E501

        :param id: The id of this DockstoreTool.  # noqa: E501
        :type: int
        """

        self._id = id

    @property
    def last_modified_date(self):
        """Gets the last_modified_date of this DockstoreTool.  # noqa: E501


        :return: The last_modified_date of this DockstoreTool.  # noqa: E501
        :rtype: int
        """
        return self._last_modified_date

    @last_modified_date.setter
    def last_modified_date(self, last_modified_date):
        """Sets the last_modified_date of this DockstoreTool.


        :param last_modified_date: The last_modified_date of this DockstoreTool.  # noqa: E501
        :type: int
        """

        self._last_modified_date = last_modified_date

    @property
    def license_information(self):
        """Gets the license_information of this DockstoreTool.  # noqa: E501


        :return: The license_information of this DockstoreTool.  # noqa: E501
        :rtype: LicenseInformation
        """
        return self._license_information

    @license_information.setter
    def license_information(self, license_information):
        """Sets the license_information of this DockstoreTool.


        :param license_information: The license_information of this DockstoreTool.  # noqa: E501
        :type: LicenseInformation
        """

        self._license_information = license_information

    @property
    def orcid_put_code(self):
        """Gets the orcid_put_code of this DockstoreTool.  # noqa: E501

        The presence of the put code indicates the entry was exported to ORCID.  # noqa: E501

        :return: The orcid_put_code of this DockstoreTool.  # noqa: E501
        :rtype: str
        """
        return self._orcid_put_code

    @orcid_put_code.setter
    def orcid_put_code(self, orcid_put_code):
        """Sets the orcid_put_code of this DockstoreTool.

        The presence of the put code indicates the entry was exported to ORCID.  # noqa: E501

        :param orcid_put_code: The orcid_put_code of this DockstoreTool.  # noqa: E501
        :type: str
        """

        self._orcid_put_code = orcid_put_code

    @property
    def tags(self):
        """Gets the tags of this DockstoreTool.  # noqa: E501


        :return: The tags of this DockstoreTool.  # noqa: E501
        :rtype: list[Tag]
        """
        return self._tags

    @tags.setter
    def tags(self, tags):
        """Sets the tags of this DockstoreTool.


        :param tags: The tags of this DockstoreTool.  # noqa: E501
        :type: list[Tag]
        """

        self._tags = tags

    @property
    def topic_id(self):
        """Gets the topic_id of this DockstoreTool.  # noqa: E501

        The Id of the corresponding topic on Dockstore Discuss  # noqa: E501

        :return: The topic_id of this DockstoreTool.  # noqa: E501
        :rtype: int
        """
        return self._topic_id

    @topic_id.setter
    def topic_id(self, topic_id):
        """Sets the topic_id of this DockstoreTool.

        The Id of the corresponding topic on Dockstore Discuss  # noqa: E501

        :param topic_id: The topic_id of this DockstoreTool.  # noqa: E501
        :type: int
        """

        self._topic_id = topic_id

    @property
    def author(self):
        """Gets the author of this DockstoreTool.  # noqa: E501

        This is the name of the author stated in the Dockstore.cwl  # noqa: E501

        :return: The author of this DockstoreTool.  # noqa: E501
        :rtype: str
        """
        return self._author

    @author.setter
    def author(self, author):
        """Sets the author of this DockstoreTool.

        This is the name of the author stated in the Dockstore.cwl  # noqa: E501

        :param author: The author of this DockstoreTool.  # noqa: E501
        :type: str
        """

        self._author = author

    @property
    def description(self):
        """Gets the description of this DockstoreTool.  # noqa: E501

        This is a human-readable description of this container and what it is trying to accomplish, required GA4GH  # noqa: E501

        :return: The description of this DockstoreTool.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this DockstoreTool.

        This is a human-readable description of this container and what it is trying to accomplish, required GA4GH  # noqa: E501

        :param description: The description of this DockstoreTool.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def labels(self):
        """Gets the labels of this DockstoreTool.  # noqa: E501

        Labels (i.e. meta tags) for describing the purpose and contents of containers  # noqa: E501

        :return: The labels of this DockstoreTool.  # noqa: E501
        :rtype: list[Label]
        """
        return self._labels

    @labels.setter
    def labels(self, labels):
        """Sets the labels of this DockstoreTool.

        Labels (i.e. meta tags) for describing the purpose and contents of containers  # noqa: E501

        :param labels: The labels of this DockstoreTool.  # noqa: E501
        :type: list[Label]
        """

        self._labels = labels

    @property
    def users(self):
        """Gets the users of this DockstoreTool.  # noqa: E501

        This indicates the users that have control over this entry, dockstore specific  # noqa: E501

        :return: The users of this DockstoreTool.  # noqa: E501
        :rtype: list[User]
        """
        return self._users

    @users.setter
    def users(self, users):
        """Sets the users of this DockstoreTool.

        This indicates the users that have control over this entry, dockstore specific  # noqa: E501

        :param users: The users of this DockstoreTool.  # noqa: E501
        :type: list[User]
        """

        self._users = users

    @property
    def starred_users(self):
        """Gets the starred_users of this DockstoreTool.  # noqa: E501

        This indicates the users that have starred this entry, dockstore specific  # noqa: E501

        :return: The starred_users of this DockstoreTool.  # noqa: E501
        :rtype: list[User]
        """
        return self._starred_users

    @starred_users.setter
    def starred_users(self, starred_users):
        """Sets the starred_users of this DockstoreTool.

        This indicates the users that have starred this entry, dockstore specific  # noqa: E501

        :param starred_users: The starred_users of this DockstoreTool.  # noqa: E501
        :type: list[User]
        """

        self._starred_users = starred_users

    @property
    def email(self):
        """Gets the email of this DockstoreTool.  # noqa: E501

        This is the email of the git organization  # noqa: E501

        :return: The email of this DockstoreTool.  # noqa: E501
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email):
        """Sets the email of this DockstoreTool.

        This is the email of the git organization  # noqa: E501

        :param email: The email of this DockstoreTool.  # noqa: E501
        :type: str
        """

        self._email = email

    @property
    def default_version(self):
        """Gets the default_version of this DockstoreTool.  # noqa: E501

        This is the name of the default version of the entry  # noqa: E501

        :return: The default_version of this DockstoreTool.  # noqa: E501
        :rtype: str
        """
        return self._default_version

    @default_version.setter
    def default_version(self, default_version):
        """Sets the default_version of this DockstoreTool.

        This is the name of the default version of the entry  # noqa: E501

        :param default_version: The default_version of this DockstoreTool.  # noqa: E501
        :type: str
        """

        self._default_version = default_version

    @property
    def is_published(self):
        """Gets the is_published of this DockstoreTool.  # noqa: E501

        Implementation specific visibility in this web service  # noqa: E501

        :return: The is_published of this DockstoreTool.  # noqa: E501
        :rtype: bool
        """
        return self._is_published

    @is_published.setter
    def is_published(self, is_published):
        """Sets the is_published of this DockstoreTool.

        Implementation specific visibility in this web service  # noqa: E501

        :param is_published: The is_published of this DockstoreTool.  # noqa: E501
        :type: bool
        """

        self._is_published = is_published

    @property
    def last_modified(self):
        """Gets the last_modified of this DockstoreTool.  # noqa: E501

        Implementation specific timestamp for last modified. Tools-> For automated/manual builds: N/A. For hosted: Last time a file was updated/created (new version created). Workflows-> For remote: When refresh is hit, last time GitHub repo was changed. Hosted: Last time a new version was made.  # noqa: E501

        :return: The last_modified of this DockstoreTool.  # noqa: E501
        :rtype: int
        """
        return self._last_modified

    @last_modified.setter
    def last_modified(self, last_modified):
        """Sets the last_modified of this DockstoreTool.

        Implementation specific timestamp for last modified. Tools-> For automated/manual builds: N/A. For hosted: Last time a file was updated/created (new version created). Workflows-> For remote: When refresh is hit, last time GitHub repo was changed. Hosted: Last time a new version was made.  # noqa: E501

        :param last_modified: The last_modified of this DockstoreTool.  # noqa: E501
        :type: int
        """

        self._last_modified = last_modified

    @property
    def last_updated(self):
        """Gets the last_updated of this DockstoreTool.  # noqa: E501

        Implementation specific timestamp for last updated on webservice. Tools-> For automated builds: last time tool/namespace was refreshed Dockstore, tool info (like changing dockerfile path) updated, or default version selected. For hosted tools: when you created the tool. Workflows-> For remote: When refresh all is hit for first time. Hosted: Seems to be time created.  # noqa: E501

        :return: The last_updated of this DockstoreTool.  # noqa: E501
        :rtype: int
        """
        return self._last_updated

    @last_updated.setter
    def last_updated(self, last_updated):
        """Sets the last_updated of this DockstoreTool.

        Implementation specific timestamp for last updated on webservice. Tools-> For automated builds: last time tool/namespace was refreshed Dockstore, tool info (like changing dockerfile path) updated, or default version selected. For hosted tools: when you created the tool. Workflows-> For remote: When refresh all is hit for first time. Hosted: Seems to be time created.  # noqa: E501

        :param last_updated: The last_updated of this DockstoreTool.  # noqa: E501
        :type: int
        """

        self._last_updated = last_updated

    @property
    def git_url(self):
        """Gets the git_url of this DockstoreTool.  # noqa: E501

        This is a link to the associated repo with a descriptor, required GA4GH  # noqa: E501

        :return: The git_url of this DockstoreTool.  # noqa: E501
        :rtype: str
        """
        return self._git_url

    @git_url.setter
    def git_url(self, git_url):
        """Sets the git_url of this DockstoreTool.

        This is a link to the associated repo with a descriptor, required GA4GH  # noqa: E501

        :param git_url: The git_url of this DockstoreTool.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and git_url is None:
            raise ValueError("Invalid value for `git_url`, must not be `None`")  # noqa: E501

        self._git_url = git_url

    @property
    def checker_id(self):
        """Gets the checker_id of this DockstoreTool.  # noqa: E501

        The id of the associated checker workflow  # noqa: E501

        :return: The checker_id of this DockstoreTool.  # noqa: E501
        :rtype: int
        """
        return self._checker_id

    @checker_id.setter
    def checker_id(self, checker_id):
        """Sets the checker_id of this DockstoreTool.

        The id of the associated checker workflow  # noqa: E501

        :param checker_id: The checker_id of this DockstoreTool.  # noqa: E501
        :type: int
        """

        self._checker_id = checker_id

    @property
    def mode(self):
        """Gets the mode of this DockstoreTool.  # noqa: E501

        This indicates what mode this is in which informs how we do things like refresh, dockstore specific  # noqa: E501

        :return: The mode of this DockstoreTool.  # noqa: E501
        :rtype: str
        """
        return self._mode

    @mode.setter
    def mode(self, mode):
        """Sets the mode of this DockstoreTool.

        This indicates what mode this is in which informs how we do things like refresh, dockstore specific  # noqa: E501

        :param mode: The mode of this DockstoreTool.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and mode is None:
            raise ValueError("Invalid value for `mode`, must not be `None`")  # noqa: E501
        allowed_values = ["AUTO_DETECT_QUAY_TAGS_AUTOMATED_BUILDS", "AUTO_DETECT_QUAY_TAGS_WITH_MIXED", "MANUAL_IMAGE_PATH", "HOSTED"]  # noqa: E501
        if (self._configuration.client_side_validation and
                mode not in allowed_values):
            raise ValueError(
                "Invalid value for `mode` ({0}), must be one of {1}"  # noqa: E501
                .format(mode, allowed_values)
            )

        self._mode = mode

    @property
    def concept_doi(self):
        """Gets the concept_doi of this DockstoreTool.  # noqa: E501

        The Digital Object Identifier (DOI) representing all of the versions of your workflow  # noqa: E501

        :return: The concept_doi of this DockstoreTool.  # noqa: E501
        :rtype: str
        """
        return self._concept_doi

    @concept_doi.setter
    def concept_doi(self, concept_doi):
        """Sets the concept_doi of this DockstoreTool.

        The Digital Object Identifier (DOI) representing all of the versions of your workflow  # noqa: E501

        :param concept_doi: The concept_doi of this DockstoreTool.  # noqa: E501
        :type: str
        """

        self._concept_doi = concept_doi

    @property
    def name(self):
        """Gets the name of this DockstoreTool.  # noqa: E501

        This is the name of the container, required: GA4GH  # noqa: E501

        :return: The name of this DockstoreTool.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this DockstoreTool.

        This is the name of the container, required: GA4GH  # noqa: E501

        :param name: The name of this DockstoreTool.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def default_dockerfile_path(self):
        """Gets the default_dockerfile_path of this DockstoreTool.  # noqa: E501

        This indicates for the associated git repository, the default path to the Dockerfile, required: GA4GH  # noqa: E501

        :return: The default_dockerfile_path of this DockstoreTool.  # noqa: E501
        :rtype: str
        """
        return self._default_dockerfile_path

    @default_dockerfile_path.setter
    def default_dockerfile_path(self, default_dockerfile_path):
        """Sets the default_dockerfile_path of this DockstoreTool.

        This indicates for the associated git repository, the default path to the Dockerfile, required: GA4GH  # noqa: E501

        :param default_dockerfile_path: The default_dockerfile_path of this DockstoreTool.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and default_dockerfile_path is None:
            raise ValueError("Invalid value for `default_dockerfile_path`, must not be `None`")  # noqa: E501

        self._default_dockerfile_path = default_dockerfile_path

    @property
    def input_file_formats(self):
        """Gets the input_file_formats of this DockstoreTool.  # noqa: E501

        File formats for describing the input file formats of every version of an entry  # noqa: E501

        :return: The input_file_formats of this DockstoreTool.  # noqa: E501
        :rtype: list[FileFormat]
        """
        return self._input_file_formats

    @input_file_formats.setter
    def input_file_formats(self, input_file_formats):
        """Sets the input_file_formats of this DockstoreTool.

        File formats for describing the input file formats of every version of an entry  # noqa: E501

        :param input_file_formats: The input_file_formats of this DockstoreTool.  # noqa: E501
        :type: list[FileFormat]
        """

        self._input_file_formats = input_file_formats

    @property
    def default_cwl_path(self):
        """Gets the default_cwl_path of this DockstoreTool.  # noqa: E501

        This indicates for the associated git repository, the default path to the CWL document, required: GA4GH  # noqa: E501

        :return: The default_cwl_path of this DockstoreTool.  # noqa: E501
        :rtype: str
        """
        return self._default_cwl_path

    @default_cwl_path.setter
    def default_cwl_path(self, default_cwl_path):
        """Sets the default_cwl_path of this DockstoreTool.

        This indicates for the associated git repository, the default path to the CWL document, required: GA4GH  # noqa: E501

        :param default_cwl_path: The default_cwl_path of this DockstoreTool.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and default_cwl_path is None:
            raise ValueError("Invalid value for `default_cwl_path`, must not be `None`")  # noqa: E501

        self._default_cwl_path = default_cwl_path

    @property
    def output_file_formats(self):
        """Gets the output_file_formats of this DockstoreTool.  # noqa: E501

        File formats for describing the output file formats of every version of an entry  # noqa: E501

        :return: The output_file_formats of this DockstoreTool.  # noqa: E501
        :rtype: list[FileFormat]
        """
        return self._output_file_formats

    @output_file_formats.setter
    def output_file_formats(self, output_file_formats):
        """Sets the output_file_formats of this DockstoreTool.

        File formats for describing the output file formats of every version of an entry  # noqa: E501

        :param output_file_formats: The output_file_formats of this DockstoreTool.  # noqa: E501
        :type: list[FileFormat]
        """

        self._output_file_formats = output_file_formats

    @property
    def default_wdl_path(self):
        """Gets the default_wdl_path of this DockstoreTool.  # noqa: E501

        This indicates for the associated git repository, the default path to the WDL document  # noqa: E501

        :return: The default_wdl_path of this DockstoreTool.  # noqa: E501
        :rtype: str
        """
        return self._default_wdl_path

    @default_wdl_path.setter
    def default_wdl_path(self, default_wdl_path):
        """Sets the default_wdl_path of this DockstoreTool.

        This indicates for the associated git repository, the default path to the WDL document  # noqa: E501

        :param default_wdl_path: The default_wdl_path of this DockstoreTool.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and default_wdl_path is None:
            raise ValueError("Invalid value for `default_wdl_path`, must not be `None`")  # noqa: E501

        self._default_wdl_path = default_wdl_path

    @property
    def default_cwl_test_parameter_file(self):
        """Gets the default_cwl_test_parameter_file of this DockstoreTool.  # noqa: E501

        This indicates for the associated git repository, the default path to the CWL test parameter file  # noqa: E501

        :return: The default_cwl_test_parameter_file of this DockstoreTool.  # noqa: E501
        :rtype: str
        """
        return self._default_cwl_test_parameter_file

    @default_cwl_test_parameter_file.setter
    def default_cwl_test_parameter_file(self, default_cwl_test_parameter_file):
        """Sets the default_cwl_test_parameter_file of this DockstoreTool.

        This indicates for the associated git repository, the default path to the CWL test parameter file  # noqa: E501

        :param default_cwl_test_parameter_file: The default_cwl_test_parameter_file of this DockstoreTool.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and default_cwl_test_parameter_file is None:
            raise ValueError("Invalid value for `default_cwl_test_parameter_file`, must not be `None`")  # noqa: E501

        self._default_cwl_test_parameter_file = default_cwl_test_parameter_file

    @property
    def default_wdl_test_parameter_file(self):
        """Gets the default_wdl_test_parameter_file of this DockstoreTool.  # noqa: E501

        This indicates for the associated git repository, the default path to the WDL test parameter file  # noqa: E501

        :return: The default_wdl_test_parameter_file of this DockstoreTool.  # noqa: E501
        :rtype: str
        """
        return self._default_wdl_test_parameter_file

    @default_wdl_test_parameter_file.setter
    def default_wdl_test_parameter_file(self, default_wdl_test_parameter_file):
        """Sets the default_wdl_test_parameter_file of this DockstoreTool.

        This indicates for the associated git repository, the default path to the WDL test parameter file  # noqa: E501

        :param default_wdl_test_parameter_file: The default_wdl_test_parameter_file of this DockstoreTool.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and default_wdl_test_parameter_file is None:
            raise ValueError("Invalid value for `default_wdl_test_parameter_file`, must not be `None`")  # noqa: E501

        self._default_wdl_test_parameter_file = default_wdl_test_parameter_file

    @property
    def tool_maintainer_email(self):
        """Gets the tool_maintainer_email of this DockstoreTool.  # noqa: E501

        The email address of the tool maintainer. Required for private repositories  # noqa: E501

        :return: The tool_maintainer_email of this DockstoreTool.  # noqa: E501
        :rtype: str
        """
        return self._tool_maintainer_email

    @tool_maintainer_email.setter
    def tool_maintainer_email(self, tool_maintainer_email):
        """Sets the tool_maintainer_email of this DockstoreTool.

        The email address of the tool maintainer. Required for private repositories  # noqa: E501

        :param tool_maintainer_email: The tool_maintainer_email of this DockstoreTool.  # noqa: E501
        :type: str
        """

        self._tool_maintainer_email = tool_maintainer_email

    @property
    def private_access(self):
        """Gets the private_access of this DockstoreTool.  # noqa: E501

        Is the docker image private or not.  # noqa: E501

        :return: The private_access of this DockstoreTool.  # noqa: E501
        :rtype: bool
        """
        return self._private_access

    @private_access.setter
    def private_access(self, private_access):
        """Sets the private_access of this DockstoreTool.

        Is the docker image private or not.  # noqa: E501

        :param private_access: The private_access of this DockstoreTool.  # noqa: E501
        :type: bool
        """
        if self._configuration.client_side_validation and private_access is None:
            raise ValueError("Invalid value for `private_access`, must not be `None`")  # noqa: E501

        self._private_access = private_access

    @property
    def toolname(self):
        """Gets the toolname of this DockstoreTool.  # noqa: E501

        This is the tool name of the container, when not-present this will function just like 0.1 dockstorewhen present, this can be used to distinguish between two containers based on the same image, but associated with different CWL and Dockerfile documents. i.e. two containers with the same registry+namespace+name but different toolnames will be two different entries in the dockstore registry/namespace/name/tool, different options to edit tags, and only the same insofar as they would \"docker pull\" the same image, required: GA4GH  # noqa: E501

        :return: The toolname of this DockstoreTool.  # noqa: E501
        :rtype: str
        """
        return self._toolname

    @toolname.setter
    def toolname(self, toolname):
        """Sets the toolname of this DockstoreTool.

        This is the tool name of the container, when not-present this will function just like 0.1 dockstorewhen present, this can be used to distinguish between two containers based on the same image, but associated with different CWL and Dockerfile documents. i.e. two containers with the same registry+namespace+name but different toolnames will be two different entries in the dockstore registry/namespace/name/tool, different options to edit tags, and only the same insofar as they would \"docker pull\" the same image, required: GA4GH  # noqa: E501

        :param toolname: The toolname of this DockstoreTool.  # noqa: E501
        :type: str
        """

        self._toolname = toolname

    @property
    def namespace(self):
        """Gets the namespace of this DockstoreTool.  # noqa: E501

        This is a docker namespace for the container, required: GA4GH  # noqa: E501

        :return: The namespace of this DockstoreTool.  # noqa: E501
        :rtype: str
        """
        return self._namespace

    @namespace.setter
    def namespace(self, namespace):
        """Sets the namespace of this DockstoreTool.

        This is a docker namespace for the container, required: GA4GH  # noqa: E501

        :param namespace: The namespace of this DockstoreTool.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and namespace is None:
            raise ValueError("Invalid value for `namespace`, must not be `None`")  # noqa: E501

        self._namespace = namespace

    @property
    def registry_string(self):
        """Gets the registry_string of this DockstoreTool.  # noqa: E501

        This is a specific docker provider like quay.io or dockerhub or n/a?, required: GA4GH  # noqa: E501

        :return: The registry_string of this DockstoreTool.  # noqa: E501
        :rtype: str
        """
        return self._registry_string

    @registry_string.setter
    def registry_string(self, registry_string):
        """Sets the registry_string of this DockstoreTool.

        This is a specific docker provider like quay.io or dockerhub or n/a?, required: GA4GH  # noqa: E501

        :param registry_string: The registry_string of this DockstoreTool.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and registry_string is None:
            raise ValueError("Invalid value for `registry_string`, must not be `None`")  # noqa: E501

        self._registry_string = registry_string

    @property
    def last_build(self):
        """Gets the last_build of this DockstoreTool.  # noqa: E501

        Implementation specific timestamp for last built. For automated builds: When refresh is hit, the last time the tool was built gets stored here. If tool was never built on quay.io, then last build will be null. N/A for hosted/manual path tools  # noqa: E501

        :return: The last_build of this DockstoreTool.  # noqa: E501
        :rtype: int
        """
        return self._last_build

    @last_build.setter
    def last_build(self, last_build):
        """Sets the last_build of this DockstoreTool.

        Implementation specific timestamp for last built. For automated builds: When refresh is hit, the last time the tool was built gets stored here. If tool was never built on quay.io, then last build will be null. N/A for hosted/manual path tools  # noqa: E501

        :param last_build: The last_build of this DockstoreTool.  # noqa: E501
        :type: int
        """

        self._last_build = last_build

    @property
    def workflow_versions(self):
        """Gets the workflow_versions of this DockstoreTool.  # noqa: E501

        Implementation specific tracking of valid build tags for the docker container  # noqa: E501

        :return: The workflow_versions of this DockstoreTool.  # noqa: E501
        :rtype: list[Tag]
        """
        return self._workflow_versions

    @workflow_versions.setter
    def workflow_versions(self, workflow_versions):
        """Sets the workflow_versions of this DockstoreTool.

        Implementation specific tracking of valid build tags for the docker container  # noqa: E501

        :param workflow_versions: The workflow_versions of this DockstoreTool.  # noqa: E501
        :type: list[Tag]
        """

        self._workflow_versions = workflow_versions

    @property
    def path(self):
        """Gets the path of this DockstoreTool.  # noqa: E501


        :return: The path of this DockstoreTool.  # noqa: E501
        :rtype: str
        """
        return self._path

    @path.setter
    def path(self, path):
        """Sets the path of this DockstoreTool.


        :param path: The path of this DockstoreTool.  # noqa: E501
        :type: str
        """

        self._path = path

    @property
    def descriptor_type(self):
        """Gets the descriptor_type of this DockstoreTool.  # noqa: E501


        :return: The descriptor_type of this DockstoreTool.  # noqa: E501
        :rtype: list[str]
        """
        return self._descriptor_type

    @descriptor_type.setter
    def descriptor_type(self, descriptor_type):
        """Sets the descriptor_type of this DockstoreTool.


        :param descriptor_type: The descriptor_type of this DockstoreTool.  # noqa: E501
        :type: list[str]
        """

        self._descriptor_type = descriptor_type

    @property
    def tool_path(self):
        """Gets the tool_path of this DockstoreTool.  # noqa: E501


        :return: The tool_path of this DockstoreTool.  # noqa: E501
        :rtype: str
        """
        return self._tool_path

    @tool_path.setter
    def tool_path(self, tool_path):
        """Sets the tool_path of this DockstoreTool.


        :param tool_path: The tool_path of this DockstoreTool.  # noqa: E501
        :type: str
        """

        self._tool_path = tool_path

    @property
    def registry(self):
        """Gets the registry of this DockstoreTool.  # noqa: E501


        :return: The registry of this DockstoreTool.  # noqa: E501
        :rtype: str
        """
        return self._registry

    @registry.setter
    def registry(self, registry):
        """Sets the registry of this DockstoreTool.


        :param registry: The registry of this DockstoreTool.  # noqa: E501
        :type: str
        """
        allowed_values = ["QUAY_IO", "DOCKER_HUB", "GITLAB", "AMAZON_ECR", "SEVEN_BRIDGES", "GITHUB_CONTAINER_REGISTRY"]  # noqa: E501
        if (self._configuration.client_side_validation and
                registry not in allowed_values):
            raise ValueError(
                "Invalid value for `registry` ({0}), must be one of {1}"  # noqa: E501
                .format(registry, allowed_values)
            )

        self._registry = registry

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(DockstoreTool, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DockstoreTool):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, DockstoreTool):
            return True

        return self.to_dict() != other.to_dict()
