# coding: utf-8

"""
    Dockstore API

    This describes the dockstore API, a webservice that manages pairs of Docker images and associated metadata such as CWL documents and Dockerfiles used to build those images. Explore swagger.json for a Swagger 2.0 description of our API and explore openapi.yaml for OpenAPI 3.0 descriptions.  # noqa: E501

    OpenAPI spec version: 1.12.0-alpha.1-SNAPSHOT
    Contact: theglobalalliance@genomicsandhealth.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from jgreenepack.configuration import Configuration


class Entry(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'aliases': 'dict(str, Alias)',
        'db_create_date': 'int',
        'db_update_date': 'int',
        'has_checker': 'bool',
        'id': 'int',
        'last_modified_date': 'int',
        'license_information': 'LicenseInformation',
        'orcid_put_code': 'str',
        'topic_id': 'int',
        'workflow_versions': 'list[Version]',
        'author': 'str',
        'description': 'str',
        'labels': 'list[Label]',
        'users': 'list[User]',
        'starred_users': 'list[User]',
        'email': 'str',
        'default_version': 'str',
        'is_published': 'bool',
        'last_modified': 'int',
        'last_updated': 'int',
        'git_url': 'str',
        'checker_id': 'int',
        'concept_doi': 'str',
        'input_file_formats': 'list[FileFormat]',
        'output_file_formats': 'list[FileFormat]'
    }

    attribute_map = {
        'aliases': 'aliases',
        'db_create_date': 'dbCreateDate',
        'db_update_date': 'dbUpdateDate',
        'has_checker': 'has_checker',
        'id': 'id',
        'last_modified_date': 'last_modified_date',
        'license_information': 'licenseInformation',
        'orcid_put_code': 'orcidPutCode',
        'topic_id': 'topicId',
        'workflow_versions': 'workflowVersions',
        'author': 'author',
        'description': 'description',
        'labels': 'labels',
        'users': 'users',
        'starred_users': 'starredUsers',
        'email': 'email',
        'default_version': 'defaultVersion',
        'is_published': 'is_published',
        'last_modified': 'last_modified',
        'last_updated': 'lastUpdated',
        'git_url': 'gitUrl',
        'checker_id': 'checker_id',
        'concept_doi': 'conceptDoi',
        'input_file_formats': 'input_file_formats',
        'output_file_formats': 'output_file_formats'
    }

    def __init__(self, aliases=None, db_create_date=None, db_update_date=None, has_checker=None, id=None, last_modified_date=None, license_information=None, orcid_put_code=None, topic_id=None, workflow_versions=None, author=None, description=None, labels=None, users=None, starred_users=None, email=None, default_version=None, is_published=None, last_modified=None, last_updated=None, git_url=None, checker_id=None, concept_doi=None, input_file_formats=None, output_file_formats=None, _configuration=None):  # noqa: E501
        """Entry - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._aliases = None
        self._db_create_date = None
        self._db_update_date = None
        self._has_checker = None
        self._id = None
        self._last_modified_date = None
        self._license_information = None
        self._orcid_put_code = None
        self._topic_id = None
        self._workflow_versions = None
        self._author = None
        self._description = None
        self._labels = None
        self._users = None
        self._starred_users = None
        self._email = None
        self._default_version = None
        self._is_published = None
        self._last_modified = None
        self._last_updated = None
        self._git_url = None
        self._checker_id = None
        self._concept_doi = None
        self._input_file_formats = None
        self._output_file_formats = None
        self.discriminator = None

        if aliases is not None:
            self.aliases = aliases
        if db_create_date is not None:
            self.db_create_date = db_create_date
        if db_update_date is not None:
            self.db_update_date = db_update_date
        if has_checker is not None:
            self.has_checker = has_checker
        if id is not None:
            self.id = id
        if last_modified_date is not None:
            self.last_modified_date = last_modified_date
        if license_information is not None:
            self.license_information = license_information
        if orcid_put_code is not None:
            self.orcid_put_code = orcid_put_code
        if topic_id is not None:
            self.topic_id = topic_id
        if workflow_versions is not None:
            self.workflow_versions = workflow_versions
        if author is not None:
            self.author = author
        if description is not None:
            self.description = description
        if labels is not None:
            self.labels = labels
        if users is not None:
            self.users = users
        if starred_users is not None:
            self.starred_users = starred_users
        if email is not None:
            self.email = email
        if default_version is not None:
            self.default_version = default_version
        if is_published is not None:
            self.is_published = is_published
        if last_modified is not None:
            self.last_modified = last_modified
        if last_updated is not None:
            self.last_updated = last_updated
        self.git_url = git_url
        if checker_id is not None:
            self.checker_id = checker_id
        if concept_doi is not None:
            self.concept_doi = concept_doi
        if input_file_formats is not None:
            self.input_file_formats = input_file_formats
        if output_file_formats is not None:
            self.output_file_formats = output_file_formats

    @property
    def aliases(self):
        """Gets the aliases of this Entry.  # noqa: E501

        aliases can be used as an alternate unique id for entries  # noqa: E501

        :return: The aliases of this Entry.  # noqa: E501
        :rtype: dict(str, Alias)
        """
        return self._aliases

    @aliases.setter
    def aliases(self, aliases):
        """Sets the aliases of this Entry.

        aliases can be used as an alternate unique id for entries  # noqa: E501

        :param aliases: The aliases of this Entry.  # noqa: E501
        :type: dict(str, Alias)
        """

        self._aliases = aliases

    @property
    def db_create_date(self):
        """Gets the db_create_date of this Entry.  # noqa: E501


        :return: The db_create_date of this Entry.  # noqa: E501
        :rtype: int
        """
        return self._db_create_date

    @db_create_date.setter
    def db_create_date(self, db_create_date):
        """Sets the db_create_date of this Entry.


        :param db_create_date: The db_create_date of this Entry.  # noqa: E501
        :type: int
        """

        self._db_create_date = db_create_date

    @property
    def db_update_date(self):
        """Gets the db_update_date of this Entry.  # noqa: E501


        :return: The db_update_date of this Entry.  # noqa: E501
        :rtype: int
        """
        return self._db_update_date

    @db_update_date.setter
    def db_update_date(self, db_update_date):
        """Sets the db_update_date of this Entry.


        :param db_update_date: The db_update_date of this Entry.  # noqa: E501
        :type: int
        """

        self._db_update_date = db_update_date

    @property
    def has_checker(self):
        """Gets the has_checker of this Entry.  # noqa: E501


        :return: The has_checker of this Entry.  # noqa: E501
        :rtype: bool
        """
        return self._has_checker

    @has_checker.setter
    def has_checker(self, has_checker):
        """Sets the has_checker of this Entry.


        :param has_checker: The has_checker of this Entry.  # noqa: E501
        :type: bool
        """

        self._has_checker = has_checker

    @property
    def id(self):
        """Gets the id of this Entry.  # noqa: E501

        Implementation specific ID for the container in this web service  # noqa: E501

        :return: The id of this Entry.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Entry.

        Implementation specific ID for the container in this web service  # noqa: E501

        :param id: The id of this Entry.  # noqa: E501
        :type: int
        """

        self._id = id

    @property
    def last_modified_date(self):
        """Gets the last_modified_date of this Entry.  # noqa: E501


        :return: The last_modified_date of this Entry.  # noqa: E501
        :rtype: int
        """
        return self._last_modified_date

    @last_modified_date.setter
    def last_modified_date(self, last_modified_date):
        """Sets the last_modified_date of this Entry.


        :param last_modified_date: The last_modified_date of this Entry.  # noqa: E501
        :type: int
        """

        self._last_modified_date = last_modified_date

    @property
    def license_information(self):
        """Gets the license_information of this Entry.  # noqa: E501


        :return: The license_information of this Entry.  # noqa: E501
        :rtype: LicenseInformation
        """
        return self._license_information

    @license_information.setter
    def license_information(self, license_information):
        """Sets the license_information of this Entry.


        :param license_information: The license_information of this Entry.  # noqa: E501
        :type: LicenseInformation
        """

        self._license_information = license_information

    @property
    def orcid_put_code(self):
        """Gets the orcid_put_code of this Entry.  # noqa: E501

        The presence of the put code indicates the entry was exported to ORCID.  # noqa: E501

        :return: The orcid_put_code of this Entry.  # noqa: E501
        :rtype: str
        """
        return self._orcid_put_code

    @orcid_put_code.setter
    def orcid_put_code(self, orcid_put_code):
        """Sets the orcid_put_code of this Entry.

        The presence of the put code indicates the entry was exported to ORCID.  # noqa: E501

        :param orcid_put_code: The orcid_put_code of this Entry.  # noqa: E501
        :type: str
        """

        self._orcid_put_code = orcid_put_code

    @property
    def topic_id(self):
        """Gets the topic_id of this Entry.  # noqa: E501

        The Id of the corresponding topic on Dockstore Discuss  # noqa: E501

        :return: The topic_id of this Entry.  # noqa: E501
        :rtype: int
        """
        return self._topic_id

    @topic_id.setter
    def topic_id(self, topic_id):
        """Sets the topic_id of this Entry.

        The Id of the corresponding topic on Dockstore Discuss  # noqa: E501

        :param topic_id: The topic_id of this Entry.  # noqa: E501
        :type: int
        """

        self._topic_id = topic_id

    @property
    def workflow_versions(self):
        """Gets the workflow_versions of this Entry.  # noqa: E501


        :return: The workflow_versions of this Entry.  # noqa: E501
        :rtype: list[Version]
        """
        return self._workflow_versions

    @workflow_versions.setter
    def workflow_versions(self, workflow_versions):
        """Sets the workflow_versions of this Entry.


        :param workflow_versions: The workflow_versions of this Entry.  # noqa: E501
        :type: list[Version]
        """

        self._workflow_versions = workflow_versions

    @property
    def author(self):
        """Gets the author of this Entry.  # noqa: E501

        This is the name of the author stated in the Dockstore.cwl  # noqa: E501

        :return: The author of this Entry.  # noqa: E501
        :rtype: str
        """
        return self._author

    @author.setter
    def author(self, author):
        """Sets the author of this Entry.

        This is the name of the author stated in the Dockstore.cwl  # noqa: E501

        :param author: The author of this Entry.  # noqa: E501
        :type: str
        """

        self._author = author

    @property
    def description(self):
        """Gets the description of this Entry.  # noqa: E501

        This is a human-readable description of this container and what it is trying to accomplish, required GA4GH  # noqa: E501

        :return: The description of this Entry.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this Entry.

        This is a human-readable description of this container and what it is trying to accomplish, required GA4GH  # noqa: E501

        :param description: The description of this Entry.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def labels(self):
        """Gets the labels of this Entry.  # noqa: E501

        Labels (i.e. meta tags) for describing the purpose and contents of containers  # noqa: E501

        :return: The labels of this Entry.  # noqa: E501
        :rtype: list[Label]
        """
        return self._labels

    @labels.setter
    def labels(self, labels):
        """Sets the labels of this Entry.

        Labels (i.e. meta tags) for describing the purpose and contents of containers  # noqa: E501

        :param labels: The labels of this Entry.  # noqa: E501
        :type: list[Label]
        """

        self._labels = labels

    @property
    def users(self):
        """Gets the users of this Entry.  # noqa: E501

        This indicates the users that have control over this entry, dockstore specific  # noqa: E501

        :return: The users of this Entry.  # noqa: E501
        :rtype: list[User]
        """
        return self._users

    @users.setter
    def users(self, users):
        """Sets the users of this Entry.

        This indicates the users that have control over this entry, dockstore specific  # noqa: E501

        :param users: The users of this Entry.  # noqa: E501
        :type: list[User]
        """

        self._users = users

    @property
    def starred_users(self):
        """Gets the starred_users of this Entry.  # noqa: E501

        This indicates the users that have starred this entry, dockstore specific  # noqa: E501

        :return: The starred_users of this Entry.  # noqa: E501
        :rtype: list[User]
        """
        return self._starred_users

    @starred_users.setter
    def starred_users(self, starred_users):
        """Sets the starred_users of this Entry.

        This indicates the users that have starred this entry, dockstore specific  # noqa: E501

        :param starred_users: The starred_users of this Entry.  # noqa: E501
        :type: list[User]
        """

        self._starred_users = starred_users

    @property
    def email(self):
        """Gets the email of this Entry.  # noqa: E501

        This is the email of the git organization  # noqa: E501

        :return: The email of this Entry.  # noqa: E501
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email):
        """Sets the email of this Entry.

        This is the email of the git organization  # noqa: E501

        :param email: The email of this Entry.  # noqa: E501
        :type: str
        """

        self._email = email

    @property
    def default_version(self):
        """Gets the default_version of this Entry.  # noqa: E501

        This is the name of the default version of the entry  # noqa: E501

        :return: The default_version of this Entry.  # noqa: E501
        :rtype: str
        """
        return self._default_version

    @default_version.setter
    def default_version(self, default_version):
        """Sets the default_version of this Entry.

        This is the name of the default version of the entry  # noqa: E501

        :param default_version: The default_version of this Entry.  # noqa: E501
        :type: str
        """

        self._default_version = default_version

    @property
    def is_published(self):
        """Gets the is_published of this Entry.  # noqa: E501

        Implementation specific visibility in this web service  # noqa: E501

        :return: The is_published of this Entry.  # noqa: E501
        :rtype: bool
        """
        return self._is_published

    @is_published.setter
    def is_published(self, is_published):
        """Sets the is_published of this Entry.

        Implementation specific visibility in this web service  # noqa: E501

        :param is_published: The is_published of this Entry.  # noqa: E501
        :type: bool
        """

        self._is_published = is_published

    @property
    def last_modified(self):
        """Gets the last_modified of this Entry.  # noqa: E501

        Implementation specific timestamp for last modified. Tools-> For automated/manual builds: N/A. For hosted: Last time a file was updated/created (new version created). Workflows-> For remote: When refresh is hit, last time GitHub repo was changed. Hosted: Last time a new version was made.  # noqa: E501

        :return: The last_modified of this Entry.  # noqa: E501
        :rtype: int
        """
        return self._last_modified

    @last_modified.setter
    def last_modified(self, last_modified):
        """Sets the last_modified of this Entry.

        Implementation specific timestamp for last modified. Tools-> For automated/manual builds: N/A. For hosted: Last time a file was updated/created (new version created). Workflows-> For remote: When refresh is hit, last time GitHub repo was changed. Hosted: Last time a new version was made.  # noqa: E501

        :param last_modified: The last_modified of this Entry.  # noqa: E501
        :type: int
        """

        self._last_modified = last_modified

    @property
    def last_updated(self):
        """Gets the last_updated of this Entry.  # noqa: E501

        Implementation specific timestamp for last updated on webservice. Tools-> For automated builds: last time tool/namespace was refreshed Dockstore, tool info (like changing dockerfile path) updated, or default version selected. For hosted tools: when you created the tool. Workflows-> For remote: When refresh all is hit for first time. Hosted: Seems to be time created.  # noqa: E501

        :return: The last_updated of this Entry.  # noqa: E501
        :rtype: int
        """
        return self._last_updated

    @last_updated.setter
    def last_updated(self, last_updated):
        """Sets the last_updated of this Entry.

        Implementation specific timestamp for last updated on webservice. Tools-> For automated builds: last time tool/namespace was refreshed Dockstore, tool info (like changing dockerfile path) updated, or default version selected. For hosted tools: when you created the tool. Workflows-> For remote: When refresh all is hit for first time. Hosted: Seems to be time created.  # noqa: E501

        :param last_updated: The last_updated of this Entry.  # noqa: E501
        :type: int
        """

        self._last_updated = last_updated

    @property
    def git_url(self):
        """Gets the git_url of this Entry.  # noqa: E501

        This is a link to the associated repo with a descriptor, required GA4GH  # noqa: E501

        :return: The git_url of this Entry.  # noqa: E501
        :rtype: str
        """
        return self._git_url

    @git_url.setter
    def git_url(self, git_url):
        """Sets the git_url of this Entry.

        This is a link to the associated repo with a descriptor, required GA4GH  # noqa: E501

        :param git_url: The git_url of this Entry.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and git_url is None:
            raise ValueError("Invalid value for `git_url`, must not be `None`")  # noqa: E501

        self._git_url = git_url

    @property
    def checker_id(self):
        """Gets the checker_id of this Entry.  # noqa: E501

        The id of the associated checker workflow  # noqa: E501

        :return: The checker_id of this Entry.  # noqa: E501
        :rtype: int
        """
        return self._checker_id

    @checker_id.setter
    def checker_id(self, checker_id):
        """Sets the checker_id of this Entry.

        The id of the associated checker workflow  # noqa: E501

        :param checker_id: The checker_id of this Entry.  # noqa: E501
        :type: int
        """

        self._checker_id = checker_id

    @property
    def concept_doi(self):
        """Gets the concept_doi of this Entry.  # noqa: E501

        The Digital Object Identifier (DOI) representing all of the versions of your workflow  # noqa: E501

        :return: The concept_doi of this Entry.  # noqa: E501
        :rtype: str
        """
        return self._concept_doi

    @concept_doi.setter
    def concept_doi(self, concept_doi):
        """Sets the concept_doi of this Entry.

        The Digital Object Identifier (DOI) representing all of the versions of your workflow  # noqa: E501

        :param concept_doi: The concept_doi of this Entry.  # noqa: E501
        :type: str
        """

        self._concept_doi = concept_doi

    @property
    def input_file_formats(self):
        """Gets the input_file_formats of this Entry.  # noqa: E501

        File formats for describing the input file formats of every version of an entry  # noqa: E501

        :return: The input_file_formats of this Entry.  # noqa: E501
        :rtype: list[FileFormat]
        """
        return self._input_file_formats

    @input_file_formats.setter
    def input_file_formats(self, input_file_formats):
        """Sets the input_file_formats of this Entry.

        File formats for describing the input file formats of every version of an entry  # noqa: E501

        :param input_file_formats: The input_file_formats of this Entry.  # noqa: E501
        :type: list[FileFormat]
        """

        self._input_file_formats = input_file_formats

    @property
    def output_file_formats(self):
        """Gets the output_file_formats of this Entry.  # noqa: E501

        File formats for describing the output file formats of every version of an entry  # noqa: E501

        :return: The output_file_formats of this Entry.  # noqa: E501
        :rtype: list[FileFormat]
        """
        return self._output_file_formats

    @output_file_formats.setter
    def output_file_formats(self, output_file_formats):
        """Sets the output_file_formats of this Entry.

        File formats for describing the output file formats of every version of an entry  # noqa: E501

        :param output_file_formats: The output_file_formats of this Entry.  # noqa: E501
        :type: list[FileFormat]
        """

        self._output_file_formats = output_file_formats

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Entry, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Entry):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Entry):
            return True

        return self.to_dict() != other.to_dict()
