# coding: utf-8

"""
    Dockstore API

    This describes the dockstore API, a webservice that manages pairs of Docker images and associated metadata such as CWL documents and Dockerfiles used to build those images. Explore swagger.json for a Swagger 2.0 description of our API and explore openapi.yaml for OpenAPI 3.0 descriptions.  # noqa: E501

    OpenAPI spec version: 1.12.0-alpha.1-SNAPSHOT
    Contact: theglobalalliance@genomicsandhealth.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from jgreenepack.configuration import Configuration


class EntryUpdateTime(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'entry_type': 'str',
        'last_update_date': 'int',
        'path': 'str',
        'pretty_path': 'str'
    }

    attribute_map = {
        'entry_type': 'entryType',
        'last_update_date': 'lastUpdateDate',
        'path': 'path',
        'pretty_path': 'prettyPath'
    }

    def __init__(self, entry_type=None, last_update_date=None, path=None, pretty_path=None, _configuration=None):  # noqa: E501
        """EntryUpdateTime - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._entry_type = None
        self._last_update_date = None
        self._path = None
        self._pretty_path = None
        self.discriminator = None

        if entry_type is not None:
            self.entry_type = entry_type
        if last_update_date is not None:
            self.last_update_date = last_update_date
        if path is not None:
            self.path = path
        if pretty_path is not None:
            self.pretty_path = pretty_path

    @property
    def entry_type(self):
        """Gets the entry_type of this EntryUpdateTime.  # noqa: E501


        :return: The entry_type of this EntryUpdateTime.  # noqa: E501
        :rtype: str
        """
        return self._entry_type

    @entry_type.setter
    def entry_type(self, entry_type):
        """Sets the entry_type of this EntryUpdateTime.


        :param entry_type: The entry_type of this EntryUpdateTime.  # noqa: E501
        :type: str
        """
        allowed_values = ["TOOL", "WORKFLOW", "SERVICE", "APPTOOL"]  # noqa: E501
        if (self._configuration.client_side_validation and
                entry_type not in allowed_values):
            raise ValueError(
                "Invalid value for `entry_type` ({0}), must be one of {1}"  # noqa: E501
                .format(entry_type, allowed_values)
            )

        self._entry_type = entry_type

    @property
    def last_update_date(self):
        """Gets the last_update_date of this EntryUpdateTime.  # noqa: E501


        :return: The last_update_date of this EntryUpdateTime.  # noqa: E501
        :rtype: int
        """
        return self._last_update_date

    @last_update_date.setter
    def last_update_date(self, last_update_date):
        """Sets the last_update_date of this EntryUpdateTime.


        :param last_update_date: The last_update_date of this EntryUpdateTime.  # noqa: E501
        :type: int
        """

        self._last_update_date = last_update_date

    @property
    def path(self):
        """Gets the path of this EntryUpdateTime.  # noqa: E501


        :return: The path of this EntryUpdateTime.  # noqa: E501
        :rtype: str
        """
        return self._path

    @path.setter
    def path(self, path):
        """Sets the path of this EntryUpdateTime.


        :param path: The path of this EntryUpdateTime.  # noqa: E501
        :type: str
        """

        self._path = path

    @property
    def pretty_path(self):
        """Gets the pretty_path of this EntryUpdateTime.  # noqa: E501


        :return: The pretty_path of this EntryUpdateTime.  # noqa: E501
        :rtype: str
        """
        return self._pretty_path

    @pretty_path.setter
    def pretty_path(self, pretty_path):
        """Sets the pretty_path of this EntryUpdateTime.


        :param pretty_path: The pretty_path of this EntryUpdateTime.  # noqa: E501
        :type: str
        """

        self._pretty_path = pretty_path

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(EntryUpdateTime, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, EntryUpdateTime):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, EntryUpdateTime):
            return True

        return self.to_dict() != other.to_dict()
