# coding: utf-8

"""
    Dockstore API

    This describes the dockstore API, a webservice that manages pairs of Docker images and associated metadata such as CWL documents and Dockerfiles used to build those images. Explore swagger.json for a Swagger 2.0 description of our API and explore openapi.yaml for OpenAPI 3.0 descriptions.  # noqa: E501

    OpenAPI spec version: 1.12.0-alpha.1-SNAPSHOT
    Contact: theglobalalliance@genomicsandhealth.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from jgreenepack.configuration import Configuration


class Event(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'db_create_date': 'int',
        'db_update_date': 'int',
        'id': 'int',
        'user': 'User',
        'organization': 'Organization',
        'tool': 'DockstoreTool',
        'workflow': 'Workflow',
        'collection': 'Collection',
        'initiator_user': 'User',
        'type': 'str',
        'version': 'Version'
    }

    attribute_map = {
        'db_create_date': 'dbCreateDate',
        'db_update_date': 'dbUpdateDate',
        'id': 'id',
        'user': 'user',
        'organization': 'organization',
        'tool': 'tool',
        'workflow': 'workflow',
        'collection': 'collection',
        'initiator_user': 'initiatorUser',
        'type': 'type',
        'version': 'version'
    }

    def __init__(self, db_create_date=None, db_update_date=None, id=None, user=None, organization=None, tool=None, workflow=None, collection=None, initiator_user=None, type=None, version=None, _configuration=None):  # noqa: E501
        """Event - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._db_create_date = None
        self._db_update_date = None
        self._id = None
        self._user = None
        self._organization = None
        self._tool = None
        self._workflow = None
        self._collection = None
        self._initiator_user = None
        self._type = None
        self._version = None
        self.discriminator = None

        if db_create_date is not None:
            self.db_create_date = db_create_date
        if db_update_date is not None:
            self.db_update_date = db_update_date
        if id is not None:
            self.id = id
        if user is not None:
            self.user = user
        if organization is not None:
            self.organization = organization
        if tool is not None:
            self.tool = tool
        if workflow is not None:
            self.workflow = workflow
        if collection is not None:
            self.collection = collection
        if initiator_user is not None:
            self.initiator_user = initiator_user
        self.type = type
        if version is not None:
            self.version = version

    @property
    def db_create_date(self):
        """Gets the db_create_date of this Event.  # noqa: E501


        :return: The db_create_date of this Event.  # noqa: E501
        :rtype: int
        """
        return self._db_create_date

    @db_create_date.setter
    def db_create_date(self, db_create_date):
        """Sets the db_create_date of this Event.


        :param db_create_date: The db_create_date of this Event.  # noqa: E501
        :type: int
        """

        self._db_create_date = db_create_date

    @property
    def db_update_date(self):
        """Gets the db_update_date of this Event.  # noqa: E501


        :return: The db_update_date of this Event.  # noqa: E501
        :rtype: int
        """
        return self._db_update_date

    @db_update_date.setter
    def db_update_date(self, db_update_date):
        """Sets the db_update_date of this Event.


        :param db_update_date: The db_update_date of this Event.  # noqa: E501
        :type: int
        """

        self._db_update_date = db_update_date

    @property
    def id(self):
        """Gets the id of this Event.  # noqa: E501

        Implementation specific ID for the event in this web service  # noqa: E501

        :return: The id of this Event.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Event.

        Implementation specific ID for the event in this web service  # noqa: E501

        :param id: The id of this Event.  # noqa: E501
        :type: int
        """

        self._id = id

    @property
    def user(self):
        """Gets the user of this Event.  # noqa: E501

        User that the event is acting on.  # noqa: E501

        :return: The user of this Event.  # noqa: E501
        :rtype: User
        """
        return self._user

    @user.setter
    def user(self, user):
        """Sets the user of this Event.

        User that the event is acting on.  # noqa: E501

        :param user: The user of this Event.  # noqa: E501
        :type: User
        """

        self._user = user

    @property
    def organization(self):
        """Gets the organization of this Event.  # noqa: E501

        Organization that the event is acting on.  # noqa: E501

        :return: The organization of this Event.  # noqa: E501
        :rtype: Organization
        """
        return self._organization

    @organization.setter
    def organization(self, organization):
        """Sets the organization of this Event.

        Organization that the event is acting on.  # noqa: E501

        :param organization: The organization of this Event.  # noqa: E501
        :type: Organization
        """

        self._organization = organization

    @property
    def tool(self):
        """Gets the tool of this Event.  # noqa: E501

        Tool that the event is acting on.  # noqa: E501

        :return: The tool of this Event.  # noqa: E501
        :rtype: DockstoreTool
        """
        return self._tool

    @tool.setter
    def tool(self, tool):
        """Sets the tool of this Event.

        Tool that the event is acting on.  # noqa: E501

        :param tool: The tool of this Event.  # noqa: E501
        :type: DockstoreTool
        """

        self._tool = tool

    @property
    def workflow(self):
        """Gets the workflow of this Event.  # noqa: E501

        Workflow that the event is acting on.  # noqa: E501

        :return: The workflow of this Event.  # noqa: E501
        :rtype: Workflow
        """
        return self._workflow

    @workflow.setter
    def workflow(self, workflow):
        """Sets the workflow of this Event.

        Workflow that the event is acting on.  # noqa: E501

        :param workflow: The workflow of this Event.  # noqa: E501
        :type: Workflow
        """

        self._workflow = workflow

    @property
    def collection(self):
        """Gets the collection of this Event.  # noqa: E501

        Collection that the event is acting on.  # noqa: E501

        :return: The collection of this Event.  # noqa: E501
        :rtype: Collection
        """
        return self._collection

    @collection.setter
    def collection(self, collection):
        """Sets the collection of this Event.

        Collection that the event is acting on.  # noqa: E501

        :param collection: The collection of this Event.  # noqa: E501
        :type: Collection
        """

        self._collection = collection

    @property
    def initiator_user(self):
        """Gets the initiator_user of this Event.  # noqa: E501

        User initiating the event.  # noqa: E501

        :return: The initiator_user of this Event.  # noqa: E501
        :rtype: User
        """
        return self._initiator_user

    @initiator_user.setter
    def initiator_user(self, initiator_user):
        """Sets the initiator_user of this Event.

        User initiating the event.  # noqa: E501

        :param initiator_user: The initiator_user of this Event.  # noqa: E501
        :type: User
        """

        self._initiator_user = initiator_user

    @property
    def type(self):
        """Gets the type of this Event.  # noqa: E501

        The event type.  # noqa: E501

        :return: The type of this Event.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this Event.

        The event type.  # noqa: E501

        :param type: The type of this Event.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and type is None:
            raise ValueError("Invalid value for `type`, must not be `None`")  # noqa: E501
        allowed_values = ["CREATE_ORG", "DELETE_ORG", "MODIFY_ORG", "APPROVE_ORG", "REJECT_ORG", "REREQUEST_ORG", "ADD_USER_TO_ORG", "REMOVE_USER_FROM_ORG", "MODIFY_USER_ROLE_ORG", "APPROVE_ORG_INVITE", "REJECT_ORG_INVITE", "CREATE_COLLECTION", "MODIFY_COLLECTION", "REMOVE_FROM_COLLECTION", "ADD_TO_COLLECTION", "ADD_VERSION_TO_ENTRY"]  # noqa: E501
        if (self._configuration.client_side_validation and
                type not in allowed_values):
            raise ValueError(
                "Invalid value for `type` ({0}), must be one of {1}"  # noqa: E501
                .format(type, allowed_values)
            )

        self._type = type

    @property
    def version(self):
        """Gets the version of this Event.  # noqa: E501

        Version associated with the event.  # noqa: E501

        :return: The version of this Event.  # noqa: E501
        :rtype: Version
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this Event.

        Version associated with the event.  # noqa: E501

        :param version: The version of this Event.  # noqa: E501
        :type: Version
        """

        self._version = version

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Event, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Event):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Event):
            return True

        return self.to_dict() != other.to_dict()
