# coding: utf-8

"""
    Dockstore API

    This describes the dockstore API, a webservice that manages pairs of Docker images and associated metadata such as CWL documents and Dockerfiles used to build those images. Explore swagger.json for a Swagger 2.0 description of our API and explore openapi.yaml for OpenAPI 3.0 descriptions.  # noqa: E501

    OpenAPI spec version: 1.12.0-alpha.1-SNAPSHOT
    Contact: theglobalalliance@genomicsandhealth.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from jgreenepack.configuration import Configuration


class Image(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'db_update_date': 'datetime',
        'image_update_date': 'str',
        'size': 'int',
        'specifier': 'str',
        'checksums': 'list[Checksum]',
        'repository': 'str',
        'tag': 'str',
        'image_id': 'str',
        'image_registry': 'str',
        'architecture': 'str',
        'os': 'str'
    }

    attribute_map = {
        'db_update_date': 'dbUpdateDate',
        'image_update_date': 'imageUpdateDate',
        'size': 'size',
        'specifier': 'specifier',
        'checksums': 'checksums',
        'repository': 'repository',
        'tag': 'tag',
        'image_id': 'imageID',
        'image_registry': 'imageRegistry',
        'architecture': 'architecture',
        'os': 'os'
    }

    def __init__(self, db_update_date=None, image_update_date=None, size=None, specifier=None, checksums=None, repository=None, tag=None, image_id=None, image_registry=None, architecture=None, os=None, _configuration=None):  # noqa: E501
        """Image - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._db_update_date = None
        self._image_update_date = None
        self._size = None
        self._specifier = None
        self._checksums = None
        self._repository = None
        self._tag = None
        self._image_id = None
        self._image_registry = None
        self._architecture = None
        self._os = None
        self.discriminator = None

        if db_update_date is not None:
            self.db_update_date = db_update_date
        if image_update_date is not None:
            self.image_update_date = image_update_date
        if size is not None:
            self.size = size
        if specifier is not None:
            self.specifier = specifier
        if checksums is not None:
            self.checksums = checksums
        if repository is not None:
            self.repository = repository
        if tag is not None:
            self.tag = tag
        if image_id is not None:
            self.image_id = image_id
        if image_registry is not None:
            self.image_registry = image_registry
        if architecture is not None:
            self.architecture = architecture
        if os is not None:
            self.os = os

    @property
    def db_update_date(self):
        """Gets the db_update_date of this Image.  # noqa: E501


        :return: The db_update_date of this Image.  # noqa: E501
        :rtype: datetime
        """
        return self._db_update_date

    @db_update_date.setter
    def db_update_date(self, db_update_date):
        """Sets the db_update_date of this Image.


        :param db_update_date: The db_update_date of this Image.  # noqa: E501
        :type: datetime
        """

        self._db_update_date = db_update_date

    @property
    def image_update_date(self):
        """Gets the image_update_date of this Image.  # noqa: E501

        The date the image was updated in the Docker repository  # noqa: E501

        :return: The image_update_date of this Image.  # noqa: E501
        :rtype: str
        """
        return self._image_update_date

    @image_update_date.setter
    def image_update_date(self, image_update_date):
        """Sets the image_update_date of this Image.

        The date the image was updated in the Docker repository  # noqa: E501

        :param image_update_date: The image_update_date of this Image.  # noqa: E501
        :type: str
        """

        self._image_update_date = image_update_date

    @property
    def size(self):
        """Gets the size of this Image.  # noqa: E501

        The size of the image in bytes  # noqa: E501

        :return: The size of this Image.  # noqa: E501
        :rtype: int
        """
        return self._size

    @size.setter
    def size(self, size):
        """Sets the size of this Image.

        The size of the image in bytes  # noqa: E501

        :param size: The size of this Image.  # noqa: E501
        :type: int
        """

        self._size = size

    @property
    def specifier(self):
        """Gets the specifier of this Image.  # noqa: E501

        How the image is specified  # noqa: E501

        :return: The specifier of this Image.  # noqa: E501
        :rtype: str
        """
        return self._specifier

    @specifier.setter
    def specifier(self, specifier):
        """Sets the specifier of this Image.

        How the image is specified  # noqa: E501

        :param specifier: The specifier of this Image.  # noqa: E501
        :type: str
        """
        allowed_values = ["PARAMETER", "NO_TAG", "LATEST", "TAG", "DIGEST"]  # noqa: E501
        if (self._configuration.client_side_validation and
                specifier not in allowed_values):
            raise ValueError(
                "Invalid value for `specifier` ({0}), must be one of {1}"  # noqa: E501
                .format(specifier, allowed_values)
            )

        self._specifier = specifier

    @property
    def checksums(self):
        """Gets the checksums of this Image.  # noqa: E501

        Checksum(s) associated with this image  # noqa: E501

        :return: The checksums of this Image.  # noqa: E501
        :rtype: list[Checksum]
        """
        return self._checksums

    @checksums.setter
    def checksums(self, checksums):
        """Sets the checksums of this Image.

        Checksum(s) associated with this image  # noqa: E501

        :param checksums: The checksums of this Image.  # noqa: E501
        :type: list[Checksum]
        """

        self._checksums = checksums

    @property
    def repository(self):
        """Gets the repository of this Image.  # noqa: E501

        Repository image belongs to  # noqa: E501

        :return: The repository of this Image.  # noqa: E501
        :rtype: str
        """
        return self._repository

    @repository.setter
    def repository(self, repository):
        """Sets the repository of this Image.

        Repository image belongs to  # noqa: E501

        :param repository: The repository of this Image.  # noqa: E501
        :type: str
        """

        self._repository = repository

    @property
    def tag(self):
        """Gets the tag of this Image.  # noqa: E501

        Git tag  # noqa: E501

        :return: The tag of this Image.  # noqa: E501
        :rtype: str
        """
        return self._tag

    @tag.setter
    def tag(self, tag):
        """Sets the tag of this Image.

        Git tag  # noqa: E501

        :param tag: The tag of this Image.  # noqa: E501
        :type: str
        """

        self._tag = tag

    @property
    def image_id(self):
        """Gets the image_id of this Image.  # noqa: E501

        Docker ID of the image  # noqa: E501

        :return: The image_id of this Image.  # noqa: E501
        :rtype: str
        """
        return self._image_id

    @image_id.setter
    def image_id(self, image_id):
        """Sets the image_id of this Image.

        Docker ID of the image  # noqa: E501

        :param image_id: The image_id of this Image.  # noqa: E501
        :type: str
        """

        self._image_id = image_id

    @property
    def image_registry(self):
        """Gets the image_registry of this Image.  # noqa: E501

        Registry the image belongs to  # noqa: E501

        :return: The image_registry of this Image.  # noqa: E501
        :rtype: str
        """
        return self._image_registry

    @image_registry.setter
    def image_registry(self, image_registry):
        """Sets the image_registry of this Image.

        Registry the image belongs to  # noqa: E501

        :param image_registry: The image_registry of this Image.  # noqa: E501
        :type: str
        """
        allowed_values = ["QUAY_IO", "DOCKER_HUB", "GITLAB", "AMAZON_ECR", "SEVEN_BRIDGES", "GITHUB_CONTAINER_REGISTRY"]  # noqa: E501
        if (self._configuration.client_side_validation and
                image_registry not in allowed_values):
            raise ValueError(
                "Invalid value for `image_registry` ({0}), must be one of {1}"  # noqa: E501
                .format(image_registry, allowed_values)
            )

        self._image_registry = image_registry

    @property
    def architecture(self):
        """Gets the architecture of this Image.  # noqa: E501

        Stores the architecture and, if available, the variant of an image. Separated by a / and only applicable to Docker Hub  # noqa: E501

        :return: The architecture of this Image.  # noqa: E501
        :rtype: str
        """
        return self._architecture

    @architecture.setter
    def architecture(self, architecture):
        """Sets the architecture of this Image.

        Stores the architecture and, if available, the variant of an image. Separated by a / and only applicable to Docker Hub  # noqa: E501

        :param architecture: The architecture of this Image.  # noqa: E501
        :type: str
        """

        self._architecture = architecture

    @property
    def os(self):
        """Gets the os of this Image.  # noqa: E501

        Stores the OS and, if available the OS version. Separated by a / and only applicable to Docker Hub  # noqa: E501

        :return: The os of this Image.  # noqa: E501
        :rtype: str
        """
        return self._os

    @os.setter
    def os(self, os):
        """Sets the os of this Image.

        Stores the OS and, if available the OS version. Separated by a / and only applicable to Docker Hub  # noqa: E501

        :param os: The os of this Image.  # noqa: E501
        :type: str
        """

        self._os = os

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Image, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Image):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Image):
            return True

        return self.to_dict() != other.to_dict()
