# coding: utf-8

"""
    Dockstore API

    This describes the dockstore API, a webservice that manages pairs of Docker images and associated metadata such as CWL documents and Dockerfiles used to build those images. Explore swagger.json for a Swagger 2.0 description of our API and explore openapi.yaml for OpenAPI 3.0 descriptions.  # noqa: E501

    OpenAPI spec version: 1.12.0-alpha.1-SNAPSHOT
    Contact: theglobalalliance@genomicsandhealth.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from jgreenepack.configuration import Configuration


class LambdaEvent(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'event_date': 'int',
        'id': 'int',
        'organization': 'str',
        'repository': 'str',
        'github_username': 'str',
        'reference': 'str',
        'success': 'bool',
        'message': 'str',
        'type': 'str'
    }

    attribute_map = {
        'event_date': 'eventDate',
        'id': 'id',
        'organization': 'organization',
        'repository': 'repository',
        'github_username': 'githubUsername',
        'reference': 'reference',
        'success': 'success',
        'message': 'message',
        'type': 'type'
    }

    def __init__(self, event_date=None, id=None, organization=None, repository=None, github_username=None, reference=None, success=None, message=None, type=None, _configuration=None):  # noqa: E501
        """LambdaEvent - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._event_date = None
        self._id = None
        self._organization = None
        self._repository = None
        self._github_username = None
        self._reference = None
        self._success = None
        self._message = None
        self._type = None
        self.discriminator = None

        if event_date is not None:
            self.event_date = event_date
        if id is not None:
            self.id = id
        self.organization = organization
        self.repository = repository
        self.github_username = github_username
        self.reference = reference
        if success is not None:
            self.success = success
        if message is not None:
            self.message = message
        self.type = type

    @property
    def event_date(self):
        """Gets the event_date of this LambdaEvent.  # noqa: E501


        :return: The event_date of this LambdaEvent.  # noqa: E501
        :rtype: int
        """
        return self._event_date

    @event_date.setter
    def event_date(self, event_date):
        """Sets the event_date of this LambdaEvent.


        :param event_date: The event_date of this LambdaEvent.  # noqa: E501
        :type: int
        """

        self._event_date = event_date

    @property
    def id(self):
        """Gets the id of this LambdaEvent.  # noqa: E501

        Unique ID of the event.  # noqa: E501

        :return: The id of this LambdaEvent.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this LambdaEvent.

        Unique ID of the event.  # noqa: E501

        :param id: The id of this LambdaEvent.  # noqa: E501
        :type: int
        """

        self._id = id

    @property
    def organization(self):
        """Gets the organization of this LambdaEvent.  # noqa: E501

        The organization from the event.  # noqa: E501

        :return: The organization of this LambdaEvent.  # noqa: E501
        :rtype: str
        """
        return self._organization

    @organization.setter
    def organization(self, organization):
        """Sets the organization of this LambdaEvent.

        The organization from the event.  # noqa: E501

        :param organization: The organization of this LambdaEvent.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and organization is None:
            raise ValueError("Invalid value for `organization`, must not be `None`")  # noqa: E501

        self._organization = organization

    @property
    def repository(self):
        """Gets the repository of this LambdaEvent.  # noqa: E501

        The repository from the event.  # noqa: E501

        :return: The repository of this LambdaEvent.  # noqa: E501
        :rtype: str
        """
        return self._repository

    @repository.setter
    def repository(self, repository):
        """Sets the repository of this LambdaEvent.

        The repository from the event.  # noqa: E501

        :param repository: The repository of this LambdaEvent.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and repository is None:
            raise ValueError("Invalid value for `repository`, must not be `None`")  # noqa: E501

        self._repository = repository

    @property
    def github_username(self):
        """Gets the github_username of this LambdaEvent.  # noqa: E501

        The name of the user on GitHub that triggers the event.  # noqa: E501

        :return: The github_username of this LambdaEvent.  # noqa: E501
        :rtype: str
        """
        return self._github_username

    @github_username.setter
    def github_username(self, github_username):
        """Sets the github_username of this LambdaEvent.

        The name of the user on GitHub that triggers the event.  # noqa: E501

        :param github_username: The github_username of this LambdaEvent.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and github_username is None:
            raise ValueError("Invalid value for `github_username`, must not be `None`")  # noqa: E501

        self._github_username = github_username

    @property
    def reference(self):
        """Gets the reference of this LambdaEvent.  # noqa: E501

        The git reference from the event.  # noqa: E501

        :return: The reference of this LambdaEvent.  # noqa: E501
        :rtype: str
        """
        return self._reference

    @reference.setter
    def reference(self, reference):
        """Sets the reference of this LambdaEvent.

        The git reference from the event.  # noqa: E501

        :param reference: The reference of this LambdaEvent.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and reference is None:
            raise ValueError("Invalid value for `reference`, must not be `None`")  # noqa: E501

        self._reference = reference

    @property
    def success(self):
        """Gets the success of this LambdaEvent.  # noqa: E501

        Whether or not the event was successful.  # noqa: E501

        :return: The success of this LambdaEvent.  # noqa: E501
        :rtype: bool
        """
        return self._success

    @success.setter
    def success(self, success):
        """Sets the success of this LambdaEvent.

        Whether or not the event was successful.  # noqa: E501

        :param success: The success of this LambdaEvent.  # noqa: E501
        :type: bool
        """

        self._success = success

    @property
    def message(self):
        """Gets the message of this LambdaEvent.  # noqa: E501

        The message associated with the event.  # noqa: E501

        :return: The message of this LambdaEvent.  # noqa: E501
        :rtype: str
        """
        return self._message

    @message.setter
    def message(self, message):
        """Sets the message of this LambdaEvent.

        The message associated with the event.  # noqa: E501

        :param message: The message of this LambdaEvent.  # noqa: E501
        :type: str
        """

        self._message = message

    @property
    def type(self):
        """Gets the type of this LambdaEvent.  # noqa: E501

        The type of event.  # noqa: E501

        :return: The type of this LambdaEvent.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this LambdaEvent.

        The type of event.  # noqa: E501

        :param type: The type of this LambdaEvent.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and type is None:
            raise ValueError("Invalid value for `type`, must not be `None`")  # noqa: E501
        allowed_values = ["PUSH", "DELETE", "INSTALL", "PUBLISH"]  # noqa: E501
        if (self._configuration.client_side_validation and
                type not in allowed_values):
            raise ValueError(
                "Invalid value for `type` ({0}), must be one of {1}"  # noqa: E501
                .format(type, allowed_values)
            )

        self._type = type

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(LambdaEvent, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, LambdaEvent):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, LambdaEvent):
            return True

        return self.to_dict() != other.to_dict()
