# coding: utf-8

"""
    Dockstore API

    This describes the dockstore API, a webservice that manages pairs of Docker images and associated metadata such as CWL documents and Dockerfiles used to build those images. Explore swagger.json for a Swagger 2.0 description of our API and explore openapi.yaml for OpenAPI 3.0 descriptions.  # noqa: E501

    OpenAPI spec version: 1.12.0-alpha.1-SNAPSHOT
    Contact: theglobalalliance@genomicsandhealth.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from jgreenepack.configuration import Configuration


class Metadata(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'api_version': 'str',
        'country': 'str',
        'friendly_name': 'str',
        'version': 'str'
    }

    attribute_map = {
        'api_version': 'api_version',
        'country': 'country',
        'friendly_name': 'friendly_name',
        'version': 'version'
    }

    def __init__(self, api_version=None, country=None, friendly_name=None, version=None, _configuration=None):  # noqa: E501
        """Metadata - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._api_version = None
        self._country = None
        self._friendly_name = None
        self._version = None
        self.discriminator = None

        self.api_version = api_version
        if country is not None:
            self.country = country
        if friendly_name is not None:
            self.friendly_name = friendly_name
        self.version = version

    @property
    def api_version(self):
        """Gets the api_version of this Metadata.  # noqa: E501

        The version of the GA4GH tool-registry API supported by this registry  # noqa: E501

        :return: The api_version of this Metadata.  # noqa: E501
        :rtype: str
        """
        return self._api_version

    @api_version.setter
    def api_version(self, api_version):
        """Sets the api_version of this Metadata.

        The version of the GA4GH tool-registry API supported by this registry  # noqa: E501

        :param api_version: The api_version of this Metadata.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and api_version is None:
            raise ValueError("Invalid value for `api_version`, must not be `None`")  # noqa: E501

        self._api_version = api_version

    @property
    def country(self):
        """Gets the country of this Metadata.  # noqa: E501

        A country code for the registry (ISO 3166-1 alpha-3)  # noqa: E501

        :return: The country of this Metadata.  # noqa: E501
        :rtype: str
        """
        return self._country

    @country.setter
    def country(self, country):
        """Sets the country of this Metadata.

        A country code for the registry (ISO 3166-1 alpha-3)  # noqa: E501

        :param country: The country of this Metadata.  # noqa: E501
        :type: str
        """

        self._country = country

    @property
    def friendly_name(self):
        """Gets the friendly_name of this Metadata.  # noqa: E501

        A friendly name that can be used in addition to the hostname to describe a registry  # noqa: E501

        :return: The friendly_name of this Metadata.  # noqa: E501
        :rtype: str
        """
        return self._friendly_name

    @friendly_name.setter
    def friendly_name(self, friendly_name):
        """Sets the friendly_name of this Metadata.

        A friendly name that can be used in addition to the hostname to describe a registry  # noqa: E501

        :param friendly_name: The friendly_name of this Metadata.  # noqa: E501
        :type: str
        """

        self._friendly_name = friendly_name

    @property
    def version(self):
        """Gets the version of this Metadata.  # noqa: E501

        The version of this registry  # noqa: E501

        :return: The version of this Metadata.  # noqa: E501
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this Metadata.

        The version of this registry  # noqa: E501

        :param version: The version of this Metadata.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and version is None:
            raise ValueError("Invalid value for `version`, must not be `None`")  # noqa: E501

        self._version = version

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Metadata, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Metadata):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Metadata):
            return True

        return self.to_dict() != other.to_dict()
